﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Mst
{
    public class MstSolucionReporteController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstSolucionReporte
        public ActionResult Index()
        {
            var mst_SolucionReporte = db.Mst_SolucionReporte.Include(m => m.Mst_TipoSolucionReporte).Include(m => m.Mst_Reporte).Include(m => m.Convenios_stConvenioLaboralTrabajadorCategoria);
            return View(mst_SolucionReporte.ToList());
        }

        // GET: MstSolucionReporte/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_SolucionReporte mst_SolucionReporte = db.Mst_SolucionReporte.Find(id);
            if (mst_SolucionReporte == null)
            {
                return HttpNotFound();
            }
            return PartialView("_Details",mst_SolucionReporte);
        }

        // GET: MstSolucionReporte/Create
        public ActionResult Create()
        {
            int idReporte = System.Convert.ToInt32(Request["Reporte"]);

            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(idReporte);
            if (mst_Reporte == null)
            {
                var result = new { value_e = "efailed", msg = "No es posible localizar el Reporte asociado." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            
            var mst_SolucionReporte = db.Mst_SolucionReporte.Where(t => t.IdReporte == idReporte).FirstOrDefault();
            if(mst_SolucionReporte != null)
            {
                return PartialView("_Details", mst_SolucionReporte);
            }

            if (mst_Reporte.Mst_EstatusReporte.EstatusReporte == "Pendiente")
            {
                var result = new { value_e = "efailed", msg = "No es posible registrar solución porque el reporte sigue en Estatus pendiente." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            ViewBag.IdTipoSolucion = new SelectList(db.Mst_TipoSolucionReporte, "IdTipoSolucion", "TipoSolucion");
            ViewBag.IdReporte = new SelectList(db.Mst_Reporte, "IdReporte", "NumeroReporte");
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdReporte = idReporte;
            return PartialView("_Create");
        }

        // POST: MstSolucionReporte/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdSolucionReporte,SolucionReporte,FechaSolucion,IdTipoSolucion,IdReporte,IdConvenioLaboralTrabajadorCategoria")] Mst_SolucionReporte mst_SolucionReporte)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            mst_SolucionReporte.FechaSolucion = DateTime.Now;
            mst_SolucionReporte.IdConvenioLaboralTrabajadorCategoria = idUser;

            if (ModelState.IsValid)
            {
                db.Mst_SolucionReporte.Add(mst_SolucionReporte);
                db.SaveChanges();

                var result = new { value_e = "esuccess", msg = "La solución al reporte se ha guardado con éxito." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            ViewBag.IdTipoSolucion = new SelectList(db.Mst_TipoSolucionReporte, "IdTipoSolucion", "TipoSolucion", mst_SolucionReporte.IdTipoSolucion);
            //ViewBag.IdReporte = new SelectList(db.Mst_Reporte, "IdReporte", "NumeroReporte", mst_SolucionReporte.IdReporte);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_SolucionReporte.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdReporte = mst_SolucionReporte.IdReporte;
            return PartialView("_Create",mst_SolucionReporte);
        }

        // GET: MstSolucionReporte/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_SolucionReporte mst_SolucionReporte = db.Mst_SolucionReporte.Find(id);
            if (mst_SolucionReporte == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdTipoSolucion = new SelectList(db.Mst_TipoSolucionReporte, "IdTipoSolucion", "TipoSolucion", mst_SolucionReporte.IdTipoSolucion);
            //ViewBag.IdReporte = new SelectList(db.Mst_Reporte, "IdReporte", "NumeroReporte", mst_SolucionReporte.IdReporte);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_SolucionReporte.IdConvenioLaboralTrabajadorCategoria);
            return PartialView("_Edit",mst_SolucionReporte);
        }

        // POST: MstSolucionReporte/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdSolucionReporte,SolucionReporte,FechaSolucion,IdTipoSolucion,IdReporte,IdConvenioLaboralTrabajadorCategoria")] Mst_SolucionReporte mst_SolucionReporte)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_SolucionReporte).State = EntityState.Modified;
                db.SaveChanges();
                var result = new { value_e = "esuccess", msg = "La solución al reporte se ha guardado con éxito." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            ViewBag.IdTipoSolucion = new SelectList(db.Mst_TipoSolucionReporte, "IdTipoSolucion", "TipoSolucion", mst_SolucionReporte.IdTipoSolucion);
            //ViewBag.IdReporte = new SelectList(db.Mst_Reporte, "IdReporte", "NumeroReporte", mst_SolucionReporte.IdReporte);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_SolucionReporte.IdConvenioLaboralTrabajadorCategoria);
            return PartialView("_Edit",mst_SolucionReporte);
        }

        // GET: MstSolucionReporte/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_SolucionReporte mst_SolucionReporte = db.Mst_SolucionReporte.Find(id);
            if (mst_SolucionReporte == null)
            {
                return HttpNotFound();
            }
            return View(mst_SolucionReporte);
        }

        // POST: MstSolucionReporte/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Mst_SolucionReporte mst_SolucionReporte = db.Mst_SolucionReporte.Find(id);
            db.Mst_SolucionReporte.Remove(mst_SolucionReporte);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
