﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Mst
{
    public class MstEntregaReporteController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstEntregaReporte
        public ActionResult Index()
        {
            var mst_EntregaReporte = db.Mst_EntregaReporte.Include(m => m.Mst_Reporte).Include(m => m.Convenios_stConvenioLaboralTrabajadorCategoria);
            return View(mst_EntregaReporte.ToList());
        }

        // GET: MstEntregaReporte/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_EntregaReporte mst_EntregaReporte = db.Mst_EntregaReporte.Find(id);
            if (mst_EntregaReporte == null)
            {
                return HttpNotFound();
            }
            return View(mst_EntregaReporte);
        }

        // GET: MstEntregaReporte/Create
        public ActionResult Create()
        {
            //recive id del reporte
            int idReporte = System.Convert.ToInt32(Request["Reporte"]);

            
            //si existe ya registrado una entrega
            var mst_EntregaReporte = db.Mst_EntregaReporte.Where(t => t.IdReporte == idReporte).FirstOrDefault();
            if (mst_EntregaReporte != null)
            {
                return PartialView("Details", mst_EntregaReporte);
            }

            //comprobar si existe registrado una solución
            Mst_SolucionReporte mst_SolucionReporte = db.Mst_SolucionReporte.Where(t => t.IdReporte == idReporte).FirstOrDefault();
            if (mst_SolucionReporte == null)
            {
                var result = new { value_e = "efailed", msg = "No se puede entregar Reporte porque no se ha registrado una solución al mismo." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(idReporte);

            int area = mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica;
            var usersArea = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == area).Select(x => new { IdConvenioLaboralTrabajadorCategoriaRecibe = x.IdConvenioLaboralTrabajadorCategoria, NombreCompleto = x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }).ToList();

            ViewBag.IdConvenioLaboralTrabajadorCategoriaRecibe = new SelectList(usersArea, "IdConvenioLaboralTrabajadorCategoriaRecibe", "NombreCompleto");
            ViewBag.IdReporte = idReporte;
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            return PartialView("Create");
        }

        // POST: MstEntregaReporte/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdEntregaReporte,FechaEntrega,UsuarioRecibe,IdConvenioLaboralTrabajadorCategoriaRecibe,NotaEntrega,IdConvenioLaboralTrabajadorCategoria,IdReporte")] Mst_EntregaReporte mst_EntregaReporte)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            mst_EntregaReporte.IdConvenioLaboralTrabajadorCategoria = idUser;
            mst_EntregaReporte.FechaEntrega = DateTime.Now;
            
            

            if (ModelState.IsValid)
            {
                db.Mst_EntregaReporte.Add(mst_EntregaReporte);
                db.SaveChanges();
                var result = new { value_e = "esuccess", msg = "Se ha registrado la entrega con exito." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            int area = mst_EntregaReporte.Mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica;
            var usersArea = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == area).Select(x => new { IdConvenioLaboralTrabajadorCategoriaRecibe = x.IdConvenioLaboralTrabajadorCategoria, NombreCompleto = x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }).ToList();

            ViewBag.IdConvenioLaboralTrabajadorCategoriaRecibe = new SelectList(usersArea, "IdConvenioLaboralTrabajadorCategoriaRecibe", "NombreCompleto", mst_EntregaReporte.IdConvenioLaboralTrabajadorCategoriaRecibe); ViewBag.IdReporte = mst_EntregaReporte.IdReporte;
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_EntregaReporte.IdConvenioLaboralTrabajadorCategoria);
            return PartialView("Create",mst_EntregaReporte);
        }

        // GET: MstEntregaReporte/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_EntregaReporte mst_EntregaReporte = db.Mst_EntregaReporte.Find(id);
            if (mst_EntregaReporte == null)
            {
                return HttpNotFound();
            }

            int area = mst_EntregaReporte.Mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica;
            var usersArea = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == area).Select(x => new { IdConvenioLaboralTrabajadorCategoriaRecibe = x.IdConvenioLaboralTrabajadorCategoria, NombreCompleto = x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }).ToList();

            ViewBag.IdConvenioLaboralTrabajadorCategoriaRecibe = new SelectList(usersArea, "IdConvenioLaboralTrabajadorCategoriaRecibe", "NombreCompleto", mst_EntregaReporte.IdConvenioLaboralTrabajadorCategoriaRecibe);//ViewBag.IdReporte = new SelectList(db.Mst_Reporte, "IdReporte", "NumeroReporte", mst_EntregaReporte.IdReporte);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_EntregaReporte.IdConvenioLaboralTrabajadorCategoria);
            return PartialView("Edit",mst_EntregaReporte);
        }

        // POST: MstEntregaReporte/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdEntregaReporte,FechaEntrega,UsuarioRecibe,IdConvenioLaboralTrabajadorCategoriaRecibe,NotaEntrega,IdConvenioLaboralTrabajadorCategoria,IdReporte")] Mst_EntregaReporte mst_EntregaReporte)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_EntregaReporte).State = EntityState.Modified;
                db.SaveChanges();
                var result = new { value_e = "esuccess", msg = "Se ha registrado entrega del Reporte con éxito." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            int area = mst_EntregaReporte.Mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica;
            var usersArea = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == area).Select(x => new { IdConvenioLaboralTrabajadorCategoriaRecibe = x.IdConvenioLaboralTrabajadorCategoria, NombreCompleto = x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre +" "+ x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno +" "+ x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno }).ToList();

            ViewBag.IdConvenioLaboralTrabajadorCategoriaRecibe = new SelectList(usersArea, "IdConvenioLaboralTrabajadorCategoriaRecibe", "NombreCompleto", mst_EntregaReporte.IdConvenioLaboralTrabajadorCategoriaRecibe);
            //ViewBag.IdReporte = new SelectList(db.Mst_Reporte, "IdReporte", "NumeroReporte", mst_EntregaReporte.IdReporte);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_EntregaReporte.IdConvenioLaboralTrabajadorCategoria);
            return PartialView("Edit",mst_EntregaReporte);
        }

        // GET: MstEntregaReporte/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_EntregaReporte mst_EntregaReporte = db.Mst_EntregaReporte.Find(id);
            if (mst_EntregaReporte == null)
            {
                return HttpNotFound();
            }
            return View(mst_EntregaReporte);
        }

        // POST: MstEntregaReporte/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Mst_EntregaReporte mst_EntregaReporte = db.Mst_EntregaReporte.Find(id);
            db.Mst_EntregaReporte.Remove(mst_EntregaReporte);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
