﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Mst.Proveedor
{
    public class MstTipoInternetController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstTipoInternet
        public ActionResult Index()
        {
            return View(db.Mst_TipoInternet.ToList());
        }

        // GET: MstTipoInternet/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_TipoInternet mst_TipoInternet = db.Mst_TipoInternet.Find(id);
            if (mst_TipoInternet == null)
            {
                return HttpNotFound();
            }
            return View(mst_TipoInternet);
        }

        // GET: MstTipoInternet/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: MstTipoInternet/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdTipoInternet,TipoInternet")] Mst_TipoInternet mst_TipoInternet)
        {
            if (ModelState.IsValid)
            {
                db.Mst_TipoInternet.Add(mst_TipoInternet);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(mst_TipoInternet);
        }

        // GET: MstTipoInternet/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_TipoInternet mst_TipoInternet = db.Mst_TipoInternet.Find(id);
            if (mst_TipoInternet == null)
            {
                return HttpNotFound();
            }
            return View(mst_TipoInternet);
        }

        // POST: MstTipoInternet/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdTipoInternet,TipoInternet")] Mst_TipoInternet mst_TipoInternet)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_TipoInternet).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(mst_TipoInternet);
        }

        // GET: MstTipoInternet/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_TipoInternet mst_TipoInternet = db.Mst_TipoInternet.Find(id);
            if (mst_TipoInternet == null)
            {
                return HttpNotFound();
            }
            return View(mst_TipoInternet);
        }

        // POST: MstTipoInternet/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Mst_TipoInternet mst_TipoInternet = db.Mst_TipoInternet.Find(id);
            db.Mst_TipoInternet.Remove(mst_TipoInternet);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
