﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Mst.Proveedor
{
    public class MstProveedorController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstProveedor
        public ActionResult Index()
        {
            return View(db.Mst_Proveedor.ToList());
        }

        // GET: MstProveedor/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Proveedor mst_Proveedor = db.Mst_Proveedor.Find(id);
            if (mst_Proveedor == null)
            {
                return HttpNotFound();
            }
            return View(mst_Proveedor);
        }

        // GET: MstProveedor/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: MstProveedor/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdProveedor,RazonSocial,Nombre,ApellidoPaterno,ApellidoMaterno,TelefonoOficina,TelefonoMovil,CorreoElectronico")] Mst_Proveedor mst_Proveedor)
        {
            if (ModelState.IsValid)
            {
                db.Mst_Proveedor.Add(mst_Proveedor);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(mst_Proveedor);
        }

        // GET: MstProveedor/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Proveedor mst_Proveedor = db.Mst_Proveedor.Find(id);
            if (mst_Proveedor == null)
            {
                return HttpNotFound();
            }
            return View(mst_Proveedor);
        }

        // POST: MstProveedor/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdProveedor,RazonSocial,Nombre,ApellidoPaterno,ApellidoMaterno,TelefonoOficina,TelefonoMovil,CorreoElectronico")] Mst_Proveedor mst_Proveedor)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_Proveedor).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(mst_Proveedor);
        }

        // GET: MstProveedor/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Proveedor mst_Proveedor = db.Mst_Proveedor.Find(id);
            if (mst_Proveedor == null)
            {
                return HttpNotFound();
            }
            return View(mst_Proveedor);
        }

        // POST: MstProveedor/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Mst_Proveedor mst_Proveedor = db.Mst_Proveedor.Find(id);
            db.Mst_Proveedor.Remove(mst_Proveedor);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
