﻿using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class MstMarcaEquipoComputoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstMarcaEquipoComputo
        public ActionResult Index()
        {
            var mst_MarcaEquipoComputo = db.Mst_MarcaEquipoComputo.Include(m => m.Mst_TipoEquipoComputo);
            return View(mst_MarcaEquipoComputo.ToList());
        }

        // GET: MstMarcaEquipoComputo/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_MarcaEquipoComputo mst_MarcaEquipoComputo = db.Mst_MarcaEquipoComputo.Find(id);
            if (mst_MarcaEquipoComputo == null)
            {
                return HttpNotFound();
            }
            return View(mst_MarcaEquipoComputo);
        }

        // GET: MstMarcaEquipoComputo/Create
        public ActionResult Create(int id)
        {
            //int id = System.Convert.ToInt32(Request["id"]);
            //ViewBag.IdTipoEquipoComputo = new SelectList(db.Mst_TipoEquipoComputo, "IdTipoEquipoComputo", "TipoEquipoComputo");
            ViewBag.IdTipoEquipoComputo = new SelectList(db.Mst_TipoEquipoComputo.Where(t=>t.IdTipoEquipoComputo == id), "IdTipoEquipoComputo", "TipoEquipoComputo");

            return View();
        }

        // POST: MstMarcaEquipoComputo/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdMarcaEquipoComputo,MarcaEquipoComputo,IdTipoEquipoComputo")] Mst_MarcaEquipoComputo mst_MarcaEquipoComputo)
        {
            if (ModelState.IsValid)
            {
                db.Mst_MarcaEquipoComputo.Add(mst_MarcaEquipoComputo);
                db.SaveChanges();
                //return RedirectToAction("Index");
                return RedirectToAction("Index", "MstTipoEquipoComputo");
            }

            ViewBag.IdTipoEquipoComputo = new SelectList(db.Mst_TipoEquipoComputo, "IdTipoEquipoComputo", "TipoEquipoComputo", mst_MarcaEquipoComputo.IdTipoEquipoComputo);
            return View(mst_MarcaEquipoComputo);
        }

        // GET: MstMarcaEquipoComputo/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_MarcaEquipoComputo mst_MarcaEquipoComputo = db.Mst_MarcaEquipoComputo.Find(id);
            if (mst_MarcaEquipoComputo == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdTipoEquipoComputo = new SelectList(db.Mst_TipoEquipoComputo.Where(t=>t.IdTipoEquipoComputo == mst_MarcaEquipoComputo.IdTipoEquipoComputo), "IdTipoEquipoComputo", "TipoEquipoComputo", mst_MarcaEquipoComputo.IdTipoEquipoComputo);
            return View(mst_MarcaEquipoComputo);
        }

        // POST: MstMarcaEquipoComputo/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdMarcaEquipoComputo,MarcaEquipoComputo,IdTipoEquipoComputo")] Mst_MarcaEquipoComputo mst_MarcaEquipoComputo)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_MarcaEquipoComputo).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index", "MstTipoEquipoComputo");
            }
            ViewBag.IdTipoEquipoComputo = new SelectList(db.Mst_TipoEquipoComputo, "IdTipoEquipoComputo", "TipoEquipoComputo", mst_MarcaEquipoComputo.IdTipoEquipoComputo);
            return View(mst_MarcaEquipoComputo);
        }

        // GET: MstMarcaEquipoComputo/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_MarcaEquipoComputo mst_MarcaEquipoComputo = db.Mst_MarcaEquipoComputo.Find(id);
            if (mst_MarcaEquipoComputo == null)
            {
                return HttpNotFound();
            }
            return View(mst_MarcaEquipoComputo);
        }

        // POST: MstMarcaEquipoComputo/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int? id)
        {
            if (id == null || id <= 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_MarcaEquipoComputo mst_MarcaEquipoComputo = db.Mst_MarcaEquipoComputo.Find(id);
            db.Mst_MarcaEquipoComputo.Remove(mst_MarcaEquipoComputo);
            db.SaveChanges();
            return RedirectToAction("Index", "MstTipoEquipoComputo");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
