﻿using Newtonsoft.Json;
using Nova.Models;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web.Mvc;
using System.Web.Services;

namespace Nova.Controllers
{
    public class MstEquipoComputoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstEquipoComputo
        public ActionResult Index()
        {
            int idUsuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            int idUsuarioArea = Seguridad.Identidad.Usuario().IdEstructuraOrganica;

            MstSeguridadRoles rolUser = new MstSeguridadRoles();

            IQueryable<Mst_EquipoComputo> mst_EquipoComputo = null;
            if (rolUser.EsAdministrador())
            {
                mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo);
            }
            else
            {
                mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo).Where(t => t.IdEstructuraOrganica == idUsuarioArea);
            }
            
            
            return View(mst_EquipoComputo);
        }

        // GET: MstEquipoComputo/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_EquipoComputo mst_EquipoComputo = db.Mst_EquipoComputo.Find(id);
            if (mst_EquipoComputo == null)
            {
                return HttpNotFound();
            }
            return View(mst_EquipoComputo);
        }

        // GET: MstEquipoComputo/Create
        public ActionResult Create()
        {
            
            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            List<Catalogos_ctEstructuraOrganica> listArea = new List<Catalogos_ctEstructuraOrganica>();
            
            if (rolUser.EsAdministrador())
            {
                listArea = db.Catalogos_ctEstructuraOrganica.Where(t => t.EsVigente == true).ToList();
            }
            else
            {
                int idUsuarioArea = Seguridad.Identidad.Usuario().IdEstructuraOrganica;
                listArea = db.Catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == idUsuarioArea && t.EsVigente == true).ToList();
            }


            var MstTipoEC = db.Mst_TipoEquipoComputo.OrderBy(t => t.IdTipoEquipoComputo);
            var MstMarcaEC = db.Mst_MarcaEquipoComputo.Where(t => t.IdTipoEquipoComputo == MstTipoEC.Select(x => x.IdTipoEquipoComputo).FirstOrDefault()).OrderBy(s => s.IdMarcaEquipoComputo);
            ViewBag.IdEstructuraOrganica = new SelectList(listArea, "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.IdTipoEquipoComputo = new SelectList(MstTipoEC, "IdTipoEquipoComputo", "TipoEquipoComputo");
            ViewBag.IdMarcaEquipoComputo = new SelectList(MstMarcaEC, "IdMarcaEquipoComputo", "MarcaEquipoComputo");
            ViewBag.IdModeloEquipoComputo = new SelectList(db.Mst_ModeloEquipoComputo.Where(t => t.IdMarcaEquipoComputo == MstMarcaEC.Select(v => v.IdMarcaEquipoComputo).FirstOrDefault()), "IdModeloEquipoComputo", "ModeloEquipoComputo");

            return View();
        }

        // POST: MstEquipoComputo/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdEquipoComputo,EquipoComputo,NumeroSerie,NumeroInventario,FechaRegistro,FechaUlmimaModificacion,IdTipoEquipoComputo,IdEstructuraOrganica,IdMarcaEquipoComputo,IdModeloEquipoComputo")] Mst_EquipoComputo mst_EquipoComputo)
        {
            

            mst_EquipoComputo.FechaRegistro = DateTime.Now;
            mst_EquipoComputo.FechaUlmimaModificacion = DateTime.Now;

            if (ModelState.IsValid)
            {
                db.Mst_EquipoComputo.Add(mst_EquipoComputo);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            
            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            List<Catalogos_ctEstructuraOrganica> listArea = new List<Catalogos_ctEstructuraOrganica>();

            if (rolUser.EsAdministrador())
            {
                listArea = db.Catalogos_ctEstructuraOrganica.Where(t => t.EsVigente == true).ToList();
            }
            else
            {
                int idUsuarioArea = Seguridad.Identidad.Usuario().IdEstructuraOrganica;
                listArea = db.Catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == idUsuarioArea && t.EsVigente == true).ToList();
            }

            var MstTipoEC = db.Mst_TipoEquipoComputo.OrderBy(t => t.IdTipoEquipoComputo);
            var MstMarcaEC = db.Mst_MarcaEquipoComputo.Where(t => t.IdTipoEquipoComputo == mst_EquipoComputo.IdTipoEquipoComputo).OrderBy(s => s.IdMarcaEquipoComputo);

            ViewBag.IdEstructuraOrganica = new SelectList(listArea, "IdEstructuraOrganica", "EstructuraOrganica", mst_EquipoComputo.IdEstructuraOrganica);
            ViewBag.IdTipoEquipoComputo = new SelectList(MstTipoEC, "IdTipoEquipoComputo", "TipoEquipoComputo", mst_EquipoComputo.IdTipoEquipoComputo);
            ViewBag.IdMarcaEquipoComputo = new SelectList(MstMarcaEC, "IdMarcaEquipoComputo", "MarcaEquipoComputo", mst_EquipoComputo.IdMarcaEquipoComputo);
            ViewBag.IdModeloEquipoComputo = new SelectList(db.Mst_ModeloEquipoComputo.Where(t => t.IdMarcaEquipoComputo == mst_EquipoComputo.IdMarcaEquipoComputo), "IdModeloEquipoComputo", "ModeloEquipoComputo", mst_EquipoComputo.IdModeloEquipoComputo);

            return View(mst_EquipoComputo);
        }

        // GET: MstEquipoComputo/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_EquipoComputo mst_EquipoComputo = db.Mst_EquipoComputo.Find(id);
            if (mst_EquipoComputo == null)
            {
                return HttpNotFound();
            }


            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            List<Catalogos_ctEstructuraOrganica> listArea = new List<Catalogos_ctEstructuraOrganica>();

            if (rolUser.EsAdministrador())
            {
                listArea = db.Catalogos_ctEstructuraOrganica.Where(t => t.EsVigente == true).ToList();
            }
            else
            {
                int idUsuarioArea = Seguridad.Identidad.Usuario().IdEstructuraOrganica;
                listArea = db.Catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == idUsuarioArea && t.EsVigente == true).ToList();
            }
            //ViewBag.IdMarcaEquipoComputo = new SelectList(db.Mst_MarcaEquipoComputo, "IdMarcaEquipoComputo", "MarcaEquipoComputo", mst_EquipoComputo.IdMarcaEquipoComputo);
            //ViewBag.IdModeloEquipoComputo = new SelectList(db.Mst_ModeloEquipoComputo, "IdModeloEquipoComputo", "ModeloEquipoComputo", mst_EquipoComputo.IdModeloEquipoComputo);
            //ViewBag.IdTipoEquipoComputo = new SelectList(db.Mst_TipoEquipoComputo, "IdTipoEquipoComputo", "TipoEquipoComputo", mst_EquipoComputo.IdTipoEquipoComputo);
            var MstTipoEC = db.Mst_TipoEquipoComputo.OrderBy(t => t.IdTipoEquipoComputo);
            var MstMarcaEC = db.Mst_MarcaEquipoComputo.Where(t => t.IdTipoEquipoComputo == mst_EquipoComputo.IdTipoEquipoComputo).OrderBy(s => s.IdMarcaEquipoComputo);

            ViewBag.IdEstructuraOrganica = new SelectList(listArea, "IdEstructuraOrganica", "EstructuraOrganica", mst_EquipoComputo.IdEstructuraOrganica);
            ViewBag.IdTipoEquipoComputo = new SelectList(MstTipoEC, "IdTipoEquipoComputo", "TipoEquipoComputo", mst_EquipoComputo.IdTipoEquipoComputo);
            ViewBag.IdMarcaEquipoComputo = new SelectList(MstMarcaEC, "IdMarcaEquipoComputo", "MarcaEquipoComputo", mst_EquipoComputo.IdMarcaEquipoComputo);
            ViewBag.IdModeloEquipoComputo = new SelectList(db.Mst_ModeloEquipoComputo.Where(t => t.IdMarcaEquipoComputo == mst_EquipoComputo.IdMarcaEquipoComputo), "IdModeloEquipoComputo", "ModeloEquipoComputo", mst_EquipoComputo.IdModeloEquipoComputo);


            return View(mst_EquipoComputo);
        }

        // POST: MstEquipoComputo/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdEquipoComputo,EquipoComputo,NumeroSerie,NumeroInventario,FechaRegistro,FechaUlmimaModificacion,IdTipoEquipoComputo,IdEstructuraOrganica,IdMarcaEquipoComputo,IdModeloEquipoComputo")] Mst_EquipoComputo mst_EquipoComputo)
        {
            //mst_EquipoComputo.FechaRegistro = DateTime.Now;
            mst_EquipoComputo.FechaUlmimaModificacion = DateTime.Now;
            if (ModelState.IsValid)
            {
                db.Entry(mst_EquipoComputo).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            List<Catalogos_ctEstructuraOrganica> listArea = new List<Catalogos_ctEstructuraOrganica>();

            if (rolUser.EsAdministrador())
            {
                listArea = db.Catalogos_ctEstructuraOrganica.Where(t => t.EsVigente == true).ToList();
            }
            else
            {
                int idUsuarioArea = Seguridad.Identidad.Usuario().IdEstructuraOrganica;
                listArea = db.Catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == idUsuarioArea && t.EsVigente == true).ToList();
            }

            var MstTipoEC = db.Mst_TipoEquipoComputo.OrderBy(t => t.IdTipoEquipoComputo);
            var MstMarcaEC = db.Mst_MarcaEquipoComputo.Where(t => t.IdTipoEquipoComputo == mst_EquipoComputo.IdTipoEquipoComputo).OrderBy(s => s.IdMarcaEquipoComputo);

            ViewBag.IdEstructuraOrganica = new SelectList(listArea, "IdEstructuraOrganica", "EstructuraOrganica", mst_EquipoComputo.IdEstructuraOrganica);
            ViewBag.IdTipoEquipoComputo = new SelectList(MstTipoEC, "IdTipoEquipoComputo", "TipoEquipoComputo", mst_EquipoComputo.IdTipoEquipoComputo);
            ViewBag.IdMarcaEquipoComputo = new SelectList(MstMarcaEC, "IdMarcaEquipoComputo", "MarcaEquipoComputo", mst_EquipoComputo.IdMarcaEquipoComputo);
            ViewBag.IdModeloEquipoComputo = new SelectList(db.Mst_ModeloEquipoComputo.Where(t => t.IdMarcaEquipoComputo == mst_EquipoComputo.IdMarcaEquipoComputo), "IdModeloEquipoComputo", "ModeloEquipoComputo", mst_EquipoComputo.IdModeloEquipoComputo);

            //ViewBag.IdMarcaEquipoComputo = new SelectList(db.Mst_MarcaEquipoComputo, "IdMarcaEquipoComputo", "MarcaEquipoComputo", mst_EquipoComputo.IdMarcaEquipoComputo);
            //ViewBag.IdModeloEquipoComputo = new SelectList(db.Mst_ModeloEquipoComputo, "IdModeloEquipoComputo", "ModeloEquipoComputo", mst_EquipoComputo.IdModeloEquipoComputo);
            //ViewBag.IdTipoEquipoComputo = new SelectList(db.Mst_TipoEquipoComputo, "IdTipoEquipoComputo", "TipoEquipoComputo", mst_EquipoComputo.IdTipoEquipoComputo);
            return View(mst_EquipoComputo);
        }

        // GET: MstEquipoComputo/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_EquipoComputo mst_EquipoComputo = db.Mst_EquipoComputo.Find(id);
            if (mst_EquipoComputo == null)
            {
                return HttpNotFound();
            }
            return View(mst_EquipoComputo);
        }

        // POST: MstEquipoComputo/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        [HttpPost]
        public ActionResult DeleteConfirmed()
        {
            var result = new { value = "", msg = "" };
            //var result = new { };
            int idEquipo = System.Convert.ToInt32(Request["EquipoId"]);
            if (idEquipo <= 0)
            {
                result = new { value = "efailed", msg = "Error al identificar el Equipo" };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            

            Mst_EquipoComputo mst_EquipoComputo = db.Mst_EquipoComputo.Find(idEquipo);
            if (mst_EquipoComputo == null)
            {
                result = new { value = "efailed", msg = "No se ha podido localizar el Equipo." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            try
            {
                db.Mst_EquipoComputo.Remove(mst_EquipoComputo);
                db.SaveChanges();
            }
            catch (Exception e)
            {
                result = new { value = "efailed", msg = e.ToString() };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            //return RedirectToAction("Index");
            result = new { value = "esuccess", msg = "Se ha eliminado el elemento correctamente." };
            return Json(result, JsonRequestBehavior.AllowGet);
        }


        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

        //[HttpPost]
        //public string GetMarcaOfTipo()
        //{
        //    int idTipo = System.Convert.ToInt32(Request["Tipo"]);

        //    var modelMarca = db.Mst_MarcaEquipoComputo.Where(t => t.IdTipoEquipoComputo == idTipo).Select(x => new {
        //        IdMarcaEquipoComputo = x.IdMarcaEquipoComputo,
        //        MarcaEquipoComputo = x.MarcaEquipoComputo
        //    }).ToList();

        //    return JsonConvert.SerializeObject(modelMarca);
        //}

        [WebMethod]
        public JsonResult GetMarcaOfTipo(int Tipo)
        {
            var modelMarca = db.Mst_MarcaEquipoComputo.Where(t => t.IdTipoEquipoComputo == Tipo).Select(x => new
            {
                IdMarcaEquipoComputo = x.IdMarcaEquipoComputo,
                MarcaEquipoComputo = x.MarcaEquipoComputo
            }).ToList();
            return Json(modelMarca, JsonRequestBehavior.AllowGet);
        }

        [WebMethod]
        public JsonResult GetModeloOfMarca(int Tipo, int Marca)
        {
            var modelos = db.Mst_ModeloEquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Where(t => t.IdMarcaEquipoComputo == Marca && t.Mst_MarcaEquipoComputo.IdTipoEquipoComputo == Tipo).ToList();
            var modelModelos = modelos.Select(x => new
            {
                IdModeloEquipoComputo = x.IdModeloEquipoComputo,
                ModeloEquipoComputo = x.ModeloEquipoComputo
            }).ToList();

            return Json(modelModelos, JsonRequestBehavior.AllowGet);
        }


        //PARA OBTENER LOS EQUIPO EN LA BÚSQUEDA POR NÚMERO DE SERIE
        [HttpPost]
        public ActionResult GetEquipoComputo_serie()
        {
            string numeroSerie = System.Convert.ToString(Request["Serie"]);
            if (numeroSerie == "")
            {
                var result = new { value_e = "efailed", msg = "El campo Serie esta vacío." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo);

            return PartialView("_ListEquiposComputo", mst_EquipoComputo.Where(t => t.NumeroSerie == numeroSerie).ToList());


        }

        //PARA OBTENER LOS EQUIPO EN LA BÚSQUEDA POR NÚMERO DE IINVENTARIO
        [HttpPost]
        public ActionResult GetEquipoComputo_inventario()
        {
            string numeroInventario = System.Convert.ToString(Request["Inventario"]);
            if (numeroInventario == "")
            {
                var result = new { value_e = "efailed", msg = "El campo Inventario esta vacío." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo);

            return PartialView("_ListEquiposComputo", mst_EquipoComputo.Where(t => t.NumeroInventario == numeroInventario).ToList());


        }

        //para obtener equipos en la busqueda al crear los tickets por medio de TIPO-MARCA-MODELO
        [HttpPost]
        public ActionResult GetEquipoComputo_tmm()
        {
            int idTipo = System.Convert.ToInt32(Request["Tipo"]);
            int idMarca = System.Convert.ToInt32(Request["Marca"]);
            int idModelo = System.Convert.ToInt32(Request["Modelo"]);

            if (idTipo <= 0)
            {
                var result = new { value_e = "efailed", msg = "No se localiza el Tipo. Selecciona Tipo." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            if (idMarca <= 0)
            {
                var result = new { value_e = "efailed", msg = "No se localiza la Marca. Selecciona Marca." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            if (idModelo <= 0)
            {
                var result = new { value_e = "efailed", msg = "No se localiza el Modelo. Selecciona Modelo." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo);
            //return View(mst_EquipoComputo.ToList());
            return PartialView("_ListEquiposComputo", mst_EquipoComputo.Where(t => t.IdTipoEquipoComputo == idTipo && t.IdMarcaEquipoComputo == idMarca && t.IdModeloEquipoComputo == idModelo).ToList());

        }




    }
}
