﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers
{
    public class MaterialDidactico_EditorialController : Controller
    {
        //
        // GET: /MaterialDidactico_Editorial/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_Editorial()
        {
            var model = db.MaterialDidactico_Editorial;
            return PartialView("_pvMaterialDidactico_Editorial", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_EditorialAddNew(Nova.Models.MaterialDidactico_Editorial item)
        {
            var model = db.MaterialDidactico_Editorial;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvMaterialDidactico_Editorial", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_EditorialUpdate(Nova.Models.MaterialDidactico_Editorial item)
        {
            var model = db.MaterialDidactico_Editorial;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdEditorial == item.IdEditorial);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvMaterialDidactico_Editorial", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_EditorialDelete(System.Int16 IdEditorial)
        {
            var model = db.MaterialDidactico_Editorial;
            if (IdEditorial != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdEditorial == IdEditorial);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                                       
                    
                }
            }


            return PartialView("_pvMaterialDidactico_Editorial", model.ToList());
        }
    }
}
