﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers
{
    public class MaterialDidactico_AutorController : Controller
    {
        //
        // GET: /MaterialDidactico_Autor/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_Autor()
        {
            var model = db.MaterialDidactico_Autor;
            return PartialView("_pvMaterialDidactico_Autor", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_AutorAddNew(Nova.Models.MaterialDidactico_Autor item)
        {
            var model = db.MaterialDidactico_Autor;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvMaterialDidactico_Autor", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_AutorUpdate(Nova.Models.MaterialDidactico_Autor item)
        {
            var model = db.MaterialDidactico_Autor;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdAutor == item.IdAutor);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvMaterialDidactico_Autor", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_AutorDelete(System.Int16 IdAutor)
        {
            var model = db.MaterialDidactico_Autor;
            if (IdAutor != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdAutor == IdAutor);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                                       
                    
                }
            }


            return PartialView("_pvMaterialDidactico_Autor", model.ToList());
        }
    }
}
