﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class MaterialDidactico_AsignaturasController : Controller
    {
        //
        // GET: /MaterialDidactico_Asignaturas/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_Asignaturas()
        {
            var model = db.MaterialDidactico_Asignaturas;
            return PartialView("_pvMaterialDidactico_Asignaturas", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_AsignaturasAddNew(Nova.Models.MaterialDidactico_Asignaturas item)
        {
            var model = db.MaterialDidactico_Asignaturas;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvMaterialDidactico_Asignaturas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_Asignaturas(Nova.Models.MaterialDidactico_Asignaturas item)
        {
            var model = db.MaterialDidactico_Asignaturas;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdAsignatura == item.IdAsignatura);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvMaterialDidactico_Asignaturas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_AsignaturasDelete(System.Int16 IdAsignatura)
        {
            var model = db.MaterialDidactico_Asignaturas;
            if (IdAsignatura != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdAsignatura == IdAsignatura);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvMaterialDidactico_Asignaturas", model.ToList());
        }
    }
}
