﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class MaterialDidactico_AsignaturaTituloController : Controller
    {
        //
        // GET: /MaterialDidactico_AsignaturaTitulo/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_AsignaturaTitulo()
        {
            var model = db.MaterialDidactico_AsignaturaTitulo;
            return PartialView("_pvMaterialDidactico_AsignaturaTitulo", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_AsignaturaTituloAddNew(Nova.Models.MaterialDidactico_AsignaturaTitulo item)
        {
            var model = db.MaterialDidactico_AsignaturaTitulo;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvMaterialDidactico_AsignaturaTitulo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_AsignaturaTitulo(Nova.Models.MaterialDidactico_AsignaturaTitulo item)
        {
            var model = db.MaterialDidactico_AsignaturaTitulo;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdAsignaturaTitulo == item.IdAsignaturaTitulo);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvMaterialDidactico_AsignaturaTitulo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_AsignaturaTituloDelete(System.Int16 IdAsignaturaTitulo)
        {
            var model = db.MaterialDidactico_AsignaturaTitulo;
            if (IdAsignaturaTitulo != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdAsignaturaTitulo == IdAsignaturaTitulo);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvMaterialDidactico_AsignaturaTitulo", model.ToList());
        }
    }
}
