﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Nova.Libraries;
using DevExpress.Web;
using DevExpress.Web.Mvc;
using System.Web.UI;
using Rotativa;

namespace Nova.Controllers.MaterialDidactico
{
    public class MaterialDidacticoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

       

        //
        // GET: /DatosPersonales/

        public ActionResult Index()
        {
            return View(db.Kardex_ctDatosPersonales.ToList());
        }

           
        public ActionResult Paso2(int id,string email,string check,string isPost=null)
        {
            ViewBag.Id = id;
            ViewBag.email = email;
            ViewBag.check = check;
            ViewBag.IsPost = isPost;
            if (Kardex_ctDatosPersonales.getProcesoCompletado(id) == true)
            {
                return View("terminado");
            }
            else
            {
                string codificado = Cifrado.Encrypt(email + id.ToString());

                if (HttpUtility.HtmlDecode(check) == codificado)
                {
                    if (isPost!=null)
                    MessageBox.Show(ViewData, TipoMensaje.Success, "Los datos Personales se han grabado exitosamente");



                    return View();
                }
                else

                    return View("NoAutorizado");
            }

        }

        //
        // GET: /DatosPersonales/Details/5

        public ActionResult Details(int id = 0)
        {
            Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
            if (kardex_ctdatospersonales == null)
            {
                return HttpNotFound();
            }
            return View(kardex_ctdatospersonales);
        }

        //
        // GET: /DatosPersonales/Create

        public ActionResult Create()
        {
            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");
            //ViewBag.ItemIDList = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");

             
            return View();
        }

        //
        // POST: /DatosPersonales/Create

        [HttpPost]
        public ActionResult Create(Kardex_ctDatosPersonales kardex_ctdatospersonales)
        {
            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");

            ViewBag.urlimage = "";
            ViewBag.IdLocalidadNacimientoText = "";
            ViewBag.IdLocalidadViveText = "";
            

            if (Request.Files[1].FileName != "" )
                kardex_ctdatospersonales.Fotografia =StreamHelpers.ReadFully(Request.Files[1].InputStream);
            else
                if (Request["hfUrlImage"]!=null)
                    if (Request["hfUrlImage"] != "")
                    {
                        kardex_ctdatospersonales.Fotografia = StreamHelpers.FromFile(Request["hfUrlImage"].Replace("..", "~"));
                        ViewBag.urlimage = Request["hfUrlImage"];
                    }

            if (Request["IdLocalidadNacimientoText"] != "")
                ViewBag.IdLocalidadNacimientoText = Request["IdLocalidadNacimientoText"];

            if (Request["IdLocalidadViveText"] != "")
                ViewBag.IdLocalidadViveText = Request["IdLocalidadViveText"];


            if (kardex_ctdatospersonales.ValidaModelo().IsValid)
            {


                if (ModelState.IsValid)
                {


                    db.Kardex_ctDatosPersonales.Add(kardex_ctdatospersonales);
                    db.SaveChanges();
                    //return RedirectToAction("Index");
                    MessageBox.Show(ViewData, TipoMensaje.Success, "Registro Grabado con éxito ");

                }
                else
                {
                    var errors = ModelState.Select(x => x.Value.Errors)
                                .Where(y => y.Count > 0)
                                .ToList();
                }      
            }
            else
                MessageBox.Show(ViewData, TipoMensaje.Warning, kardex_ctdatospersonales.ValidaModelo().Mensaje);

            return View(kardex_ctdatospersonales);
        }

        //
        // GET: /DatosPersonales/Edit/5

        //public ActionResult Edit(int id )
            public ActionResult Edit(int id ,string email,string check)
        {

            
            ViewBag.Id = id;
            ViewBag.email = email;
            ViewBag.check = check;

            if (Kardex_ctDatosPersonales.getProcesoCompletado(id) == true)
            {
                return View("terminado");
            }
            else
            {
                string codificado = Cifrado.Encrypt(email + id.ToString());

                if (HttpUtility.UrlDecode(check) == codificado)
                {
                    ViewBag.IdKardex = id;
                    ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");


                    Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
                    ViewBag.urlimage = kardex_ctdatospersonales.Fotografia;


                    ViewBag.IdLocalidadNacimientoText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoNacimiento, kardex_ctdatospersonales.IdMunicipioNacimiento, kardex_ctdatospersonales.IdLocalidadNacimiento);


                    ViewBag.IdLocalidadViveText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoVive, kardex_ctdatospersonales.IdMunicipioVive, kardex_ctdatospersonales.IdLocalidadVive);

                    kardex_ctdatospersonales.CorreoElectronico = email;

                    if (kardex_ctdatospersonales == null)
                    {
                        return HttpNotFound();
                    }
                    return View(kardex_ctdatospersonales);
                }
                else
                    //throw new Exception(" Los parametros de la página a la que esta accesando no son válidos");

                    return View("NoAutorizado");
            }
         
        }


            public ActionResult Terminar(int id, string email, string check)
            {

                string codificado = Cifrado.Encrypt(email + id.ToString());

                if (HttpUtility.HtmlDecode(check) == codificado)
                {
                    ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");
                    ViewBag.IdKardex = id;

                    Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
                    ViewBag.urlimage = kardex_ctdatospersonales.Fotografia;
                   
                    kardex_ctdatospersonales.ProcesoCompletado = true;

                    db.SaveChanges();

                    ViewBag.IdLocalidadNacimientoText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoNacimiento, kardex_ctdatospersonales.IdMunicipioNacimiento, kardex_ctdatospersonales.IdLocalidadNacimiento);


                    ViewBag.IdLocalidadViveText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoVive, kardex_ctdatospersonales.IdMunicipioVive, kardex_ctdatospersonales.IdLocalidadVive);

                    if (kardex_ctdatospersonales == null)
                    {
                        return HttpNotFound();
                    }
                    //return View(kardex_ctdatospersonales);

                    return new ViewAsPdf(kardex_ctdatospersonales) { CustomSwitches = " --header-center  \" COLEGIO DE ESTUDIOS CIENTÍFICOS Y TECNOLÓGICOS DEL ESTADO DE OAXACA\" --footer-center \"Página [page] de [topage]\" --page-size Letter --footer-line --header-line " };
                }
                else
                    //throw new Exception(" Los parametros de la página a la que esta accesando no son válidos");

                    return View("NoAutorizado");


            }
        //
        // POST: /DatosPersonales/Edit/5

        [HttpPost]
        public ActionResult Edit(Kardex_ctDatosPersonales kardex_ctdatospersonales)
        {
            Int32 idk = kardex_ctdatospersonales.IdKardex;

            byte[] foto= db.Kardex_ctDatosPersonales.Where(e => e.IdKardex == idk).Select(f=> f.Fotografia).SingleOrDefault();



            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");
            ViewBag.IdKardex = kardex_ctdatospersonales.IdKardex;

            ViewBag.urlimage = "";
            ViewBag.IdLocalidadNacimientoText = "";
            ViewBag.IdLocalidadViveText = "";

            if (Request.Files[0].FileName != "")
                kardex_ctdatospersonales.Fotografia = StreamHelpers.ReadFully(Request.Files[0].InputStream);
            else

                //if (Request["hfUrlImage"] != null)
                //    if (Request["hfUrlImage"] != "")
                //    {
                //        kardex_ctdatospersonales.Fotografia = StreamHelpers.FromFile(Request["hfUrlImage"].Replace("..", "~"));
                //        ViewBag.urlimage = Request["hfUrlImage"];
                //    }
            {
                
                kardex_ctdatospersonales.Fotografia = foto;
            }

            if (Request["IdLocalidadNacimientoText"] != "")
                ViewBag.IdLocalidadNacimientoText = Request["IdLocalidadNacimientoText"];

            if (Request["IdLocalidadViveText"] != "")
                ViewBag.IdLocalidadViveText = Request["IdLocalidadViveText"];


            if (kardex_ctdatospersonales.ValidaModelo().IsValid)
            {

                if (ModelState.IsValid)
                {
                    
                    db.Entry(kardex_ctdatospersonales).State = System.Data.Entity.EntityState.Modified;
                    //db.Kardex_ctDatosPersonales.Add(kardex_ctdatospersonales);
                    db.SaveChanges();
                       string codificado = Cifrado.Encrypt( kardex_ctdatospersonales.CorreoElectronico+kardex_ctdatospersonales.IdKardex.ToString());

                    
                        MessageBox.Show(ViewData, TipoMensaje.Information, "Los datos Personales se han grabado exitosamente");

                    return RedirectToAction("Paso2", "DatosPersonales", new { id = kardex_ctdatospersonales.IdKardex, email = kardex_ctdatospersonales.CorreoElectronico, check = codificado ,isPost="1"});
                }
                else
                {
                    var errors = ModelState.Select(x => x.Value.Errors)
                             .Where(y => y.Count > 0)
                             .ToList();


                }
            }
            else
                MessageBox.Show(ViewData, TipoMensaje.Warning, kardex_ctdatospersonales.ValidaModelo().Mensaje);


            return View(kardex_ctdatospersonales);
        }

        //
        // GET: /DatosPersonales/Delete/5

        public ActionResult Delete(int id = 0)
        {
            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");

            Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
            if (kardex_ctdatospersonales == null)
            {
                return HttpNotFound();
            }
            return View(kardex_ctdatospersonales);
        }

        //
        // POST: /DatosPersonales/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {
            Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
            db.Kardex_ctDatosPersonales.Remove(kardex_ctdatospersonales);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }

        //public ActionResult CallbacksImageUpload(IEnumerable<UploadedFile> ucCallbacks)
        //{
        //    return null;
        //}

        public ActionResult UploadControlCallbackAction()
        {
            UploadControlExtension.GetUploadedFiles("Fotografia", UploadControlDemosHelper.UploadControlValidationSettings, UploadControlDemosHelper.uc_FileUploadComplete);
            return null;
        }
       
               public ActionResult getFotografia(int id)
            {
                byte[] image = Kardex_ctDatosPersonales.getFotografia(id);
                   if (image==null)
                       return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.png"), "image/jpg");
                   else

                return File(image, "image/jpg");
            }

               public ActionResult Terminado(int id, string email, string check)
        {

            ViewBag.Id = id;
            ViewBag.email = email;
            ViewBag.check = check;
            return View();
        }      

    }

     

      

    public class UploadControlDemosHelper
    {
        public const string UploadDirectory = "/Content/UploadControl/UploadFolder/";

        public static readonly DevExpress.Web.UploadControlValidationSettings UploadControlValidationSettings = new DevExpress.Web.UploadControlValidationSettings
        {
            AllowedFileExtensions = new string[] { ".jpg", ".jpeg", ".jpe", ".gif", ".bmp", },
            MaxFileSize = 20971520,
        };

        public static void uc_FileUploadComplete(object sender, FileUploadCompleteEventArgs e)
        {
            if (e.UploadedFile.IsValid)
            {
                string resultFilePath = HttpContext.Current.Request.MapPath(UploadDirectory + e.UploadedFile.FileName);
               e.UploadedFile.SaveAs(resultFilePath, true);//Code Central Mode - Uncomment This Line
                IUrlResolutionService urlResolver = sender as IUrlResolutionService;
                if (urlResolver != null)
                {
                    //e.CallbackData = urlResolver.ResolveClientUrl(UploadDirectory + e.UploadedFile.FileName);
                    e.CallbackData = String.Format(HttpContext.Current.Request.IsSecureConnection ? "https://{0}{1}{2}" : "http://{0}{1}{2}", HttpContext.Current.Request.Url.Host, (HttpContext.Current.Request.Url.IsDefaultPort ? "" : ":" + HttpContext.Current.Request.Url.Port), UploadDirectory + e.UploadedFile.FileName);
                }
            }
        }

       
    }
}