﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Nova.Libraries;
using DevExpress.Web;
using DevExpress.Web.Mvc;
using System.Web.UI;
using Rotativa;
using System.Transactions;
using System.Drawing;
using DotNet.Highcharts;
using DotNet.Highcharts.Options;
using DotNet.Highcharts.Enums;
using Seguridad;
using DotNet.Highcharts.Helpers;
using System.Collections;

namespace Nova.Controllers.MaterialDidactico
{
    public class ChartsModel
    {
        public Highcharts Chart1 { get; set; }
        public Highcharts Chart2 { get; set; }
    }

    public class MaterialDidacticoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        //  private bdAriesEntities dbAries = new bdAriesEntities();

        //
        // GET: /DatosPersonales/
        public ActionResult EstadisticaModalidad()
        {
            //throw new ApplicationException("La fecha para crear solicitudes ha finalizado");

            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(f => f.FechaInicio).FirstOrDefault();

            List<TipoModalidad> ltm = new List<TipoModalidad>();
            TipoModalidad tm = new TipoModalidad();
            tm.Modalidad = "PLANTEL";
            ltm.Add(tm);
            TipoModalidad tm2 = new TipoModalidad();
            tm2.Modalidad = "EMSAD";
            ltm.Add(tm2);
            ViewBag.Modalidad = ltm;

            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            ViewBag.Id = id;

            return View();
        }
        public ActionResult DetalleSolicitudesModalidad(int id)
        {
            //int id = 0;
            //if (Request["IdConvocatoria"] != null)
            //    id = System.Convert.ToInt32(Request["IdConvocatoria"]);


            ViewBag.ListadoDetalleModalidad = Nova.Models.MaterialDidactico_Solicitud.ObtenSolicitudesModalidad(id);

            return PartialView(ViewBag.ListadoDetalleModalidad);
        }
        public ActionResult DetalleSolicitudesModalidadArea(string Modalidad, int id)
        {

            ViewBag.ListadoDetalleModalidadArea = Nova.Models.MaterialDidactico_Solicitud.ObtenSolicitudesModalidadArea(Modalidad, id);
            return PartialView(ViewBag.ListadoDetalleModalidadArea);
        }
        public ActionResult DetalleSolicitudesModalidadCentro(string Centro, int id)
        {

            ViewBag.ListadoDetalleModalidadCentro = Nova.Models.MaterialDidactico_Solicitud.ObtenSolicitudesModalidadCentro(Centro, id);
            return PartialView(ViewBag.ListadoDetalleModalidadCentro);
        }
        public ActionResult DetalleSolicitudesModalidadAreaCentro(string area, int id)
        {

            ViewBag.ListadoDetalleModalidadAreaCentro = Nova.Models.MaterialDidactico_Solicitud.ObtenSolicitudesModalidadAreaCentro(area, id);
            return PartialView(ViewBag.ListadoDetalleModalidadAreaCentro);
        }

        public JsonResult ListarCentrosModalidad(string modalidad, int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            if (id == 0)
            {
                var sm = from r in db.vwAulasDidacticas
                         where r.Modalidad == modalidad
                         orderby r.Modalidad
                         group r by r.CentroEducativo into grp
                         select new { key = grp.Key };
                List<CentroEducativo> listacentros = new List<CentroEducativo>();
                foreach (var item in sm)
                {
                    CentroEducativo sol = new CentroEducativo();
                    sol.Centro = item.key;
                    listacentros.Add(sol);
                }

                var JsonListado = Json(listacentros.ToList(), JsonRequestBehavior.AllowGet);
                return JsonListado;
            }
            else
            {
                var sm = from r in db.vwAulasDidacticas
                         where r.Modalidad == modalidad && r.IdConvocatoria == id
                         orderby r.Modalidad
                         group r by r.CentroEducativo into grp
                         select new { key = grp.Key };
                List<CentroEducativo> listacentros = new List<CentroEducativo>();
                foreach (var item in sm)
                {
                    CentroEducativo sol = new CentroEducativo();
                    sol.Centro = item.key;
                    listacentros.Add(sol);
                }

                var JsonListado = Json(listacentros.ToList(), JsonRequestBehavior.AllowGet);
                return JsonListado;
            }

        }
        public JsonResult ListarAreaCentrosModalidad(string modalidad, int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            var sm = from r in db.vwAulasDidacticas
                     where r.Modalidad == modalidad
                     orderby r.Modalidad
                     group r by r.Asignatura into grp
                     select new { key = grp.Key };
            List<CentroEducativo> listacentros = new List<CentroEducativo>();
            foreach (var item in sm)
            {
                CentroEducativo sol = new CentroEducativo();
                sol.Centro = item.key;
                listacentros.Add(sol);
            }

            var JsonListado = Json(listacentros.ToList(), JsonRequestBehavior.AllowGet);
            return JsonListado;

        }

        public ActionResult Autorizar(int id)
        {
            MaterialDidactico_Solicitud materialdidactico_solicitud = db.MaterialDidactico_Solicitud.Where(r => r.IdSolicitud == id).FirstOrDefault();

            return View(materialdidactico_solicitud);
        }

        //
        // POST: /InventarioQuincena/Create

        [HttpPost]
        public ActionResult Autorizar()
        {
            int id = System.Convert.ToInt32(Request["hfidsolicitud"]);
            MaterialDidactico_Solicitud materialdidactico_solicitud = db.MaterialDidactico_Solicitud.Where(r => r.IdSolicitud == id).FirstOrDefault();


            materialdidactico_solicitud.FechaAtencion = DateTime.Now;

            materialdidactico_solicitud.IdUsuarioAutorizo = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {


                if (Request["hfno"] == "1")
                {
                    db.MaterialDidactico_Solicitud.Add(materialdidactico_solicitud);
                    db.Entry(materialdidactico_solicitud).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();

                    foreach (var item in materialdidactico_solicitud.MaterialDidactico_SolicitudDetalle)
                    {
                        item.EsAutorizada = false;



                        db.MaterialDidactico_SolicitudDetalle.Add(item);
                        db.Entry(item).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();
                    }
                    //return RedirectToAction("VersolicitudesArea", "MaterialDidactico_solicitud");
                    return View("AutorizarNo");
                }


                if (Request["hfsave"] == "1")
                {
                    db.MaterialDidactico_Solicitud.Add(materialdidactico_solicitud);
                    db.Entry(materialdidactico_solicitud).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();

                    foreach (var item in materialdidactico_solicitud.MaterialDidactico_SolicitudDetalle)
                    {
                        int cantidad = System.Convert.ToInt32(Request["cantidad" + item.IdSolicitudDetalle.ToString()]);
                        item.EsAutorizada = true;
                        item.CantidadAutorizada = cantidad;
                        item.VistoBueno = false;

                        //MaterialDidactico_Titulo existencias = db.MaterialDidactico_Titulo.Where(f => f.IdTitulo == item.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Titulo.IdTitulo).FirstOrDefault();

                        //existencias.Existencia = existencias.Existencia - item.CantidadAutorizada;

                        //db.MaterialDidactico_Titulo.Add(existencias);
                        //db.Entry(existencias).State = System.Data.Entity.EntityState.Modified;
                        //db.SaveChanges();


                        db.MaterialDidactico_SolicitudDetalle.Add(item);
                        db.Entry(item).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();
                    }

                }

                scope.Complete();

                // return RedirectToAction("VersolicitudesArea", "MaterialDidactico_solicitud");
                return View("AutorizarOK");
            }








            //return View(materialdidactico_solicitud);
        }

        public ActionResult VistoBueno(int id)
        {

            MaterialDidactico_Solicitud materialdidactico_solicitud = db.MaterialDidactico_Solicitud.Where(r => r.IdSolicitud == id).FirstOrDefault();

            return View(materialdidactico_solicitud);
        }

        //
        // POST: /InventarioQuincena/Create

        [HttpPost]
        public ActionResult VistoBueno()
        {
            int id = System.Convert.ToInt32(Request["hfidsolicitud"]);
            MaterialDidactico_Solicitud materialdidactico_solicitud = db.MaterialDidactico_Solicitud.Where(r => r.IdSolicitud == id).FirstOrDefault();


            materialdidactico_solicitud.FechaAtencion = DateTime.Now;
            materialdidactico_solicitud.IdUsuarioVistoBueno = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {


                if (Request["hfno"] == "1")
                {
                    db.MaterialDidactico_Solicitud.Add(materialdidactico_solicitud);
                    db.Entry(materialdidactico_solicitud).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();

                    foreach (var item in materialdidactico_solicitud.MaterialDidactico_SolicitudDetalle)
                    {
                        item.EsAutorizada = false;



                        db.MaterialDidactico_SolicitudDetalle.Add(item);
                        db.Entry(item).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();
                    }
                    return View("VistoBuenoOk");
                }


                if (Request["hfsave"] == "1")
                {
                    db.MaterialDidactico_Solicitud.Add(materialdidactico_solicitud);
                    materialdidactico_solicitud.VistoBueno = true;
                    db.Entry(materialdidactico_solicitud).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();

                    foreach (var item in materialdidactico_solicitud.MaterialDidactico_SolicitudDetalle)
                    {
                        int cantidad = System.Convert.ToInt32(Request["cantidad" + item.IdSolicitudDetalle.ToString()]);
                        item.EsAutorizada = true;
                        item.CantidadAutorizada = cantidad;
                        item.VistoBueno = true;

                        //MaterialDidactico_AsignaturaTitulo existencias = db.MaterialDidactico_AsignaturaTitulo.Where(f => f.MaterialDidactico_InventarioTitulo.IdTitulo == item.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_InventarioTitulo.MaterialDidactico_Titulo.IdTitulo).FirstOrDefault();
                        MaterialDidactico_InventarioTitulo existencias = db.MaterialDidactico_InventarioTitulo.Where(f => f.IdInventarioTitulo == item.MaterialDidactico_AsignaturaTitulo.IdInventarioTitulo).FirstOrDefault();

                        existencias.Existencia = existencias.Existencia - item.CantidadAutorizada;


                        db.MaterialDidactico_InventarioTitulo.Add(existencias);
                        db.Entry(existencias).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();


                        db.MaterialDidactico_SolicitudDetalle.Add(item);
                        db.Entry(item).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();
                    }

                }

                scope.Complete();

                return View("VistoBuenoOk");
            }








            // return View(materialdidactico_solicitud);
        }

        public ActionResult ImpresionSolicitud(int id)
        {

            List<MaterialDidactico_SolicitudDetalle> seleccion = db.MaterialDidactico_SolicitudDetalle.Where(r => r.IdSolicitud == id).ToList();

            MaterialDidactico_Solicitud sol = db.MaterialDidactico_Solicitud.Where(v => v.IdSolicitud == id).FirstOrDefault();
            ViewBag.seleccion = seleccion;
            ViewBag.sol = sol;



            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 10;
            m.Right = 10;
            m.Top = 0;
            string foot = " Fecha y hora de registro" + DateTime.Now.ToShortDateString();
            return new ViewAsPdf() { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = "Solicitudmaterial.pdf" };
            //return View();
        }


        public ActionResult Usuario(int id,int idmodalidad)
        {
            ViewBag.Id = id;
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria Usuario = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(v => v.Convenios_stConvenioLaboralTrabajador.IdTrabajador == id).OrderByDescending(y=> y.IdConvenioLaboralTrabajadorCategoria ).OrderByDescending(y=> y.IdConvenioLaboralTrabajadorCategoria ).FirstOrDefault();

            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(b=> b.FechaInicio).FirstOrDefault();
            int w = 0;
            if (convocatoria == null)

            { w = 1; }
            else
            {



                ViewBag.Convocatoria = convocatoria.Convocatoria + " " + convocatoria.FechaInicio.ToString() + " - " + convocatoria.FechaTermino;



                int modalidad = idmodalidad;
                //if (Usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica.IndexOf("plantel", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
                //{
                //    modalidad = 1;
                //}
                //else
                //    if (Usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica.IndexOf("emsad", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
                //    {
                //        modalidad = 2;
                //    }
                //    else
                //        throw new ApplicationException("No se pudo determinar la modalidad de estudio, no se tienen los privilegios para completar la operación ");

                ViewBag.IdConvocatoria = convocatoria.IdConvocatoria;
                ViewBag.Areas = MaterialDidactico_SolicitudDetalle.ObtenerAsignaturas(modalidad, 0);
                ViewBag.MaterialYaPedido = MaterialDidactico_SolicitudDetalle.ObtenerMaterialPedidoPreviamente(Usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica);

                bool puedesolicitar = true;


                int restriccion = MaterialDidactico_SolicitudDetalle.ObtenerTotalSolicitudesRealizadas(Usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica, convocatoria.IdConvocatoria, id);

                if (modalidad == 1)
                {
                    ViewBag.opcion = "Selecciona una Materia";
                    ViewBag.titulo = "Materia";
                    if (restriccion > 3)
                    { puedesolicitar = false; }

                }
                else
                {
                    ViewBag.opcion = "Selecciona el campo de conocimiento";
                    ViewBag.titulo = "Campo de conocimiento";
                    if (restriccion > 30)
                    { puedesolicitar = false; }
                }

                if (puedesolicitar == false)
                {
                    throw new ApplicationException("Ha sobrepasado el límite de solicitudes por " + ViewBag.titulo + " permitido");
                }
                // ViewBag.Asignaturas = MaterialDidactico_SolicitudDetalle.ObtenerAsignaturas(-1);

                ViewBag.Material = MaterialDidactico_SolicitudDetalle.ObtenerMaterial(-1, convocatoria.IdConvocatoria);

                ViewBag.IdAsignatura = "";
                List<MaterialDidactico_SolicitudDetalle> seleccion = new List<MaterialDidactico_SolicitudDetalle>();
                Session["Seleccion"] = seleccion;

                ViewBag.porque = "";
                ViewBag.como = "";
                ViewBag.resultados = "";
                ViewBag.imprimir = "";



                // }
            }
            return View();
        }

        [HttpPost]
        public ActionResult Usuario(FormCollection form)
        {
            ViewBag.Id = Request["hfidusuario"];
            int idu = System.Convert.ToInt32(Request["hfidusuario"]);
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria Usuario = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(v => v.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idu).OrderByDescending(y=> y.IdConvenioLaboralTrabajadorCategoria ).OrderByDescending(y=> y.IdConvenioLaboralTrabajadorCategoria ).FirstOrDefault();


            @ViewBag.porque = Request["txtporque"];
            @ViewBag.como = Request["txtcomo"];
            @ViewBag.resultados = Request["txtresultados"];

            ViewBag.imprimir = "";

            // ViewBag.Areas= MaterialDidactico_SolicitudDetalle.ObtenerAreaConocimiento(System.Convert.ToInt16(Request["IdAreaConocimiento"]));
            int IdAreaConocimiento = 0;
            if (Request["hfidasginatura"] != "")
                IdAreaConocimiento = System.Convert.ToInt16(Request["hfidasginatura"]);

            ViewBag.IdAsignatura = Request["hfidasginatura"];

            List<MaterialDidactico_SolicitudDetalle> seleccion = (List<MaterialDidactico_SolicitudDetalle>)Session["Seleccion"];




            int asignatura = 0;
            if (Request["IdAsignatura"] != "")
                asignatura = System.Convert.ToInt16(Request["IdAsignatura"]);


            int IdConvocatoria = 0;
            if (Request["IdConvocatoria"] != "")
                IdConvocatoria = System.Convert.ToInt16(Request["IdConvocatoria"]);

            ViewBag.IdConvocatoria = IdConvocatoria;

            ViewBag.Convocatoria = Request["Convocatoria"];

            // ViewBag.Areas = MaterialDidactico_SolicitudDetalle.ObtenerAreaConocimiento(IdAreaConocimiento);


            int modalidad = 2;
            if (Usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica.IndexOf("plantel", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
            {
                modalidad = 1;
            }
            ViewBag.Areas = MaterialDidactico_SolicitudDetalle.ObtenerAsignaturas(modalidad, IdAreaConocimiento);

            ViewBag.MaterialYaPedido = MaterialDidactico_SolicitudDetalle.ObtenerMaterialPedidoPreviamente(Usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica);

            if (modalidad == 1)
            {
                ViewBag.opcion = "Selecciona una Materia";
                ViewBag.titulo = "Materia";
            }
            else
            {
                ViewBag.opcion = "Selecciona el campo de conocimiento";
                ViewBag.titulo = "Campo de conocimiento";
            }



            // ViewBag.Asignaturas = MaterialDidactico_SolicitudDetalle.ObtenerAsignaturas(IdAreaConocimiento, asignatura);

            ViewBag.Material = MaterialDidactico_SolicitudDetalle.ObtenerMaterial(IdAreaConocimiento, IdConvocatoria);

            if (Request["hfadd"] == "1")
            {
                string[] datos = Request["hfdata"].Split(',');

                if (datos.Count() > 0)
                {
                    // List<vwPlanesEstudioAsignaturas> asignaturasAries = dbAries.vwPlanesEstudioAsignaturas.ToList();




                    foreach (var item in datos)
                    {
                        if (item != "")
                        {

                            MaterialDidactico_SolicitudDetalle existe = seleccion.Where(f => f.IdAsignaturaTitulo == System.Convert.ToInt16(item)).FirstOrDefault();
                            if (existe == null)
                            {
                                // vwPlanesEstudioAsignaturas asignaturasinfo = asignaturasAries.Where(t => t.IdAsignatura == asignatura).FirstOrDefault();
                                MaterialDidactico_SolicitudDetalle detalle = new MaterialDidactico_SolicitudDetalle();

                                MaterialDidactico_AsignaturaTitulo catalogo = db.MaterialDidactico_AsignaturaTitulo.Find(System.Convert.ToInt16(item));


                                var mismaarea = seleccion.Where(f => f.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura != catalogo.MaterialDidactico_Asignaturas.Asignatura).FirstOrDefault();
                                if (mismaarea != null)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "Debe de seleccionar productos del mismo campo de conocimiento");
                                }
                                else
                                {
                                    detalle.MaterialDidactico_AsignaturaTitulo = catalogo;
                                    detalle.IdSolicitud = 0;
                                    detalle.IdAsignaturaTitulo = System.Convert.ToInt16(item);
                                    detalle.CantidadSolicitada = System.Convert.ToInt16(Request["cantidad" + item]);
                                    detalle.CantidadAutorizada = 0;
                                    detalle.EsAutorizada = false;



                                    //db.MaterialDidactico_SolicitudDetalle.Add(detalle);
                                    seleccion.Add(detalle);
                                }
                            }
                        }

                    }

                    //   db.SaveChanges();
                    //   scope.Complete();
                    //   MessageBox.Show(ViewData, TipoMensaje.Success, "Tu solicitud ha sido enviada exitosamente");
                    //}
                }
            }


            if (Request["hfsave"] == "1")
            {

                if (seleccion.Count == 0)
                {
                    MessageBox.Show(ViewData, TipoMensaje.Error, "Debe de seleccionar productos para su solicitud");
                }

                //MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.Where(h => DateTime.Today.Date >= h.FechaInicio && DateTime.Today.Date <= h.FechaTermino).FirstOrDefault();
                MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(b => b.FechaInicio).FirstOrDefault();


                if (MaterialDidactico_SolicitudDetalle.ObtenerTotalSolicitudesPorUsuario(IdConvocatoria, Usuario.Convenios_stConvenioLaboralTrabajador.IdTrabajador, asignatura) > 0)
                {
                    throw new Exception("No puede realizar mas de una solicitud por " + ViewBag.titulo);
                }

                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    MaterialDidactico_Solicitud solicitud = new MaterialDidactico_Solicitud();

                    solicitud.CentroEducativo = Usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica;
                    solicitud.FechaSolicitud = DateTime.Now;
                    solicitud.IdTrabajador = Usuario.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    solicitud.IdUsuarioAutorizo = 0;
                    solicitud.Porque = Request["txtporque"];
                    solicitud.Como = Request["txtcomo"];
                    solicitud.Resultados = Request["txtresultados"];
                    solicitud.IdConvocatoria = convocatoria.IdConvocatoria;

                    if (solicitud.CentroEducativo.IndexOf("plantel", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
                        solicitud.Modalidad = "PLANTEL";
                    else
                        if (solicitud.CentroEducativo.IndexOf("EMSAD", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
                            solicitud.Modalidad = "EMSAD";
                        else
                            solicitud.Modalidad = solicitud.CentroEducativo;


                    db.MaterialDidactico_Solicitud.Add(solicitud);
                    try
                    {
                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {


                        if (e.GetOriginalException().Message.IndexOf("duplic") > -1)
                        {
                            throw new Exception("Estimado usuario usted ya realizó su solicitud");
                        }
                        else
                            throw new Exception(e.GetOriginalException().Message);
                    }


                    foreach (var item in seleccion)
                    {
                        item.MaterialDidactico_AsignaturaTitulo = null;
                        item.IdSolicitud = solicitud.IdSolicitud;
                        db.MaterialDidactico_SolicitudDetalle.Add(item);
                        db.SaveChanges();
                    }

                    scope.Complete();
                    ViewBag.imprimir = solicitud.IdSolicitud.ToString();
                    ViewBag.id = solicitud.IdSolicitud.ToString();
                    MessageBox.Show(ViewData, TipoMensaje.Success, "Tu solicitud ha sido enviada exitosamente");
                    //seleccion.Clear();
                    seleccion.RemoveAll(e => e.IdSolicitud == solicitud.IdSolicitud);
                }
            }

            if (Request["hfdelete"] != "")
            {
                MaterialDidactico_SolicitudDetalle existe = seleccion.Where(f => f.IdAsignaturaTitulo == System.Convert.ToInt16(Request["hfdelete"])).FirstOrDefault();
                seleccion.Remove(existe);
            }

            Session["Seleccion"] = seleccion;

            return View();
        }

        public ActionResult Index()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.Where(h => DateTime.Today.Date >= h.FechaInicio && DateTime.Today.Date <= h.FechaTermino).FirstOrDefault();

            if (convocatoria == null)

            { throw new ApplicationException("La fecha para crear solicitudes ha finalizado"); }
            else
            {



                ViewBag.Convocatoria = convocatoria.Convocatoria + " " + convocatoria.FechaInicio.ToString() + " - " + convocatoria.FechaTermino;

                //if (Session["AreaUsuario"] == null)
                //{
                //    RedirectToAction("Login", "Account");
                //}
                //else
                //{

                int modalidad = 0;
                if (Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica.IndexOf("plantel", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
                {
                    modalidad = 1;
                }
                else
                    if (Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica.IndexOf("emsad", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
                    {
                        modalidad = 2;
                    }
                    else
                        throw new ApplicationException("No se pudo determinar la modalidad de estudio, no se tienen los privilegios para completar la operación ");

                ViewBag.IdConvocatoria = convocatoria.IdConvocatoria;
                ViewBag.Areas = MaterialDidactico_SolicitudDetalle.ObtenerAsignaturas(modalidad, 0);
                ViewBag.MaterialYaPedido = MaterialDidactico_SolicitudDetalle.ObtenerMaterialPedidoPreviamente(Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica);

                bool puedesolicitar = true;


                int restriccion = MaterialDidactico_SolicitudDetalle.ObtenerTotalSolicitudesRealizadas(Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica, convocatoria.IdConvocatoria, Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                if (modalidad == 1)
                {
                    ViewBag.opcion = "Selecciona una Materia";
                    ViewBag.titulo = "Materia";
                    if (restriccion > 3)
                    { puedesolicitar = false; }

                }
                else
                {
                    ViewBag.opcion = "Selecciona el campo de conocimiento";
                    ViewBag.titulo = "Campo de conocimiento";
                    if (restriccion > 0)
                    { puedesolicitar = false; }
                }

                if (puedesolicitar == false)
                {
                    throw new ApplicationException("Ha sobrepasado el límite de solicitudes por " + ViewBag.titulo + " permitido");
                }
                // ViewBag.Asignaturas = MaterialDidactico_SolicitudDetalle.ObtenerAsignaturas(-1);

                ViewBag.Material = MaterialDidactico_SolicitudDetalle.ObtenerMaterial(-1, convocatoria.IdConvocatoria);

                ViewBag.IdAsignatura = "";
                List<MaterialDidactico_SolicitudDetalle> seleccion = new List<MaterialDidactico_SolicitudDetalle>();
                Session["Seleccion"] = seleccion;

                ViewBag.porque = "";
                ViewBag.como = "";
                ViewBag.resultados = "";
                ViewBag.imprimir = "";
                ViewBag.id = "";



                // }
            }
            return View();
        }

        [HttpPost]
        public ActionResult Index(FormCollection form)
        {
            @ViewBag.porque = Request["txtporque"];
            @ViewBag.como = Request["txtcomo"];
            @ViewBag.resultados = Request["txtresultados"];

            ViewBag.imprimir = "";

            // ViewBag.Areas= MaterialDidactico_SolicitudDetalle.ObtenerAreaConocimiento(System.Convert.ToInt16(Request["IdAreaConocimiento"]));
            int IdAreaConocimiento = 0;
            if (Request["hfidasginatura"] != "")
                IdAreaConocimiento = System.Convert.ToInt16(Request["hfidasginatura"]);

            ViewBag.IdAsignatura = Request["hfidasginatura"];

            List<MaterialDidactico_SolicitudDetalle> seleccion = (List<MaterialDidactico_SolicitudDetalle>)Session["Seleccion"];




            int asignatura = 0;
            if (Request["IdAsignatura"] != "")
                asignatura = System.Convert.ToInt16(Request["IdAsignatura"]);


            int IdConvocatoria = 0;
            if (Request["IdConvocatoria"] != "")
                IdConvocatoria = System.Convert.ToInt16(Request["IdConvocatoria"]);

            ViewBag.IdConvocatoria = IdConvocatoria;

            ViewBag.Convocatoria = Request["Convocatoria"];

            // ViewBag.Areas = MaterialDidactico_SolicitudDetalle.ObtenerAreaConocimiento(IdAreaConocimiento);


            int modalidad = 2;
            if (Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica.IndexOf("plantel", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
            {
                modalidad = 1;
            }
            ViewBag.Areas = MaterialDidactico_SolicitudDetalle.ObtenerAsignaturas(modalidad, IdAreaConocimiento);

            ViewBag.MaterialYaPedido = MaterialDidactico_SolicitudDetalle.ObtenerMaterialPedidoPreviamente(Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica);

            if (modalidad == 1)
            {
                ViewBag.opcion = "Selecciona una Materia";
                ViewBag.titulo = "Materia";
            }
            else
            {
                ViewBag.opcion = "Selecciona el campo de conocimiento";
                ViewBag.titulo = "Campo de conocimiento";
            }



            // ViewBag.Asignaturas = MaterialDidactico_SolicitudDetalle.ObtenerAsignaturas(IdAreaConocimiento, asignatura);

            ViewBag.Material = MaterialDidactico_SolicitudDetalle.ObtenerMaterial(IdAreaConocimiento, IdConvocatoria);

            if (Request["hfadd"] == "1")
            {
                string[] datos = Request["hfdata"].Split(',');

                if (datos.Count() > 0)
                {
                    // List<vwPlanesEstudioAsignaturas> asignaturasAries = dbAries.vwPlanesEstudioAsignaturas.ToList();




                    foreach (var item in datos)
                    {
                        if (item != "")
                        {

                            MaterialDidactico_SolicitudDetalle existe = seleccion.Where(f => f.IdAsignaturaTitulo == System.Convert.ToInt16(item)).FirstOrDefault();
                            if (existe == null)
                            {
                                // vwPlanesEstudioAsignaturas asignaturasinfo = asignaturasAries.Where(t => t.IdAsignatura == asignatura).FirstOrDefault();
                                MaterialDidactico_SolicitudDetalle detalle = new MaterialDidactico_SolicitudDetalle();

                                MaterialDidactico_AsignaturaTitulo catalogo = db.MaterialDidactico_AsignaturaTitulo.Find(System.Convert.ToInt16(item));


                                var mismaarea = seleccion.Where(f => f.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura != catalogo.MaterialDidactico_Asignaturas.Asignatura).FirstOrDefault();
                                if (mismaarea != null)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "Debe de seleccionar productos del mismo campo de conocimiento");
                                }
                                else
                                {
                                    detalle.MaterialDidactico_AsignaturaTitulo = catalogo;
                                    detalle.IdSolicitud = 0;
                                    detalle.IdAsignaturaTitulo = System.Convert.ToInt16(item);
                                    detalle.CantidadSolicitada = System.Convert.ToInt16(Request["cantidad" + item]);
                                    detalle.CantidadAutorizada = 0;
                                    detalle.EsAutorizada = false;



                                    //db.MaterialDidactico_SolicitudDetalle.Add(detalle);
                                    seleccion.Add(detalle);
                                }
                            }
                        }

                    }

                    //   db.SaveChanges();
                    //   scope.Complete();
                    //   MessageBox.Show(ViewData, TipoMensaje.Success, "Tu solicitud ha sido enviada exitosamente");
                    //}
                }
            }


            if (Request["hfsave"] == "1")
            {

                if (seleccion.Count == 0)
                {
                    MessageBox.Show(ViewData, TipoMensaje.Error, "Debe de seleccionar productos para su solicitud");
                }

                MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.Where(h => DateTime.Today.Date >= h.FechaInicio && DateTime.Today.Date <= h.FechaTermino).FirstOrDefault();


                if (MaterialDidactico_SolicitudDetalle.ObtenerTotalSolicitudesPorUsuario(IdConvocatoria, Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador, asignatura) > 0)
                {
                    throw new Exception("No puede realizar mas de una solicitud por " + ViewBag.titulo);
                }

                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    MaterialDidactico_Solicitud solicitud = new MaterialDidactico_Solicitud();

                    solicitud.CentroEducativo = Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;
                    solicitud.FechaSolicitud = DateTime.Now;
                    solicitud.IdTrabajador = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    solicitud.IdUsuarioAutorizo = 0;
                    solicitud.Porque = Request["txtporque"];
                    solicitud.Como = Request["txtcomo"];
                    solicitud.Resultados = Request["txtresultados"];
                    solicitud.IdConvocatoria = convocatoria.IdConvocatoria;

                    if (solicitud.CentroEducativo.IndexOf("plantel", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
                        solicitud.Modalidad = "PLANTEL";
                    else
                        if (solicitud.CentroEducativo.IndexOf("EMSAD", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
                            solicitud.Modalidad = "EMSAD";
                        else
                            solicitud.Modalidad = solicitud.CentroEducativo;


                    db.MaterialDidactico_Solicitud.Add(solicitud);
                    try
                    {
                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {


                        if (e.GetOriginalException().Message.IndexOf("duplic") > -1)
                        {
                            throw new Exception("Estimado usuario usted ya realizó su solicitud");
                        }
                        else
                            throw new Exception(e.GetOriginalException().Message);
                    }


                    foreach (var item in seleccion)
                    {
                        item.MaterialDidactico_AsignaturaTitulo = null;
                        item.IdSolicitud = solicitud.IdSolicitud;
                        db.MaterialDidactico_SolicitudDetalle.Add(item);
                        db.SaveChanges();
                    }

                    scope.Complete();
                    ViewBag.imprimir = solicitud.IdSolicitud.ToString();
                    ViewBag.id = solicitud.IdSolicitud.ToString();
                    MessageBox.Show(ViewData, TipoMensaje.Success, "Tu solicitud ha sido enviada exitosamente");
                    //seleccion.Clear();
                    seleccion.RemoveAll(e => e.IdSolicitud == solicitud.IdSolicitud);
                }
            }

            if (Request["hfdelete"] != "")
            {
                MaterialDidactico_SolicitudDetalle existe = seleccion.Where(f => f.IdAsignaturaTitulo == System.Convert.ToInt16(Request["hfdelete"])).FirstOrDefault();
                seleccion.Remove(existe);
            }

            Session["Seleccion"] = seleccion;

            return View();
        }


        public ActionResult EstadisticaTitulo()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();

            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;

            var rt = db.MaterialDidactico_SolicitudDetalle.Where(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.IdModalidad == 1 && g.CantidadAutorizada > 0 && g.EsAutorizada == true && g.VistoBueno == true).GroupBy(a => new { a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura, a.IdSolicitud, a.MaterialDidactico_Solicitud.Modalidad }).Select(g => new { Titulo = g.Key.Asignatura, IdSolicitud = g.Key.IdSolicitud, Modalidad = g.Key.Modalidad, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();
            ChartsModel model = new ChartsModel();

            if (id == 0)
                id = 0;
            else
                rt = db.MaterialDidactico_SolicitudDetalle.Where(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.IdModalidad == 1 && g.CantidadAutorizada > 0 && g.EsAutorizada == true && g.VistoBueno == true && g.MaterialDidactico_Solicitud.IdConvocatoria == id).GroupBy(a => new { a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura, a.IdSolicitud, a.MaterialDidactico_Solicitud.Modalidad }).Select(g => new { Titulo = g.Key.Asignatura, IdSolicitud = g.Key.IdSolicitud, Modalidad = g.Key.Modalidad, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            var f = rt.GroupBy(r => new { r.Titulo, r.Modalidad }).Select(g => new { Titulo = g.Key.Titulo.ToString(), Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            ViewBag.Id = id;


            //MaterialDidactico_SolicitudDetalle material = db.MaterialDidactico_SolicitudDetalle.Select(d => d.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Titulo.Titulo).ToArray();
            //string[] categories = { "MSIE", "Firefox", "Chrome", "Safari", "Opera" };
            //var f = db.MaterialDidactico_SolicitudDetalle.GroupBy(a => a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Titulo.Titulo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t=> t.Count).ToArray();

            List<string> cat = new List<string>();
            //DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data();
            DotNet.Highcharts.Options.Point[] valores = new DotNet.Highcharts.Options.Point[f.Count()];
            int total = 0;
            int c = 0;
            foreach (var item in f)
            {

                DotNet.Highcharts.Options.Point valor = new DotNet.Highcharts.Options.Point();
                cat.Add(item.Titulo);
                valor.Y = item.Count;
                valor.Name = item.Titulo;
                total = total + item.Count;

                valores[c] = valor;
                c = c + 1;
            }
            ViewData["total"] = total;

            DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data(valores);
            const string NAME = "Estadísticas de solicitudes por Materia";

            string[] categories = cat.ToArray();
            //  DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data(new[]
            //{
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 55.11,
            //        Color = Color.FromName("colors[0]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "MSIE versions",
            //            Categories = new[] { "MSIE 6.0", "MSIE 7.0", "MSIE 8.0", "MSIE 9.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 10.85, 7.35, 33.06, 2.81 }),
            //            Color = Color.FromName("colors[0]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 21.63,
            //        Color = Color.FromName("colors[1]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Firefox versions",
            //            Categories = new[] { "Firefox 2.0", "Firefox 3.0", "Firefox 3.5", "Firefox 3.6", "Firefox 4.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.20, 0.83, 1.58, 13.12, 5.43 }),
            //            Color = Color.FromName("colors[1]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 11.94,
            //        Color = Color.FromName("colors[2]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Chrome versions",
            //            Categories = new[] { "Chrome 5.0", "Chrome 6.0", "Chrome 7.0", "Chrome 8.0", "Chrome 9.0", "Chrome 10.0", "Chrome 11.0", "Chrome 12.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.12, 0.19, 0.12, 0.36, 0.32, 9.91, 0.50, 0.22 }),
            //            Color = Color.FromName("colors[2]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 7.15,
            //        Color = Color.FromName("colors[3]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Safari versions",
            //            Categories = new[] { "Safari 5.0", "Safari 4.0", "Safari Win 5.0", "Safari 4.1", "Safari/Maxthon", "Safari 3.1", "Safari 4.1" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 4.55, 1.42, 0.23, 0.21, 0.20, 0.19, 0.14 }),
            //            Color = Color.FromName("colors[3]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 2.14,
            //        Color = Color.FromName("colors[4]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Opera versions",
            //            Categories = new[] { "Opera 9.x", "Opera 10.x", "Opera 11.x" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.12, 0.37, 1.65 }),
            //            Color = Color.FromName("colors[4]")
            //        }
            //    }
            //});

            Highcharts chart = new Highcharts("chart")
                .InitChart(new Chart { DefaultSeriesType = ChartTypes.Column })
                .SetTitle(new Title { Text = "Estadísticas de solicitudes por Materia" })
                //.SetSubtitle(new Subtitle { Text = "Click the columns to view versions. Click again to view brands." })
                .SetXAxis(new XAxis { Categories = categories })
                .SetYAxis(new YAxis { Title = new YAxisTitle { Text = "Total" } })
                .SetLegend(new Legend { Enabled = false })
                .SetTooltip(new Tooltip { Formatter = "TooltipFormatter" })
                .SetPlotOptions(new PlotOptions
                {
                    Column = new PlotOptionsColumn
                    {
                        Cursor = Cursors.Pointer,
                        ColorByPoint = true,
                        Point = new PlotOptionsColumnPoint { Events = new PlotOptionsColumnPointEvents { Click = "ColumnPointClick" } },
                        DataLabels = new PlotOptionsColumnDataLabels
                        {
                            Enabled = true,

                            // Color = Color.FromName("colors[0]"),
                            Formatter = "function() { return this.y +''; }",
                            Style = "fontWeight: 'bold'"
                        }
                    }
                })
                .SetSeries(new Series
                {
                    Name = "Browser brands",
                    Data = data,
                    Color = Color.White
                })
                .SetExporting(new Exporting { Enabled = false })
                .AddJavascripFunction(
                    "TooltipFormatter",
                    @"var point = this.point, s = this.x +':<b>'+ this.y +' </b><br/>';
                      if (point.drilldown) {
                        s += 'Click to view '+ point.category +' versions';
                      } else {
                        s += 'Click to return to browser brands';
                      }
                      return s;"
                )
                .AddJavascripFunction(
                    "ColumnPointClick",
                    @"var drilldown = this.drilldown;
                      if (drilldown) { // drill down
                        setChart(drilldown.name, drilldown.categories, drilldown.data.data, drilldown.color);
                      } else { // restore
                        setChart(name, categories, data.data);
                      }"
                )
                .AddJavascripFunction(
                    "setChart",
                    @"chart.xAxis[0].setCategories(categories);
                      chart.series[0].remove();
                      chart.addSeries({
                         name: name,
                         data: data,
                         color: color || 'white'
                      });",
                    "name", "categories", "data", "color"
                )
                .AddJavascripVariable("colors", "Highcharts.getOptions().colors")
                .AddJavascripVariable("name", "'{0}'".FormatWith(NAME))
                .AddJavascripVariable("categories", JsonSerializer.Serialize(categories))
                .AddJavascripVariable("data", JsonSerializer.Serialize(data));

            model.Chart1 = chart;

            //********************************************************


            var rt2 = db.MaterialDidactico_SolicitudDetalle.Where(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.IdModalidad == 2 && g.CantidadAutorizada > 0 && g.EsAutorizada == true && g.VistoBueno == true).GroupBy(a => new { a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura, a.IdSolicitud, a.MaterialDidactico_Solicitud.Modalidad }).Select(g => new { Titulo = g.Key.Asignatura, IdSolicitud = g.Key.IdSolicitud, Modalidad = g.Key.Modalidad, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            if (id == 0)
                id = 0;
            else
                rt2 = db.MaterialDidactico_SolicitudDetalle.Where(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.IdModalidad == 2 && g.MaterialDidactico_Solicitud.IdConvocatoria == id && g.CantidadAutorizada > 0 && g.EsAutorizada == true && g.VistoBueno == true).GroupBy(a => new { a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura, a.IdSolicitud, a.MaterialDidactico_Solicitud.Modalidad }).Select(g => new { Titulo = g.Key.Asignatura, IdSolicitud = g.Key.IdSolicitud, Modalidad = g.Key.Modalidad, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            var f2 = rt2.GroupBy(r => new { r.Titulo, r.Modalidad }).Select(g => new { Titulo = g.Key.Titulo.ToString(), Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();



            //MaterialDidactico_SolicitudDetalle material = db.MaterialDidactico_SolicitudDetalle.Select(d => d.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Titulo.Titulo).ToArray();
            //string[] categories = { "MSIE", "Firefox", "Chrome", "Safari", "Opera" };
            //var f = db.MaterialDidactico_SolicitudDetalle.GroupBy(a => a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Titulo.Titulo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t=> t.Count).ToArray();

            List<string> cat2 = new List<string>();
            //DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data();
            DotNet.Highcharts.Options.Point[] valores2 = new DotNet.Highcharts.Options.Point[f2.Count()];

            int c2 = 0;
            int total2 = 0;
            foreach (var item in f2)
            {

                DotNet.Highcharts.Options.Point valor2 = new DotNet.Highcharts.Options.Point();
                cat2.Add(item.Titulo);
                valor2.Y = item.Count;
                valor2.Name = item.Titulo;
                total2 = total2 + item.Count;
                valores2[c2] = valor2;
                c2 = c2 + 1;
            }

            ViewData["total2"] = total2;
            DotNet.Highcharts.Helpers.Data data2 = new DotNet.Highcharts.Helpers.Data(valores2);
            //const string NAME2 = "Estadísticas de solicitudes por Materia/Area de Conocimiento";

            string[] categories2 = cat2.ToArray();
            //  DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data(new[]
            //{
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 55.11,
            //        Color = Color.FromName("colors[0]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "MSIE versions",
            //            Categories = new[] { "MSIE 6.0", "MSIE 7.0", "MSIE 8.0", "MSIE 9.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 10.85, 7.35, 33.06, 2.81 }),
            //            Color = Color.FromName("colors[0]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 21.63,
            //        Color = Color.FromName("colors[1]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Firefox versions",
            //            Categories = new[] { "Firefox 2.0", "Firefox 3.0", "Firefox 3.5", "Firefox 3.6", "Firefox 4.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.20, 0.83, 1.58, 13.12, 5.43 }),
            //            Color = Color.FromName("colors[1]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 11.94,
            //        Color = Color.FromName("colors[2]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Chrome versions",
            //            Categories = new[] { "Chrome 5.0", "Chrome 6.0", "Chrome 7.0", "Chrome 8.0", "Chrome 9.0", "Chrome 10.0", "Chrome 11.0", "Chrome 12.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.12, 0.19, 0.12, 0.36, 0.32, 9.91, 0.50, 0.22 }),
            //            Color = Color.FromName("colors[2]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 7.15,
            //        Color = Color.FromName("colors[3]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Safari versions",
            //            Categories = new[] { "Safari 5.0", "Safari 4.0", "Safari Win 5.0", "Safari 4.1", "Safari/Maxthon", "Safari 3.1", "Safari 4.1" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 4.55, 1.42, 0.23, 0.21, 0.20, 0.19, 0.14 }),
            //            Color = Color.FromName("colors[3]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 2.14,
            //        Color = Color.FromName("colors[4]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Opera versions",
            //            Categories = new[] { "Opera 9.x", "Opera 10.x", "Opera 11.x" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.12, 0.37, 1.65 }),
            //            Color = Color.FromName("colors[4]")
            //        }
            //    }
            //});

            Highcharts chart2 = new Highcharts("chart2")
                .InitChart(new Chart { DefaultSeriesType = ChartTypes.Column })
                .SetTitle(new Title { Text = "Estadísticas de solicitudes por Area de Conocimiento" })
                //.SetSubtitle(new Subtitle { Text = "Click the columns to view versions. Click again to view brands." })
                .SetXAxis(new XAxis { Categories = categories2 })
                .SetYAxis(new YAxis { Title = new YAxisTitle { Text = "Total" } })
                .SetLegend(new Legend { Enabled = false })
                .SetTooltip(new Tooltip { Formatter = "TooltipFormatter" })
                .SetPlotOptions(new PlotOptions
                {
                    Column = new PlotOptionsColumn
                    {
                        Cursor = Cursors.Pointer,
                        ColorByPoint = true,
                        Point = new PlotOptionsColumnPoint { Events = new PlotOptionsColumnPointEvents { Click = "ColumnPointClick" } },
                        DataLabels = new PlotOptionsColumnDataLabels
                        {
                            Enabled = true,

                            // Color = Color.FromName("colors[0]"),
                            Formatter = "function() { return this.y +''; }",
                            Style = "fontWeight: 'bold'"
                        }
                    }
                })
                .SetSeries(new Series
                {
                    Name = "Browser brands",
                    Data = data2,
                    Color = Color.White
                })
                .SetExporting(new Exporting { Enabled = false })
                .AddJavascripFunction(
                    "TooltipFormatter",
                    @"var point = this.point, s = this.x +':<b>'+ this.y +'</b><br/>';
                      if (point.drilldown) {
                        s += 'Click to view '+ point.category +' versions';
                      } else {
                        s += 'Click to return to browser brands';
                      }
                      return s;"
                )
                .AddJavascripFunction(
                    "ColumnPointClick",
                    @"var drilldown = this.drilldown;
                      if (drilldown) { // drill down
                        setChart(drilldown.name, drilldown.categories, drilldown.data.data, drilldown.color);
                      } else { // restore
                        setChart(name, categories, data.data);
                      }"
                )
                .AddJavascripFunction(
                    "setChart",
                    @"chart.xAxis[0].setCategories(categories);
                      chart.series[0].remove();
                      chart.addSeries({
                         name: name,
                         data: data,
                         color: color || 'white'
                      });",
                    "name", "categories", "data", "color"
                )
                .AddJavascripVariable("colors", "Highcharts.getOptions().colors")
                .AddJavascripVariable("name", "'{0}'".FormatWith(NAME))
                .AddJavascripVariable("categories", JsonSerializer.Serialize(categories2))
                .AddJavascripVariable("data", JsonSerializer.Serialize(data2));

            //ViewData["chart2"] = chart2;

            model.Chart2 = chart2;
            return View(model);
        }

        public ActionResult EstadisticaMateria()
        {

            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();

            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;

            var rt = db.MaterialDidactico_SolicitudDetalle.Where(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.IdModalidad == 1 && g.CantidadAutorizada > 0 && g.EsAutorizada == true && g.VistoBueno == true).GroupBy(a => new { a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura, a.IdSolicitud }).Select(g => new { Titulo = g.Key.Asignatura, IdSolicitud = g.Key.IdSolicitud, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();
            if (id == 0)
                id = 0;
            else
                rt = db.MaterialDidactico_SolicitudDetalle.Where(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.IdModalidad == 1 && g.CantidadAutorizada > 0 && g.MaterialDidactico_Solicitud.IdConvocatoria == id && g.EsAutorizada == true && g.VistoBueno == true).GroupBy(a => new { a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura, a.IdSolicitud }).Select(g => new { Titulo = g.Key.Asignatura, IdSolicitud = g.Key.IdSolicitud, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            ViewBag.Id = id;

            var f = rt.GroupBy(r => new { r.Titulo }).Select(g => new { g.Key.Titulo, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();





            //MaterialDidactico_SolicitudDetalle material = db.MaterialDidactico_SolicitudDetalle.Select(d => d.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Titulo.Titulo).ToArray();
            //string[] categories = { "MSIE", "Firefox", "Chrome", "Safari", "Opera" };
            //var f = db.MaterialDidactico_SolicitudDetalle.GroupBy(a => a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Titulo.Titulo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t=> t.Count).ToArray();

            List<string> cat = new List<string>();
            //DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data();
            DotNet.Highcharts.Options.Point[] valores = new DotNet.Highcharts.Options.Point[f.Count()];

            int c = 0;
            foreach (var item in f)
            {

                DotNet.Highcharts.Options.Point valor = new DotNet.Highcharts.Options.Point();
                cat.Add(item.Titulo);
                valor.Y = item.Count;
                valor.Name = item.Titulo;

                valores[c] = valor;
                c = c + 1;
            }
            DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data(valores);
            const string NAME = "Estadísticas de solicitudes por Materia";

            string[] categories = cat.ToArray();
            //  DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data(new[]
            //{
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 55.11,
            //        Color = Color.FromName("colors[0]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "MSIE versions",
            //            Categories = new[] { "MSIE 6.0", "MSIE 7.0", "MSIE 8.0", "MSIE 9.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 10.85, 7.35, 33.06, 2.81 }),
            //            Color = Color.FromName("colors[0]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 21.63,
            //        Color = Color.FromName("colors[1]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Firefox versions",
            //            Categories = new[] { "Firefox 2.0", "Firefox 3.0", "Firefox 3.5", "Firefox 3.6", "Firefox 4.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.20, 0.83, 1.58, 13.12, 5.43 }),
            //            Color = Color.FromName("colors[1]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 11.94,
            //        Color = Color.FromName("colors[2]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Chrome versions",
            //            Categories = new[] { "Chrome 5.0", "Chrome 6.0", "Chrome 7.0", "Chrome 8.0", "Chrome 9.0", "Chrome 10.0", "Chrome 11.0", "Chrome 12.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.12, 0.19, 0.12, 0.36, 0.32, 9.91, 0.50, 0.22 }),
            //            Color = Color.FromName("colors[2]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 7.15,
            //        Color = Color.FromName("colors[3]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Safari versions",
            //            Categories = new[] { "Safari 5.0", "Safari 4.0", "Safari Win 5.0", "Safari 4.1", "Safari/Maxthon", "Safari 3.1", "Safari 4.1" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 4.55, 1.42, 0.23, 0.21, 0.20, 0.19, 0.14 }),
            //            Color = Color.FromName("colors[3]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 2.14,
            //        Color = Color.FromName("colors[4]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Opera versions",
            //            Categories = new[] { "Opera 9.x", "Opera 10.x", "Opera 11.x" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.12, 0.37, 1.65 }),
            //            Color = Color.FromName("colors[4]")
            //        }
            //    }
            //});

            Highcharts chart = new Highcharts("chart")
                .InitChart(new Chart { DefaultSeriesType = ChartTypes.Column })
                .SetTitle(new Title { Text = "Estadísticas de solicitudes por Materia" })
                //.SetSubtitle(new Subtitle { Text = "Click the columns to view versions. Click again to view brands." })
                .SetXAxis(new XAxis { Categories = categories })
                .SetYAxis(new YAxis { Title = new YAxisTitle { Text = "Total" } })
                .SetLegend(new Legend { Enabled = false })
                .SetTooltip(new Tooltip { Formatter = "TooltipFormatter" })
                .SetPlotOptions(new PlotOptions
                {
                    Column = new PlotOptionsColumn
                    {
                        Cursor = Cursors.Pointer,
                        ColorByPoint = true,
                        Point = new PlotOptionsColumnPoint { Events = new PlotOptionsColumnPointEvents { Click = "ColumnPointClick" } },
                        DataLabels = new PlotOptionsColumnDataLabels
                        {
                            Enabled = true,

                            // Color = Color.FromName("colors[0]"),
                            Formatter = "function() { return this.y +' solicitudes'; }",
                            Style = "fontWeight: 'bold'"
                        }
                    }
                })
                .SetSeries(new Series
                {
                    Name = "Browser brands",
                    Data = data,
                    Color = Color.White
                })
                .SetExporting(new Exporting { Enabled = false })
                .AddJavascripFunction(
                    "TooltipFormatter",
                    @"var point = this.point, s = this.x +':<b>'+ this.y +' solicitudes</b><br/>';
                      if (point.drilldown) {
                        s += 'Click to view '+ point.category +' versions';
                      } else {
                        s += 'Click to return to browser brands';
                      }
                      return s;"
                )
                .AddJavascripFunction(
                    "ColumnPointClick",
                    @"var drilldown = this.drilldown;
                      if (drilldown) { // drill down
                        setChart(drilldown.name, drilldown.categories, drilldown.data.data, drilldown.color);
                      } else { // restore
                        setChart(name, categories, data.data);
                      }"
                )
                .AddJavascripFunction(
                    "setChart",
                    @"chart.xAxis[0].setCategories(categories);
                      chart.series[0].remove();
                      chart.addSeries({
                         name: name,
                         data: data,
                         color: color || 'white'
                      });",
                    "name", "categories", "data", "color"
                )
                .AddJavascripVariable("colors", "Highcharts.getOptions().colors")
                .AddJavascripVariable("name", "'{0}'".FormatWith(NAME))
                .AddJavascripVariable("categories", JsonSerializer.Serialize(categories))
                .AddJavascripVariable("data", JsonSerializer.Serialize(data));

            return View(chart);
        }

        public ActionResult EstadisticaAreaConocimiento()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();


            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;



            var rt = db.MaterialDidactico_SolicitudDetalle.Where(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.IdModalidad == 2 && g.CantidadAutorizada > 0 && g.EsAutorizada == true && g.VistoBueno == true).GroupBy(a => new { a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura, a.IdSolicitud }).Select(g => new { Titulo = g.Key.Asignatura, IdSolicitud = g.Key.IdSolicitud, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            if (id == 0)
                id = 0;
            else
                rt = db.MaterialDidactico_SolicitudDetalle.Where(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.IdModalidad == 2 && g.CantidadAutorizada > 0 && g.MaterialDidactico_Solicitud.IdConvocatoria == id && g.EsAutorizada == true && g.VistoBueno == true).GroupBy(a => new { a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura, a.IdSolicitud }).Select(g => new { Titulo = g.Key.Asignatura, IdSolicitud = g.Key.IdSolicitud, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            var f = rt.GroupBy(r => new { r.Titulo }).Select(g => new { g.Key.Titulo, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();


            ViewBag.Id = id;

            //MaterialDidactico_SolicitudDetalle material = db.MaterialDidactico_SolicitudDetalle.Select(d => d.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Titulo.Titulo).ToArray();
            //string[] categories = { "MSIE", "Firefox", "Chrome", "Safari", "Opera" };
            //var f = db.MaterialDidactico_SolicitudDetalle.GroupBy(a => a.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Titulo.Titulo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t=> t.Count).ToArray();

            List<string> cat = new List<string>();
            //DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data();
            DotNet.Highcharts.Options.Point[] valores = new DotNet.Highcharts.Options.Point[f.Count()];

            int c = 0;
            foreach (var item in f)
            {

                DotNet.Highcharts.Options.Point valor = new DotNet.Highcharts.Options.Point();
                cat.Add(item.Titulo);
                valor.Y = item.Count;
                valor.Name = item.Titulo;

                valores[c] = valor;
                c = c + 1;
            }
            DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data(valores);
            const string NAME = "Estadísticas de solicitudes por Area de Conocimiento";

            string[] categories = cat.ToArray();
            //  DotNet.Highcharts.Helpers.Data data = new DotNet.Highcharts.Helpers.Data(new[]
            //{
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 55.11,
            //        Color = Color.FromName("colors[0]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "MSIE versions",
            //            Categories = new[] { "MSIE 6.0", "MSIE 7.0", "MSIE 8.0", "MSIE 9.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 10.85, 7.35, 33.06, 2.81 }),
            //            Color = Color.FromName("colors[0]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 21.63,
            //        Color = Color.FromName("colors[1]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Firefox versions",
            //            Categories = new[] { "Firefox 2.0", "Firefox 3.0", "Firefox 3.5", "Firefox 3.6", "Firefox 4.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.20, 0.83, 1.58, 13.12, 5.43 }),
            //            Color = Color.FromName("colors[1]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 11.94,
            //        Color = Color.FromName("colors[2]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Chrome versions",
            //            Categories = new[] { "Chrome 5.0", "Chrome 6.0", "Chrome 7.0", "Chrome 8.0", "Chrome 9.0", "Chrome 10.0", "Chrome 11.0", "Chrome 12.0" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.12, 0.19, 0.12, 0.36, 0.32, 9.91, 0.50, 0.22 }),
            //            Color = Color.FromName("colors[2]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 7.15,
            //        Color = Color.FromName("colors[3]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Safari versions",
            //            Categories = new[] { "Safari 5.0", "Safari 4.0", "Safari Win 5.0", "Safari 4.1", "Safari/Maxthon", "Safari 3.1", "Safari 4.1" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 4.55, 1.42, 0.23, 0.21, 0.20, 0.19, 0.14 }),
            //            Color = Color.FromName("colors[3]")
            //        }
            //    },
            //    new DotNet.Highcharts.Options.Point
            //    {
            //        Y = 2.14,
            //        Color = Color.FromName("colors[4]"),
            //        Drilldown = new Drilldown
            //        {
            //            Name = "Opera versions",
            //            Categories = new[] { "Opera 9.x", "Opera 10.x", "Opera 11.x" },
            //            Data = new DotNet.Highcharts.Helpers.Data(new object[] { 0.12, 0.37, 1.65 }),
            //            Color = Color.FromName("colors[4]")
            //        }
            //    }
            //});

            Highcharts chart = new Highcharts("chart")
                .InitChart(new Chart { DefaultSeriesType = ChartTypes.Column })
                .SetTitle(new Title { Text = "Estadísticas de solicitudes por Area de Conocimiento" })
                //.SetSubtitle(new Subtitle { Text = "Click the columns to view versions. Click again to view brands." })
                .SetXAxis(new XAxis { Categories = categories })
                .SetYAxis(new YAxis { Title = new YAxisTitle { Text = "Total" } })
                .SetLegend(new Legend { Enabled = false })
                .SetTooltip(new Tooltip { Formatter = "TooltipFormatter" })
                .SetPlotOptions(new PlotOptions
                {
                    Column = new PlotOptionsColumn
                    {
                        Cursor = Cursors.Pointer,
                        ColorByPoint = true,
                        Point = new PlotOptionsColumnPoint { Events = new PlotOptionsColumnPointEvents { Click = "ColumnPointClick" } },
                        DataLabels = new PlotOptionsColumnDataLabels
                        {
                            Enabled = true,

                            // Color = Color.FromName("colors[0]"),
                            Formatter = "function() { return this.y +' solicitudes'; }",
                            Style = "fontWeight: 'bold'"
                        }
                    }
                })
                .SetSeries(new Series
                {
                    Name = "Browser brands",
                    Data = data,
                    Color = Color.White
                })
                .SetExporting(new Exporting { Enabled = false })
                .AddJavascripFunction(
                    "TooltipFormatter",
                    @"var point = this.point, s = this.x +':<b>'+ this.y +' solicitudes</b><br/>';
                      if (point.drilldown) {
                        s += 'Click to view '+ point.category +' versions';
                      } else {
                        s += 'Click to return to browser brands';
                      }
                      return s;"
                )
                .AddJavascripFunction(
                    "ColumnPointClick",
                    @"var drilldown = this.drilldown;
                      if (drilldown) { // drill down
                        setChart(drilldown.name, drilldown.categories, drilldown.data.data, drilldown.color);
                      } else { // restore
                        setChart(name, categories, data.data);
                      }"
                )
                .AddJavascripFunction(
                    "setChart",
                    @"chart.xAxis[0].setCategories(categories);
                      chart.series[0].remove();
                      chart.addSeries({
                         name: name,
                         data: data,
                         color: color || 'white'
                      });",
                    "name", "categories", "data", "color"
                )
                .AddJavascripVariable("colors", "Highcharts.getOptions().colors")
                .AddJavascripVariable("name", "'{0}'".FormatWith(NAME))
                .AddJavascripVariable("categories", JsonSerializer.Serialize(categories))
                .AddJavascripVariable("data", JsonSerializer.Serialize(data));

            return View(chart);
        }

        public ActionResult EstadisticaArea()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();

            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            ChartsModel model = new ChartsModel();

            var vv = db.MaterialDidactico_SolicitudDetalle.Where(g => g.CantidadAutorizada >  0 && g.EsAutorizada==true && g.VistoBueno == true).Select(g => g.IdSolicitud).ToList();

            var f = db.MaterialDidactico_Solicitud.Where(g => vv.Contains(g.IdSolicitud) &&  g.Modalidad == "EMSAD" && g.IdUsuarioAutorizo > 0 && g.VistoBueno == true).GroupBy(a => a.CentroEducativo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            if (id == 0)
                id = 0;
            else

                f = db.MaterialDidactico_Solicitud.Where(g => vv.Contains(g.IdSolicitud) && g.Modalidad == "EMSAD" && g.IdUsuarioAutorizo > 0 && g.IdConvocatoria == id && g.VistoBueno == true).GroupBy(a => a.CentroEducativo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            ViewBag.Id = id;

            List<string> cat = new List<string>();

            //DotNet.Highcharts.Options.Point[] valores = new DotNet.Highcharts.Options.Point[f.Count()];
            DotNet.Highcharts.Options.Series[] valores = new DotNet.Highcharts.Options.Series[1];
            List<object> totales = new List<object>();

            int c = 0;
            int ts = 0;

            foreach (var item in f)
            {

                cat.Add(item.Titulo);
                totales.Add(item.Count);
                ts = ts + item.Count;
                c = c + 1;
            }
            DotNet.Highcharts.Options.Series uno = new DotNet.Highcharts.Options.Series();
            Object[] o = totales.ToArray();
            uno.Name = "Total " + ts.ToString();

            uno.Data = new DotNet.Highcharts.Helpers.Data(o);

            string[] categories = cat.ToArray();



            Highcharts chart = new Highcharts("chart1")

              .InitChart(new Chart { DefaultSeriesType = ChartTypes.Bar, Height = 1600 })
              .SetTitle(new Title { Text = "Estadísticas de solicitudes por centros Emsad" })
              .SetXAxis(new XAxis { Categories = categories })
              .SetYAxis(new YAxis
              {
                  Min = 0,
                  Title = new YAxisTitle { Text = "Total de solicitudes" }
              })
              .SetTooltip(new Tooltip { Formatter = "function() { return ''+ this.series.name +': '+ this.y +' solicitudes'; }" })
              .SetPlotOptions(new PlotOptions { Bar = new PlotOptionsBar { Stacking = Stackings.Normal, ColorByPoint = true } })
              .SetSeries(uno);


            model.Chart2 = chart;

            var f2 = db.MaterialDidactico_Solicitud.Where(g => vv.Contains(g.IdSolicitud) &&  g.Modalidad == "PLANTEL" && g.IdUsuarioAutorizo > 0).GroupBy(a => a.CentroEducativo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            if (id == 0)
                f2 = db.MaterialDidactico_Solicitud.Where(g => vv.Contains(g.IdSolicitud) &&  g.Modalidad == "PLANTEL" && g.IdUsuarioAutorizo > 0).GroupBy(a => a.CentroEducativo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();
            else
                f2 = db.MaterialDidactico_Solicitud.Where(g => vv.Contains(g.IdSolicitud) &&   g.Modalidad == "PLANTEL" && g.IdUsuarioAutorizo > 0 && g.IdConvocatoria == id).GroupBy(a => a.CentroEducativo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();


            List<string> cat2 = new List<string>();

            //DotNet.Highcharts.Options.Point[] valores = new DotNet.Highcharts.Options.Point[f.Count()];
            DotNet.Highcharts.Options.Series[] valores2 = new DotNet.Highcharts.Options.Series[1];
            List<object> totales2 = new List<object>();

            int c2 = 0;
            int ts2 = 0;

            foreach (var item in f2)
            {

                cat2.Add(item.Titulo);
                totales2.Add(item.Count);
                ts2 = ts2 + item.Count;
                c2 = c2 + 1;
            }
            DotNet.Highcharts.Options.Series uno2 = new DotNet.Highcharts.Options.Series();
            Object[] o2 = totales2.ToArray();
            uno2.Name = "Total " + ts2.ToString();

            uno2.Data = new DotNet.Highcharts.Helpers.Data(o2);

            string[] categories2 = cat2.ToArray();



            Highcharts chart2 = new Highcharts("chart2")

              .InitChart(new Chart { DefaultSeriesType = ChartTypes.Bar, Height = 1600 })
              .SetTitle(new Title { Text = "Estadísticas de solicitudes por Planteles" })
              .SetXAxis(new XAxis { Categories = categories2 })
              .SetYAxis(new YAxis
              {
                  Min = 0,
                  Title = new YAxisTitle { Text = "Total de solicitudes" }
              })
              .SetTooltip(new Tooltip { Formatter = "function() { return ''+ this.series.name +': '+ this.y +' solicitudes'; }" })
              .SetPlotOptions(new PlotOptions { Bar = new PlotOptionsBar { Stacking = Stackings.Normal, ColorByPoint = true } })
              .SetSeries(uno2);

            model.Chart1 = chart2;

            return View(model);

        }

        public ActionResult EstadisticaCentroEmsad()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();


            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;

            var f = db.MaterialDidactico_Solicitud.Where(g => g.Modalidad == "EMSAD" && g.IdUsuarioAutorizo > 0 && g.VistoBueno == true).GroupBy(a => a.CentroEducativo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();
            if (id == 0)
                id = 0;
            else
                f = db.MaterialDidactico_Solicitud.Where(g => g.Modalidad == "EMSAD" && g.IdUsuarioAutorizo > 0 && g.IdConvocatoria == id && g.VistoBueno == true).GroupBy(a => a.CentroEducativo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            ViewBag.Id = id;

            List<string> cat = new List<string>();

            //DotNet.Highcharts.Options.Point[] valores = new DotNet.Highcharts.Options.Point[f.Count()];
            DotNet.Highcharts.Options.Series[] valores = new DotNet.Highcharts.Options.Series[1];
            List<object> totales = new List<object>();

            int c = 0;
            int ts = 0;

            foreach (var item in f)
            {

                cat.Add(item.Titulo);
                totales.Add(item.Count);
                ts = ts + item.Count;
                c = c + 1;
            }
            DotNet.Highcharts.Options.Series uno = new DotNet.Highcharts.Options.Series();
            Object[] o = totales.ToArray();
            uno.Name = "Total " + ts.ToString();

            uno.Data = new DotNet.Highcharts.Helpers.Data(o);

            string[] categories = cat.ToArray();



            Highcharts chart = new Highcharts("chart")

              .InitChart(new Chart { DefaultSeriesType = ChartTypes.Bar, Height = 1600 })
              .SetTitle(new Title { Text = "Estadísticas de solicitudes por centros Emsad" })
              .SetXAxis(new XAxis { Categories = categories })
              .SetYAxis(new YAxis
              {
                  Min = 0,
                  Title = new YAxisTitle { Text = "Total de solicitudes" }
              })
              .SetTooltip(new Tooltip { Formatter = "function() { return ''+ this.series.name +': '+ this.y +' solicitudes'; }" })
              .SetPlotOptions(new PlotOptions { Bar = new PlotOptionsBar { Stacking = Stackings.Normal, ColorByPoint = true } })
              .SetSeries(uno);


            return View(chart);


        }

        public ActionResult EstadisticaCentroPlantel()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();

            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            var f = db.MaterialDidactico_Solicitud.Where(g => g.Modalidad == "PLANTEL" && g.IdUsuarioAutorizo > 0 && g.VistoBueno == true).GroupBy(a => a.CentroEducativo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();
            if (id == 0)
                id = 0;
            else
                f = db.MaterialDidactico_Solicitud.Where(g => g.Modalidad == "PLANTEL" && g.IdUsuarioAutorizo > 0 && g.IdConvocatoria == id && g.VistoBueno == true).GroupBy(a => a.CentroEducativo).Select(g => new { Titulo = g.Key, Count = g.Count() }).OrderByDescending(t => t.Count).ToArray();

            ViewBag.Id = id;


            List<string> cat = new List<string>();

            //DotNet.Highcharts.Options.Point[] valores = new DotNet.Highcharts.Options.Point[f.Count()];
            DotNet.Highcharts.Options.Series[] valores = new DotNet.Highcharts.Options.Series[1];
            List<object> totales = new List<object>();

            int c = 0;
            int ts = 0;

            foreach (var item in f)
            {

                cat.Add(item.Titulo);
                totales.Add(item.Count);
                ts = ts + item.Count;
                c = c + 1;
            }
            DotNet.Highcharts.Options.Series uno = new DotNet.Highcharts.Options.Series();
            Object[] o = totales.ToArray();
            uno.Name = "Total " + ts.ToString();

            uno.Data = new DotNet.Highcharts.Helpers.Data(o);

            string[] categories = cat.ToArray();



            Highcharts chart = new Highcharts("chart")

              .InitChart(new Chart { DefaultSeriesType = ChartTypes.Bar, Height = 1600 })
              .SetTitle(new Title { Text = "Estadísticas de solicitudes por Planteles" })
              .SetXAxis(new XAxis { Categories = categories })
              .SetYAxis(new YAxis
              {
                  Min = 0,
                  Title = new YAxisTitle { Text = "Total de solicitudes" }
              })
              .SetTooltip(new Tooltip { Formatter = "function() { return ''+ this.series.name +': '+ this.y +' solicitudes'; }" })
              .SetPlotOptions(new PlotOptions { Bar = new PlotOptionsBar { Stacking = Stackings.Normal, ColorByPoint = true } })
              .SetSeries(uno);


            return View(chart);
        }

        public ActionResult Concentrado()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(f => f.FechaInicio).FirstOrDefault();

            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            ViewBag.Id = id;

            List<Nova.Models.vwAulasDidacticas> model = db.vwAulasDidacticas.Where(t => t.IdConvocatoria == id).OrderBy(e => e.IdSolicitud).ToList();
            return View(model);
        }

        //public ActionResult ConcentradoXls()
        //{
        //    Response.AddHeader("Content-Type", "application/vnd.ms-excel");
        //    Response.AddHeader("Content-Disposition", "attachment;filename=ConcentradoAulasDidacticas.xls");
        //    List<Nova.Models.vwAulasDidacticas> model = db.vwAulasDidacticas.OrderBy(e => e.IdSolicitud).ToList();
        //    return View(model);
        //}

        public ActionResult Material()
        {

            List<Nova.Models.MaterialDidactico_AsignaturaTitulo> model = db.MaterialDidactico_AsignaturaTitulo.OrderBy(e => e.MaterialDidactico_Asignaturas.Asignatura).ToList();
            return View(model);
        }

        public ActionResult CentrosSinParticipar()
        {

            List<Nova.Models.Catalogos_ctEstructuraOrganica> centros = db.Catalogos_ctEstructuraOrganica.Where(r => r.EstructuraOrganica.Contains("PLANTEL N") || r.EstructuraOrganica.Contains("EMSAD N")).ToList();

            List<CentrosEducativos> centrossolicitud = db.MaterialDidactico_Solicitud.Select(r => new CentrosEducativos { EstructuraOrganica = r.CentroEducativo }).ToList();

            List<Nova.Models.Catalogos_ctEstructuraOrganica> model = centros.Where(y => !centrossolicitud.Any(p2 => p2.EstructuraOrganica == y.EstructuraOrganica)).OrderBy(g => g.EstructuraOrganica).ToList();


            return View(model);
        }

        public ActionResult Entregas()
        {

            List<Nova.Models.Catalogos_ctEstructuraOrganica> centros = db.Catalogos_ctEstructuraOrganica.Where(r => r.EstructuraOrganica.Contains("PLANTEL N") || r.EstructuraOrganica.Contains("EMSAD N")).ToList();

            List<CentrosEducativos> centrossolicitud = db.MaterialDidactico_Solicitud.Select(r => new CentrosEducativos { EstructuraOrganica = r.CentroEducativo }).ToList();

            List<TotalProductosEntregas> model = db.MaterialDidactico_SolicitudDetalle.Where(b => b.EsAutorizada == true && b.VistoBueno == true).GroupBy(t => t.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_InventarioTitulo.MaterialDidactico_Titulo.Titulo).Select(r => new TotalProductosEntregas { Titulo = r.Key, Total = r.Sum(a => a.CantidadAutorizada), TipoMaterial = r.Max(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_InventarioTitulo.MaterialDidactico_Titulo.MaterialDidactico_TipoMaterial.TipoMaterial) }).ToList();


            return View(model);
        }



        //public ActionResult MaterialXls()
        //{
        //    Response.AddHeader("Content-Type", "application/vnd.ms-excel");
        //    Response.AddHeader("Content-Disposition", "attachment;filename=MaterialAulasDidacticas.xls");
        //    List<Nova.Models.MaterialDidactico_AsignaturaTitulo> model = db.MaterialDidactico_AsignaturaTitulo.OrderBy(e => e.MaterialDidactico_Asignaturas.Asignatura).ToList();
        //    return View(model);
        //}
    }
}