﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.Web.Mvc;

namespace Nova.Controllers
{
    public class vwLocalidadesController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        //
        // GET: /vwLocalidades/
        [AllowAnonymous]
        public ActionResult Index()
        {
            return View(db.vwLocalidades.ToList());
        }

        //
        // GET: /vwLocalidades/Details/5

        public ActionResult Details(decimal id = 0)
        {
            vwLocalidades vwlocalidades = db.vwLocalidades.Find(id);
            if (vwlocalidades == null)
            {
                return HttpNotFound();
            }
            return View(vwlocalidades);
        }

        //
        // GET: /vwLocalidades/Create

        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /vwLocalidades/Create

        [HttpPost]
        public ActionResult Create(vwLocalidades vwlocalidades)
        {
            if (ModelState.IsValid)
            {
                db.vwLocalidades.Add(vwlocalidades);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(vwlocalidades);
        }

        //
        // GET: /vwLocalidades/Edit/5

        public ActionResult Edit(decimal id = 0)
        {
            vwLocalidades vwlocalidades = db.vwLocalidades.Find(id);
            if (vwlocalidades == null)
            {
                return HttpNotFound();
            }
            return View(vwlocalidades);
        }

        //
        // POST: /vwLocalidades/Edit/5

        [HttpPost]
        public ActionResult Edit(vwLocalidades vwlocalidades)
        {
            if (ModelState.IsValid)
            {
                db.Entry(vwlocalidades).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(vwlocalidades);
        }

        //
        // GET: /vwLocalidades/Delete/5

        public ActionResult Delete(decimal id = 0)
        {
            vwLocalidades vwlocalidades = db.vwLocalidades.Find(id);
            if (vwlocalidades == null)
            {
                return HttpNotFound();
            }
            return View(vwlocalidades);
        }

        //
        // POST: /vwLocalidades/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(decimal id)
        {
            vwLocalidades vwlocalidades = db.vwLocalidades.Find(id);
            db.vwLocalidades.Remove(vwlocalidades);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
        Nova.Models.bdNovaEntities db1 = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        [AllowAnonymous]
        public ActionResult GridViewPartial(string gridname,string scriptfunction)
        {
            //var model = db1.vwLocalidades;

            ViewData["gridname"] = gridname;
            ViewData["scriptfunction"] = scriptfunction;
            

            return PartialView("_GridViewPartial");
        }

    }
}