﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Rotativa;
using System.Globalization;
namespace Nova.Controllers.ListaRaya
{
    
    public class ListaRayaController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: ListaRaya
        public ActionResult Index()
        {
            var nomina_stNominaTrabajador = db.Nomina_stNominaTrabajador.Include(n => n.Convenios_stConvenioLaboralTrabajadorCategoria).Include(n => n.Nomina_stNomina);
            return View(nomina_stNominaTrabajador.ToList());
        }

        // GET: ListaRaya/Details/5
        public ActionResult Details(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Nomina_stNominaTrabajador nomina_stNominaTrabajador = db.Nomina_stNominaTrabajador.Find(id);
            if (nomina_stNominaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(nomina_stNominaTrabajador);
        }

        // GET: ListaRaya/Create
        public ActionResult Create()
        {
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdNomina = new SelectList(db.Nomina_stNomina, "IdNomina", "AliasNomina");
            return View();
        }
        // POST: ListaRaya/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdNominaTrabajador,IdNomina,IdConvenioLaboralTrabajadorCategoria,SueldoBruto,SueldoDiario,SueldoNeto,SueldoTransferencia,SueldoMonedero,IdTrabajadorCuentasTransferencia,IdTrabajadorCuentasMonedero,HorasSemanaMes,HorasSemanaMesTrabajadas,HorasTrabajadasExcedentes,HorasTrabajadasInterinas,DiasEfectivosLaborados,CostoPorHora,CostoPorHoraExcedente,CostoPorHorasInterinas,SalarioDiarioIntegrado,QuinquenioDiario,MaterialDidacticoDiario,SalarioConvencional1,SalarioConvencional2,SumaPercepcionesVariables,BaseGravable,HorasEfectivasDeTrabajo,EsDevolucion,SalarioBrutoGravable")] Nomina_stNominaTrabajador nomina_stNominaTrabajador)
        {
            if (ModelState.IsValid)
            {
                db.Nomina_stNominaTrabajador.Add(nomina_stNominaTrabajador);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", nomina_stNominaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdNomina = new SelectList(db.Nomina_stNomina, "IdNomina", "AliasNomina", nomina_stNominaTrabajador.IdNomina);
            return View(nomina_stNominaTrabajador);
        }


        // Imprimir lista de asistencia
         //[HttpPost]
        public ActionResult ListaRaya(int idnomina)
        {


            DateTime FechaInicioNomina = new DateTime();
            DateTime FechaFinalNomina = new DateTime();
            int Parametro = new int();
            //string percepcion;
            //Decimal importe = new Decimal();
            var ca = (from a in db.Nomina_stNomina
                     where a.IdNomina == idnomina
                      select new
                      {
                          
                          FechaInicio = a.FechaInicio,
                          FechaFinal= a.FechaTermino,
                          Parametro = a.IdQuincenaMes
                      });
            foreach (var item in ca)
            {

                FechaInicioNomina = item.FechaInicio;
                FechaFinalNomina = item.FechaFinal;
                Parametro = item.Parametro;
               
                //    TimeSpan diferencia = FechaTerminoCurso.Date - FechaInicioCurso.Date; 
                //diascurso =diferencia.TotalDays;
            }

            List<Nomina_stNominaTrabajador> listarayatrabajadores = db.Nomina_stNominaTrabajador.Where(b => b.IdNomina == idnomina).OrderBy(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica).ThenBy(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();
                    
      
           
            if (listarayatrabajadores.Count() == 0)
            {

                throw new ApplicationException("No existen trabajadores en la nomina seleccionada");
            }
            //Session["percepciones"] = ll;
            Session["listarayatrabajadores"] = listarayatrabajadores;
            Session["FechaInicioNomina"] = FechaInicioNomina.ToString("dd 'DE' MMMM", CultureInfo.CreateSpecificCulture("es-MX")).ToUpper();
            Session["FechaFinalNomina"] = FechaFinalNomina.ToString("dd 'DE' MMMM 'DE' yyyy", CultureInfo.CreateSpecificCulture("es-MX")).ToUpper();
            Session["Parametro"] = Parametro;
            Session["FechaEmision"] = DateTime.Now.ToString("dd 'DE' MMMM 'DE' yyyy", CultureInfo.CreateSpecificCulture("es-MX")).ToUpper(); 
              // 
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 10;
            m.Right = 5;
            m.Top = 0;

            string foot = " Fecha y hora de registro" + DateTime.Now.ToShortDateString();
            return View(listarayatrabajadores);
            //return new ViewAsPdf(listarayatrabajadores) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = "ListaAsistencia.pdf" };
        }

        // GET: ListaRaya/Edit/5
        public ActionResult Edit(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Nomina_stNominaTrabajador nomina_stNominaTrabajador = db.Nomina_stNominaTrabajador.Find(id);
            if (nomina_stNominaTrabajador == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", nomina_stNominaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdNomina = new SelectList(db.Nomina_stNomina, "IdNomina", "AliasNomina", nomina_stNominaTrabajador.IdNomina);
            return View(nomina_stNominaTrabajador);
        }

        // POST: ListaRaya/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdNominaTrabajador,IdNomina,IdConvenioLaboralTrabajadorCategoria,SueldoBruto,SueldoDiario,SueldoNeto,SueldoTransferencia,SueldoMonedero,IdTrabajadorCuentasTransferencia,IdTrabajadorCuentasMonedero,HorasSemanaMes,HorasSemanaMesTrabajadas,HorasTrabajadasExcedentes,HorasTrabajadasInterinas,DiasEfectivosLaborados,CostoPorHora,CostoPorHoraExcedente,CostoPorHorasInterinas,SalarioDiarioIntegrado,QuinquenioDiario,MaterialDidacticoDiario,SalarioConvencional1,SalarioConvencional2,SumaPercepcionesVariables,BaseGravable,HorasEfectivasDeTrabajo,EsDevolucion,SalarioBrutoGravable")] Nomina_stNominaTrabajador nomina_stNominaTrabajador)
        {
            if (ModelState.IsValid)
            {
                db.Entry(nomina_stNominaTrabajador).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", nomina_stNominaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdNomina = new SelectList(db.Nomina_stNomina, "IdNomina", "AliasNomina", nomina_stNominaTrabajador.IdNomina);
            return View(nomina_stNominaTrabajador);
        }

        // GET: ListaRaya/Delete/5
        public ActionResult Delete(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Nomina_stNominaTrabajador nomina_stNominaTrabajador = db.Nomina_stNominaTrabajador.Find(id);
            if (nomina_stNominaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(nomina_stNominaTrabajador);
        }

        // POST: ListaRaya/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(long id)
        {
            Nomina_stNominaTrabajador nomina_stNominaTrabajador = db.Nomina_stNominaTrabajador.Find(id);
            db.Nomina_stNominaTrabajador.Remove(nomina_stNominaTrabajador);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
