﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.Web.Mvc;
using Nova.Libraries;

namespace Nova.Controllers
{
    public class TrabajadorController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        //
        // GET: /Trabajador/

        public ActionResult Index()
        {
            var kardex_cttrabajador = db.Kardex_ctTrabajador.Include(k => k.Kardex_ctDatosPersonales);

            return View(kardex_cttrabajador.ToList());
        }

        //
        // GET: /Trabajador/Details/5

        public ActionResult Details(int id = 0)
        {
            Kardex_ctTrabajador kardex_cttrabajador = db.Kardex_ctTrabajador.Find(id);
            if (kardex_cttrabajador == null)
            {
                return HttpNotFound();
            }
            return View(kardex_cttrabajador);
        }

        //
        // GET: /Trabajador/Create

        //public ActionResult Create()
        //{
        //    //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP");
        //    //ViewBag.CountryList = new SelectList(Kardex_ctTrabajador.getAspirantes(), "IdKardex", "CURP");
        //    ViewBag.IdKardex = Kardex_ctTrabajador.getAspirantes();
        //    return View();
        //}

        public ActionResult Create(int IdKardex = 0)
        {
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP");
            //ViewBag.CountryList = new SelectList(Kardex_ctTrabajador.getAspirantes(Id), "IdKardex", "CURP");
            //IEnumerable<SelectListItem> lista= Kardex_ctTrabajador.getAspirantes(IdKardex);

            bdNovaEntities bd = new bdNovaEntities();
            
            Kardex_ctDatosPersonales datospersonales = bd.Kardex_ctDatosPersonales.Find(IdKardex);
            Kardex_ctTrabajador lista = bd.Kardex_ctTrabajador.Where(e => e.IdKardex == IdKardex).SingleOrDefault();

            if (lista != null)
            {
                //    MessageBox.Show(ViewData, TipoMensaje.Information, "El trabajador ya tiene asignado un Identificador");
                throw new ApplicationException("El trabajador que eligió ya tiene asignado un Identificador ");
            }

            ViewBag.datospersonales = datospersonales;
            ViewBag.IdKardex = IdKardex;
            ViewBag.ListaKardex = lista;
            return View();
        }
        //
        // POST: /Trabajador/Create

        [HttpPost]
        public ActionResult Create(Kardex_ctTrabajador kardex_cttrabajador)
        {
            bdNovaEntities bd = new bdNovaEntities();
            if (ModelState.IsValid)
            {
                try
                {
                    db.Kardex_ctTrabajador.Add(kardex_cttrabajador);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //throw new System.ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }


                
                return RedirectToAction("Index");
            }

            var ListErrors = ModelState.Values.SelectMany(t => t.Errors).Select(e => e.ErrorMessage).ToList();

            ModelState.AddModelError(string.Empty, ListErrors[0].ToString());
            

            Kardex_ctDatosPersonales datospersonales = bd.Kardex_ctDatosPersonales.Find(kardex_cttrabajador.IdKardex);
            ViewBag.datospersonales = datospersonales;
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_cttrabajador.IdKardex);
            return View(kardex_cttrabajador);
        }

        //
        // GET: /Trabajador/Edit/5

        public ActionResult Edit(int id = 0)
        {
            Kardex_ctTrabajador kardex_cttrabajador = db.Kardex_ctTrabajador.Find(id);
            if (kardex_cttrabajador == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_cttrabajador.IdKardex);
            return View(kardex_cttrabajador);
        }

        //
        // POST: /Trabajador/Edit/5

        [HttpPost]
        public ActionResult Edit(Kardex_ctTrabajador kardex_cttrabajador)
        {
            if (ModelState.IsValid)
            {
                db.Entry(kardex_cttrabajador).State = System.Data.Entity.EntityState.Modified; ;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_cttrabajador.IdKardex);
            return View(kardex_cttrabajador);
        }

        //
        // GET: /Trabajador/Delete/5

        public ActionResult Delete(int id = 0)
        {
            Kardex_ctTrabajador kardex_cttrabajador = db.Kardex_ctTrabajador.Find(id);
            if (kardex_cttrabajador == null)
            {
                return HttpNotFound();
            }
            return View(kardex_cttrabajador);
        }

        //
        // POST: /Trabajador/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {
            Kardex_ctTrabajador kardex_cttrabajador = db.Kardex_ctTrabajador.Find(id);
            db.Kardex_ctTrabajador.Remove(kardex_cttrabajador);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
        Nova.Models.bdNovaEntities db1 = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvgvTrabajadores()
        {
            var model = db1.Kardex_ctTrabajador;
            return PartialView("__pvgvTrabajadores", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvTrabajadoresAddNew(Nova.Models.Kardex_ctTrabajador item)
        {
            var model = db1.Kardex_ctTrabajador;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db1.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgvTrabajadores", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvTrabajadoresUpdate(Nova.Models.Kardex_ctTrabajador item)
        {
            var model = db1.Kardex_ctTrabajador;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdTrabajador == item.IdTrabajador);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db1.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgvTrabajadores", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvTrabajadoresDelete(System.Int32 IdTrabajador)
        {
            var model = db1.Kardex_ctTrabajador;
            if (IdTrabajador != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdTrabajador == IdTrabajador);
                    if (item != null)
                        model.Remove(item);
                    db1.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("__pvgvTrabajadores", model.ToList());
        }
    }
}