﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using System.Data.SqlClient;
using System.Configuration;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DevExpress.XtraLayout.Filtering.Templates;
using Nova.Models.Kardex;
using WebGrease.Activities;
using System.Web.UI.WebControls;
using Seguridad;
using System.Net.Sockets;
using System.Runtime.InteropServices.ComTypes;
using DevExpress.CodeParser;
using DevExpress.Utils.About;
using DevExpress.XtraEditors.Filtering.Templates;
using DevExpress.Utils.Extensions;

namespace Nova.Controllers.Kardex
{
    public class Kardex_DocumentosExpedienteController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";


        string queryexpediente = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";

        string queryseguimiento = @"select x.IdKardex, x.Nombre,x.ApellidoPaterno,x.ApellidoMaterno,x.UbicacionFisica,x.RelacionLaboral,x.RelacionConvenioLaboral,x.IdConvenioLaboral, z.Archivos from	 (select a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral    from bdNova.dbo.vwDatosAspirantesTrabajadores  a
								 left join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardex=b.IdKardex
								 left join bdNova.dbo.Kardex_TipoDocumento c on b.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on b.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
									 where  A.EstatusTrabajador = 'ALTA'
								  group by a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral)	 x
								  left join ( select  a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                  b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,b.RelacionLaboral,b.RelacionConvenioLaboral 
                                 ,COUNT(*) as Archivos from bdNova.dbo.Kardex_DocumentosExpediente a
                                 left join bdNova.dbo.vwDatosAspirantesTrabajadores b on a.IdKardex=b.IdKardex
                                 left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
								 
								  group by a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                 b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,
								 b.RelacionLaboral,b.RelacionConvenioLaboral) z on  x.IdKardex= z.IdKardex";

        string queryseguimiento300 = @"select c.IdTrabajador, c.Nombre,c.ApellidoPaterno,c.ApellidoMaterno, b.IdKardexDocumentosExpedienteTrabajador from Kardex_DocumentosExpediente a
                inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador b on a.IdKardexDocumentosExpediente=b.IdKardexDocumentosExpediente
                inner join vwDatosAspirantesTrabajadores c on a.IdKardex = c.IdKardex
                where a.IdKardexTipoDocumento = 4 and c.IdTrabajador  IN (19, 42, 46, 49, 76, 90, 93, 119, 163, 175, 220, 271, 273, 284, 295, 322, 355, 387, 459, 537, 561, 607, 707, 756, 772, 786, 846, 863, 873, 882, 883, 884, 889, 897, 909, 922, 924, 939, 943, 947, 948, 951, 957, 964, 969, 973, 979, 987, 996, 1002, 
                  1004, 1010, 1015, 1024, 1032, 1033, 1036, 1044, 1045, 1066, 1067, 1071, 1078, 1081, 1094, 1100, 1109, 1125, 1146, 1152, 1154, 1176, 1196, 1207, 1222, 1227, 1234, 1256, 1276, 1288, 1290, 1306, 1319, 1342, 1346, 1354, 1356, 1359, 1378, 1387, 1389, 1397, 
                  1400, 1410, 1411, 1417, 1432, 1433, 1442, 1457, 1460, 1461, 1465, 1468, 1470, 1478, 1496, 1501, 1507, 1513, 1517, 1521, 1523, 1543, 1556, 1566, 1577, 1578, 1588, 1597, 1598, 1607, 1612, 1626, 1628, 1629, 1633, 1634, 1643, 1670, 1686, 1700, 1704, 1713, 
                  1750, 1755, 1756, 1763, 1784, 1794, 1826, 1827, 1951, 1954, 1967, 1969, 2022, 2053, 2054, 2059, 2094, 2120, 2128, 2154, 2160, 2186, 2189, 2201, 2226, 2235, 2242, 2290, 2304, 2314, 2458, 2464, 2484, 2494, 2572, 2623, 2645, 2704, 2715, 2716, 2761, 2788, 
                  2841, 2857, 2862, 2868, 2881, 2903, 3010, 3045, 3134, 3208, 3218, 3247, 3255, 3277, 3286, 3439, 3440, 3441, 3445, 3523, 3588, 3593, 3615, 3616, 3648, 3649, 3661, 3681, 3683, 3719, 3748, 3765, 3775, 3779, 3788, 3792, 3797, 3819, 3913, 3946, 3968, 3990, 
                  4013, 4053, 4063, 4065, 4110, 4121, 4163, 4261, 4287, 4310, 4311, 4312, 4317, 4319, 4330, 4335, 4336, 4339, 4343, 4347, 4377, 4390, 4447, 4539, 4540, 4544, 4546, 4552, 4553, 4558, 4569, 4585, 4589, 4616, 4621, 4622, 4625, 4627, 4630, 4632) 
                   order by c.IdTrabajador DESC";

        string queryubicacionfisica = @"SELECT EstructuraOrganica FROM bdNova.dbo.Catalogos_ctEstructuraOrganica
                                        WHERE EsVigente= 1";

        string queryrelacionlaboral = @" SELECT RelacionConvenioLaboral FROM bdNova.dbo.Convenios_stRelacionConvenioLaboral";





        // GET: KardexGradoAcademico
        public ActionResult Index()
        {
            //Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //var kardex_GradoAcademicodapper= (List<Kardex_GradoAcademicoFotografia>)dp.connection.Query<Kardex_GradoAcademicoFotografia>(query);
            var kardex_GradoAcademico = db.Kardex_GradoAcademico.Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia); ;
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "Crear Grado Académico";
            ViewBag.TituloSwal = "Eliminar Grado Académico";
            ViewBag.PreguntaSwal = "¿Está seguro de eliminar el Grado Académico?";
            //dp.Close();
            return View(kardex_GradoAcademico.ToList());
        }

        // GET: KardexGradoAcademico/Details/5

        //public ActionResult Details(int id)
        public ActionResult Details()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string query = string.Format(@"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
                        where a.IdKardex = {0}
                        ", IdKardex);
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(query);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpediente.Where(z=> z.IdKardex == IdKardex));
        }


        public ActionResult VerDetails(int id)
        {

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryexpediente);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = id;
            dp.Close();
            var Expediente = kardex_DocumentosExpediente.Where(z => z.IdKardex == id);

            ViewBag.NombreTrabajador = Expediente.FirstOrDefault().Nombre + " " + Expediente.FirstOrDefault().ApellidoPaterno + " " + Expediente.FirstOrDefault().ApellidoMaterno;
                
            return View(Expediente);
            //return View(kardex_DocumentosExpediente.Where(z => z.IdKardex == IdKardex));
        }


        public ActionResult Expedientes()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryseguimiento);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            var ubicacionfisica = (List<UbicacionSeguimiento>)dp.connection.Query<UbicacionSeguimiento>(queryubicacionfisica);

            IEnumerable<SelectListItem> selectList = from s in ubicacionfisica
                                                     select new SelectListItem
                                                     {
                                                         Value = s.EstructuraOrganica.ToString(),
                                                         Text = s.EstructuraOrganica
                                                     };
            ViewBag.IdUbicacionFisica = new SelectList(selectList, "Value", "Text");

            var relacionlaboral = (List<RelacionLaboralSeguimiento>)dp.connection.Query<RelacionLaboralSeguimiento>(queryrelacionlaboral);

            IEnumerable<SelectListItem> selectListrelacion = from s in relacionlaboral
                                                     select new SelectListItem
                                                     {
                                                         Value = s.RelacionConvenioLaboral.ToString(),
                                                         Text = s.RelacionConvenioLaboral
                                                     };
            ViewBag.IdRelacionLaboral = new SelectList(selectListrelacion, "Value", "Text");






            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        public ActionResult Expedientes300()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedientesTrabajadores300>)dp.connection.Query<KardexDocumentosExpedientesTrabajadores300>(queryseguimiento300);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            var ubicacionfisica = (List<UbicacionSeguimiento>)dp.connection.Query<UbicacionSeguimiento>(queryubicacionfisica);

            IEnumerable<SelectListItem> selectList = from s in ubicacionfisica
                                                     select new SelectListItem
                                                     {
                                                         Value = s.EstructuraOrganica.ToString(),
                                                         Text = s.EstructuraOrganica
                                                     };
            ViewBag.IdUbicacionFisica = new SelectList(selectList, "Value", "Text");

            var relacionlaboral = (List<RelacionLaboralSeguimiento>)dp.connection.Query<RelacionLaboralSeguimiento>(queryrelacionlaboral);

            IEnumerable<SelectListItem> selectListrelacion = from s in relacionlaboral
                                                             select new SelectListItem
                                                             {
                                                                 Value = s.RelacionConvenioLaboral.ToString(),
                                                                 Text = s.RelacionConvenioLaboral
                                                             };
            ViewBag.IdRelacionLaboral = new SelectList(selectListrelacion, "Value", "Text");






            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        public ActionResult ExpedientesCentro()
        {
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryseguimiento);
            int idcltc = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            short? idModalidad = new bdNovaEntities().vwDatosAspirantesTrabajadores.Where(x => x.IdKardex == IdKardex).FirstOrDefault().IdModalidadEstudio;
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idcltc);
            int nivel = (short)convenio.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.OrdenEstructuraOrganica;
            if (idModalidad == 0 && nivel < 5 || idModalidad > 0 && nivel < 11)
            {
         
                 //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
                //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
                ViewBag.Controlador = "KardexGradoAcademico";
                ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
                ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
                ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
                //ViewBag.IdKardex = id;

                string UbicacionFisica = kardex_DocumentosExpedienteSeguimiento.Where(x => x.IdKardex == IdKardex).FirstOrDefault().UbicacionFisica;
                ViewBag.IdKardex = IdKardex;

                var ubicacionfisica = (List<UbicacionSeguimiento>)dp.connection.Query<UbicacionSeguimiento>(queryubicacionfisica);

                IEnumerable<SelectListItem> selectList = from s in ubicacionfisica.Where(z => z.EstructuraOrganica == UbicacionFisica)
                                                         select new SelectListItem
                                                         {
                                                             Value = s.EstructuraOrganica.ToString(),
                                                             Text = s.EstructuraOrganica
                                                         };
                ViewBag.IdUbicacionFisica = new SelectList(selectList, "Value", "Text");

                var relacionlaboral = (List<RelacionLaboralSeguimiento>)dp.connection.Query<RelacionLaboralSeguimiento>(queryrelacionlaboral);

                IEnumerable<SelectListItem> selectListrelacion = from s in relacionlaboral
                                                                 select new SelectListItem
                                                                 {
                                                                     Value = s.RelacionConvenioLaboral.ToString(),
                                                                     Text = s.RelacionConvenioLaboral
                                                                 };
                ViewBag.IdRelacionLaboral = new SelectList(selectListrelacion, "Value", "Text");






                dp.Close();
            }
            else { throw new Exception("El usaurio no tiene los permisos necesarios"); }

            return View(kardex_DocumentosExpedienteSeguimiento);
        }



        public ActionResult SeguimientoExpedientes()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryseguimiento);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        [HttpPost]
        public ActionResult ExpedientesTrabajadores(string IdUbicacionFisica, string IdRelacionLaboral)
        {
            
            string Filtro = string.Empty;



            if (IdUbicacionFisica != "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "' and  x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
            }
            if (IdUbicacionFisica != "" && IdRelacionLaboral == "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral == "")
            {
                Filtro = "" ;
            }


            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string querybuscar = @"select x.IdKardex, x.Nombre,x.ApellidoPaterno,x.ApellidoMaterno,x.UbicacionFisica,x.RelacionLaboral,x.RelacionConvenioLaboral,x.IdConvenioLaboral, x.Sexo, z.Archivos from	 (select a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral,a.Sexo    from bdNova.dbo.vwDatosAspirantesTrabajadores  a
								 left join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardex=b.IdKardex
								 left join bdNova.dbo.Kardex_TipoDocumento c on b.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on b.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
									 where  A.EstatusTrabajador = 'ALTA'
								  group by a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral, a.Sexo)	 x
								  left join ( select  a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                 b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,b.RelacionLaboral,b.RelacionConvenioLaboral ,b.Sexo
                                 ,COUNT(*) as Archivos from bdNova.dbo.Kardex_DocumentosExpediente a
                                 left join bdNova.dbo.vwDatosAspirantesTrabajadores b on a.IdKardex=b.IdKardex
                                 left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
								 
								  group by a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                  b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,
								 b.RelacionLaboral,b.RelacionConvenioLaboral,b.Sexo) z on  x.IdKardex= z.IdKardex
                                    " + Filtro + " order by x.IdKardex DESC ";




            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(querybuscar, new { IdUbicacionFisica, IdRelacionLaboral });

            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        [HttpPost]
        public ActionResult ExpedientesTrabajadores300(string IdUbicacionFisica, string IdRelacionLaboral)
        {

            string Filtro = string.Empty;



            if (IdUbicacionFisica != "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "' and  x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
            }
            if (IdUbicacionFisica != "" && IdRelacionLaboral == "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral == "")
            {
                Filtro = "";
            }


            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string querybuscar = @"select c.IdTrabajador, c.Nombre,c.ApellidoPaterno,c.ApellidoMaterno, b.IdKardexDocumentosExpedienteTrabajador from Kardex_DocumentosExpediente a
                inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador b on a.IdKardexDocumentosExpediente=b.IdKardexDocumentosExpediente
                inner join vwDatosAspirantesTrabajadores c on a.IdKardex = c.IdKardex
                where a.IdKardexTipoDocumento = 4 and c.IdTrabajador  IN (19, 42, 46, 49, 76, 90, 93, 119, 163, 175, 220, 271, 273, 284, 295, 322, 355, 387, 459, 537, 561, 607, 707, 756, 772, 786, 846, 863, 873, 882, 883, 884, 889, 897, 909, 922, 924, 939, 943, 947, 948, 951, 957, 964, 969, 973, 979, 987, 996, 1002, 
                  1004, 1010, 1015, 1024, 1032, 1033, 1036, 1044, 1045, 1066, 1067, 1071, 1078, 1081, 1094, 1100, 1109, 1125, 1146, 1152, 1154, 1176, 1196, 1207, 1222, 1227, 1234, 1256, 1276, 1288, 1290, 1306, 1319, 1342, 1346, 1354, 1356, 1359, 1378, 1387, 1389, 1397, 
                  1400, 1410, 1411, 1417, 1432, 1433, 1442, 1457, 1460, 1461, 1465, 1468, 1470, 1478, 1496, 1501, 1507, 1513, 1517, 1521, 1523, 1543, 1556, 1566, 1577, 1578, 1588, 1597, 1598, 1607, 1612, 1626, 1628, 1629, 1633, 1634, 1643, 1670, 1686, 1700, 1704, 1713, 
                  1750, 1755, 1756, 1763, 1784, 1794, 1826, 1827, 1951, 1954, 1967, 1969, 2022, 2053, 2054, 2059, 2094, 2120, 2128, 2154, 2160, 2186, 2189, 2201, 2226, 2235, 2242, 2290, 2304, 2314, 2458, 2464, 2484, 2494, 2572, 2623, 2645, 2704, 2715, 2716, 2761, 2788, 
                  2841, 2857, 2862, 2868, 2881, 2903, 3010, 3045, 3134, 3208, 3218, 3247, 3255, 3277, 3286, 3439, 3440, 3441, 3445, 3523, 3588, 3593, 3615, 3616, 3648, 3649, 3661, 3681, 3683, 3719, 3748, 3765, 3775, 3779, 3788, 3792, 3797, 3819, 3913, 3946, 3968, 3990, 
                  4013, 4053, 4063, 4065, 4110, 4121, 4163, 4261, 4287, 4310, 4311, 4312, 4317, 4319, 4330, 4335, 4336, 4339, 4343, 4347, 4377, 4390, 4447, 4539, 4540, 4544, 4546, 4552, 4553, 4558, 4569, 4585, 4589, 4616, 4621, 4622, 4625, 4627, 4630, 4632) 
                  " + Filtro + " order by c.IdTrabajador DESC ";




            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedientesTrabajadores300>)dp.connection.Query<KardexDocumentosExpedientesTrabajadores300>(querybuscar, new { IdUbicacionFisica, IdRelacionLaboral });

            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        [HttpPost]
        public ActionResult ExpedientesTrabajadoresCentro(string IdUbicacionFisica, string IdRelacionLaboral)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryseguimiento);
            string UbicacionFisica = kardex_DocumentosExpediente.Where(x => x.IdKardex == IdKardex).FirstOrDefault().UbicacionFisica;

            string Filtro = string.Empty;



            if (IdUbicacionFisica != "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "' and  x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral != "")
            {
                Filtro = "where x.UbicacionFisica ='" + UbicacionFisica + "' and  x.RelacionConvenioLaboral ='" + IdRelacionLaboral + "'";
                
            }
            if (IdUbicacionFisica != "" && IdRelacionLaboral == "")
            {
                Filtro = "where x.UbicacionFisica ='" + IdUbicacionFisica + "'";
            }
            if (IdUbicacionFisica == "" && IdRelacionLaboral == "")
            {
                Filtro = "where x.UbicacionFisica ='" + UbicacionFisica + "'";
            }


            
            
            string querybuscar = @"select x.IdKardex, x.Nombre,x.ApellidoPaterno,x.ApellidoMaterno,x.UbicacionFisica,x.RelacionLaboral,x.RelacionConvenioLaboral,x.IdConvenioLaboral, x.Sexo, z.Archivos from	 (select a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral, a.Sexo    from bdNova.dbo.vwDatosAspirantesTrabajadores  a
								 left join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardex=b.IdKardex
								 left join bdNova.dbo.Kardex_TipoDocumento c on b.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on b.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
									 where  A.EstatusTrabajador = 'ALTA'
								  group by a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral, a.Sexo)	 x
								  left join ( select  a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                 b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,b.RelacionLaboral,b.RelacionConvenioLaboral ,b.Sexo
                                 ,COUNT(*) as Archivos from bdNova.dbo.Kardex_DocumentosExpediente a
                                 left join bdNova.dbo.vwDatosAspirantesTrabajadores b on a.IdKardex=b.IdKardex
                                 left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
								 
								  group by a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                  b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,
								 b.RelacionLaboral,b.RelacionConvenioLaboral,b.Sexo) z on  x.IdKardex= z.IdKardex
                                  " + Filtro + " order by x.IdKardex DESC ";


            
            var kardex_DocumentosExpedienteSeguimiento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(querybuscar, new { IdUbicacionFisica, IdRelacionLaboral });

            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpedienteSeguimiento);
        }

        // GET: KardexGradoAcademico/Create
        public ActionResult Create()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string querytipodocumento;

            //querytipodocumento = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
            //INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
            //inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
            //where Tp.IdConvenioLaboral=@IdConvenioLaboral and Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
            //                        from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";
            querytipodocumento = @"SELECT *  
                                     FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
                                     INNER JOIN bdNova.dbo.Kardex_TipoDocumento a ON a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
                                     INNER JOIN bdNova.dbo.Catalogos_ctConvenioLaboral b ON b.IdConvenioLaboral = Tp.IdConvenioLaboral
                                     WHERE 
                                         Tp.IdConvenioLaboral = @IdConvenioLaboral
                                         AND (
                                             Tp.IdKardexTipoDocumento = 18 
                                             OR Tp.IdKardexTipoDocumento NOT IN (
                                                 SELECT IdKardexTipoDocumento 
                                                 FROM bdNova.dbo.Kardex_DocumentosExpediente 
                                                 WHERE IdKardex = @IdKardex
                                             )
                                         )";
            var todastipodocumento = (List<Kardex_TipoDocumento>)dpcg.connection.Query<Kardex_TipoDocumento>(querytipodocumento, new { IdConvenioLaboral, IdKardex });

            dpcg.Close();

            ViewBag.IdKardex = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == IdKardex).FirstOrDefault().IdKardex;
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumento, "IdKardexTipoDocumento", "DocumentoExpediente");
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar");
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            return PartialView();
        }

        // POST: KardexGradoAcademico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdKardexDocumentosExpediente,IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,Folio,Clave,FechaDocumento,NombreArchivo,FechaRegistro")] Kardex_DocumentosExpediente kardex_DocumentosExpediente, int IdCicloEscolar, HttpPostedFileBase upload)
        {


            Kardex_GradoAcademico kardex_GradoAcademico = new Kardex_GradoAcademico();
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            //kardex_GradoAcademicoFotografia.AbreviaturaProfesion = kardex_GradoAcademicoFotografia.AbreviaturaProfesion.ToUpper();
            //kardex_GradoAcademicoFotografia.NivelEstudioDescripcion = kardex_GradoAcademicoFotografia.NivelEstudioDescripcion.ToUpper();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            string CicloEscolar = Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(z => z.IdCicloEscolar == IdCicloEscolar).FirstOrDefault().CicloEscolar;

            if (kardex_DocumentosExpediente.IdKardexTipoDocumento == 8)
            {
                if (kardex_DocumentosExpediente.Folio.Length != 13)
                {

                    //ModelState.AddModelError("Clave", "La Clave de Elector debe tener 13 caracteres.");
                    string msj = $"El Folio de Elector debe tener 13 caracteres. Capturó {kardex_DocumentosExpediente.Folio.Length} ";
                    return JsonView(false, msj);

                }



            }

            //oficialia_stAnexoDocumentoEntradaTemporal.UsuarioFechaAnexo = usuarioactual;

            if (ModelState.IsValid)
            {

                //var RegistrosRepetidos = db.Kardex_DocumentosExpediente.Where(g => g.IdKardexDocumentosExpediente == kardex_DocumentosExpediente.IdKardexDocumentosExpediente).ToArray();
                //int valor = RegistrosRepetidos.Count();
                //if (valor > 0)
                //{


                //    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                //}



                //else
                //{

                try
                {
                    if (upload != null && upload.ContentLength > 0)

                    {

                        byte[] imagenData = null;
                        string tipoarchivo = "";
                        using (var binaryArchivo = new BinaryReader(upload.InputStream))
                        {
                            imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                            tipoarchivo = upload.ContentType;
                        }
                        //kardex_GradoAcademicoFotografia.Archivo = imagenData;
                        //kardex_GradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                        //kardex_GradoAcademicoFotografia.NombreArchivo = upload.FileName;


                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos
                            //string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,Folio,Clave,FechaDocumento) " +
                            // "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "','" + kardex_DocumentosExpediente.Folio + "','" + kardex_DocumentosExpediente.Clave + "','" + kardex_DocumentosExpediente.FechaDocumento + "')";


                            //var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);

                            //Escribir Datos de los archivos
                            if (kardex_DocumentosExpediente.IdKardexTipoDocumento == 8 )
                            {
                                string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,Folio,Clave) " +
                                 "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "','" + kardex_DocumentosExpediente.Folio + "','" + kardex_DocumentosExpediente.Clave + "')";
                                var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);
                            }
                            else if (kardex_DocumentosExpediente.IdKardexTipoDocumento == 5 || kardex_DocumentosExpediente.IdKardexTipoDocumento == 13)
                            {
                                string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,Folio,FechaDocumento) " +
                                 "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "','" + kardex_DocumentosExpediente.Folio + "','" + kardex_DocumentosExpediente.FechaDocumento.Value.ToString("yyyy/MM/dd") + "')";
                                var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);
                            }
                            else
                            {
                                string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar) " +
                                 "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "')";
                                var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);
                            }


                            string sql = @"SELECT Max(IdKardexDocumentosExpediente)
                                                FROM bdNova.dbo.Kardex_DocumentosExpediente";
                            int idKardexDocumentosExpediente = dp.connection.ExecuteScalar<int>(sql);

                            //Escribir archivo 

                            string sql01 = "Insert Into bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador (IdKardex ,Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexDocumentosExpediente) " +
                                 "Values(@IdKardex,@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexDocumentosExpediente)  ";

                            DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));

                            var parameters = new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = idKardexDocumentosExpediente };
                            var rowsAffectedImg01 = dp.connection.ExecuteScalar(sql01, parameters);



                            dp.Close();
                            trans.Complete();
                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        }

                    }

                    else
                    {

                        Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                        if (kardex_DocumentosExpediente.IdKardexTipoDocumento == 8)
                        {
                            string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,Folio,Clave) " +
                             "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "','" + kardex_DocumentosExpediente.Folio + "','" + kardex_DocumentosExpediente.Clave + "')";
                            var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);
                        }
                        else if (kardex_DocumentosExpediente.IdKardexTipoDocumento == 5 || kardex_DocumentosExpediente.IdKardexTipoDocumento == 13)
                        {
                            string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,Folio,FechaDocumento) " +
                             "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "','" + kardex_DocumentosExpediente.Folio + "','" + kardex_DocumentosExpediente.FechaDocumento.Value.ToString("yyyy/MM/dd") + "')";
                            var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);
                        }
                        else
                        {
                            string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar) " +
                             "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "')";
                            var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);
                        }
                        dp.Close();
                        return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    }


                }


                catch (Exception e)
                {
                    if (e.Message.Contains("clave duplicada"))
                    {
                        return Json(new { Valid = false, Message = "Ya existe un Nombramiento y Oficio de Comisión con  el ciclo escolar: " + CicloEscolar });
                    }
                    else if (e.Message.Contains("El objeto que acepta valores Null debe tener un valor."))
                    {
                        return Json(new { Valid = false, Message = "Todos los datos son requeridos" });

                    }
                    else
                    {
                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                }


                return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                //}



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }





        public FileResult VerInfo(int idgradoacademico)
        {
            var archivosanexo = db.Kardex_stGradoAcademicoFotografia.Where(x => x.IdKardexGradoAcademico == idgradoacademico).FirstOrDefault();

            if (archivosanexo.TipoDocumento == "application/pdf")
            {
                return File(archivosanexo.Archivo, "application/pdf");

            }
            else if (archivosanexo.TipoDocumento == "application/msword")
            {
                return File(archivosanexo.Archivo, "application/msword");
            }

            else if (archivosanexo.TipoDocumento == "image/jpeg")
            {
                return File(archivosanexo.Archivo, "image/jpeg");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.ms-excel")
            {
                return File(archivosanexo.Archivo, "application/vnd.ms-excel");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            }

            return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }


        public FileResult DescargarInfo(int idkardexdocumentosexpedientetrabajador)
        {
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string queryexpedientetrabajador;

            queryexpedientetrabajador = @"select* from bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador a
                                            inner join vwDatosaspirantesTrabajadores b on a.IdKardex = b.IdKardex
                                            where a.IdKardexDocumentosExpedienteTrabajador = @idkardexdocumentosexpedientetrabajador";
            var todosexpedientes = (List<KardexDocumentosExpedientesTrabajadores300>)dpcg.connection.Query<KardexDocumentosExpedientesTrabajadores300>(queryexpedientetrabajador, new { idkardexdocumentosexpedientetrabajador });
            dpcg.Close();

            if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/pdf")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/pdf", "Descarga_" + todosexpedientes.FirstOrDefault().IdTrabajador + "_" + todosexpedientes.FirstOrDefault().Nombre + " " + todosexpedientes.FirstOrDefault().ApellidoPaterno + " " + todosexpedientes.FirstOrDefault().ApellidoMaterno + "_" + todosexpedientes.FirstOrDefault().RFC + ".pdf");

            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/msword")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/msword", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".doc");
            }

            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "image/jpeg")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "image/jpeg", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".jpg");
            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/vnd.ms-excel")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.ms-excel", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".xls");
            }


            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/octet-stream")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/octet-stream", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".zip");
            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".docx");
            }

            return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".xlsx");

            //string modalidad = "Poa_Mir" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


        }

        // GET: KardexGradoAcademico/Edit/5
        public ActionResult Edit(int id)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string query = string.Format(@"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar,a.Folio,a.Clave, a.FechaDocumento, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
                        where a.IdKardex = {0}
                        ", IdKardex);
          
            ViewBag.IdKardex = IdKardex;
            ViewBag.IdKardexDocumentosExpediente = id;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(query);
    
            string querytipodocumento;

            querytipodocumento = @"Select * from (Select * from bdNova.dbo.Kardex_TipoDocumento Tp
                                     where Tp.IdKardexTipoDocumento in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
                                           from bdNova.dbo.Kardex_DocumentosExpediente )) a
                                    inner join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardexTipoDocumento = b.IdKardexTipoDocumento
                                    where b.IdKardex=@IdKardex";

            var todastipodocumento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(querytipodocumento, new { IdKardex });

            int TipoDocumento = todastipodocumento.Where(z=> z.IdKardexDocumentosExpediente== id).FirstOrDefault().IdKardexTipoDocumento;


            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string querytipodocumentos;

            //querytipodocumento = @"Select * from bdNova.dbo.Kardex_TipoDocumento Tp where 
            //                     Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
            //                     from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";


            querytipodocumentos = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
								 INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
								 inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
								 where Tp.IdConvenioLaboral=@IdConvenioLaboral ";


            var todastipodocumentos = (List<Kardex_TipoDocumento>)dp.connection.Query<Kardex_TipoDocumento>(querytipodocumentos, new { IdConvenioLaboral });




            string queryciclo;

            queryciclo = @"select a.IdCicloEscolar, b.CicloEscolar from bdCtlEscSeg.dbo.ctCicloescolar a
                            inner join bdNova.dbo.Kardex_DocumentosExpediente b on a.Nombre=b.CicloEscolar
                            where b.IdKardexDocumentosExpediente=@id";

            var todasciclo = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryciclo, new { id });

            int idciclo = todasciclo.FirstOrDefault().IdCicloEscolar;



            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            var valorkardex_DocumentosExpediente = kardex_DocumentosExpediente.Where(z=> z.IdKardex==id).FirstOrDefault();
            if (kardex_DocumentosExpediente == null)
            {
                return HttpNotFound();
            }
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_GradoAcademico.IdKardex);
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumentos.ToList(), "IdKardexTipoDocumento", "DocumentoExpediente", todastipodocumentos.Where(x=> x.IdKardexTipoDocumento == TipoDocumento).FirstOrDefault().IdKardexTipoDocumento);
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar", Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(a=> a.IdCicloEscolar == idciclo).FirstOrDefault().IdCicloEscolar);
            ViewBag.IdKardexTipoDocumentos = TipoDocumento;
            dp.Close();
            return PartialView(kardex_DocumentosExpediente.Where(a => a.IdKardexDocumentosExpediente == id).FirstOrDefault());

            //return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdKardexDocumentosExpediente,IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,Folio,Clave,FechaDocumento,NombreArchivo,FechaRegistro")] Kardex_DocumentosExpediente kardex_DocumentosExpediente, int IdCicloEscolar, HttpPostedFileBase upload)
        {
                string msj = "El Grado académico ha sido editado existosamente!";
          
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            //kardex_GradoAcademico.AbreviaturaProfesion=kardex_GradoAcademico.AbreviaturaProfesion.ToUpper();
            //kardex_GradoAcademico.NivelEstudioDescripcion=kardex_GradoAcademico.NivelEstudioDescripcion.ToUpper();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            string CicloEscolar = Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(z => z.IdCicloEscolar == IdCicloEscolar).FirstOrDefault().CicloEscolar;
            DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));

            if (ModelState.IsValid)
            {
             
                try
                {

                    if (upload != null && upload.ContentLength > 0)
                    {
                        byte[] imagenData = null;
                        string tipoarchivo = "";
                        using (var binaryArchivo = new BinaryReader(upload.InputStream))
                        {
                            imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                            tipoarchivo = upload.ContentType;

                        }
                        //kardex_stGradoAcademicoFotografia.Archivo = imagenData;
                        //kardex_stGradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                        //kardex_stGradoAcademicoFotografia.NombreArchivo = upload.FileName;


                           using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos

                            string sqlupdateQuery = $@"UPDATE bdNova.dbo.Kardex_DocumentosExpediente SET IdKardex = {kardex_DocumentosExpediente.IdKardex}, IdKardexTipoDocumento = {kardex_DocumentosExpediente.IdKardexTipoDocumento}, IdConvenioLaboralTrabajadorCategoriaRegistro = {IdConveniolaboraltrabajadorcategoria}, FechaActualizacion = '{DateTime.Now:yyyy/MM/dd}', FechaEntrega = '{DateTime.Now:yyyy/MM/dd}'" +
                                                  (kardex_DocumentosExpediente.Folio != null ? $", Folio = '{kardex_DocumentosExpediente.Folio}'" : "") +
                                                  (kardex_DocumentosExpediente.Clave != null ? $", Clave = '{kardex_DocumentosExpediente.Clave}'" : "") +
                                                  (kardex_DocumentosExpediente.FechaDocumento != null ? $", FechaDocumento = '{kardex_DocumentosExpediente.FechaDocumento:yyyy/MM/dd}'" : "") +
                                                  (!string.IsNullOrEmpty(CicloEscolar) ? $", CicloEscolar = '{CicloEscolar}'" : "") +
                                                  $" WHERE IdKardexDocumentosExpediente = {kardex_DocumentosExpediente.IdKardexDocumentosExpediente};";

                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);

                            //string sqlupdateQuery = @"UPDATE bdNova.dbo.Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = "+ IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar+ "','" + kardex_DocumentosExpediente.Folio + "','" + kardex_DocumentosExpediente.Clave + "','" + kardex_DocumentosExpediente.FechaDocumento + " WHERE IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";

                            //var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);



                            string sql = @"SELECT IdKardexDocumentosExpediente
                                           FROM bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador
										   where IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";
                            int idKardexDocumentosExpediente = dp.connection.ExecuteScalar<int>(sql);

                            ////Escribir archivo 
                            
                            if (idKardexDocumentosExpediente != 0)
                            {
                                var rowsAffectedDocFile = dp.connection.Execute("UPDATE bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador SET IdKardex=@IdKardex, Archivo= @Archivo, TipoDocumento = @TipoDocumento, NombreArchivo=@NombreArchivo, FechaRegistro=@FechaRegistro, IdKardexDocumentosExpediente=@IdKardexDocumentosExpediente WHERE IdKardexDocumentosExpediente = @IdKardexDocumentosExpediente01", new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente, IdKardexDocumentosExpediente01 = kardex_DocumentosExpediente.IdKardexDocumentosExpediente });
                            }
                            else
                            {
                                string sqlinsert = "Insert Into bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador (IdKardex ,Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexDocumentosExpediente) " +
                                   "Values(@IdKardex,@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexDocumentosExpediente)  ";                                

                                var parameters = new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente };
                                var rowsAffectedImg01 = dp.connection.ExecuteScalar(sqlinsert, parameters);

                            }
                            
                            


                            dp.Close();
                                trans.Complete();
                                return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                            }

                        }

                    else 
                    {
                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos

                            string sqlupdateQuery = @"UPDATE bdNova.dbo.Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = " + IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar + "','" + kardex_DocumentosExpediente.Folio + "','" + kardex_DocumentosExpediente.Clave + "','" + kardex_DocumentosExpediente.FechaDocumento + "' WHERE IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";

                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);


                            dp.Close();
                            trans.Complete();
                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });
                        }

                            


                    }
                       
                   
                       
                        
                    }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: KardexGradoAcademico/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            if (kardex_GradoAcademico == null)
            {
                return HttpNotFound();
            }
            return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            //db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {

                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                        var sqlDeleteExp= "DELETE bdNova.dbo.Kardex_DocumentosExpediente WHERE IdKardexDocumentosExpediente ="+ id +"";

                        var rowsAffectedExp = dp.connection.Execute(sqlDeleteExp);

                        var sqlDeleteArchivo = "DELETE bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador WHERE IdKardexDocumentosExpediente = "+ id +"";


                        var rowsAffectedArch = dp.connection.Execute(sqlDeleteArchivo);

                        dp.Close();
                        trans.Complete();
                    }
                    //db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
