﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class IsrGrupoController : Controller
    {
        //
        // GET: /IsrGrupo/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvIsrGrupo()
        {
            var model = db.Configuracion_stIsrGrupo;
            return PartialView("_pvIsrGrupo", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvIsrGrupoAddNew(Nova.Models.Configuracion_stIsrGrupo item)
        {
            var model = db.Configuracion_stIsrGrupo;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvIsrGrupo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvIsrGrupoUpdate(Nova.Models.Configuracion_stIsrGrupo item)
        {
            var model = db.Configuracion_stIsrGrupo;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdIsrGrupo == item.IdIsrGrupo);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvIsrGrupo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvIsrGrupoDelete(System.Int16 IdIsrGrupo)
        {
            var model = db.Configuracion_stIsrGrupo;
            if (IdIsrGrupo != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdIsrGrupo == IdIsrGrupo);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvIsrGrupo", model.ToList());
        }
    }
}
