﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;
using Nova.Libraries;
using Dapper;
using System.Text;
using System.Transactions;
using Seguridad;



namespace Nova.Controllers.Inicidencia
{
    public class IncidenciaPermisoTrabajadorController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: IncidenciaPermisoTrabajador
        public ActionResult Index()
        {
            Session["Busqueda"] = "INCIDENCIAS";
            var incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Include(i => i.Catalogos_ctTipoIncidencia).Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria).Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria1).Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria2).Include(i => i.Nomina_stNominaTrabajador);
            return View();
        }
        public ActionResult Incidencia(int IdConvenioLaboralTrabajadorCategoria)
        {
            var idcltc = db.vwDatosAspirantesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
            Session["IdConvenioLaboralTrabajadorCategoria"] = IdConvenioLaboralTrabajadorCategoria;
            var IncidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria ).ToList();
            //&& s.FechaTermino.Year == DateTime.Now.Year
            //var incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Include(i => i.Catalogos_ctTipoIncidencia).Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria).Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria1).Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria2).Include(i => i.Nomina_stNominaTrabajador);
            return View(IncidenciaPermiso_stIncidenciaTrabajador.ToList());
        }

        // GET: IncidenciaPermisoTrabajador/Details/5
        public ActionResult Details(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // GET: IncidenciaPermisoTrabajador/Create
        public ActionResult Crear(int? id = 0, int? IdInTraPadre = 0)
        {

            if (id == 0)
            {
                int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
                var IncidenciasTrabajador = from a in db.Catalogos_ctTipoIncidencia
                                            from b in db.IncidenciaPermiso_stIncidenciaTrabajador
                                            where a.IdTipoIncidencia == b.IdTipoIncidencia && b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.Incidencia == "RIESGO DE TRABAJO"
                                            select new
                                            {
                                                b.IdIncidenciaTrabajador,
                                                Incidencia = a.Incidencia + " || " + "Fecha Inicio: " + b.FechaInicio + " || " + "Fecha Termino: " + b.FechaTermino
                                            };
                ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia");
                ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
                ViewBag.IdIncidenciaTrabajadorPadre = new SelectList(IncidenciasTrabajador, "IdIncidenciaTrabajador", "Incidencia");
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
                return View("Create");
            }
           
            else if (id == 5)
            {
                var Resultado = from a in db.Catalogos_ctTipoIncidencia
                                where a.Incidencia == "RIESGO DE TRABAJO"
                                select new { a.IdTipoIncidencia };
                int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
                ViewBag.id = id;
                ViewBag.idintrapadre = IdInTraPadre;
                Session["IdTipoIncidencia"] = ViewBag.id;
                Session["IdInTraPadre"] = ViewBag.idintrapadre;

                if (ViewBag.idintrapadre == 0)
                {
                    var IncidenciasTrabajador = from a in db.Catalogos_ctTipoIncidencia
                                                from b in db.IncidenciaPermiso_stIncidenciaTrabajador
                                                where a.IdTipoIncidencia == b.IdTipoIncidencia && b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.Incidencia == "RIESGO DE TRABAJO"
                                                select new
                                                {
                                                    b.IdIncidenciaTrabajador,
                                                    Incidencia = a.Incidencia + " || " + "Fecha Inicio: " + b.FechaInicio + " || " + "Fecha Termino: " + b.FechaTermino
                                                };

                    ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia.Where(a => a.IdTipoIncidencia == id), "IdTipoIncidencia", "Incidencia");
                    ViewBag.IdIncidenciaTrabajadorPadre = new SelectList(IncidenciasTrabajador, "IdIncidenciaTrabajador", "Incidencia");
                    ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
                    return View("Create");


                }
                else
                {
                    var IncidenciasTrabajador = from a in db.Catalogos_ctTipoIncidencia
                                                from b in db.IncidenciaPermiso_stIncidenciaTrabajador
                                                where a.IdTipoIncidencia == b.IdTipoIncidencia && b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.Incidencia == "RIESGO DE TRABAJO"
                                                select new
                                                {
                                                    b.IdIncidenciaTrabajador,
                                                    Incidencia = a.Incidencia + " || " + "Fecha Inicio: " + b.FechaInicio + " || " + "Fecha Termino: " + b.FechaTermino
                                                };

                    ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia.Where(a => a.IdTipoIncidencia == id), "IdTipoIncidencia", "Incidencia");
                    ViewBag.IdIncidenciaTrabajadorPadre = new SelectList(IncidenciasTrabajador.Where(c => c.IdIncidenciaTrabajador == IdInTraPadre), "IdIncidenciaTrabajador", "Incidencia");
                    ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
                    return View("Create");
                }
            }

            else if (id == 4)
            {
                var Resultado = from a in db.Catalogos_ctTipoIncidencia
                                where a.Incidencia == "ENFERMEDAD GENERAL"
                                select new { a.IdTipoIncidencia };
                int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
                ViewBag.id = id;
                ViewBag.idintrapadre = IdInTraPadre;
                Session["IdTipoIncidencia"] = ViewBag.id;
                Session["IdInTraPadre"] = ViewBag.idintrapadre;

                if (ViewBag.idintrapadre == 0)
                {
                    var IncidenciasTrabajador = from a in db.Catalogos_ctTipoIncidencia
                                                from b in db.IncidenciaPermiso_stIncidenciaTrabajador
                                                where a.IdTipoIncidencia == b.IdTipoIncidencia && b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.Incidencia == "ENFERMEDAD GENERAL"
                                                select new
                                                {
                                                    b.IdIncidenciaTrabajador,
                                                    Incidencia = a.Incidencia + " || " + "Fecha Inicio: " + b.FechaInicio + " || " + "Fecha Termino: " + b.FechaTermino
                                                };

                    ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia.Where(a => a.IdTipoIncidencia == id), "IdTipoIncidencia", "Incidencia");
                    ViewBag.IdIncidenciaTrabajadorPadre = new SelectList(IncidenciasTrabajador, "IdIncidenciaTrabajador", "Incidencia");
                    ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
                    return View("Create");


                }
                else
                {
                    var IncidenciasTrabajador = from a in db.Catalogos_ctTipoIncidencia
                                                from b in db.IncidenciaPermiso_stIncidenciaTrabajador
                                                where a.IdTipoIncidencia == b.IdTipoIncidencia && b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.Incidencia == "ENFERMEDAD GENERAL"
                                                select new
                                                {
                                                    b.IdIncidenciaTrabajador,
                                                    Incidencia = a.Incidencia + " || " + "Fecha Inicio: " + b.FechaInicio + " || " + "Fecha Termino: " + b.FechaTermino
                                                };

                    ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia.Where(a => a.IdTipoIncidencia == id), "IdTipoIncidencia", "Incidencia");
                    ViewBag.IdIncidenciaTrabajadorPadre = new SelectList(IncidenciasTrabajador.Where(c => c.IdIncidenciaTrabajador == IdInTraPadre), "IdIncidenciaTrabajador", "Incidencia");
                    ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
                    return View("Create");
                }

            }

            else if (id == 6)
            {
                var Resultado = from a in db.Catalogos_ctTipoIncidencia
                                where a.Incidencia == "MATERNIDAD"
                                select new { a.IdTipoIncidencia };
                int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
                ViewBag.id = id;
                ViewBag.idintrapadre = IdInTraPadre;
                Session["IdTipoIncidencia"] = ViewBag.id;
                Session["IdInTraPadre"] = ViewBag.idintrapadre;

                if (ViewBag.idintrapadre == 0)
                {
                    var IncidenciasTrabajador = from a in db.Catalogos_ctTipoIncidencia
                                                from b in db.IncidenciaPermiso_stIncidenciaTrabajador
                                                where a.IdTipoIncidencia == b.IdTipoIncidencia && b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.Incidencia == "MATERNIDAD"
                                                select new
                                                {
                                                    b.IdIncidenciaTrabajador,
                                                    Incidencia = a.Incidencia + " || " + "Fecha Inicio: " + b.FechaInicio + " || " + "Fecha Termino: " + b.FechaTermino
                                                };

                    ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia.Where(a => a.IdTipoIncidencia == id), "IdTipoIncidencia", "Incidencia");
                    ViewBag.IdIncidenciaTrabajadorPadre = new SelectList(IncidenciasTrabajador, "IdIncidenciaTrabajador", "Incidencia");
                    ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
                    return View("Create");


                }
                else
                {
                    var IncidenciasTrabajador = from a in db.Catalogos_ctTipoIncidencia
                                                from b in db.IncidenciaPermiso_stIncidenciaTrabajador
                                                where a.IdTipoIncidencia == b.IdTipoIncidencia && b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.Incidencia == "MATERNIDAD"
                                                select new
                                                {
                                                    b.IdIncidenciaTrabajador,
                                                    Incidencia = a.Incidencia + " || " + "Fecha Inicio: " + b.FechaInicio + " || " + "Fecha Termino: " + b.FechaTermino
                                                };

                    ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia.Where(a => a.IdTipoIncidencia == id), "IdTipoIncidencia", "Incidencia");
                    ViewBag.IdIncidenciaTrabajadorPadre = new SelectList(IncidenciasTrabajador.Where(c => c.IdIncidenciaTrabajador == IdInTraPadre), "IdIncidenciaTrabajador", "Incidencia");
                    ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                    ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
                    return View("Create");
                }

            }
                
           
            else
            {
                var Resultado = from a in db.Catalogos_ctTipoIncidencia
                                select new { a.IdTipoIncidencia };
                int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
                ViewBag.id = id;
                ViewBag.idintrapadre = IdInTraPadre;
                Session["IdTipoIncidencia"] = ViewBag.id;
                Session["IdInTraPadre"] = ViewBag.idintrapadre;
                var IncidenciasTrabajador = from a in db.Catalogos_ctTipoIncidencia
                                            from b in db.IncidenciaPermiso_stIncidenciaTrabajador
                                            where a.IdTipoIncidencia == b.IdTipoIncidencia && b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria
                                            select new
                                            {
                                                b.IdIncidenciaTrabajador,
                                                Incidencia = a.Incidencia + " || " + "Fecha Inicio: " + b.FechaInicio + " || " + "Fecha Termino: " + b.FechaTermino
                                            };
                ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia.Where(a => a.IdTipoIncidencia == id), "IdTipoIncidencia", "Incidencia");
                ViewBag.IdIncidenciaTrabajadorPadre = new SelectList(IncidenciasTrabajador, "IdIncidenciaTrabajador", "Incidencia");
                ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
                ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
                return View("Create");


            }

        }

        public ActionResult Crear2()
        {

            int id = 0;
            id = System.Convert.ToInt32(Request["IdTipoIncidencia"]);
            int IdInTraPadre = 0;
            IdInTraPadre = System.Convert.ToInt32(Request["IdIncidenciaTrabajadorPadre"]);
            if (IdInTraPadre > 0)
            {

                DateTime FechaTerminoSubsecuente = (DateTime)(db.IncidenciaPermiso_stIncidenciaTrabajador.AsEnumerable().Where(r => r.IdIncidenciaTrabajador == IdInTraPadre).Select(r => r.FechaTermino).First());
                var FechaInicioSubsecuente2 = from a in db.IncidenciaPermiso_stIncidenciaTrabajador
                                              where a.IdIncidenciaTrabajador == IdInTraPadre
                                              select new
                                              {
                                                  a.FechaInicio
                                              };
                ViewBag.FechaTerminoSubsecuente = FechaTerminoSubsecuente;
                Session["FechaTerminoSubsecuente"] = ViewBag.FechaTerminoSubsecuente;

                return RedirectToAction("Crear", new { id, IdInTraPadre });
            }
            return RedirectToAction("Crear", new { id, IdInTraPadre });

        }




        // POST: IncidenciaPermisoTrabajador/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdIncidenciaTrabajador,IdConvenioLaboralTrabajadorCategoria,IdTipoIncidencia,FechaInicio,FechaTermino,Observaciones,UserId,FechaCreacion,IdNominaTrabajador,EsAplicada,EsSubsecuente,DiasPagados100,DiasPagados40,DiasAcumulados,IdIncidenciaTrabajadorPadre,IdConvenioLaboralTrabajadorCategoriaRegistro,Autorizo,IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaTrabajadorPadre,Horas")] IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador)
        {


            int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
            int IdTipoIncidencia = (int)Session["IdTipoIncidencia"];
            int IdTipoIncidenciaPadre = (int)Session["IdInTraPadre"];
            //DateTime FechaInicioNuevaIncidencia = Convert.ToDateTime(FechaInicio);
            DateTime FechaTerminoSubsecuente = Convert.ToDateTime(Session["FechaTerminoSubsecuente"]);
            if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > incidenciaPermiso_stIncidenciaTrabajador.FechaTermino)
            {
                MessageBox.Show(ViewData, TipoMensaje.Error, "La Fecha de inicio de la incidencia no debe ser menor a la fecha término");
            }


            if (ModelState.IsValid)
            {
                if (IdTipoIncidenciaPadre > 0)
                {
                    if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < FechaTerminoSubsecuente)
                    {
                        MessageBox.Show(ViewData, TipoMensaje.Error, "La Fecha de inicio de la incidencia debe ser mayor a la fecha de la incidencia selecccionada");
                        //throw new Exception("La Fecha de inicio de la incidencia debe ser mayor a la fecha de la incidencia selecccionada");
                    }
                    else
                    {
                        Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                        string query;
                        short valor = 0;
                        query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                        var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                        dp.Close();
                        Boolean Traslape = false;
                        Traslape = incidencias.Any(e =>
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                        if (Traslape)
                        {

                            MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                        }
                      
                        
                        else {
                        var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                        incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                        incidenciaPermiso_stIncidenciaTrabajador.EsSubsecuente = true;
                        incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                        incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                        incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                        incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                        incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                        incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                        incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                        incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                        incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                        incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = IdTipoIncidenciaPadre;
                        incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                        db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                        db.SaveChanges();
                        return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                            }
                    }
                }
                else
                
                {

                    if (IdTipoIncidencia == 1 || IdTipoIncidencia == 10 || IdTipoIncidencia == 11)
                    {
                        int permisos = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => (z.IdTipoIncidencia == 10 || z.IdTipoIncidencia == 11 || z.IdTipoIncidencia == 12 || z.IdTipoIncidencia == 1) && z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && z.IdIncidenciaJustificacion == 0).Count();
                        if (permisos > 0) 
                         {
                             // Antiguedad 
                            var permisostrabajador =   from a in db.IncidenciaPermiso_stIncidenciaTrabajador
                                                       where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && (a.IdTipoIncidencia == 10 || a.IdTipoIncidencia == 11 || a.IdTipoIncidencia == 12 || a.IdTipoIncidencia == 1)
                                                        orderby a.FechaTermino descending
                                                        select new
                                                        {
                                                            a.FechaTermino
                                                        };
                             DateTime FechaTerminoUltimoPermisoTrabajador = permisostrabajador.FirstOrDefault().FechaTermino.Value;
                             DateTime FechaInicioAntiguedadTrabajador = FechaTerminoUltimoPermisoTrabajador;
                             DateTime FechaTerminoAntiguedadTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                             if (FechaInicioAntiguedadTrabajador > FechaTerminoAntiguedadTrabajador)
                                 throw new ArgumentException("Incorrecta fecha término " + FechaTerminoAntiguedadTrabajador);

                             TimeSpan AntiguedadNueva = FechaTerminoAntiguedadTrabajador - FechaInicioAntiguedadTrabajador;
                             Session["AntiguedadNueva"] = AntiguedadNueva.Days;
                            // Dias Permiso
                             DateTime FechaInicioPermiso2 = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                             DateTime FechaTerminoPermiso2 = incidenciaPermiso_stIncidenciaTrabajador.FechaTermino.Value;
                             if (FechaInicioPermiso2 > FechaTerminoPermiso2)
                                 throw new ArgumentException("Incorrecto la fecha de término " + FechaTerminoPermiso2);

                             TimeSpan diaspermiso = FechaTerminoPermiso2 - FechaInicioPermiso2;
                             Session["DiasPermisoNvo"] = diaspermiso.Days;
                             if (Convert.ToInt32(Session["AntiguedadNueva"]) < 1095)
                             {
                                 MessageBox.Show(ViewData, TipoMensaje.Error, "No puedes solicitar permiso ya que no cumples con la antiguedad minima initerrumpída");
                             }
                             if (Convert.ToInt32(Session["AntiguedadNueva"]) >= 1095 && Convert.ToInt32(Session["AntiguedadNueva"]) <= 1825)
                             {
                                 if (Convert.ToInt32(Session["DiasPermisoNvo"]) > 549)
                                 {
                                     MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 3 semestres");
                                 }
                                 else 
                                 {
                                     Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                     string query;
                                     short valor = 0;
                                     query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                     var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                     dp.Close();
                                     Boolean Traslape = false;
                                     Traslape = incidencias.Any(e =>
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                     if (Traslape)
                                     {

                                         MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                     }

                                     else
                                     {

                                         using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                                {
                                                    TransactionOptions Grabar = new TransactionOptions();
                                                    Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                                                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                                                {
                                                      try
                                                        {

                                                             var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                                             incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                             incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                                             incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                                             incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                                             incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                                             incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                                             incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                                             incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                                             incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                                             incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                                             incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                                             incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                                             incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                                             db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                                             db.SaveChanges();
                                                             //CLTC, CLT,Plaza
                                                             var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                                             conveniolaboralcategoria.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                             conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                             conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = true;
                                                             db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                                             db.SaveChanges();
                                                             Kardex_stEstatusTrabajador estatustrabajador = new Kardex_stEstatusTrabajador();
                                                             //Escribir alta del trabajador
                                                             estatustrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                             estatustrabajador.IdEstatusTrabajador = 12;
                                                             estatustrabajador.FechaEstatusTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                             db.Kardex_stEstatusTrabajador.Add(estatustrabajador);
                                                             db.SaveChanges();
                                                             
                                                        }
                                                      catch (Exception e)
                                                      {
                                                          ViewData["EditError"] = e.Message;
                                                          // all changes will be rolled back
                                                      }
                                                      scope.Complete();
                                                }
                                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                                }
                                     }
                                 }
                             }
                             if (Convert.ToInt32(Session["AntiguedadNueva"]) > 1825 && Convert.ToInt32(Session["AntiguedadNueva"]) <= 2920)
                             {
                                 if (Convert.ToInt32(Session["DiasPermisoNvo"]) > 732)
                                 {
                                     MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 4 semestres");
                                 }
                                 else
                                 {
                                     Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                     string query;
                                     short valor = 0;
                                     query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                     var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                     dp.Close();
                                     Boolean Traslape = false;
                                     Traslape = incidencias.Any(e =>
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                     if (Traslape)
                                     {

                                         MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                     }

                                     else
                                     {
                                         using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                                {
                                                    TransactionOptions Grabar = new TransactionOptions();
                                                    Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                                                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                                                {
                                                      try
                                                        {
                                                         var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                                         incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                                         incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                                         incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                                         db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                                         db.SaveChanges();
                                                         //CLTC, CLT,Plaza
                                                         var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                                         conveniolaboralcategoria.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = true;
                                                         db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                                         db.SaveChanges();
                                                         Kardex_stEstatusTrabajador estatustrabajador = new Kardex_stEstatusTrabajador();
                                                         //Escribir alta del trabajador
                                                         estatustrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         estatustrabajador.IdEstatusTrabajador = 12;
                                                         estatustrabajador.FechaEstatusTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         db.Kardex_stEstatusTrabajador.Add(estatustrabajador);
                                                         db.SaveChanges();
                                                         
                                                        }
                                                      catch (Exception e)
                                                      {
                                                          ViewData["EditError"] = e.Message;
                                                          // all changes will be rolled back
                                                      }
                                                      scope.Complete();
                                                }
                                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                                }
                                     }

                                 }
                             }
                             if (Convert.ToInt32(Session["AntiguedadNueva"]) > 2920 && Convert.ToInt32(Session["AntiguedadNueva"]) <= 3650)
                             {
                                 if (Convert.ToInt32(Session["DiasPermisoNvo"]) > 1098)
                                 {
                                     MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 6 semestres");
                                 }
                                 else
                                 {
                                     Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                     string query;
                                     short valor = 0;
                                     query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                     var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                     dp.Close();
                                     Boolean Traslape = false;
                                     Traslape = incidencias.Any(e =>
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                     if (Traslape)
                                     {

                                         MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                     }

                                     else
                                     {
                                          using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                                {
                                                    TransactionOptions Grabar = new TransactionOptions();
                                                    Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                                                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                                                {
                                                      try
                                                        {
                                                         var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                                         incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                                         incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                                         incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                                         db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                                         db.SaveChanges();
                                                         //CLTC, CLT,Plaza
                                                         var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                                         conveniolaboralcategoria.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = true;
                                                         db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                                         db.SaveChanges();
                                                         Kardex_stEstatusTrabajador estatustrabajador = new Kardex_stEstatusTrabajador();
                                                         //Escribir alta del trabajador
                                                         estatustrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         estatustrabajador.IdEstatusTrabajador = 12;
                                                         estatustrabajador.FechaEstatusTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         db.Kardex_stEstatusTrabajador.Add(estatustrabajador);
                                                         db.SaveChanges();
                                                         
                                                        }
                                                      catch (Exception e)
                                                      {
                                                          ViewData["EditError"] = e.Message;
                                                          // all changes will be rolled back
                                                      }
                                                      scope.Complete();
                                                }
                                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                                }
                                     }

                                 }
                             }
                             if (Convert.ToInt32(Session["AntiguedadNueva"]) > 3650)
                             {
                                 if (Convert.ToInt32(Session["DiasPermisoNvo"]) > 2196)
                                 {
                                     MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 12 semestres");
                                 }
                                 else
                                 {
                                     Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                     string query;
                                     short valor = 0;
                                     query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                     var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                     dp.Close();
                                     Boolean Traslape = false;
                                     Traslape = incidencias.Any(e =>
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                     if (Traslape)
                                     {

                                         MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                     }

                                     else
                                     {
                                          using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                                {
                                                    TransactionOptions Grabar = new TransactionOptions();
                                                    Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                                                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                                                {
                                                      try
                                                        {
                                                         var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                                         incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                                         incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                                         incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                                         db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                                         db.SaveChanges();
                                                         //CLTC, CLT,Plaza
                                                         var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                                         conveniolaboralcategoria.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = true;
                                                         db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                                         db.SaveChanges();
                                                         Kardex_stEstatusTrabajador estatustrabajador = new Kardex_stEstatusTrabajador();
                                                         //Escribir alta del trabajador
                                                         estatustrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         estatustrabajador.IdEstatusTrabajador = 12;
                                                         estatustrabajador.FechaEstatusTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         db.Kardex_stEstatusTrabajador.Add(estatustrabajador);
                                                         db.SaveChanges();
                                                         
                                                        }
                                                      catch (Exception e)
                                                      {
                                                          ViewData["EditError"] = e.Message;
                                                          // all changes will be rolled back
                                                      }
                                                      scope.Complete();
                                                }
                                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                                }
                                     }
                                 }
                             }
                     
                         }
                     else 
                         {
                             
                            
                            var IdeTrabajador = from a in db.vwDatosAspirantesTrabajadores
                                                  where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria
                                                  select new
                                                  {
                                                      a.IdTrabajador
                                                  };

                            int idtrabajador = Convert.ToInt32(IdeTrabajador.FirstOrDefault().IdTrabajador);
                            SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

                            AntiguedadLaboralQuinquenioTrabajador quinquenio = antiguedad.getAntiguedad(idtrabajador); 
                          

                             DateTime FechaInicioPermiso = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                             DateTime FechaTerminoPermiso = incidenciaPermiso_stIncidenciaTrabajador.FechaTermino.Value;
                             if (FechaInicioPermiso > FechaTerminoPermiso)
                                 throw new ArgumentException("Incorrecto la fecha de término " + FechaTerminoPermiso);

                             TimeSpan span = FechaTerminoPermiso - FechaInicioPermiso;
                             Session["DiasPrimerPermiso"] = span.Days;
                             if (quinquenio.AñosLaboral < 3)
                             {
                                 MessageBox.Show(ViewData, TipoMensaje.Error, "No puedes solicitar permiso ya que no cumples con la antiguedad minima initerrumpída");
                             }
                             if (quinquenio.AñosLaboral >= 3 && quinquenio.AñosLaboral < 5)
                             {
                                 if (Convert.ToInt32(Session["DiasPrimerPermiso"]) > 549)
                                 {
                                     MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 3 semestres");
                                 }
                                 else 
                                 {
                                     Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                     string query;
                                     short valor = 0;
                                     query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                     var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                     dp.Close();
                                     Boolean Traslape = false;
                                     Traslape = incidencias.Any(e =>
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                     if (Traslape)
                                     {

                                         MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                     }

                                     else
                                     {
                                          using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                                {
                                                    TransactionOptions Grabar = new TransactionOptions();
                                                    Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                                                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                                                {
                                                      try
                                                        {

                                                         var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                                         incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                                         incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                                         incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                                         db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                                         db.SaveChanges();
                                                         //CLTC, CLT,Plaza
                                                         var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                                         conveniolaboralcategoria.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = true;
                                                         db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                                         db.SaveChanges();
                                                         Kardex_stEstatusTrabajador estatustrabajador = new Kardex_stEstatusTrabajador();
                                                         //Escribir alta del trabajador
                                                         estatustrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         estatustrabajador.IdEstatusTrabajador = 12;
                                                         estatustrabajador.FechaEstatusTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         db.Kardex_stEstatusTrabajador.Add(estatustrabajador);
                                                         db.SaveChanges();
                                                        
                                                        }
                                                      catch (Exception e)
                                                      {
                                                          ViewData["EditError"] = e.Message;
                                                          // all changes will be rolled back
                                                      }
                                                      scope.Complete();
                                                }
                                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                                }
                                     }
                                 }
                             }
                             if (quinquenio.AñosLaboral >= 5 && quinquenio.AñosLaboral < 8)
                             {
                                 if (Convert.ToInt32(Session["DiasPrimerPermiso"]) > 732)
                                 {
                                     MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 4 semestres");
                                 }
                                 else 
                                 {
                                     Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                     string query;
                                     short valor = 0;
                                     query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                     var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                     dp.Close();
                                     Boolean Traslape = false;
                                     Traslape = incidencias.Any(e =>
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                     if (Traslape)
                                     {

                                         MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                     }

                                     else
                                     {
                                         using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                                {
                                                    TransactionOptions Grabar = new TransactionOptions();
                                                    Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                                                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                                                {
                                                      try
                                                        {

                                                         var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                                         incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                                         incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                                         incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                                         db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                                         db.SaveChanges();
                                                         //CLTC, CLT,Plaza
                                                         var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                                         conveniolaboralcategoria.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = true;
                                                         db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                                         db.SaveChanges();
                                                         Kardex_stEstatusTrabajador estatustrabajador = new Kardex_stEstatusTrabajador();
                                                         //Escribir alta del trabajador
                                                         estatustrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         estatustrabajador.IdEstatusTrabajador = 12;
                                                         estatustrabajador.FechaEstatusTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         db.Kardex_stEstatusTrabajador.Add(estatustrabajador);
                                                         db.SaveChanges();
                                                         
                                                        }
                                                      catch (Exception e)
                                                      {
                                                          ViewData["EditError"] = e.Message;
                                                          // all changes will be rolled back
                                                      }
                                                      scope.Complete();
                                                }
                                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                                }
                                     }
                                 }
                             }
                             if (quinquenio.AñosLaboral >= 8 && quinquenio.AñosLaboral < 10)
                             {
                                 if (Convert.ToInt32(Session["DiasPrimerPermiso"]) > 1098)
                                 {
                                     MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 6 semestres");
                                 }
                                 else
                                 {
                                     Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                     string query;
                                     short valor = 0;
                                     query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                     var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                     dp.Close();
                                     Boolean Traslape = false;
                                     Traslape = incidencias.Any(e =>
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                     if (Traslape)
                                     {

                                         MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                     }

                                     else
                                     {
                                         using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                                {
                                                    TransactionOptions Grabar = new TransactionOptions();
                                                    Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                                                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                                                {
                                                      try
                                                        {

                                                         var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                                         incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                                         incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                                         incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                                         db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                                         db.SaveChanges();
                                                         //CLTC, CLT,Plaza
                                                         var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                                         conveniolaboralcategoria.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = true;
                                                         db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                                         db.SaveChanges();
                                                         Kardex_stEstatusTrabajador estatustrabajador = new Kardex_stEstatusTrabajador();
                                                         //Escribir alta del trabajador
                                                         estatustrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         estatustrabajador.IdEstatusTrabajador = 12;
                                                         estatustrabajador.FechaEstatusTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         db.Kardex_stEstatusTrabajador.Add(estatustrabajador);
                                                         db.SaveChanges();
                                                         
                                                        }
                                                      catch (Exception e)
                                                      {
                                                          ViewData["EditError"] = e.Message;
                                                          // all changes will be rolled back
                                                      }
                                                      scope.Complete();
                                                }
                                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                                }
                                     }
                                 }
                             }
                             if (quinquenio.AñosLaboral >= 10)
                             {
                                 if (Convert.ToInt32(Session["DiasPrimerPermiso"]) > 2196)
                                 {
                                     MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 6 semestres");
                                 }

                                 else
                                 {
                                     Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                     string query;
                                     short valor = 0;
                                     query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                     var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                     dp.Close();
                                     Boolean Traslape = false;
                                     Traslape = incidencias.Any(e =>
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                                (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                     if (Traslape)
                                     {

                                         MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                     }

                                     else
                                     {
                                         using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                                {
                                                    TransactionOptions Grabar = new TransactionOptions();
                                                    Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                                                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                                                {
                                                      try
                                                        {

                                                         var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                                         incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                                         incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                                         incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                                         incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                                         incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                                         db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                                         db.SaveChanges();
                                                         //CLTC, CLT,Plaza
                                                         var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                                         conveniolaboralcategoria.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.AddDays(-1);
                                                         conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.AddDays(-1);
                                                         conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = true;
                                                         db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                                         db.SaveChanges();
                                                          
                                                         Kardex_stEstatusTrabajador estatustrabajador = new Kardex_stEstatusTrabajador();
                                                         //Escribir alta del trabajador
                                                         estatustrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                                         estatustrabajador.IdEstatusTrabajador = 12;
                                                         estatustrabajador.FechaEstatusTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                                         db.Kardex_stEstatusTrabajador.Add(estatustrabajador);
                                                         db.SaveChanges();
                                                         
                                                        }
                                                      catch (Exception e)
                                                      {
                                                          ViewData["EditError"] = e.Message;
                                                          // all changes will be rolled back
                                                      }
                                                      scope.Complete();
                                                }
                                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                                }
                                     }
                                 }
                                 
                             }

                         }
                    
                    
                    }


                    //else if (IdTipoIncidencia == 15 || IdTipoIncidencia == 16 || IdTipoIncidencia == 18 || IdTipoIncidencia == 19 || IdTipoIncidencia == 21)
                    //{
                    //    // DIAS PERMISO
                    //    DateTime firstDay = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                    //    DateTime lastDay = incidenciaPermiso_stIncidenciaTrabajador.FechaTermino.Value;
                    //    if (firstDay > lastDay)
                    //        throw new ArgumentException("Incorrect last day " + lastDay);

                    //    TimeSpan span = lastDay - firstDay;
                    //    int businessDays = span.Days + 1;
                    //    int fullWeekCount = businessDays / 7;
                    //    // find out if there are weekends during the time exceedng the full weeks
                    //    if (businessDays > fullWeekCount * 7)
                    //    {
                    //        // we are here to find out if there is a 1-day or 2-days weekend
                    //        // in the time interval remaining after subtracting the complete weeks
                    //        int firstDayOfWeek = (int)firstDay.DayOfWeek;
                    //        int lastDayOfWeek = (int)lastDay.DayOfWeek;
                    //        if (lastDayOfWeek < firstDayOfWeek)
                    //            lastDayOfWeek += 7;
                    //        if (firstDayOfWeek <= 6)
                    //        {
                    //            if (lastDayOfWeek >= 7)// Both Saturday and Sunday are in the remaining time interval
                    //                businessDays -= 2;
                    //            else if (lastDayOfWeek >= 6)// Only Saturday is in the remaining time interval
                    //                businessDays -= 1;
                    //        }
                    //        else if (firstDayOfWeek <= 7 && lastDayOfWeek >= 7)// Only Sunday is in the remaining time interval
                    //            businessDays -= 1;
                    //    }

                    //    // subtract the weekends during the full weeks in the interval
                    //    businessDays -= fullWeekCount + fullWeekCount;
                    //    Session["Dias"] = businessDays;
                    //    ViewBag.Dias = businessDays;


                    //    // subtract the number of bank holidays during the time interval
                    //    //foreach (DateTime bankHoliday in bankHolidays)
                    //    //{
                    //    //    DateTime bh = bankHoliday.Date;
                    //    //    if (firstDay <= bh && bh <= lastDay)
                    //    //        --businessDays;
                    //    //}
                    //    //return businessDays;
                    //}

                    else if (IdTipoIncidencia == 15)
                    {
                        // DIAS PERMISO
                        DateTime firstDay = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                        DateTime lastDay = incidenciaPermiso_stIncidenciaTrabajador.FechaTermino.Value;
                        if (firstDay > lastDay)
                            throw new ArgumentException("Incorrect last day " + lastDay);

                        TimeSpan span = lastDay - firstDay;
                        int businessDays = span.Days + 1;
                        int fullWeekCount = businessDays / 7;
                        // find out if there are weekends during the time exceedng the full weeks
                        if (businessDays > fullWeekCount * 7)
                        {
                            // we are here to find out if there is a 1-day or 2-days weekend
                            // in the time interval remaining after subtracting the complete weeks
                            int firstDayOfWeek = (int)firstDay.DayOfWeek;
                            int lastDayOfWeek = (int)lastDay.DayOfWeek;
                            if (lastDayOfWeek < firstDayOfWeek)
                                lastDayOfWeek += 7;
                            if (firstDayOfWeek <= 6)
                            {
                                if (lastDayOfWeek >= 7)// Both Saturday and Sunday are in the remaining time interval
                                    businessDays -= 2;
                                else if (lastDayOfWeek >= 6)// Only Saturday is in the remaining time interval
                                    businessDays -= 1;
                            }
                            else if (firstDayOfWeek <= 7 && lastDayOfWeek >= 7)// Only Sunday is in the remaining time interval
                                businessDays -= 1;
                        }

                        // subtract the weekends during the full weeks in the interval
                        businessDays -= fullWeekCount + fullWeekCount;
                        Session["Dias"] = businessDays;
                        ViewBag.Dias = businessDays;


                        // subtract the number of bank holidays during the time interval
                        //foreach (DateTime bankHoliday in bankHolidays)
                        //{
                        //    DateTime bh = bankHoliday.Date;
                        //    if (firstDay <= bh && bh <= lastDay)
                        //        --businessDays;
                        //}
                        //return businessDays;


                        if (Convert.ToInt32(Session["Dias"]) > 12)
                        {
                            MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 12 días hábiles");
                        }
                        else if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year != incidenciaPermiso_stIncidenciaTrabajador.FechaTermino.Value.Year)
                        {
                            MessageBox.Show(ViewData, TipoMensaje.Error, " La fecha de la incidencia debe ser del mismo año");
                        }
                        else
                        {
                            int dias = 0;
                            foreach (var item in db.IncidenciaPermiso_stIncidenciaTrabajador.Where(a => a.IdTipoIncidencia == 15 && a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.FechaInicio.Year == DateTime.Now.Year && a.FechaTermino.Value.Year == DateTime.Now.Year).ToList())
                            {
                                DateTime firstDay2 = item.FechaInicio;
                                DateTime lastDay2 = item.FechaTermino.Value;
                                if (firstDay2 > lastDay2)
                                    throw new ArgumentException("Incorrect last day " + lastDay2);

                                TimeSpan span2 = lastDay2 - firstDay2;
                                int businessDays2 = span2.Days + 1;
                                int fullWeekCount2 = businessDays2 / 7;
                                // find out if there are weekends during the time exceedng the full weeks
                                if (businessDays2 > fullWeekCount2 * 7)
                                {
                                    // we are here to find out if there is a 1-day or 2-days weekend
                                    // in the time interval remaining after subtracting the complete weeks
                                    int firstDayOfWeek2 = (int)firstDay2.DayOfWeek;
                                    int lastDayOfWeek2 = (int)lastDay2.DayOfWeek;
                                    if (lastDayOfWeek2 < firstDayOfWeek2)
                                        lastDayOfWeek2 += 7;
                                    if (firstDayOfWeek2 <= 6)
                                    {
                                        if (lastDayOfWeek2 >= 7)// Both Saturday and Sunday are in the remaining time interval
                                            businessDays2 -= 2;
                                        else if (lastDayOfWeek2 >= 6)// Only Saturday is in the remaining time interval
                                            businessDays2 -= 1;
                                    }
                                    else if (firstDayOfWeek2 <= 7 && lastDayOfWeek2 >= 7)// Only Sunday is in the remaining time interval
                                        businessDays2 -= 1;
                                }

                                // subtract the weekends during the full weeks in the interval
                                businessDays2 -= fullWeekCount2 + fullWeekCount2;
                                dias = dias + businessDays2;
                            }
                            int TotalDiasEconomicos = dias + Convert.ToInt32(Session["Dias"]);

                            if (TotalDiasEconomicos > 12)
                            {

                                MessageBox.Show(ViewData, TipoMensaje.Error, "Tiene permisos económicos anteriores y rebasa ya los 12 días permitidos");
                            }

                            else
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query;
                                short valor = 0;
                                query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                dp.Close();
                                Boolean Traslape = false;
                                Traslape = incidencias.Any(e =>
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                if (Traslape)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                }
                                //foreach (var item in incidencias)
                                //{

                                //    if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio >= item.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino <= item.FechaTermino)
                                //    {
                                //        Traslape = true;
                                //        break;

                                //    }
                                //    if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio <= item.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino <= item.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino >= item.FechaInicio)
                                //    {
                                //        Traslape = true;
                                //        break;
                                //    }
                                //    if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio >= item.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio <= item.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino >= item.FechaTermino)
                                //    {
                                //        Traslape = true;
                                //        break;
                                //    }

                                //    if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio <= item.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino >= item.FechaTermino)
                                //    {
                                //        Traslape = true;
                                //        break;

                                //    }
                                //    if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == item.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == item.FechaTermino)
                                //    {
                                //        Traslape = true;
                                //        break;
                                //    }

                                //}

                                else
                                {

                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                }

                            }
                        }
                    }

                    else if (IdTipoIncidencia == 31)
                    {
                        if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Day <= 15)
                        {
                            int retardos31 = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(c => c.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && c.IdTipoIncidencia == 31 && c.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year && c.FechaInicio.Month == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Month && c.FechaInicio.Day <= 15).Count();

                            if (retardos31 >= 2)
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query;
                                short valor = 0;
                                query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                dp.Close();
                                Boolean Traslape = false;
                                Traslape = incidencias.Any(e =>
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                if (Traslape)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                }

                                else
                                {
                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    var lista_Incidencia2 = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = 2;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                }
                            }
                            else
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query;
                                short valor = 0;
                                query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                dp.Close();
                                Boolean Traslape = false;
                                Traslape = incidencias.Any(e =>
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                if (Traslape)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                }
                                else
                                {
                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                }
                            }

                        }
                        else
                        {
                            int retardos31 = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(c => c.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && c.IdTipoIncidencia == 31 && c.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year && c.FechaTermino.Value.Month == incidenciaPermiso_stIncidenciaTrabajador.FechaTermino.Value.Month && c.FechaInicio.Day > 15).Count();

                            if (retardos31 >= 2)
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query;
                                short valor = 0;
                                query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                dp.Close();
                                Boolean Traslape = false;
                                Traslape = incidencias.Any(e =>
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                if (Traslape)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                }
                                else
                                {
                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    var lista_Incidencia2 = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = 2;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                }
                            }
                            else
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query;
                                short valor = 0;
                                query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                dp.Close();
                                Boolean Traslape = false;
                                Traslape = incidencias.Any(e =>
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                if (Traslape)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                }
                                else
                                {
                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                }
                            }
                        }
                    }
                    else if (IdTipoIncidencia == 32)
                    {
                        if (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Day <= 15)
                        {
                            int retardos32 = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(c => c.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && c.IdTipoIncidencia == 32 && c.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year && c.FechaInicio.Month == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Month && c.FechaInicio.Day <= 15).Count();

                            if (retardos32 >= 2)
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query;
                                short valor = 0;
                                query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                dp.Close();
                                Boolean Traslape = false;
                                Traslape = incidencias.Any(e =>
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                if (Traslape)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                }
                                else
                                {
                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    var lista_Incidencia2 = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = 8;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                }
                            }
                            else
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query;
                                short valor = 0;
                                query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                dp.Close();
                                Boolean Traslape = false;
                                Traslape = incidencias.Any(e =>
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                if (Traslape)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                }
                                else
                                {
                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                }
                            }

                        }
                        else
                        {
                            int retardos32 = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(c => c.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && c.IdTipoIncidencia == 32 && c.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year && c.FechaTermino.Value.Month == incidenciaPermiso_stIncidenciaTrabajador.FechaTermino.Value.Month && c.FechaInicio.Day > 15).Count();

                            if (retardos32 >= 2)
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query;
                                short valor = 0;
                                query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                dp.Close();
                                Boolean Traslape = false;
                                Traslape = incidencias.Any(e =>
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                if (Traslape)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                }
                                else
                                {
                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    var lista_Incidencia2 = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = 8;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                }
                            }
                            else
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query;
                                short valor = 0;
                                query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                                var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                                dp.Close();
                                Boolean Traslape = false;
                                Traslape = incidencias.Any(e =>
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                           (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                                if (Traslape)
                                {

                                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                                }
                                else
                                {
                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                                }
                            }
                        }
                    }
                    else if (IdTipoIncidencia == 2 || IdTipoIncidencia == 8 || IdTipoIncidencia == 34)
                    {
                        Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                        string query;
                        short valor = 0;
                        query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString(); 
                        var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                        dp.Close();
                        Boolean Traslape = false;
                        Traslape = incidencias.Any(e =>
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaTermino) ||
                                   (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaTermino));
                        if (Traslape)
                        {

                            MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                        }

                        else
                        {

                            var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                            incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                            incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                            incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                            incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                            incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                            incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                            incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                            incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                            incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                            incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                            incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                            db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                            db.SaveChanges();
                            return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                        }
                    }

                    else if (IdTipoIncidencia == 12 )
                    {

                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            TransactionOptions Grabar = new TransactionOptions();
                            Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                            {
                                try
                                {

                                    var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                    incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                    incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                    db.SaveChanges();
                                    //CLTC, CLT,Plaza
                                    var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                    conveniolaboralcategoria.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.AddDays(-1);
                                    conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.AddDays(-1);
                                    conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = true;
                                    db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                    db.SaveChanges();

                                    Kardex_stEstatusTrabajador estatustrabajador = new Kardex_stEstatusTrabajador();
                                    //Escribir alta del trabajador
                                    estatustrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                    estatustrabajador.IdEstatusTrabajador = 12;
                                    estatustrabajador.FechaEstatusTrabajador = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                                    db.Kardex_stEstatusTrabajador.Add(estatustrabajador);
                                    db.SaveChanges();

                                }
                                catch (Exception e)
                                {
                                    ViewData["EditError"] = e.Message;
                                    // all changes will be rolled back
                                }
                                scope.Complete();
                            }
                            return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                        }
                        
                    }

                    else if (IdTipoIncidencia == 16)
                    {
                        // DIAS PERMISO
                        DateTime firstDay = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                        DateTime lastDay = incidenciaPermiso_stIncidenciaTrabajador.FechaTermino.Value;
                        if (firstDay > lastDay)
                            throw new ArgumentException("Incorrect last day " + lastDay);

                        TimeSpan span = lastDay - firstDay;
                        int businessDays = span.Days + 1;
                        int fullWeekCount = businessDays / 7;
                        // find out if there are weekends during the time exceedng the full weeks
                        if (businessDays > fullWeekCount * 7)
                        {
                            // we are here to find out if there is a 1-day or 2-days weekend
                            // in the time interval remaining after subtracting the complete weeks
                            int firstDayOfWeek = (int)firstDay.DayOfWeek;
                            int lastDayOfWeek = (int)lastDay.DayOfWeek;
                            if (lastDayOfWeek < firstDayOfWeek)
                                lastDayOfWeek += 7;
                            if (firstDayOfWeek <= 6)
                            {
                                if (lastDayOfWeek >= 7)// Both Saturday and Sunday are in the remaining time interval
                                    businessDays -= 2;
                                else if (lastDayOfWeek >= 6)// Only Saturday is in the remaining time interval
                                    businessDays -= 1;
                            }
                            else if (firstDayOfWeek <= 7 && lastDayOfWeek >= 7)// Only Sunday is in the remaining time interval
                                businessDays -= 1;
                        }

                        // subtract the weekends during the full weeks in the interval
                        businessDays -= fullWeekCount + fullWeekCount;
                        Session["Dias"] = businessDays;
                        ViewBag.Dias = businessDays;


                        // subtract the number of bank holidays during the time interval
                        //foreach (DateTime bankHoliday in bankHolidays)
                        //{
                        //    DateTime bh = bankHoliday.Date;
                        //    if (firstDay <= bh && bh <= lastDay)
                        //        --businessDays;
                        //}
                        //return businessDays;

                        if (Convert.ToInt32(Session["Dias"]) > 9)
                        {

                            MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 9 dias hábiles");

                        }
                        else
                        {
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                            string query;
                            short valor = 0;
                            query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString();
                            var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                            dp.Close();
                            Boolean Traslape = false;
                            Traslape = incidencias.Any(e =>
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                            if (Traslape)
                            {

                                MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                            }
                            else
                            {

                                var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                db.SaveChanges();
                                return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });



                            }

                        }
                    }
                    else if (IdTipoIncidencia == 18 || IdTipoIncidencia == 19 || IdTipoIncidencia == 21)
                    {
                        // DIAS PERMISO
                        DateTime firstDay = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                        DateTime lastDay = incidenciaPermiso_stIncidenciaTrabajador.FechaTermino.Value;
                        if (firstDay > lastDay)
                            throw new ArgumentException("Incorrect last day " + lastDay);

                        TimeSpan span = lastDay - firstDay;
                        int businessDays = span.Days + 1;
                        int fullWeekCount = businessDays / 7;
                        // find out if there are weekends during the time exceedng the full weeks
                        if (businessDays > fullWeekCount * 7)
                        {
                            // we are here to find out if there is a 1-day or 2-days weekend
                            // in the time interval remaining after subtracting the complete weeks
                            int firstDayOfWeek = (int)firstDay.DayOfWeek;
                            int lastDayOfWeek = (int)lastDay.DayOfWeek;
                            if (lastDayOfWeek < firstDayOfWeek)
                                lastDayOfWeek += 7;
                            if (firstDayOfWeek <= 6)
                            {
                                if (lastDayOfWeek >= 7)// Both Saturday and Sunday are in the remaining time interval
                                    businessDays -= 2;
                                else if (lastDayOfWeek >= 6)// Only Saturday is in the remaining time interval
                                    businessDays -= 1;
                            }
                            else if (firstDayOfWeek <= 7 && lastDayOfWeek >= 7)// Only Sunday is in the remaining time interval
                                businessDays -= 1;
                        }

                        // subtract the weekends during the full weeks in the interval
                        businessDays -= fullWeekCount + fullWeekCount;
                        Session["Dias"] = businessDays;
                        ViewBag.Dias = businessDays;


                        // subtract the number of bank holidays during the time interval
                        //foreach (DateTime bankHoliday in bankHolidays)
                        //{
                        //    DateTime bh = bankHoliday.Date;
                        //    if (firstDay <= bh && bh <= lastDay)
                        //        --businessDays;
                        //}
                        //return businessDays;

                        if (Convert.ToInt32(Session["Dias"]) > 5)
                        {
                            MessageBox.Show(ViewData, TipoMensaje.Error, "El tipo de incidencia seleccionada no  debe ser mayor a 5 dias hábiles");
                        }
                        else
                        {
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                            string query;
                            short valor = 0;
                            query = @"SELECT IdIncidenciaTrabajador, IdConvenioLaboralTrabajadorCategoria, IdTipoIncidencia, FechaInicio, FechaTermino, Observaciones, UserId, FechaCreacion, 
                                     IdNominaTrabajador, EsAplicada, EsSubsecuente, DiasPagados100, DiasPagados40, DiasAcumulados, IdIncidenciaTrabajadorPadre, 
                                     IdConvenioLaboralTrabajadorCategoriaRegistro, Autorizo, IdConvenioLaboralTrabajadorCategoriaAutorizo, IdIncidenciaJustificacion, QuincenasCalculadas, 
                                     PercepcionDiaria, Horas
                                     FROM IncidenciaPermiso_stIncidenciaTrabajador
                                     where  IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + " and  IdIncidenciaJustificacion =" + valor.ToString();
                            var incidencias = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(query);
                            dp.Close();
                            Boolean Traslape = false;
                            Traslape = incidencias.Any(e =>
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino < e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio == e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaTermino) ||
                                       (incidenciaPermiso_stIncidenciaTrabajador.FechaInicio > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaInicio < e.FechaTermino && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino > e.FechaInicio && incidenciaPermiso_stIncidenciaTrabajador.FechaTermino == e.FechaTermino));
                            if (Traslape)
                            {

                                MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede agregar la incidencia y/o permiso pq existen translape de fechas");
                            }
                            else
                            {

                                var lista_Incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                                incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = (short)IdTipoIncidencia;
                                incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                                incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                                incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                                incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                                incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                                incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                                incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                                incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                                incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                                incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = null;
                                incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
                                db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                                db.SaveChanges();
                                return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                            }
                        }
                    }
                    }
                    
                //return RedirectToAction("Index");
            }

            var IncidenciasTrabajador = from a in db.Catalogos_ctTipoIncidencia
                                        from b in db.IncidenciaPermiso_stIncidenciaTrabajador
                                        where a.IdTipoIncidencia == b.IdTipoIncidencia && b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.Incidencia == "RIESGO DE TRABAJO"
                                        select new
                                        {
                                            b.IdIncidenciaTrabajador,
                                            Incidencia = a.Incidencia + " || " + "Fecha Inicio: " + b.FechaInicio + " || " + "Fecha Termino: " + b.FechaTermino
                                        };

            ViewBag.IdIncidenciaTrabajadorPadre = new SelectList(IncidenciasTrabajador, "IdIncidenciaTrabajador", "Incidencia");

            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo);
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador", incidenciaPermiso_stIncidenciaTrabajador.IdNominaTrabajador);
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // GET: IncidenciaPermisoTrabajador/Edit/5
        public ActionResult Edit(long? id)
        {
               if (id == null)
                {
                    return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
                }
                IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
                if (incidenciaPermiso_stIncidenciaTrabajador == null)
                {
                        return HttpNotFound();
                }
                ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia);
                ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro);
                ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo);
                ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador", incidenciaPermiso_stIncidenciaTrabajador.IdNominaTrabajador);
                return View(incidenciaPermiso_stIncidenciaTrabajador);
                   
        }

        // POST: IncidenciaPermisoTrabajador/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdIncidenciaTrabajador,IdConvenioLaboralTrabajadorCategoria,IdTipoIncidencia,FechaInicio,FechaTermino,Observaciones,UserId,FechaCreacion,IdNominaTrabajador,EsAplicada,EsSubsecuente,DiasPagados100,DiasPagados40,DiasAcumulados,IdIncidenciaTrabajadorPadre,IdConvenioLaboralTrabajadorCategoriaRegistro,Autorizo,IdConvenioLaboralTrabajadorCategoriaAutorizo")] IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador)
        {
            int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
            
            if (ModelState.IsValid)
            {
                var fechas = (from a in db.IncidenciaPermiso_stIncidenciaTrabajador
                              where a.IdIncidenciaTrabajador == incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajador
                              select new
                              {
                                  IdTipoIncidencia = a.IdTipoIncidencia,
                                  IdIncidenciaTrabajadorPadre = a.IdIncidenciaTrabajadorPadre,
                                  FechaInicio = a.FechaInicio,
                                  FechaTermino = a.FechaTermino
                              });

                short IdTipoIncidencia = (short)fechas.FirstOrDefault().IdTipoIncidencia;
                if (IdTipoIncidencia == 1 || IdTipoIncidencia == 10 || IdTipoIncidencia == 11)
                {

                    MessageBox.Show(ViewData, TipoMensaje.Error, "No se puede editar un permiso sin goce de sueldo por razones de seguridad del sistema");
                }
                else { 
                incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                incidenciaPermiso_stIncidenciaTrabajador.UserId = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                incidenciaPermiso_stIncidenciaTrabajador.FechaCreacion = DateTime.Now;
                incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                incidenciaPermiso_stIncidenciaTrabajador.DiasPagados100 = 0;
                incidenciaPermiso_stIncidenciaTrabajador.DiasPagados40 = 0;
                incidenciaPermiso_stIncidenciaTrabajador.DiasAcumulados = 0;
                incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro = IdConvenioLaboralTrabajadorCategoria;
                incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdConvenioLaboralTrabajadorCategoria;
                incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                incidenciaPermiso_stIncidenciaTrabajador.QuincenasCalculadas = "";
               
                DateTime FechaInicio = Convert.ToDateTime(fechas.FirstOrDefault().FechaInicio);
                DateTime FechaTermino = Convert.ToDateTime(fechas.FirstOrDefault().FechaTermino);
            
                incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia = IdTipoIncidencia;
                incidenciaPermiso_stIncidenciaTrabajador.FechaInicio = FechaInicio;
                incidenciaPermiso_stIncidenciaTrabajador.FechaTermino = FechaTermino;
                
                var IdInTraPadre = from a in db.IncidenciaPermiso_stIncidenciaTrabajador
                                   where a.IdIncidenciaTrabajador == incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajador
                                     select new
                                     {
                                         a.IdIncidenciaTrabajadorPadre
                                     };

                int IdIncidenciaTrabajadorPadre = Convert.ToInt32(IdInTraPadre.FirstOrDefault().IdIncidenciaTrabajadorPadre);
                incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajadorPadre = IdIncidenciaTrabajadorPadre;
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Incidencia", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                }
                //return RedirectToAction("Index");
            }
            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia);
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo);
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador", incidenciaPermiso_stIncidenciaTrabajador.IdNominaTrabajador);
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // GET: IncidenciaPermisoTrabajador/Delete/5
        public ActionResult Delete(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: IncidenciaPermisoTrabajador/Delete/5
        [HttpPost, ActionName("DeleteConfirmed")]
        //[ValidateAntiForgeryToken]
        public JsonResult DeleteConfirmed(long id)
        {
            int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
            var fechas = (from a in db.IncidenciaPermiso_stIncidenciaTrabajador
                          where a.IdIncidenciaTrabajador == id
                          select new
                          {
                              IdTipoIncidencia = a.IdTipoIncidencia,
                              IdIncidenciaTrabajadorPadre = a.IdIncidenciaTrabajadorPadre,
                              FechaInicio = a.FechaInicio,
                              FechaTermino = a.FechaTermino
                          });
            int IdTipoIncidencia = fechas.FirstOrDefault().IdTipoIncidencia;
            if (IdTipoIncidencia == 10 || IdTipoIncidencia==11 || IdTipoIncidencia==12 || IdTipoIncidencia==1) 
            {
                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                                {
                                                    TransactionOptions Grabar = new TransactionOptions();
                                                    Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                                                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                                                {
                                                      try
                                                        {
                                                            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
                                                            db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
                                                            db.SaveChanges();
                                                            //CLTC, CLT,Plaza
                                                            var conveniolaboralcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
                                                            conveniolaboralcategoria.FechaTermino = null;
                                                            conveniolaboralcategoria.Convenios_stConvenioLaboralTrabajador.FechaTermino = null;
                                                            conveniolaboralcategoria.Plazas_stDistribucionPlazaCategoria.EsVacante = false;
                                                            db.Entry(conveniolaboralcategoria).State = System.Data.Entity.EntityState.Modified;
                                                            db.SaveChanges();
                                                            //Estatus
                                                            var estatusborrar  = (from a in db.Kardex_stEstatusTrabajador
                                                                                  where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && a.FechaEstatusTrabajador == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio
                                                                                  select new
                                                                                  {
                                                                                      IdEstatusTrabajadorBitacora = a.IdEstatusTrabajadorBitacora
                                                                                  });
                                                            int IdEstatusTrabajadorBitacora = (int)estatusborrar.FirstOrDefault().IdEstatusTrabajadorBitacora;
                                                            Kardex_stEstatusTrabajador estatustrabajador = db.Kardex_stEstatusTrabajador.Find(IdEstatusTrabajadorBitacora);
                                                            db.Kardex_stEstatusTrabajador.Remove(estatustrabajador);
                                                            db.SaveChanges();
                                                           
                                                        }
                                                      catch (Exception e)
                                                      {
                                                          ViewData["EditError"] = e.Message;
                                                          // all changes will be rolled back
                                                      }
                                                      scope.Complete();
                                                }
                                                    return new JsonResult() { Data = "Registro eliminado exitosamente" };
                                                }
            }
            else 
            { 
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
            db.SaveChanges();
            return new JsonResult() { Data = "Registro eliminado exitosamente" };
            }
            
            //return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
