﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using System.Windows.Media.Animation;
using Dapper;
using DevExpress.Data.Mask;
using DevExpress.Office.Utils;
using DevExpress.Utils.Extensions;
using DevExpress.XtraCharts.Native;
 
using Nova.Controllers.RelojChecador;
using Nova.Libraries;
using Nova.Models;
using Nova.Models.IncidenciaPermiso;
using Nova.Models.Kardex;
using Nova.Models.Nomina;
using Nova.Models.Sindicato;
using Rotativa;
using Seguridad;
using DapperQuery = Nova.Libraries.DapperQuery;

namespace Nova.Controllers
{
    public class IncidenciaPermisoTrabajadoresController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        public static (DateTime FechaInicio, DateTime FechaFin) CalcularFechasQuincena(int quincena, int año)
        {
            if (quincena < 1 || quincena > 24)
            {
                throw new ArgumentException("La quincena debe estar entre 1 y 24", nameof(quincena));
            }

            int mes = (quincena + 1) / 2;
            bool esPrimeraQuincena = quincena % 2 != 0;

            DateTime fechaInicio = esPrimeraQuincena
                ? new DateTime(año, mes, 1)
                : new DateTime(año, mes, 16);

            DateTime fechaFin = esPrimeraQuincena
                ? new DateTime(año, mes, 15)
                : new DateTime(año, mes, DateTime.DaysInMonth(año, mes));

            return (fechaInicio, fechaFin);
        }


        [HttpPost]
        public ActionResult Reprocesarids(int ida, short idarea, short idqm, string rol)
        {
            TrabajadoresHorasTrabajadas rp = new TrabajadoresHorasTrabajadas();
            var qna =System.Convert.ToInt16(db.Catalogos_ctQuincenaMes.Find(idqm).QuincenaMes);
            var (fechai, fechaf) =  CalcularFechasQuincena(qna, ida);
            var model = rp.ObtenHorasTrabajadas(fechai, fechaf,idarea);

            //Nova.Models.RelojChecador reloj = new Nova.Models.RelojChecador();

            var controllerB = new RelojChecadorController();
            controllerB.ControllerContext = new ControllerContext(this.Request.RequestContext, controllerB);




            // Ahora puedes usar el resultado como necesites
            JsonResult data =new JsonResult();
 

            foreach (var item in model)
            {
                  data = controllerB.testing((int)item.IdTrabajador,  item.Fecha.Substring(0,10), idarea) as JsonResult;
            }

            return Json(new { Valid = true, msj = "Proceso comnpleto" });
        }

        public ActionResult GetTrabajadoresHorasTrabajadas(int ida, short idarea, short idqm, string rol)
        {
            TrabajadoresHorasTrabajadas rp = new TrabajadoresHorasTrabajadas();
            var qna = System.Convert.ToInt16(db.Catalogos_ctQuincenaMes.Find(idqm).QuincenaMes);
            var (fechai, fechaf) = CalcularFechasQuincena(qna, ida);
            var model = rp.ObtenHorasTrabajadas(fechai, fechaf, idarea);

            return PartialView("_TrabajadoresHorasTrabajadas", model);
        }

        // GET: IncidenciaPermisoTrabajador
        public ActionResult Index()
        {
            var usuario = Seguridad.Identidad.Usuario();
            var quincenames = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes();
            ViewBag.justificaciones = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getTipoJustificacion();
            ViewBag.IdQuincenaMes = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");
            ViewBag.IdAreasUsuario = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAreasUsuario(usuario.IdConvenioLaboralTrabajadorCategoria), "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.Rol = "OperadorIncidencias";
            ViewBag.Leyendas = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetLeyendas();

            return View();
        }
        public ActionResult AdministradorIncidencias()
        {
            var usuario = Seguridad.Identidad.Usuario();
            var quincenames = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes();
            ViewBag.justificaciones = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getTipoJustificacion();
            ViewBag.IdQuincenaMes = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");
            ViewBag.IdAreasUsuario = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAreasAdmin(), "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.Rol = "AdministradorIncidencias";
            ViewBag.Leyendas = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetLeyendas();

            return View("Index");
        }

        public ActionResult IncidenciasGlobales(string fechainicial = null, string fechafinal = null)
        {

            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasGlobales(fechainicial, fechafinal));
        }
        public ActionResult IncidenciasPorMesaAdmin()
        {



            return View("IncidenciasPorMesa", IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPorMesa(0));
        }
        public ActionResult IncidenciasPorMesa()
        {
            var id = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var hay = db.Nomina_RelojChecadorControlUsuarios.AsNoTracking().Where(d => d.IdConvenioLaboralTrabajadorCategoria == id).FirstOrDefault();

            if (hay == null)
            {
                throw new ApplicationException("Esta opción solo es para reposnsables de las mesas");
            }



            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPorMesa(id));
        }
        public ActionResult ResponsablesIncidencias()
        {
            var usuario = Seguridad.Identidad.Usuario();
            var qna=IncidenciaPermisoTrabajadorProcesoEstatus.ObtenerQuincena(DateTime.Now);

            var quincenames = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes();
            var qnaselec  =db.Catalogos_ctQuincenaMes.AsNoTracking().Where(a => a.QuincenaMes == qna).FirstOrDefault().IdQuincenaMes;
            var año = DateTime.Now.Year;
            ViewBag.justificaciones = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getTipoJustificacion();
            ViewBag.IdQuincenaMes = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes", qnaselec);
            ViewBag.IdAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año", año);
            ViewBag.IdAreasUsuario = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAreaDirector(usuario.IdConvenioLaboralTrabajadorCategoria), "IdEstructuraOrganica", "EstructuraOrganica",usuario.IdEstructuraOrganica);
            ViewBag.Rol = "ResponsableIncidencias";
            ViewBag.Leyendas = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetLeyendas();


            return View("Index");
        }
        public ActionResult PermisosArea(PermisosArea permisosarea)
        {
            DateTime fechainicial = Convert.ToDateTime(permisosarea.fi);
            DateTime fechafinal = Convert.ToDateTime(permisosarea.ff).AddDays(30);
            //var listpermisosarea = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "PERMISO"
            // && z.Convenios_stConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria == permisosarea.idarea
            // && z.Autorizo == true
            // && z.Catalogos_ctTipoIncidencia.EsPermiso==true
            // && (z.FechaInicio <= fechainicial && z.FechaTermino >= fechainicial) || (z.FechaInicio >= fechainicial && z.FechaTermino <= fechafinal)
            // || (z.FechaInicio <= fechafinal && z.FechaTermino >= fechafinal)
            // || (z.FechaInicio <= fechainicial && z.FechaTermino >= fechafinal)).ToList();
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query;

            query = @"select f.IdTrabajador as Id,b.Incidencia as Permiso,f.Nombre,f.ApellidoPaterno,f.ApellidoMaterno,a.FechaInicio,a.FechaTermino from IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
inner join Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on a.IdConvenioLaboralTrabajadorCategoria= d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador e on e.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
inner join vwDatosAspirantesTrabajadores f on f.IdTrabajador = e.IdTrabajador
where a.FechaInicio<='" + fechainicial.ToString("yyyyMMdd") + "' and a.FechaTermino>='" + fechafinal.ToString("yyyyMMdd") + "' and f.IdEstructuraOrganicaFisica= " + permisosarea.idarea + " and (b.IdTipoIncidencia in (10,11 ) or c.IdTipoIncidenciaPermiso in(4,5) ) " +
@" union all " +
@"select a.IdTrabajador as Id,b.Incidencia as Permiso,d.Nombre,d.ApellidoPaterno,d.ApellidoMaterno,a.FechaInicio,a.FechaTermino from Nomina_ApoyoEstudios a
inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
inner join Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
inner join vwDatosAspirantesTrabajadores d on a.IdTrabajador = d.IdTrabajador
where a.FechaInicio<='" + fechainicial.ToString("yyyyMMdd") + "' and a.FechaTermino>='" + fechafinal.ToString("yyyyMMdd") + "' and d.IdEstructuraOrganicaFisica= " + permisosarea.idarea + " and (b.IdTipoIncidencia in (10,11 ) or c.IdTipoIncidenciaPermiso in(4,5))  "
+ @"order by 1,6";
            List<TrabajadoresPermisos> t = (List<TrabajadoresPermisos>)dp.connection.Query<TrabajadoresPermisos>(query);
            dp.Close();

            return PartialView("pvPermisosUbicabcionFisica", t);
        }

        public ActionResult PivotIncidencias(string ida, short idarea, short idqm, string rol)
        {
            var model=CreaPivotIncidencias(ida, idarea, idqm, rol);
            return PartialView(model);

        }

        [AllowAnonymous]
        public ActionResult EstatusProcesoIncidencias( short idarea, short año, string qna)
        {
            IncidenciaPermisoTrabajadorProcesoEstatus reporte = new IncidenciaPermisoTrabajadorProcesoEstatus();
            var model = reporte.ObtenerDatos(idarea, qna, año);
            return PartialView("_EstatusProcesoIncidencias",model);

        }

        private EstructuraIncidencias CreaPivotIncidencias(string ida, short idarea, short idqm, string rol)
        {
            ViewBag.justificaciones = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getTipoJustificacion();
            ViewBag.Leyendas = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetLeyendas();

            string año = ida;
            int aaaa = Convert.ToInt32(año);
            ViewBag.Año = aaaa;
            ViewBag.Idqm = idqm;
            DateTime FechaInicial = DateTime.MinValue;
            DateTime FechaFinal = DateTime.MinValue;
            ViewBag.Idarea = idarea;

            Nomina_RelojChecadorAreas areaactual = db.Nomina_RelojChecadorAreas.Where(a => a.IdEstructuraOrganica == idarea).FirstOrDefault();

            ViewBag.EstructuraOrganica = areaactual.EstructuraOrganica;

            Boolean esquincenapar = false;
            short NoQuincena = System.Convert.ToInt16(db.Catalogos_ctQuincenaMes.AsNoTracking().Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().QuincenaMes);
            ViewBag.Rol = rol;


            ViewBag.NoQuincena = NoQuincena;
            ViewBag.NombreMes = db.Catalogos_ctQuincenaMes.AsNoTracking().Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().Catalogos_ctMes.Mes;
            string NoMes = System.Convert.ToString(db.Catalogos_ctQuincenaMes.AsNoTracking().Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().IdMes);
            short Mes = System.Convert.ToInt16(NoMes);
            if (NoQuincena % 2 == 0)
            {
                esquincenapar = true;
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes + "-16");
                switch (NoMes)
                {
                    case "2":
                        Boolean esbisiesto = System.DateTime.IsLeapYear(Convert.ToInt32(año));
                        if (esbisiesto)
                            FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-29");
                        else
                            FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-28");
                        break;
                    case "4":
                    case "6":
                    case "9":
                    case "11":
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-30");
                        break;
                    default:
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-31");
                        break;
                }
            }
            else
            {
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes);
                FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-15");
            }
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            //            string qTrabajadores, qIncidencias;
            //            string fechasfiltro = $@" (b.FechaInicio <= '{FechaFinal.ToShortDateString()}'
            //OR b.FechaInicio <= DATEADD(YEAR, -2, '{FechaFinal.ToShortDateString()}'))
            //    AND(b.FechaTermino IS NULL OR b.FechaTermino >= '{FechaInicial.ToShortDateString()}' or (DATEDIFF(MONTH, fechatermino, cast('" + FechaFinal.ToShortDateString() + "' as date) ) < 4) ) ";

            //            string fechasfiltroinci = $@" b.FechaInicio <= '{FechaFinal.ToShortDateString()}'
            // AND (b.FechaTermino IS NULL OR b.FechaTermino >= '{FechaInicial.ToShortDateString()}') ";

            //            string fechasfiltrobajas = @" and DATEDIFF(MONTH, fechatermino, cast('" + FechaFinal.ToShortDateString() + "' as date) ) < 4)";

            //            string fechasfiltrobajastrabajadores = @" or (DATEDIFF(MONTH, fechatermino, cast('" + FechaFinal.ToShortDateString() + "' as date) ) < 4)";

            //            //         (cast(FechaTermino as date) >= '" + FechaFinal.ToShortDateString() + "' or FechaTermino is null or DATEDIFF(MONTH, fechatermino, cast('" + FechaFinal.ToShortDateString() + "' as date) ) < 3)" +
            //            //" and (cast(FechaInicio as date)<='" + FechaInicial.ToShortDateString() + "'  or  ConvenioLaboral='BASE') " +

            //            qTrabajadores = @"select *,(SELECT [esexima]
            //  FROM [Nomina_RelojChecadorLibre]
            //  where IdConvenioLaboralTrabajadorCategoria =q.IdConvenioLaboralTrabajadorCategoria
            //  and (FechaTermino is null or FechaTermino>=GETDATE() ) )
            //  as LibreMonitoreo from (
            //SELECT  top 1000000 ROW_NUMBER() OVER(Partition by  idtrabajador  ORDER BY idtrabajador,FechaInicio desc) AS idq ,
            //DATEDIFF(MONTH, fechatermino, getdate() ) AS DateDiff,[IdConvenioLaboralTrabajadorCategoria]
            //      ,[RFC]
            //      ,[IdKardex]
            //      ,[CURP]
            //      ,[Nombre]
            //      ,[ApellidoPaterno]
            //      ,[ApellidoMaterno]
            //      ,[Sexo]
            //      ,[IdTrabajador]
            //      ,[FechaAsignacion]
            //      ,[ConvenioLaboral]
            //      ,[RelacionLaboral]
            //      ,[Categoria]
            //      ,[EstructuraOrganica]
            //      ,[EstructuraOrganicaPadrePlaza]
            //      ,[UbicacionFisica]
            //      ,[EstructuraOrganicaPadre]
            //      ,[EsComisionado]
            //      ,[FechaInicio]
            //      ,[FechaTermino]
            //      ,[IdConvenioLaboralTrabajador]
            //      ,[EstatusTrabajador]
            //      ,[Fotografia]
            //      ,[NSS]
            //      ,[CorreoElectronico]
            //      ,[IdCategoria]
            //      ,[IdEstructuraOrganica]
            //      ,[IdRelacionLaboral]
            //      ,[IdConvenioLaboral]
            //      ,[IdEstructuraOrganicaPadre]
            //      ,[CorreoInstitucional]
            //      ,[Telefono]
            //      ,[OrdenEstructuraOrganica]
            //      ,[IdEstructuraOrganicaFisica]
            //      ,[Antiguedad]
            //      ,[Años]
            //      ,[Meses]
            //      ,[Dias]
            //      ,[Direccion]
            //      ,[CorreoTrabajo]
            //      ,[TelefonoTrabajo]
            //      ,[ProcesoCompletado]
            //      ,[IdModalidadEstudio]
            //      ,[IdDistribucionPlazaCategoria]
            //      ,[IdRelacionConvenioLaboral]
            //      ,[IdeEmpleadoAnt]
            //      ,[EsHomologado]
            //      ,[CategoriaAnteriorNova]
            //      ,[RelacionConvenioLaboral]
            //      ,[Pk]
            //      ,[JornadaLaboral]
            //      ,[HorasMinimo]
            //      ,[HorasMaximo]
            //      ,[EsCuotaSindical]
            //      ,[FechaCuotaSindical]
            //      ,[Calle]
            //      ,[Colonia]
            //      ,[CodigoPostal]
            //      ,[NumeroExterior]
            //      ,[NumeroInterior]
            //      ,[MunicipioVive]
            //      ,[EstadoVive]
            //      ,[LocalidadVive]
            //  FROM [vwDatosAspirantesTrabajadoresHistorial] b
            //  where " + fechasfiltro + " and IdEstructuraOrganicaFisica=" + idarea +
            //  " order by  FechaInicio desc " +
            //  ") as q where q.idq=1";

            //            qIncidencias = @" select a.IdIncidenciaTrabajador,a.FechaInicio,a.FechaTermino,a.Horas,a.tiempofuera,d.IdTrabajador,e.Nombre+' '+e.ApellidoPaterno+' '+e.ApellidoMaterno as Trabajador
            //,CASE WHEN j.RelacionLaboral='DOCENTE' then a.Horas else DATEDIFF(day, b.FechaInicio,a.FechaTermino) end as DiasHorasIncidencia
            //,CASE WHEN k.Incidencia='DÍAS ECONÓMICOS' then DATEDIFF(day, b.FechaInicio,a.FechaTermino) ELSE 0 end DiasEconomicos
            //,ka.Nombre+' '+ka.ApellidoPaterno+' '+ka.ApellidoMaterno as QuienAutorizo
            //,kj.Nombre+' '+kj.ApellidoPaterno+' '+kj.ApellidoMaterno as QuienJustifico
            //,kr.Nombre+' '+kr.ApellidoPaterno+' '+kr.ApellidoMaterno as QuienRegistro
            //,k.Incidencia, k.Nomenclatura,k.Color
            //,ij.IncidenciaJustificacion as IncidenciaJustico,ij.Nomenclatura as NomenclaturaJustifico,ij.Color ColorJustifico
            //,a.IdNominaTrabajador,f.EstructuraOrganica,h.Categoria
            //,a.Observaciones,j.RelacionLaboral,l.ConvenioLaboral,a.EsAplicada,a.Autorizo,a.DescripcionJustificacion
            //,a.FechaAutorizacion,a.FechaCreacion,a.FechaJustificacion
            //,a.EsJustificacionExtemporanea
            //,a.IdIncidenciaJustificacion
            //,a.EsCancelada
            //,a.EsCerrada
            //,a.EsFaltaDirecta
            //,e.CURP
            //,b.FechaTermino as FechaTerminoConvenio
            //,f.IdModalidadEstudio
            //,a.QuincenaParaNomina
            //,a.AñoParaNomina
            //from 
            //IncidenciaPermiso_stIncidenciaTrabajador a " +
            //           " inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria" +
            //           " inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador" +
            //           " inner join Kardex_ctTrabajador d on d.IdTrabajador = c.IdTrabajador" +
            //           " inner join Kardex_ctDatosPersonales e on d.IdKardex= e.IdKardex" +
            //           " inner join Catalogos_ctEstructuraOrganica f on b.IdEstructuraOrganica =f.IdEstructuraOrganica" +
            //           " inner join Plazas_stDistribucionPlazaCategoria g on b.IdDistribucionPlazaCategoria=g.IdDistribucionPlazaCategoria" +
            //           " inner join Plazas_ctCategoria h on g.IdCategoria=h.IdCategoria" +
            //           " inner join Convenios_stRelacionConvenioLaboral i on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral" +
            //           " inner join Catalogos_ctRelacionLaboral j on i.IdRelacionLaboral=j.IdRelacionLaboral" +
            //           " inner join Catalogos_ctTipoIncidencia k on a.IdTipoIncidencia=k.IdTipoIncidencia" +
            //           " inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=i.IdConvenioLaboral" +
            //           " left join Convenios_stConvenioLaboralTrabajadorCategoria ca on a.IdConvenioLaboralTrabajadorCategoriaAutorizo=ca.IdConvenioLaboralTrabajadorCategoria" +
            //           " left join Convenios_stConvenioLaboralTrabajador la on la.IdConvenioLaboralTrabajador= ca.IdConvenioLaboralTrabajador" +
            //           " left join Kardex_ctTrabajador ta on ta.IdTrabajador=la.IdTrabajador" +
            //           " left join Kardex_ctDatosPersonales ka on ka.IdKardex = ta.IdKardex" +
            //           " left join Convenios_stConvenioLaboralTrabajadorCategoria cj on a.IdConvenioLaboralTrabajadorCategoriaJustifico=cj.IdConvenioLaboralTrabajadorCategoria" +
            //           " left join Convenios_stConvenioLaboralTrabajador lj on lj.IdConvenioLaboralTrabajador= cj.IdConvenioLaboralTrabajador" +
            //           " left join Kardex_ctTrabajador tj on tj.IdTrabajador=lj.IdTrabajador" +
            //           " left join Kardex_ctDatosPersonales kj on kj.IdKardex = tj.IdKardex" +
            //           " left join Convenios_stConvenioLaboralTrabajadorCategoria cr on a.IdConvenioLaboralTrabajadorCategoriaRegistro=cr.IdConvenioLaboralTrabajadorCategoria" +
            //           " left join Convenios_stConvenioLaboralTrabajador lr on lr.IdConvenioLaboralTrabajador= cr.IdConvenioLaboralTrabajador" +
            //           " left join Kardex_ctTrabajador tr on tr.IdTrabajador=lr.IdTrabajador" +
            //           " left join Kardex_ctDatosPersonales kr on kr.IdKardex = tr.IdKardex" +
            //           " left join Incidencia_ctJustificacion ij on ij.IdIncidenciaJustificacion = a.IdIncidenciaJustificacion" +
            //           " where b.IdEstructuraOrganica in " +
            //                      "(select idestructuraOrganicafisica from vwdatosaspirantestrabajadoreshistorial where " +
            //                      " idtrabajador in (select idtrabajador from vwdatosaspirantestrabajadoreshistorial where idestructuraOrganicafisica = " + idarea + fechasfiltrobajas+" )   and " +
            //                      "   (a.IdTipoIncidencia in (2,31,36,8,32,37,38,35,43,58,47)) and "
            //                      + fechasfiltroinci + " order by 23 ,35";
            //            List<vwDatosAspirantesTrabajadoresAsistencias> t = (List<vwDatosAspirantesTrabajadoresAsistencias>)dp.connection.Query<vwDatosAspirantesTrabajadoresAsistencias>(qTrabajadores);
            //            List<IncidenciaTrabajador> ti = (List<IncidenciaTrabajador>)dp.connection.Query<IncidenciaTrabajador>(qIncidencias);

            string qTrabajadores, qIncidencias;

            //            String conindeciapermiso = $@"select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadores ee where
            //restringirmenu is NOT null and incidencia not like '%INCAPACIDAD%' and IdEstructuraOrganicaFisica = {idarea} and EstatusTrabajador<>'BAJA'";

            //            List<vwDatosAspirantesTrabajadoresAsistencias> trab_conincindecia = (List<vwDatosAspirantesTrabajadoresAsistencias>)dp.connection.Query<vwDatosAspirantesTrabajadoresAsistencias>(conindeciapermiso);
            //            string idconveniostrabjadoresquitar = string.Join(",", trab_conincindecia.Select(x => x.IdConvenioLaboralTrabajadorCategoria));

            string condicionquitartrab = "";
            //            if (idconveniostrabjadoresquitar.Length > 0)
            //                condicionquitartrab = $"  IdConvenioLaboralTrabajadorCategoria not in({idconveniostrabjadoresquitar})  and ";
            qTrabajadores = $@"WITH TrabajadoresBase AS (
    -- Obtener trabajadores en IdEstructuraOrganicaFisica = {idarea} dentro del periodo
    SELECT  
        ROW_NUMBER() OVER (PARTITION BY idtrabajador ORDER BY idtrabajador, FechaInicio DESC) AS idq,
        DATEDIFF(MONTH, fechatermino, GETDATE()) AS DateDiff,
        vwDatosAspirantesTrabajadoresHistorial.*,
        (SELECT [esexima] 
         FROM [Nomina_RelojChecadorLibre] 
         WHERE IdConvenioLaboralTrabajadorCategoria = vwDatosAspirantesTrabajadoresHistorial.IdConvenioLaboralTrabajadorCategoria
         AND (FechaTermino IS NULL OR FechaTermino >= GETDATE()) ) AS LibreMonitoreo,

        (SELECT TOP 1 Incidencia FROM vwLicenciasTrabajadores AS bb  
         WHERE vwDatosAspirantesTrabajadoresHistorial.IdConvenioLaboralTrabajadorCategoria = bb.IdConvenioLaboralTrabajadorCategoria
         AND (
             (bb.FechaInicioIncidencia <= '{ FechaInicial.ToString("yyyyMMdd")}' AND bb.FechaTerminoIncidencia >= '{ FechaFinal.ToString("yyyyMMdd")}')
         )
         AND Incidencia NOT LIKE '%COMISIÓN PARA OCUPAR PLAZA VACANTE%' 
         AND Incidencia NOT LIKE '%incapacidad%' 
        ) AS Incidencia
    FROM vwDatosAspirantesTrabajadoresHistorial
    WHERE IdEstructuraOrganicaFisica = {idarea}
    AND (
        FechaTermino IS NULL
        OR (FechaInicio <= '{ FechaFinal.ToString("yyyyMMdd")}' AND (FechaTermino >= '{ FechaInicial.ToString("yyyyMMdd")}' OR FechaTermino IS NULL))
    )
)

SELECT * FROM TrabajadoresBase

UNION ALL

-- Obtener los mismos trabajadores en otra ubicación dentro del mismo periodo
SELECT  
    ROW_NUMBER() OVER (PARTITION BY h.idtrabajador ORDER BY h.idtrabajador, h.FechaInicio DESC) AS idq,
    DATEDIFF(MONTH, h.fechatermino, GETDATE()) AS DateDiff,
    h.*,
    (SELECT [esexima] 
     FROM [Nomina_RelojChecadorLibre] 
     WHERE IdConvenioLaboralTrabajadorCategoria = h.IdConvenioLaboralTrabajadorCategoria
     AND (FechaTermino IS NULL OR FechaTermino >= GETDATE()) ) AS LibreMonitoreo,

    (SELECT TOP 1 Incidencia FROM vwLicenciasTrabajadores AS bb  
     WHERE h.IdConvenioLaboralTrabajadorCategoria = bb.IdConvenioLaboralTrabajadorCategoria
     AND (
         (bb.FechaInicioIncidencia <= '{ FechaInicial.ToString("yyyyMMdd")}' AND bb.FechaTerminoIncidencia >= '{ FechaFinal.ToString("yyyyMMdd")}')
     )
     AND Incidencia NOT LIKE '%COMISIÓN PARA OCUPAR PLAZA VACANTE%' 
     AND Incidencia NOT LIKE '%incapacidad%' 
    ) AS Incidencia
FROM vwDatosAspirantesTrabajadoresHistorial h
INNER JOIN TrabajadoresBase tb ON h.IdTrabajador = tb.IdTrabajador  
WHERE h.IdEstructuraOrganicaFisica <> {idarea}  
AND (
    (h.FechaInicio <= '{ FechaFinal.ToString("yyyyMMdd")}' AND h.FechaTermino >= '{ FechaInicial.ToString("yyyyMMdd")}')  
    OR h.FechaTermino IS NULL
)

ORDER BY IdTrabajador, IdConvenioLaboralTrabajadorCategoria;
";

//            qTrabajadores = $@"select *,(SELECT [esexima]
//  FROM [Nomina_RelojChecadorLibre]
//  where IdConvenioLaboralTrabajadorCategoria =q.IdConvenioLaboralTrabajadorCategoria
//  and (FechaTermino is null or FechaTermino>=GETDATE() ) )
//  as LibreMonitoreo from (
//SELECT  top 1000000 ROW_NUMBER() OVER(Partition by  idtrabajador  ORDER BY idtrabajador,FechaInicio desc) AS idq ,
//DATEDIFF(MONTH, fechatermino, getdate() ) AS DateDiff,[IdConvenioLaboralTrabajadorCategoria]
//      ,[RFC]
//      ,[IdKardex]
//      ,[CURP]
//      ,[Nombre]
//      ,[ApellidoPaterno]
//      ,[ApellidoMaterno]
//      ,[Sexo]
//      ,[IdTrabajador]
//      ,[FechaAsignacion]
//      ,[ConvenioLaboral]
//      ,[RelacionLaboral]
//      ,[Categoria]
//      ,[EstructuraOrganica]
//      ,[EstructuraOrganicaPadrePlaza]
//      ,[UbicacionFisica]
//      ,[EstructuraOrganicaPadre]
//      ,[EsComisionado]
//      ,[FechaInicio]
//      ,[FechaTermino]
//      ,[IdConvenioLaboralTrabajador]
//      ,[EstatusTrabajador]
//      ,[Fotografia]
//      ,[NSS]
//      ,[CorreoElectronico]
//      ,[IdCategoria]
//      ,[IdEstructuraOrganica]
//      ,[IdRelacionLaboral]
//      ,[IdConvenioLaboral]
//      ,[IdEstructuraOrganicaPadre]
//      ,[CorreoInstitucional]
//      ,[Telefono]
//      ,[OrdenEstructuraOrganica]
//      ,[IdEstructuraOrganicaFisica]
//      ,[Antiguedad]
//      ,[Años]
//      ,[Meses]
//      ,[Dias]
//      ,[Direccion]
//      ,[CorreoTrabajo]
//      ,[TelefonoTrabajo]
//      ,[ProcesoCompletado]
//      ,[IdModalidadEstudio]
//      ,[IdDistribucionPlazaCategoria]
//      ,[IdRelacionConvenioLaboral]
//      ,[IdeEmpleadoAnt]
//      ,[EsHomologado]
//      ,[CategoriaAnteriorNova]
//      ,[RelacionConvenioLaboral]
//      ,[Pk]
//      ,[JornadaLaboral]
//      ,[HorasMinimo]
//      ,[HorasMaximo]
//      ,[EsCuotaSindical]
//      ,[FechaCuotaSindical]
//      ,[Calle]
//      ,[Colonia]
//      ,[CodigoPostal]
//      ,[NumeroExterior]
//      ,[NumeroInterior]
//      ,[MunicipioVive]
//      ,[EstadoVive]
//      ,[LocalidadVive]
//        ,EsPlazaBase
//,Incidencia= (select top 1 Incidencia from vwLicenciasTrabajadores as bb  where vwDatosAspirantesTrabajadoresHistorial.IdConvenioLaboralTrabajadorCategoria=bb.IdConvenioLaboralTrabajadorCategoria
//	and    (   
//    ((bb.FechaInicioIncidencia<='" + FechaInicial.ToShortDateString() + "' and  bb.FechaTerminoIncidencia>='" + FechaFinal.ToShortDateString() +@"' 
//	))
//	and Incidencia not like '%COMISIÓN PARA OCUPAR PLAZA VACANTE%' 
//	and Incidencia not like '%incapacidad%' 
//	)
//	  )
//  FROM  [vwDatosAspirantesTrabajadoresHistorial]
//  where " + condicionquitartrab + @"
//   (
//    IdEstructuraOrganicaFisica = "+ idarea +@"
//    AND
//    (
//      -- Registros sin fecha de término
//      FechaTermino is NULL
//      OR
//      -- Registros que terminan después o exactamente el ft
//      cast(FechaTermino as date) >= '"+ FechaFinal.ToString("yyyyMMdd") + @"'
//      OR
//      -- Registros que terminan entre el fi y el ft
//      (cast(FechaTermino as date) <= '"+ FechaFinal.ToString("yyyyMMdd") + @"' AND cast(FechaTermino as date) >= '" + FechaInicial.ToString("yyyyMMdd") + @"')
//      OR
//      -- Registros que han terminado hace menos de 3 meses
//      DATEDIFF(MONTH, fechatermino, cast('"+ FechaFinal.ToString("yyyyMMdd") + @"' as date)) < 3
//    )
//    AND
//    (
//      -- Registros que inician antes o exactamente el fi
//      cast(FechaInicio as date) <= '" + FechaInicial.ToString("yyyyMMdd") + @"'
//      OR
//      -- Registros de tipo BASE
//      ConvenioLaboral = 'BASE'
//      OR
//      -- Registros que inician entre el fi y ft
//      (cast(FechaInicio as date) >= '" + FechaInicial.ToString("yyyyMMdd") + @"' AND cast(FechaInicio as date) <= '"+ FechaFinal.ToString("yyyyMMdd") + @"')
//    )
//  ) and IdEstructuraOrganicaFisica=" + idarea +
//  " order by  FechaInicio desc " +
//  ") as q   where q.estatustrabajador<>'PROXIMAMENTE' order by IdTrabajador, IdConvenioLaboralTrabajadorCategoria ";

   

            //agregar a los de confianza comisionados
            string sqlcxonfianza = $@"select b.IdConvenioLaboralTrabajadorCategoria from [Nomina_SuplenciasSolicitudes] a
  inner join [Convenios_SuplenciasControl] b on a.IdSuplenciaSolicitud=b.IdSuplenciaSolicitud
  inner join [Convenios_stConvenioLaboralTrabajadorCategoria] c on c.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
  inner join Plazas_stDistribucionPlazaCategoria e on e.IdDistribucionPlazaCategoria=c.IdDistribucionPlazaCategoria
  inner join Plazas_ctCategoria f on f.IdCategoria=e.IdCategoria
  inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral=f.IdRelacionConvenioLaboral
    where   and a.EsAtendida=1 
	and RelacionConvenioLaboral like '%CONFIANZA%'";

            List<vwDatosAspirantesTrabajadoresAsistencias> t = (List<vwDatosAspirantesTrabajadoresAsistencias>)dp.connection.Query<vwDatosAspirantesTrabajadoresAsistencias>(qTrabajadores);

          
            //var t = FiltrarRegistrosPorTrabajador(tempo, FechaInicial, FechaFinal);



            string idTrabajadores = string.Join(",", t.Select(trabajador => trabajador.IdTrabajador));
            string idconveniostrabjadores = string.Join(",", t.Select(trabajador => trabajador.IdConvenioLaboralTrabajadorCategoria));

            string comisionestrabajadoresquery = $@" select *  FROM  [vwLicenciasTrabajadores] where  
                    TipoIncidenciaPermiso not like '%incapacidad%' and  
                idTrabajador in({idTrabajadores})
                and  (FechaInicioIncidencia BETWEEN '{FechaInicial.ToShortDateString()}' AND '{FechaFinal.ToShortDateString()}'
                    OR FechaTerminoIncidencia BETWEEN '{FechaInicial.ToShortDateString()}' AND '{FechaFinal.ToShortDateString()}'
                    OR ('{FechaInicial.ToShortDateString()}' BETWEEN FechaInicioIncidencia AND FechaTerminoIncidencia
                    OR '{FechaFinal.ToShortDateString()}' BETWEEN FechaInicioIncidencia AND FechaTerminoIncidencia)
                    or estatus='PROXIMA'
                    )";

            List<vwLicenciasTrabajadores> comisionestrabajadores = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(comisionestrabajadoresquery);

            comisionestrabajadores.RemoveAll(item => item.FechaTerminoIncidencia <= FechaFinal);

            string idIdIncidenciaTrabajadores = string.Join(",", comisionestrabajadores.Select(trabajador => trabajador.IdIncidenciaTrabajador));

            List<Convenios_SuplenciasControl> incidencialistascomisiones = new List<Convenios_SuplenciasControl>();
            if (idIdIncidenciaTrabajadores.Length > 0)
            {
                string sql = $@" select * from 
                    Convenios_SuplenciasControl where IdIncidenciaTrabajador in ( {idIdIncidenciaTrabajadores})";

                incidencialistascomisiones = (List<Convenios_SuplenciasControl>)dp.connection.Query<Convenios_SuplenciasControl>(sql);
            }



            qIncidencias = @" select a.IdConvenioLaboralTrabajadorCategoria, a.IdIncidenciaTrabajador,a.FechaInicio,a.FechaTermino,a.Horas,a.tiempofuera,d.IdTrabajador,e.Nombre+' '+e.ApellidoPaterno+' '+e.ApellidoMaterno as Trabajador
,CASE WHEN j.RelacionLaboral='DOCENTE' then a.Horas else DATEDIFF(day, b.FechaInicio,a.FechaTermino) end as DiasHorasIncidencia
,CASE WHEN k.Incidencia='DÍAS ECONÓMICOS' then DATEDIFF(day, b.FechaInicio,a.FechaTermino) ELSE 0 end DiasEconomicos
,ka.Nombre+' '+ka.ApellidoPaterno+' '+ka.ApellidoMaterno as QuienAutorizo
,kj.Nombre+' '+kj.ApellidoPaterno+' '+kj.ApellidoMaterno as QuienJustifico
,kr.Nombre+' '+kr.ApellidoPaterno+' '+kr.ApellidoMaterno as QuienRegistro
,k.Incidencia, k.Nomenclatura,k.Color
,ij.IncidenciaJustificacion as IncidenciaJustico,ij.Nomenclatura as NomenclaturaJustifico,ij.Color ColorJustifico
,a.IdNominaTrabajador,f.EstructuraOrganica,h.Categoria
,a.Observaciones,j.RelacionLaboral,l.ConvenioLaboral,a.EsAplicada,a.Autorizo,a.DescripcionJustificacion
,a.FechaAutorizacion,a.FechaCreacion,a.FechaJustificacion
,a.EsJustificacionExtemporanea
,a.IdIncidenciaJustificacion
,a.EsCancelada
,a.EsCerrada
,a.EsFaltaDirecta
,e.CURP
,b.FechaTermino as FechaTerminoConvenio
,f.IdModalidadEstudio
,a.QuincenaParaNomina
,a.AñoParaNomina
from 
IncidenciaPermiso_stIncidenciaTrabajador a " +
           " inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria" +
           " inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador" +
           " inner join Kardex_ctTrabajador d on d.IdTrabajador = c.IdTrabajador" +
           " inner join Kardex_ctDatosPersonales e on d.IdKardex= e.IdKardex" +
           " inner join Catalogos_ctEstructuraOrganica f on b.IdEstructuraOrganica =f.IdEstructuraOrganica" +
           " inner join Plazas_stDistribucionPlazaCategoria g on b.IdDistribucionPlazaCategoria=g.IdDistribucionPlazaCategoria" +
           " inner join Plazas_ctCategoria h on g.IdCategoria=h.IdCategoria" +
           " inner join Convenios_stRelacionConvenioLaboral i on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral" +
           " inner join Catalogos_ctRelacionLaboral j on i.IdRelacionLaboral=j.IdRelacionLaboral" +
           " inner join Catalogos_ctTipoIncidencia k on a.IdTipoIncidencia=k.IdTipoIncidencia" +
           " inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=i.IdConvenioLaboral" +
           " left join Convenios_stConvenioLaboralTrabajadorCategoria ca on a.IdConvenioLaboralTrabajadorCategoriaAutorizo=ca.IdConvenioLaboralTrabajadorCategoria" +
           " left join Convenios_stConvenioLaboralTrabajador la on la.IdConvenioLaboralTrabajador= ca.IdConvenioLaboralTrabajador" +
           " left join Kardex_ctTrabajador ta on ta.IdTrabajador=la.IdTrabajador" +
           " left join Kardex_ctDatosPersonales ka on ka.IdKardex = ta.IdKardex" +
           " left join Convenios_stConvenioLaboralTrabajadorCategoria cj on a.IdConvenioLaboralTrabajadorCategoriaJustifico=cj.IdConvenioLaboralTrabajadorCategoria" +
           " left join Convenios_stConvenioLaboralTrabajador lj on lj.IdConvenioLaboralTrabajador= cj.IdConvenioLaboralTrabajador" +
           " left join Kardex_ctTrabajador tj on tj.IdTrabajador=lj.IdTrabajador" +
           " left join Kardex_ctDatosPersonales kj on kj.IdKardex = tj.IdKardex" +
           " left join Convenios_stConvenioLaboralTrabajadorCategoria cr on a.IdConvenioLaboralTrabajadorCategoriaRegistro=cr.IdConvenioLaboralTrabajadorCategoria" +
           " left join Convenios_stConvenioLaboralTrabajador lr on lr.IdConvenioLaboralTrabajador= cr.IdConvenioLaboralTrabajador" +
           " left join Kardex_ctTrabajador tr on tr.IdTrabajador=lr.IdTrabajador" +
           " left join Kardex_ctDatosPersonales kr on kr.IdKardex = tr.IdKardex" +
           " left join Incidencia_ctJustificacion ij on ij.IdIncidenciaJustificacion = a.IdIncidenciaJustificacion" +
           " where a.IdConvenioLaboralTrabajadorCategoria in " +
                      "(" + idconveniostrabjadores + ")  " +
                      "and ( a.IdTipoIncidencia in (2,31,36,8,32,37,38,35,43,58,47)) " +
                      " and cast(a.FechaInicio as date)>=" + "'" + FechaInicial.ToShortDateString() + "'" + " and cast(a.FechaTermino as date)<=" + "'" + FechaFinal.ToShortDateString() + "'" +
            " order by 23 ,35";

            // " where b.IdEstructuraOrganica in " +
            //          "(select idestructuraOrganicafisica from vwdatosaspirantestrabajadoreshistorial where " +
            //          " idtrabajador in (select idtrabajador from vwdatosaspirantestrabajadoreshistorial where idestructuraOrganicafisica = " + idarea + " ) )  " +
            //          "and ( a.IdTipoIncidencia in (2,31,36,8,32,37,38,35,43,58,47)) " +
            //          " and cast(a.FechaInicio as date)>=" + "'" + FechaInicial.ToShortDateString() + "'" + " and cast(a.FechaTermino as date)<=" + "'" + FechaFinal.ToShortDateString() + "'" +
            //" order by 23 ,35";
            List<IncidenciaTrabajador> ti = (List<IncidenciaTrabajador>)dp.connection.Query<IncidenciaTrabajador>(qIncidencias);

            string verificainicidencasenotroconvenio = $@"select IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,nombrecompleto,categoria,
d.UbicacionFisica,d.EstructuraOrganica,count(IdTrabajador) as TotalIncidencias
  from [IncidenciaPermiso_stIncidenciaTrabajador] a
  inner join [vwDatosAspirantesTrabajadoresHistorial] d on a.IdConvenioLaboralTrabajadorCategoria=d.IdConvenioLaboralTrabajadorCategoria
  --inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador 
  inner join Catalogos_ctTipoIncidencia s on s.IdTipoIncidencia=a.IdTipoIncidencia
 inner join Catalogos_ctTipoIncidenciaPermiso t on s.IdTipoIncidenciaPermiso=t.IdTipoIncidenciaPermiso
 where 
 cast(a.FechaInicio as date)>='{FechaInicial.ToShortDateString()}' and cast(a.FechaTermino as date)<='{FechaFinal.ToShortDateString()}'
 and 
 TipoIncidenciaPermiso='INCIDENCIA' AND Autorizo=0 and a.IdNominaTrabajador is null
and idtrabajador in ({idTrabajadores}) and d.idestructuraorganicafisica<>{idarea}
 group by IdTrabajador,a.IdConvenioLaboralTrabajadorCategoria,nombrecompleto,categoria,d.UbicacionFisica,d.EstructuraOrganica";

            
                    List<IncidenciasTotalesTrabajador> incidenciasOtraArea = (List<IncidenciasTotalesTrabajador>)dp.connection.Query<IncidenciasTotalesTrabajador>(verificainicidencasenotroconvenio);


            string qeuryasiste = $@" select  [IdRelojChecadorAsistencia]
      ,a.[IdEstructuraOrganica]
      ,a.[IdModalidadEstudio]
      ,[iGLCount]
      ,[IdTrabajador]
      ,[idwVerifyMode]
      ,[idwInOutMode]
      ,[FechaAsistencia]
      ,[Workcode]
      ,[IdConvenioLaboralTrabajadorCategoria]
      ,[EsProcesada]
      ,[IdTrabajadorReloj]
      ,b.EstructuraOrganica FROM Nomina_RelojChecadorAsistencia a 
      inner join [Nomina_RelojChecadorAreas] b on a.IdEstructuraOrganica=b.IdEstructuraOrganica
     where CAST(FechaAsistencia  as date) >= CAST('{FechaInicial.ToString("yyyyMMdd")}' as date) and CAST(FechaAsistencia  as date) <= CAST('{FechaFinal.ToString("yyyyMMdd")}' as date)
        and idtrabajador in ({idTrabajadores}) order by idtrabajador,FechaAsistencia ";

            List<Nomina_RelojChecadorAsistenciaEstructura> asistenciaT = (List<Nomina_RelojChecadorAsistenciaEstructura>)dp.connection.Query<Nomina_RelojChecadorAsistenciaEstructura>(qeuryasiste);


            string reloj = $@"select 
			z.EstructuraOrganica,c.IdEstructuraOrganica as IdReloj
			from [Nomina_RelojChecadorAreasEstructuraOrganica] x
			inner join Catalogos_ctEstructuraOrganica z on x.IdEstructuraOrganica=z.IdEstructuraOrganica
			inner join [Nomina_RelojChecadorAreas] c on c.IdRelojChecadorAreas=x.IdRelojChecadorAreas
			where x.IdRelojChecadorAreas in(
			SELECT b.IdRelojChecadorAreas
                FROM [Nomina_RelojChecadorAreasEstructuraOrganica] a
                inner join [Nomina_RelojChecadorAreas] b on a.[IdRelojChecadorAreas]=b.[IdRelojChecadorAreas] 
            WHERE a.[IdEstructuraOrganica]={idarea}
			)";

            List<AreasReloj> areareloj = (List<AreasReloj>)dp.connection.Query<AreasReloj>(reloj);

            string arearelojcadena = string.Join("", areareloj.Select(s => s.EstructuraOrganica));

            ViewBag.IdReloj =areareloj.FirstOrDefault().IdReloj;
            ViewBag.AreasRelojCadena = arearelojcadena;


            dp.Close();

            List<LeyendasReporte> lLey = new List<LeyendasReporte>();
            List<LeyendasReporte> lLey2 = new List<LeyendasReporte>();

            lLey = ti.Where(z => z.IdIncidenciaJustificacion != 0).GroupBy(x => new { x.IncidenciaJustico, x.NomenclaturaJustifico }).Select(z => new LeyendasReporte { Incidencia = z.Key.IncidenciaJustico, Nomenclatura = z.Key.NomenclaturaJustifico }).ToList();
            lLey2 = ti.Where(z => z.IdIncidenciaJustificacion == 0 && z.Incidencia != null).GroupBy(x => new { x.Incidencia, x.Nomenclatura }).Select(z => new LeyendasReporte { Incidencia = z.Key.Incidencia, Nomenclatura = z.Key.Nomenclatura }).ToList();
            lLey.AddRange(lLey2);
            ViewBag.LeyendasReporte = lLey;
            // Grupo por Idtrabajador
           // var trabajadores = t.GroupBy(x => x.IdTrabajador).Select(z => new { IdTrabajador = z.Key }).ToList();
            var encuentracerrada = ti.Where(z => z.EsCerrada == true).ToList();
            ViewBag.ReporteValido = "NO";
            if (encuentracerrada.Count > 0)
            {
                ViewBag.ReporteValido = "SI";
            }

            ViewBag.NombreArea = db.Catalogos_ctEstructuraOrganica.AsNoTracking().Where(z => z.IdEstructuraOrganica == idarea).FirstOrDefault().EstructuraOrganica;
            var datosdirector = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(z => (z.Categoria == "RESPONSABLE DEL CENTRO \"A\"" ||
                                                   z.Categoria == "RESPONSABLE DEL CENTRO \"B\"" ||
                                                   z.Categoria == "RESPONSABLE DEL CENTRO \"C\"" ||
                                                   z.Categoria == "DIRECTOR DE PLANTEL \"A\"" ||
                                                    z.Categoria == "JEFE DE DEPARTAMENTO" ||
                                                    z.Categoria == "SUBDIRECTOR DE ÁREA" ||
                                                    z.Categoria == "DIRECTOR DE ÁREA" ||
                                                    z.Categoria == "DIRECTOR GENERAL" ||
                                                   z.Categoria == "DIRECTOR DE PLANTEL \"B\"") && z.IdEstructuraOrganicaFisica == idarea && z.EstatusTrabajador == "ALTA").FirstOrDefault();
            if (datosdirector == null)
            {
                var jefe = db.Catalogos_ctEstructuraOrganica.AsNoTracking().Where(s => s.IdEstructuraOrganica == idarea).FirstOrDefault();

                var responsable = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(z => (z.Categoria == "RESPONSABLE DEL CENTRO \"A\"" ||
                                                   z.Categoria == "RESPONSABLE DEL CENTRO \"B\"" ||
                                                   z.Categoria == "RESPONSABLE DEL CENTRO \"C\"" ||
                                                   z.Categoria == "DIRECTOR DE PLANTEL \"A\"" ||
                                                    z.Categoria == "JEFE DE DEPARTAMENTO" ||
                                                    z.Categoria == "SUBDIRECTOR DE ÁREA" ||
                                                    z.Categoria == "DIRECTOR DE ÁREA" ||
                                                    z.Categoria == "DIRECTOR GENERAL" ||
                                                   z.Categoria == "DIRECTOR DE PLANTEL \"B\"") && z.IdEstructuraOrganicaFisica == jefe.IdEstructuraOrganicaPadre && z.EstatusTrabajador == "ALTA").FirstOrDefault();
                if (responsable != null)
                    //ViewBag.DirectorArea = responsable.Nombre + " " + responsable.ApellidoPaterno + " " + responsable.ApellidoMaterno; 
                    ViewBag.DirectorArea = responsable;
                else
                    //ViewBag.DirectorArea = "";
                    ViewBag.DirectorArea = null;

            }
            else
            {
                //ViewBag.DirectorArea = datosdirector.Nombre + " " + datosdirector.ApellidoPaterno + " " + datosdirector.ApellidoMaterno;
                ViewBag.DirectorArea = datosdirector;

            }
            //var usuario = Seguridad.Identidad.Usuario();

            DapperQuery dpmesa = new DapperQuery("bdNovaEntities");
    
            string querymesa;
            querymesa = @"SELECT d.Nombre,d.ApellidoPaterno,d.ApellidoMaterno
                      FROM [bdNova].[dbo].[Nomina_RelojChecadorAreasEstructuraOrganica] a
                      inner join Nomina_RelojChecadorControlUsuarios b on a.IdRelojChecadorAreas=b.IdRelojChecadorAreas 
                      inner join Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganica=c.IdEstructuraOrganica
                      inner join vwDatosAspirantesTrabajadores d on d.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                      where c.IdEstructuraOrganica=" + idarea + @" and EstatusTrabajador='ALTA' and d.RestringirMenu is null";


           // List<NombreMesa> nombremesa = (List<NombreMesa>)dp.connection.Query<NombreMesa>(querymesa);

            dpmesa.Close();
            //if (nombremesa.Count() == 0)
            //{
            //    ViewBag.NombreUsuario = "";
            //}
            //else
            //{
            //    ViewBag.NombreUsuario = nombremesa.FirstOrDefault().Nombre + ' ' + nombremesa.FirstOrDefault().ApellidoPaterno + ' ' + nombremesa.FirstOrDefault().ApellidoPaterno;
            //}
            //ViewBag.NombreUsuario = usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            // Grupo por Idtrabajador
            //var trabajadores = t.Where(a => (a.Incidencia==null )  ).GroupBy(x => new { x.IdTrabajador, x.IdConvenioLaboralTrabajadorCategoria }).Select(z => new { IdTrabajador = z.Key.IdTrabajador, IdConvenioLaboralTrabajadorCategoria = z.Key.IdConvenioLaboralTrabajadorCategoria }).ToList();
            var trabajadores = t.GroupBy(x => new { x.IdTrabajador, x.IdConvenioLaboralTrabajadorCategoria }).Select(z => new { IdTrabajador = z.Key.IdTrabajador, IdConvenioLaboralTrabajadorCategoria = z.Key.IdConvenioLaboralTrabajadorCategoria }).ToList();
            // pivot incidencias por trabajador
            List<VistaIncidenciaTrabajador> Listaincidencias = new List<VistaIncidenciaTrabajador>();
            // Obtiene día inicial y final de la quincena
            short diainicialquincena = Convert.ToByte(FechaInicial.ToShortDateString().Substring(0, 2));
            short diafinalquincena = Convert.ToByte(FechaFinal.ToShortDateString().Substring(0, 2));
            short diaincidencia = 0;
            ViewBag.diainicialquincena = diainicialquincena;
            ViewBag.diafinalquincena = diafinalquincena;
            ViewBag.FechaInicial = FechaInicial.Date;
            ViewBag.FechaFinal = FechaFinal.Date;
            int faltas;
            int permisoseconomicos;
            string tobservaciones;
            Boolean puntualidadasistencia = false;
            var idsTrabajadoresConDuplicados = t
   .GroupBy(x => x.IdTrabajador)
   .Where(g => g.Count() > 1)
   .Select(g => g.Key)
   .ToList();

            foreach (var p in trabajadores)
            {

                

                   

                var datostrabajador = t.Where(x => x.IdTrabajador == p.IdTrabajador && x.IdConvenioLaboralTrabajadorCategoria == p.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                var haycomision = t.Where(a => a.IdTrabajador == p.IdTrabajador && a.IdConvenioLaboralTrabajadorCategoria == p.IdConvenioLaboralTrabajadorCategoria )
                //&& a.ESTATUS!="PROXIMA").OrderBy(q => q.FechaInicioIncidencia)
                .FirstOrDefault();
                bool existecontinuacion = false;
                //if (haycomision != null)
                //{
                //    var siguiente = comisionestrabajadores.Where(a => a.IdTrabajador == p.IdTrabajador
                //     && a.FechaInicioIncidencia==haycomision.FechaTerminoIncidencia.Value.AddDays(+1) ).FirstOrDefault();
                //    if (siguiente != null)
                //        existecontinuacion = true;
                //}
                

                //  var idconvenioltc = t.Where(a => a.IdTrabajador == p.IdTrabajador).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = (int)datostrabajador.IdTrabajador;
                string Trabajador = datostrabajador.Nombre + " " + datostrabajador.ApellidoPaterno + " " + datostrabajador.ApellidoMaterno;
                string Categoria = datostrabajador.Categoria;
                string RelacionLaboral = datostrabajador.RelacionLaboral;
                string ConvenioLaboral = datostrabajador.ConvenioLaboral;
                int IdModalidadEstudio = (int)datostrabajador.IdModalidadEstudio;
                string Estatus = datostrabajador.EstatusTrabajador;

                faltas = 0;
                permisoseconomicos = 0;
                tobservaciones = "";
                VistaIncidenciaTrabajador vit = new VistaIncidenciaTrabajador();

                string contratodetalle = "";
                bool entro = false;

                var existefaltasenotrolugar = incidenciasOtraArea.Where(z => z.IdTrabajador == p.IdTrabajador).FirstOrDefault();
                if (existefaltasenotrolugar != null)
                {
                    vit.ExisteFaltasEnOtraArea = $"Verifique que sean correctas las faltas para {existefaltasenotrolugar.NombreCompleto} en :{existefaltasenotrolugar.UbicacionFisica} para esta quincena.";
                }
                 
                if (idsTrabajadoresConDuplicados.Where(a => a.Value == p.IdTrabajador).FirstOrDefault() != null)
                {
                    if ((bool)datostrabajador.EsPlazaBase )
                    {
                        //contratodetalle = $"{Categoria} | {haycomision.FechaInicioIncidencia.ToString("yyyy-MM-dd")} - {haycomision.FechaTerminoIncidencia.Value.ToString("yyyy-MM-dd")}- {haycomision.UbicacionFisicaComision} ";
                        //vit.ExisteComision = "COMISION";
                        contratodetalle = $"";
                        vit.ExisteComision = "PLAZA";
                        entro = true;
                    }
                    else {
                        if (haycomision != null)
                        {
                            string ftcom = "";
                            if (haycomision.FechaTermino.HasValue)
                                ftcom = haycomision.FechaTermino.Value.ToString("yyyy-MM-dd");
                            contratodetalle = $"{Categoria} | {haycomision.FechaInicio.Value.ToString("yyyy-MM-dd")} - {ftcom} | {haycomision.UbicacionFisica} ";
                            vit.ExisteComision = "COMISION";
                            vit.ContratoFechas = contratodetalle;
                            entro = true;
                        }
                    }
                }

                //if (haycomision != null)
                //{
                //    var hayincidenciacomision = incidencialistascomisiones.Where(a => a.IdIncidenciaTrabajador == haycomision.IdIncidenciaTrabajador).FirstOrDefault();
                //    if (hayincidenciacomision != null)
                //    {
                //        if (hayincidenciacomision.IdConvenioLaboralTrabajadorCategoriaCubierto == p.IdConvenioLaboralTrabajadorCategoria)
                //        { //es la comision aqui debe de haber una ubicacionfisica
                //            contratodetalle = $"{Categoria} | {haycomision.FechaInicioIncidencia.ToString("yyyy-MM-dd")} - {haycomision.FechaTerminoIncidencia.Value.ToString("yyyy-MM-dd")}- {haycomision.UbicacionFisicaComision} ";
                //            vit.ExisteComision = "COMISION";
                //        }
                //        else
                //        {// si son igualea es contrato nuevo
                //            if (hayincidenciacomision.IdConvenioLaboralTrabajadorCategoria != p.IdConvenioLaboralTrabajadorCategoria
                //        && hayincidenciacomision.IdConvenioLaboralTrabajadorCategoriaAnterior != p.IdConvenioLaboralTrabajadorCategoria)
                //            {
                //                contratodetalle = $"{Categoria} {haycomision.FechaInicioIncidencia.ToString("yyyy-MM-dd")} - {haycomision.FechaTerminoIncidencia.Value.ToString("yyyy-MM-dd")} - {datostrabajador.UbicacionFisica} ({haycomision.EstructuraOrganica}) ";
                //                vit.ExisteComision = "PLAZA";
                //            }
                //        }


                //    }
                //    else
                //    {
                //        if (haycomision.FechaTermino != null)
                //            contratodetalle = $"{Categoria} {haycomision.FechaInicio} - {haycomision.FechaTermino}- {haycomision.UbicacionFisicaComision}";
                //        else
                //            contratodetalle = $"{Categoria} {haycomision.FechaInicio} - {haycomision.UbicacionFisicaComision}";
                //    }

                if (!entro)
                {
                    DateTime _fechatermino=DateTime.Now;
                    if (haycomision.FechaTermino != null)
                        _fechatermino = haycomision.FechaTermino.Value;

                    if (haycomision != null && _fechatermino >= FechaFinal.Date)
                    {
                        if ((bool)datostrabajador.EsPlazaBase)
                        {

                            //vit.ExisteComision = "PLAZA";

    //                        var comisionfecha = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking()
    //.Where(a => a.IdTrabajador == datostrabajador.IdTrabajador &&
    //            a.IdConvenioLaboralTrabajadorCategoria != datostrabajador.IdConvenioLaboralTrabajadorCategoria &&
    //            (DbFunctions.TruncateTime(FechaInicial) >= DbFunctions.TruncateTime(a.FechaInicio) &&
    //             DbFunctions.TruncateTime(FechaInicial) <= DbFunctions.TruncateTime(a.FechaTermino) ||
    //             DbFunctions.TruncateTime(FechaFinal) >= DbFunctions.TruncateTime(a.FechaInicio) &&
    //             DbFunctions.TruncateTime(FechaFinal) <= DbFunctions.TruncateTime(a.FechaTermino) ||
    //             DbFunctions.TruncateTime(a.FechaInicio) >= DbFunctions.TruncateTime(FechaInicial) &&
    //             DbFunctions.TruncateTime(a.FechaInicio) <= DbFunctions.TruncateTime(FechaFinal)))
     
    //.FirstOrDefault();

    //                        if (comisionfecha!=null)
    //                            contratodetalle = $"{comisionfecha.Categoria} | {comisionfecha.FechaInicio.Value.ToString("yyyy-MM-dd")} - {comisionfecha.FechaInicio.Value.ToString("yyyy-MM-dd")}- {comisionfecha.UbicacionFisica} ";
    //                        vit.ExisteComision = "COMISION";
                            //vit.ContratoFechas = contratodetalle;
                        }
                    }
                }
                //else
                //    vit.ContratoFechas = contratodetalle;



                //}

              

                vit.LibreMonitoreo = datostrabajador.LibreMonitoreo;
                // se agrego el convenio par poder identificar si fue una comsiion en la que estuvo en una quince determinada

                vit.IdConvenioLaboralTrabajadorCategoria = (int)p.IdConvenioLaboralTrabajadorCategoria;
                vit.Id = IdTrabajador;
                vit.Trabajador = Trabajador;
                vit.Categoria = Categoria;
                vit.ConvenioLaboral = ConvenioLaboral;
                vit.RelacionLaboral = RelacionLaboral;
                vit.Ftc = null;
                vit.IdModalidadEstudio = IdModalidadEstudio;
                vit.Estatus = Estatus;
                if (datostrabajador.FechaTermino.HasValue)
                {
                    vit.Ftc = datostrabajador.FechaTermino.Value;
                    
                }
                vit.FechaInicioContrato = datostrabajador.FechaInicio.Value;


                for (DateTime date = FechaInicial; date <= FechaFinal; date = date.AddDays(1.0))
                {
                    bool deberProcesar = true;

                    if ((bool)datostrabajador.EsPlazaBase == true)
                    {
                        if (haycomision != null)
                        {
                            DateTime _fterminoc = new DateTime();
                            if (haycomision.FechaTermino.HasValue)
                                _fterminoc = haycomision.FechaTermino.Value;

                            bool fechaEnRango = haycomision.FechaInicio<= date && (date <= _fterminoc ||  haycomision.FechaTermino==null ) ;

                            bool fechaINicioEnRango = date>=haycomision.FechaInicio && (date <= _fterminoc || haycomision.FechaTermino == null);
                            //  bool fechaEnRango2 = haycomision.FechaInicioIncidencia.Year==date.Year && date.Month == haycomision.FechaInicioIncidencia.Month;
                            string incidencia = "";
                            if (haycomision.Incidencia != null)
                            {
                                incidencia = haycomision.Incidencia;
                            }
                            if (!incidencia.Contains("LICENCIA SIN GOCE DE SUELDO PARA") && !fechaEnRango )
                            {
                                deberProcesar = false; // Si la fecha está dentro del rango de la comisión, no debemos procesar
                            }

                            if (!fechaINicioEnRango && !existecontinuacion)
                            {
                                deberProcesar = false; // Si la fecha está dentro del rango de la comisión, no debemos procesar
                            }

                            if (fechaINicioEnRango && deberProcesar == false )
                            {
                                deberProcesar = true; // Si la fecha está dentro del rango de la comisión, no debemos procesar
                            }
                            //else
                            //if (!fechaEnRango2)
                            //{
                            //    deberProcesar = false; // Si la fecha está dentro del rango de la comisión, no debemos procesar
                            //}

                            //if (!haycomision.Incidencia.Contains("LICENCIA SIN GOCE DE SUELDO PARA") && haycomision.FechaInicioIncidencia < date && date < haycomision.FechaTerminoIncidencia)
                            //{
                            //    deberProcesar = false; // Si la fecha está dentro del rango de la comisión, no debemos procesar

                            //}
                        }
                    }
                    else
                    {
                        deberProcesar = false;
                        if ((date >= datostrabajador.FechaInicio &&
                            date <= datostrabajador.FechaTermino))
                        {
                            deberProcesar = true; // No procesar si está dentro del rango del trabajador o un día antes/después
                        }
                        else
                            if (datostrabajador.FechaInicio >= date && datostrabajador.FechaTermino >= date)
                            deberProcesar = true;
                    }
                    bool procesar = false;
                    
                    if (deberProcesar)
                    {
                        if (datostrabajador.EsPlazaBase==true)
                        {
                            var sinpermisos = t.Where(a => a.IdTrabajador == datostrabajador.IdTrabajador && a.IdConvenioLaboralTrabajadorCategoria != datostrabajador.IdConvenioLaboralTrabajadorCategoria).ToList();
                            bool existe = sinpermisos.Any(r => date >= r.FechaInicio && date <= r.FechaTermino);
                            if (!existe)
                                procesar = true;
                        }
                        else
                        {
                            if (datostrabajador.FechaInicio <= date && (datostrabajador.FechaTermino >= date || datostrabajador.FechaTermino == null))
                            {
                                procesar = true;
                            }
                        }

                        var incidenciasTrabajadordia = ti.Where(z => z.IdTrabajador == p.IdTrabajador && z.IdConvenioLaboralTrabajadorCategoria == p.IdConvenioLaboralTrabajadorCategoria && z.FechaInicio.Year == date.Year && z.FechaInicio.Month == date.Month && z.FechaInicio.Day == date.Day).ToList();
                        var asistenciasDelTrabajadorPorDia = asistenciaT.Where(w =>
                        w.FechaAsistencia.Year == date.Year && w.FechaAsistencia.Month == date.Month && w.FechaAsistencia.Day == date.Day
                        && w.IdTrabajador == p.IdTrabajador).Select(a => new AsistencasDelTrabajador
                        {
                            IdTrabajador = a.IdTrabajador,
                            EsProcesada = a.EsProcesada,
                            Hora = a.FechaAsistencia,
                            EstructuraOrganica = IncidenciaPermiso_stIncidenciaTrabajador.ObtenerPrimerasLetras(a.EstructuraOrganica)
                        }).ToList();

                        // Verifica a que día corresponde
                        diaincidencia = Convert.ToByte(date.ToShortDateString().Substring(0, 2));

                        switch (diaincidencia)
                        {
                            case 1:

                                vit.AsistencasDelTrabajadorDia1 = asistenciasDelTrabajadorPorDia;
                                vit.vD1 = procesar;
                                break;
                            case 2:

                                vit.AsistencasDelTrabajadorDia2 = asistenciasDelTrabajadorPorDia;
                                vit.vD2 = procesar;
                                break;
                            case 3:

                                vit.AsistencasDelTrabajadorDia3 = asistenciasDelTrabajadorPorDia;
                                vit.vD3 = procesar;
                                break;
                            case 4:

                                vit.AsistencasDelTrabajadorDia4 = asistenciasDelTrabajadorPorDia;
                                vit.vD4 = procesar;
                                break;
                            case 5:

                                vit.AsistencasDelTrabajadorDia5 = asistenciasDelTrabajadorPorDia;
                                vit.vD5 = procesar;
                                break;
                            case 6:

                                vit.AsistencasDelTrabajadorDia6 = asistenciasDelTrabajadorPorDia;
                                vit.vD6 = procesar;
                                break;
                            case 7:

                                vit.AsistencasDelTrabajadorDia7 = asistenciasDelTrabajadorPorDia;
                                vit.vD7 = procesar;
                                break;
                            case 8:

                                vit.AsistencasDelTrabajadorDia8 = asistenciasDelTrabajadorPorDia;
                                vit.vD8 = procesar;
                                break;
                            case 9:

                                vit.AsistencasDelTrabajadorDia9 = asistenciasDelTrabajadorPorDia;
                                vit.vD9 = procesar;
                                break;
                            case 10:

                                vit.AsistencasDelTrabajadorDia10 = asistenciasDelTrabajadorPorDia;
                                vit.vD10 = procesar;
                                break;
                            case 11:

                                vit.AsistencasDelTrabajadorDia11 = asistenciasDelTrabajadorPorDia;
                                vit.vD11 = procesar;
                                break;
                            case 12:

                                vit.AsistencasDelTrabajadorDia12 = asistenciasDelTrabajadorPorDia;
                                vit.vD12 = procesar;
                                break;
                            case 13:

                                vit.AsistencasDelTrabajadorDia13 = asistenciasDelTrabajadorPorDia;
                                vit.vD13 = procesar;
                                break;
                            case 14:

                                vit.AsistencasDelTrabajadorDia14 = asistenciasDelTrabajadorPorDia;
                                vit.vD14 = procesar;
                                break;
                            case 15:

                                vit.AsistencasDelTrabajadorDia15 = asistenciasDelTrabajadorPorDia;
                                vit.vD15 = procesar;
                                break;
                            case 16:

                                vit.AsistencasDelTrabajadorDia1 = asistenciasDelTrabajadorPorDia;
                                vit.vD16 = procesar;
                                break;
                            case 17:

                                vit.AsistencasDelTrabajadorDia2 = asistenciasDelTrabajadorPorDia;
                                vit.vD2 = procesar;
                                break;
                            case 18:

                                vit.AsistencasDelTrabajadorDia3 = asistenciasDelTrabajadorPorDia;
                                vit.vD3 = procesar;
                                break;
                            case 19:

                                vit.AsistencasDelTrabajadorDia4 = asistenciasDelTrabajadorPorDia;
                                vit.vD4= procesar;
                                break;
                            case 20:

                                vit.AsistencasDelTrabajadorDia5 = asistenciasDelTrabajadorPorDia;
                                vit.vD5 = procesar;
                                break;
                            case 21:

                                vit.AsistencasDelTrabajadorDia6 = asistenciasDelTrabajadorPorDia;
                                vit.vD6 = procesar;
                                break;
                            case 22:

                                vit.AsistencasDelTrabajadorDia7 = asistenciasDelTrabajadorPorDia;
                                vit.vD7 = procesar;
                                break;
                            case 23:

                                vit.AsistencasDelTrabajadorDia8 = asistenciasDelTrabajadorPorDia;
                                vit.vD8 = procesar;
                                break;
                            case 24:

                                vit.AsistencasDelTrabajadorDia9 = asistenciasDelTrabajadorPorDia;
                                vit.vD9 = procesar;
                                break;
                            case 25:

                                vit.AsistencasDelTrabajadorDia10 = asistenciasDelTrabajadorPorDia;
                                vit.vD10 = procesar;
                                break;
                            case 26:

                                vit.AsistencasDelTrabajadorDia11 = asistenciasDelTrabajadorPorDia;
                                vit.vD11 = procesar;
                                break;
                            case 27:

                                vit.AsistencasDelTrabajadorDia12 = asistenciasDelTrabajadorPorDia;
                                vit.vD12 = procesar;
                                break;
                            case 28:

                                vit.AsistencasDelTrabajadorDia13 = asistenciasDelTrabajadorPorDia;
                                vit.vD13 = procesar;
                                break;
                            case 29:

                                vit.AsistencasDelTrabajadorDia14 = asistenciasDelTrabajadorPorDia;
                                vit.vD14 = procesar;
                                break;
                            case 30:

                                vit.AsistencasDelTrabajadorDia15 = asistenciasDelTrabajadorPorDia;
                                vit.vD15 = procesar;
                                break;
                            case 31:

                                vit.AsistencasDelTrabajadorDia16 = asistenciasDelTrabajadorPorDia;
                                vit.vD16 = procesar;
                                break;
                            default:
                                throw new Exception("Error al procesar las asistencias del trabajador " + Trabajador);


                        }

                        if (incidenciasTrabajadordia.Count() > 0)

                        {



                            foreach (var ind in incidenciasTrabajadordia)
                            {
                                tobservaciones = tobservaciones + " " + ind.Observaciones;
                                if (ind.Nomenclatura != null)
                                {
                                    if (RelacionLaboral == "ADMINISTRATIVO")
                                    {
                                        if ((ind.Incidencia.Contains("FALTA") && ind.Autorizo == false && ind.IncidenciaJustico != "DÍA ECONÓMICO")
                                            || (ind.Incidencia.Contains("FALTA") && ind.Autorizo == true && ind.IdIncidenciaJustificacion == 0)
                                            //|| (ind.Incidencia.Contains("FALTA") && ind.IncidenciaJustico == "DÍA ECONÓMICO"  && ind.Autorizo == false)

                                            || (ind.Incidencia.Contains("OMISIÓN") && ind.Autorizo == false)

                                            )
                                        {
                                            faltas = faltas + 1;
                                        }

                                    }
                                    else
                                    {
                                        if (RelacionLaboral == "DOCENTE")
                                        {
                                            if ((ind.Incidencia.Contains("FALTA") && ind.Autorizo == false && ind.IncidenciaJustico != "DÍA ECONÓMICO")
                                            || (ind.Incidencia.Contains("FALTA") && ind.Autorizo == true && ind.IdIncidenciaJustificacion == 0)
                                            //|| (ind.Incidencia.Contains("FALTA") && ind.IncidenciaJustico == "DÍA ECONÓMICO" && ind.Autorizo == false)

                                            || (ind.Incidencia.Contains("OMISIÓN") && ind.Autorizo == false)

                                            )
                                            {
                                                faltas = faltas + ind.Horas;
                                            }

                                        }

                                    }
                                    if (ind.NomenclaturaJustifico != null)
                                    {
                                        if (
                                            (ind.IncidenciaJustico == "DÍA ECONÓMICO" && ConvenioLaboral == "BASE" && ind.FechaAutorizacion != null && ind.Autorizo == true)
                                            //|| (ind.IncidenciaJustico == "DÍA ECONÓMICO" && ConvenioLaboral == "BASE" && (ind.FechaAutorizacion==null || ind.FechaAutorizacion.Year ==1))
                                            )
                                        {
                                            permisoseconomicos = permisoseconomicos + 1;
                                        }
                                    }
                                }
                            }
                            switch (diaincidencia)
                            {
                                case 1:
                                    vit.D1 = 1;
                                    vit.vD1 = procesar;
                                    vit.IncidenciasDia1 = incidenciasTrabajadordia;

                                    break;
                                case 2:
                                    vit.D2 = 2;
                                    vit.IncidenciasDia2 = incidenciasTrabajadordia;
                                    vit.vD2 = procesar;
                                    break;
                                case 3:
                                    vit.D3 = 3;
                                    vit.IncidenciasDia3 = incidenciasTrabajadordia;
                                    vit.vD3 = procesar;
                                    break;
                                case 4:
                                    vit.D4 = 4;
                                    vit.IncidenciasDia4 = incidenciasTrabajadordia;
                                    vit.vD4 = procesar;
                                    break;
                                case 5:
                                    vit.D5 = 5;
                                    vit.IncidenciasDia5 = incidenciasTrabajadordia;
                                    vit.vD5 = procesar;
                                    break;
                                case 6:
                                    vit.D6 = 6;
                                    vit.IncidenciasDia6 = incidenciasTrabajadordia;
                                    vit.vD6 = procesar;
                                    break;
                                case 7:
                                    vit.D7 = 7;
                                    vit.IncidenciasDia7 = incidenciasTrabajadordia;
                                    vit.vD7 = procesar;
                                    break;
                                case 8:
                                    vit.D8 = 8;
                                    vit.IncidenciasDia8 = incidenciasTrabajadordia;
                                    vit.vD8 = procesar;
                                    break;
                                case 9:
                                    vit.D9 = 9;
                                    vit.IncidenciasDia9 = incidenciasTrabajadordia;
                                    vit.vD9 = procesar;
                                    break;
                                case 10:
                                    vit.D10 = 10;
                                    vit.IncidenciasDia10 = incidenciasTrabajadordia;
                                    vit.vD10 = procesar;
                                    break;
                                case 11:
                                    vit.D11 = 11;
                                    vit.IncidenciasDia11 = incidenciasTrabajadordia;
                                    vit.vD11 = procesar;
                                    break;
                                case 12:
                                    vit.D12 = 12;
                                    vit.IncidenciasDia12 = incidenciasTrabajadordia;
                                    vit.vD12 = procesar;
                                    break;
                                case 13:
                                    vit.D13 = 13;
                                    vit.IncidenciasDia13 = incidenciasTrabajadordia;
                                    vit.vD13 = procesar;
                                    break;
                                case 14:
                                    vit.D14 = 14;
                                    vit.IncidenciasDia14 = incidenciasTrabajadordia;
                                    vit.vD14 = procesar;
                                    break;
                                case 15:
                                    vit.D15 = 15;
                                    vit.IncidenciasDia15 = incidenciasTrabajadordia;
                                    vit.vD15 = procesar;
                                    break;
                                case 16:
                                    vit.D1 = 16;
                                    vit.IncidenciasDia1 = incidenciasTrabajadordia;
                                    vit.vD16 = procesar;
                                    break;
                                case 17:
                                    vit.D2 = 17;
                                    vit.IncidenciasDia2 = incidenciasTrabajadordia;
                                    vit.vD2 = procesar;
                                    break;
                                case 18:
                                    vit.D3 = 18;
                                    vit.IncidenciasDia3 = incidenciasTrabajadordia;
                                    vit.vD3 = procesar;
                                    break;
                                case 19:
                                    vit.D4 = 19;
                                    vit.IncidenciasDia4 = incidenciasTrabajadordia;
                                    vit.vD4 = procesar;
                                    break;
                                case 20:
                                    vit.D5 = 20;
                                    vit.IncidenciasDia5 = incidenciasTrabajadordia;
                                    vit.vD5 = procesar;
                                    break;
                                case 21:
                                    vit.D6 = 21;
                                    vit.IncidenciasDia6 = incidenciasTrabajadordia;
                                    vit.vD6 = procesar;

                                    break;
                                case 22:
                                    vit.D7 = 22;
                                    vit.IncidenciasDia7 = incidenciasTrabajadordia;
                                    vit.vD7 = procesar;
                                    break;
                                case 23:
                                    vit.D8 = 23;
                                    vit.IncidenciasDia8 = incidenciasTrabajadordia;
                                    vit.vD8 = procesar;
                                    break;
                                case 24:
                                    vit.D9 = 24;
                                    vit.IncidenciasDia9 = incidenciasTrabajadordia;
                                    vit.vD9 = procesar;
                                    break;
                                case 25:
                                    vit.D10 = 25;
                                    vit.IncidenciasDia10 = incidenciasTrabajadordia;
                                    vit.vD10 = procesar;
                                    break;
                                case 26:
                                    vit.D11 = 26;
                                    vit.IncidenciasDia11 = incidenciasTrabajadordia;
                                    vit.vD11 = procesar;
                                    break;
                                case 27:
                                    vit.D12 = 27;
                                    vit.IncidenciasDia12 = incidenciasTrabajadordia;
                                    vit.vD12 = procesar;
                                    break;
                                case 28:
                                    vit.D13 = 28;
                                    vit.IncidenciasDia13 = incidenciasTrabajadordia;
                                    vit.vD13 = procesar;
                                    break;
                                case 29:
                                    vit.D14 = 29;
                                    vit.IncidenciasDia14 = incidenciasTrabajadordia;
                                    vit.vD14 = procesar;
                                    break;
                                case 30:
                                    vit.D15 = 30;
                                    vit.IncidenciasDia15 = incidenciasTrabajadordia;
                                    vit.vD15 = procesar;
                                    break;
                                case 31:
                                    vit.D16 = 31;
                                    vit.IncidenciasDia16 = incidenciasTrabajadordia;
                                    vit.vD16 = procesar;
                                    break;
                                default:
                                    throw new Exception("Error al procesar las incidencias del trabajador " + Trabajador);


                            }
                        }
                    }
                }

                //-----------------------
                vit.Faltas = faltas;
                vit.PuntualidadAsistencia = false;
                vit.Observaciones = tobservaciones;
                vit.DiasEconomicos = permisoseconomicos;
                if ((NoQuincena % 2) == 0)
                {
                    var pa1 = db.IncidenciaPermiso_stIncidenciaTrabajador
                     .AsNoTracking().Where(
                        z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral=="BASE"
                        &&
                        z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == p.IdTrabajador
                     && (
                     (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && z.IdIncidenciaJustificacion == 0  && RelacionLaboral == "ADMINISTRATIVO" )
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && z.IdIncidenciaJustificacion == 0  && RelacionLaboral == "DOCENTE" && !(z.Catalogos_ctTipoIncidencia.Incidencia == "FALTA HORAS CLUB"))
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("OMISIÓN DE SALIDA") )
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO" )  )
                     || (z.Incidencia_ctJustificacion.IncidenciaJustificacion.Contains("OMISIÓN DE SALIDA") )
                               || (z.Incidencia_ctJustificacion.IncidenciaJustificacion.Contains("OMISIÓN DE ENTRADA"))
                     )
                      && ((z.FechaInicio.Year == aaaa && z.FechaInicio.Month == Mes) && (z.FechaInicio.Day >= diainicialquincena && z.FechaInicio.Day <= diafinalquincena))
                      ).ToList();
                    if (pa1.Count() > 0)
                    {
                        vit.PuntualidadAsistencia = true;
                    }


                }
                else
                {
                    var pa2 = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking()
                     .Where(
                        z =>
                        z.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "BASE"
                        &&
                        z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == p.IdTrabajador
                     && (
                     (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && z.IdIncidenciaJustificacion==0 && RelacionLaboral == "ADMINISTRATIVO"  )
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && z.IdIncidenciaJustificacion == 0  && RelacionLaboral == "DOCENTE"  && !(z.Catalogos_ctTipoIncidencia.Incidencia == "FALTA HORAS CLUB"))
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("OMISIÓN DE SALIDA") )

                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO")  )
                     || (z.Incidencia_ctJustificacion.IncidenciaJustificacion.Contains("OMISIÓN DE SALIDA")  )
                     || (z.Incidencia_ctJustificacion.IncidenciaJustificacion.Contains("OMISIÓN DE ENTRADA"))

                     )
                     && ((z.FechaInicio.Year == aaaa && z.FechaInicio.Month == Mes) && (z.FechaInicio.Day >= diainicialquincena && z.FechaInicio.Day <= diafinalquincena))
                     ).ToList();
                    if (pa2.Count() > 0)
                    {
                        vit.PuntualidadAsistencia = true;
                    }


                }

                Listaincidencias.Add(vit);



            }
            EstructuraIncidencias ei = new EstructuraIncidencias();
            ei.InicidenciasTrabajadores = Listaincidencias;

            return ei;
        }
        public ActionResult CerrarIncidencias()
        {
            //var dtrabajador = db.vwDatosAspirantesTrabajadores.Where(x => x.IdTrabajador == IdTrabajador).FirstOrDefault();
            //ViewBag.Trabajador = dtrabajador.Nombre + " " + dtrabajador.ApellidoPaterno + " " + dtrabajador.ApellidoMaterno;
            ViewBag.IdQuincenaMesA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(true), "IdAño", "Año");

            return PartialView();
        }
        public ActionResult cambiarquincena(long id)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return Json(new { Valid = false, Message = "No se encontró la incidencia, Id=" + incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajador }, JsonRequestBehavior.AllowGet);
            }

            if (incidenciaPermiso_stIncidenciaTrabajador.EsAplicada)
            {
                if (incidenciaPermiso_stIncidenciaTrabajador.EsCancelada == false)
                    return Json(new { Valid = false, Message = "La incidencia ya fue aplicada, no es posible cambiar la quincena para nómina" }, JsonRequestBehavior.AllowGet);

            }
            int IdTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.IdIncidenciaTrabajador == id).FirstOrDefault().Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            var dtrabajador = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(x => x.IdTrabajador == IdTrabajador && x.RestringirMenu == null).FirstOrDefault();
            ViewBag.IdTrabajador = IdTrabajador;
            ViewBag.Trabajador = dtrabajador.Nombre + " " + dtrabajador.ApellidoPaterno + " " + dtrabajador.ApellidoMaterno;
            ViewBag.QuincenaMes = incidenciaPermiso_stIncidenciaTrabajador.QuincenaParaNomina;
            ViewBag.Año = incidenciaPermiso_stIncidenciaTrabajador.AñoParaNomina;
            ViewBag.IdQuincenaMes = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");

            return PartialView(incidenciaPermiso_stIncidenciaTrabajador);
        }
        [HttpPost]

        public ActionResult cambiarquincena(long id, int quincena, int año)
        {
            //long id = System.Convert.ToInt64(Request.Form["IdIncidenciaTrabajador"]);
            //int quincena = System.Convert.ToInt32(Request.Form["hfQuincenaMesCambio"]);
            //int año = System.Convert.ToInt32(Request.Form["hfAnioCambio"]);
            if (quincena == 0 || año == 0)
            {
                return Json(new { Valid = false, Message = "Deberá seleccionar un año y una quincena" }, JsonRequestBehavior.AllowGet);

            }
            var usuario = Seguridad.Identidad.Usuario();
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return Json(new { Valid = false, Message = "No se encontró la incidencia, Id=" + incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajador }, JsonRequestBehavior.AllowGet);
            }
            incidenciaPermiso_stIncidenciaTrabajador.QuincenaParaNomina = db.Catalogos_ctQuincenaMes.AsNoTracking().Where(z => z.IdQuincenaMes == quincena).FirstOrDefault().QuincenaMes;
            incidenciaPermiso_stIncidenciaTrabajador.AñoParaNomina = año;
            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = "La quincena y el año para nómina se grabaron exitosamente" }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        [HttpPost]
        public ActionResult CerrarIncidencias(string ida, short idarea, short idqm, string rol, short idia, short idqma)
        {
            string link = "../IncidenciaPermisoTrabajador/PivotIncidencias?ida=" + ida + "&idarea=" + idarea + "&idqm=" + idqm + "&rol=" + rol;

            Uri myUri = new Uri(link, UriKind.Relative);
            string area = db.Catalogos_ctEstructuraOrganica.AsNoTracking().Where(x => x.IdEstructuraOrganica == idarea).FirstOrDefault().EstructuraOrganica;

            string año = ida;
            DateTime FechaInicial = DateTime.MinValue;
            DateTime FechaFinal = DateTime.MinValue;

            Boolean esquincenapar = false;
            short NoQuincena = System.Convert.ToInt16(db.Catalogos_ctQuincenaMes.AsNoTracking().Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().QuincenaMes);
            string NoQuincenaNomina = db.Catalogos_ctQuincenaMes.AsNoTracking().Where(x => x.IdQuincenaMes == idqma).FirstOrDefault().QuincenaMes;

            ViewBag.ol = rol;
            ViewBag.NoQuincena = NoQuincena;
            ViewBag.NombreMes = db.Catalogos_ctQuincenaMes.AsNoTracking().Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().Catalogos_ctMes.Mes;
            string NoMes = System.Convert.ToString(db.Catalogos_ctQuincenaMes.AsNoTracking().Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().IdMes);
            short Mes = System.Convert.ToInt16(NoMes);
            if (NoQuincena % 2 == 0)
            {
                esquincenapar = true;
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes + "-16");
                switch (NoMes)
                {
                    case "2":
                        Boolean esbisiesto = System.DateTime.IsLeapYear(Convert.ToInt32(año));
                        if (esbisiesto)
                            FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-29");
                        else
                            FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-28");
                        break;
                    case "4":
                    case "6":
                    case "9":
                    case "11":
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-30");
                        break;
                    default:
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-31");
                        break;
                }
            }
            else
            {
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes);
                FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-15");
            }
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string msj = "El proceso de cerrar incidencias se realizó exitosamente !!";

            string query;

            query = @"select a.IdIncidenciaTrabajador
from IncidenciaPermiso_stIncidenciaTrabajador a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
where b.IdEstructuraOrganica=" + idarea + " and (a.EsCerrada=0 ) and (a.IdTipoIncidencia!=0)  and (cast(a.FechaInicio as date)>=" + "'" + FechaInicial.ToShortDateString() + "'" + " and cast(a.FechaTermino as date)<=" + "'" + FechaFinal.ToShortDateString() + "')"
+ "order by a.FechaInicio";
            List<long> t = (List<long>)dp.connection.Query<long>(query);
            dp.Close();
            if (t.Count() == 0)
            {
                //MessageBox.Show(ViewData, TipoMensaje.Error, "No existen incidencias abiertas", "Error", myUri.ToString());
                //return View("VError");

                return Json(new { Valid = false, Message = "No existen incidencias abiertas" }, JsonRequestBehavior.AllowGet);

            }
            // Cierra las incidencias de la quincena y el área
            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {

                Models.RelojChecador rch = new Nova.Models.RelojChecador(true);
               // rch.CierreMes(idarea, FechaFinal.ToShortDateString(), NoQuincenaNomina, año);

                foreach (var item in t)
                {
                    IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(item);

                    incidenciaPermiso_stIncidenciaTrabajador.EsCerrada = true;
                    incidenciaPermiso_stIncidenciaTrabajador.AñoParaNomina = idia;
                    incidenciaPermiso_stIncidenciaTrabajador.QuincenaParaNomina = NoQuincenaNomina;
                    db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                    try
                    {

                        db.SaveChanges();
                    }
                    catch (Exception ex)
                    {
                        //MessageBox.Show(ViewData, TipoMensaje.Error, ExceptionExtensions.GetOriginalException(ex).Message, "Error", myUri.ToString());
                        //return View("VError");

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(ex).Message }, JsonRequestBehavior.AllowGet);
                    }
                }

                //var qna = db.Catalogos_ctQuincenaMes.AsNoTracking().Where(x => x.IdQuincenaMes == idqm).FirstOrDefault();

                IncidenciaPermisoTrabajadorProcesoEstatus proceso = new IncidenciaPermisoTrabajadorProcesoEstatus();
                proceso.GuardaEstatus(idarea, Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria, NoQuincena.ToString("D2"), System.Convert.ToInt32(ida), IncidenciasProcesosEstatus.CERRADO, NoQuincenaNomina, idia);


                scope.Complete();
            }

            //MessageBox.Show(ViewData, TipoMensaje.Error, msj, "Error", myUri.ToString());
            //return View("VError");
            SendPushNotification("Cerró incidencias de la quincena: " + NoQuincena + " año: " + año + "centro: " + area, TypePushNotification.success, Session["Aplicacion"].ToString());
            return Json(new { Valid = true, Message = msj, JsonRequestBehavior.AllowGet });

        }

        public ActionResult ReporteIncidenciasPdf(string ida, short idarea, short idqm, string rol)
        {
            var ei = CreaPivotIncidencias(ida, idarea, idqm, rol);

            if (rol == "ResponsableIncidencias")
            {
                var qna =  db.Catalogos_ctQuincenaMes.AsNoTracking().Where(x => x.IdQuincenaMes == idqm).FirstOrDefault();
                IncidenciaPermisoTrabajadorProcesoEstatus proceso = new IncidenciaPermisoTrabajadorProcesoEstatus();
                proceso.GuardaEstatus(idarea, Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria, qna.QuincenaMes, System.Convert.ToInt32(ida), IncidenciasProcesosEstatus.REVISADO);

            }

            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 1;


            ////return View("ReporteMir", result.ToList());
            return new ViewAsPdf(ei) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            //return View(ei);

        }

        // GET: IncidenciaPermiso_stIncidenciaTrabajador/Details/5
        public ActionResult Details(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }
        public ActionResult HorasClub(string id,int idcltc, string fi, string ff, string di, string df, string nuquin, string nommes)
        {

            

            int Id = Convert.ToInt32(id);
           // int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu == null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            var regrelacionlaboral = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(z => z.IdTrabajador == Id && z.IdConvenioLaboralTrabajadorCategoria==idcltc).FirstOrDefault();
            string relacionlaboral = regrelacionlaboral.RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);

            if (EsQuincenaCerrada(fechainicial, regrelacionlaboral.IdEstructuraOrganicaFisica))
            {
                return JsonView(false, "Ya la quincena esta cerrada, ya no es posible agregar mas incidencias");

            }
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult HorasClub(Falta fhc)
        {

            

            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);

            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();

            if (EsQuincenaCerrada(fhc.Dia, datostrabajador.IdEstructuraOrganicaFisica))
            {
                return JsonView(false, "Ya la quincena esta cerrada, ya no es posible agregar mas incidencias");

            }

            if (datostrabajador.FechaTermino != null)
            { 
                if (fhc.Dia > datostrabajador.FechaTermino)
                {
                    return Json(new { Valid = false, Message = $"La fecha de término de este contrato o comisión es {datostrabajador.FechaTermino}, no se puede aplicar horas club en un día posterior {fhc.Dia}" }, JsonRequestBehavior.AllowGet);

                }
               }
                else
                {
                    var rs = IncidenciaPermiso_stIncidenciaTrabajador.ValidaContratosComision((int)datostrabajador.IdTrabajador, idcltc, fhc.Dia);
                    if (!rs.IsValid)

                        return Json(new { Valid = false, Message = rs.Messsage }, JsonRequestBehavior.AllowGet);

                }
            short Idmodalidad = 0;
            //if (db.vwDatosAspirantesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault().IdModalidadEstudio.HasValue)
            //if (datostrabajador.IdModalidadEstudio)
            //{
            //    Idmodalidad = db.vwDatosAspirantesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault().IdModalidadEstudio.Value;
            //}
            if (datostrabajador.IdModalidadEstudio != 2)
            {
                ModelState.AddModelError("E3", "Las horas club solo aplican para EMSAD");
            }
            if (fhc.Horas == 0)
            {
                ModelState.AddModelError("E1", "Debe ingresar las horas de la falta");
            }
            else
            {
                if (fhc.Horas > 12)
                {
                    ModelState.AddModelError("E2", "el número de horas no debe ser mayor a 12");

                }
                ipt.IdTipoIncidencia = 58;
                ipt.Horas = fhc.Horas;

            }

            DateTime fi = fhc.Dia;
            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = false;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

            string msj = "Se grabó el retardo exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        public ActionResult Retardo(string id, int idcltc,string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            vwDatosAspirantesTrabajadoresHistorial datvw = new vwDatosAspirantesTrabajadoresHistorial();
            datvw = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(z => z.IdTrabajador == Id && z.IdConvenioLaboralTrabajadorCategoria== idcltc).FirstOrDefault();
            //if (datvw == null)
            //{
            //    datvw = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id).FirstOrDefault();
            //}

            //int idcltc = (int)datvw.IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = datvw.RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);

            
            
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;
            ViewBag.NombreTrabajador = $"{datvw.Nombre} {datvw.ApellidoPaterno} {datvw.ApellidoMaterno} - {datvw.ConvenioLaboral}- {datvw.RelacionLaboral} {datvw.Categoria}";

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Retardo(Prima falta)
        {
            
            DateTime fi = falta.Dia;
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);

            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();

            if (EsQuincenaCerrada(falta.Dia, datostrabajador.IdEstructuraOrganicaFisica))
            {
                return JsonView(false, "Ya la quincena esta cerrada, ya no es posible agregar mas incidencias");

            }

            if (datostrabajador.FechaTermino != null)
            { 
                if (fi > datostrabajador.FechaTermino)
                {
                    return Json(new { Valid = false, Message = $"La fecha de término de este contrato o comisión es {datostrabajador.FechaTermino}, no se puede aplicar un retardo en un día posterior {fi}" }, JsonRequestBehavior.AllowGet);

                }
        }
            else
            {
                var rs = IncidenciaPermiso_stIncidenciaTrabajador.ValidaContratosComision((int)datostrabajador.IdTrabajador, idcltc, fi);
                if (!rs.IsValid)

                    return Json(new { Valid = false, Message = rs.Messsage }, JsonRequestBehavior.AllowGet);

            }

            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = false;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

            if (rela == "DOCENTE")
            {
                ipt.IdTipoIncidencia = 32;
                ipt.FechaRegistroRetardo = DateTime.Now;
            }
            else
            {
                ipt.IdTipoIncidencia = 31;

            }
            string msj = "Se grabó el retardo exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();

                    Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();
                    
                    rc.CreaFaltasPorRetardosYPases(ipt.FechaInicio, (int)datostrabajador.IdTrabajador);
                   

                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult omisionsalida(string id, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            int idcltc = (int)db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(z => z.IdTrabajador == Id && z.RestringirMenu == null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(z => z.IdTrabajador == Id && z.RestringirMenu == null).FirstOrDefault().RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult omisionsalida(Prima falta)
        {
            DateTime fi = falta.Dia;
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);

            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();
            if (datostrabajador.FechaTermino != null)
                if (fi > datostrabajador.FechaTermino)
                {
                    return Json(new { Valid = false, Message = $"La fecha de término de este contrato o comisión es {datostrabajador.FechaTermino}, no se puede aplicar una omisión en un día posterior {fi}" }, JsonRequestBehavior.AllowGet);

                }
            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = false;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;
            ipt.IdTipoIncidencia = 35;
            string msj = "Se grabó el retardo exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        public ActionResult Falta(string id, int idcltc,string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);

            vwDatosAspirantesTrabajadoresHistorial datvw = new vwDatosAspirantesTrabajadoresHistorial();
            datvw = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(z => z.IdTrabajador == Id && z.IdConvenioLaboralTrabajadorCategoria==idcltc).FirstOrDefault();
            //if (datvw == null)
            //{
            //    datvw = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id).FirstOrDefault();
            //}

            //// int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            ////string relacionlaboral= db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().RelacionLaboral;
            //int idcltc = (int)datvw.IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = datvw.RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);
            
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;
            ViewBag.NombreTrabajador= $"{datvw.Nombre} {datvw.ApellidoPaterno} {datvw.ApellidoMaterno} - {datvw.ConvenioLaboral}- {datvw.RelacionLaboral} {datvw.Categoria}";

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }

        public bool EsQuincenaCerrada(DateTime fecha, short? idestructuraOrganicaFisica)
        {
            // Determinar el inicio y fin de la quincena
            DateTime inicioQuincena, finQuincena;
            if (fecha.Day <= 15)
            {
                inicioQuincena = new DateTime(fecha.Year, fecha.Month, 1);
                finQuincena = new DateTime(fecha.Year, fecha.Month, 15);
            }
            else
            {
                inicioQuincena = new DateTime(fecha.Year, fecha.Month, 16);
                finQuincena = new DateTime(fecha.Year, fecha.Month, DateTime.DaysInMonth(fecha.Year, fecha.Month));
            }
           // return false;
            // Buscar registros en la base de datos
            using (var db = new bdNovaEntities()) // Reemplaza TuContextoDeBD con el nombre real de tu contexto
            {
                var registrosEnQuincena = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking()
                    .Where(a => a.FechaInicio >= inicioQuincena &&
                                a.FechaTermino <= finQuincena &&
                                a.AñoParaNomina != null && a.EsCerrada==true 
                                && a.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica== idestructuraOrganicaFisica
                                &&
                                a.QuincenaParaNomina.Trim() != "")
                    
                    .ToList();
                if (registrosEnQuincena.Count() > 0)
                    return true;
                else
                    return false;
             
            }

        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Falta(Falta falta)
        {
             

            var diasacrear = HttpContext.Request.Params.Get("hfdia");

            if (diasacrear == "")
                return JsonView(false, "Debe de seleccionar al menos un día para continuar, revise su información");

            var arraydias = diasacrear.Split(',');
            var hayerror = false;
            var entrofor = false;
            string messages = "";
            string msjfaltas = "";
            int idcltctemp = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);

            var datostrabajadorf = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltctemp).FirstOrDefault();

            if (EsQuincenaCerrada(falta.Dia, datostrabajadorf.IdEstructuraOrganicaFisica))
            {
                return JsonView(false, "Ya la quincena esta cerrada, ya no es posible agregar mas incidencias");

            }

            foreach (var elemento in arraydias)
            {

                DateTime fi = falta.Dia;
                //DateTime fi = DateTime.Parse(elemento);
                //DateTime ftqna = DateTime.Parse(elemento);
                //DateTime fiqna = DateTime.Parse(elemento);
                //if (fi.Day > 15)
                //{
                //    fiqna = DateTime.Parse($"{fi.Year}-{fi.Month}-16");
                //    ftqna = DateTime.Parse($"{fi.Year}-{fi.Month}-{DateTime.DaysInMonth(fi.Year, fi.Month)}");
                //}
                //else
                //{
                //    fiqna = DateTime.Parse($"{fi.Year}-{fi.Month}-01");
                //    ftqna = DateTime.Parse($"{fi.Year}-{fi.Month}-15");
                //}

                int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);

                // DapperQuery dp = new DapperQuery("bdNovaEntities");
                //string sql = $@" select *  FROM  vwLicenciasTrabajadores where  
                //  TipoIncidenciaPermiso='COMISIÓN' and 
                //IdConvenioLaboralTrabajadorCategoria in({idcltctemp})
                //and  (FechaInicioIncidencia BETWEEN '{fiqna.ToString("yyyyMMdd")}' AND '{ftqna.ToString("yyyyMMdd")}'
                //    OR FechaTerminoIncidencia BETWEEN '{fiqna.ToString("yyyyMMdd")}' AND '{ftqna.ToString("yyyyMMdd")}'
                //    OR ('{fiqna.ToString("yyyyMMdd")}' BETWEEN FechaInicioIncidencia AND FechaTerminoIncidencia
                //    OR '{ftqna.ToString("yyyyMMdd")}' BETWEEN FechaInicioIncidencia AND FechaTerminoIncidencia)
                //    )";

                //var licencias = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(sql);
                //dp.Close();
                var idt = db.Convenios_stConvenioLaboralTrabajadorCategoria
                     .Find(idcltc);
               
                var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria==idcltc).FirstOrDefault();
                
                //var existecomisionparaestadechas = datostrabajador.Where(q => q.FechaInicio >= fi && q.FechaTermino >= fi
                //      ).FirstOrDefault();

               // bool convenioentrefechas = false;
                //if (existecomisionparaestadechas.IdConvenioLaboralTrabajadorCategoria == idcltc)
                //if (licencias.Count()>0)
                //{
                //    convenioentrefechas = true;
                //}
                 
                
                
                
                
            //if (datostrabajador.FechaTermino != null)
            //if (convenioentrefechas)
            //    {
            //        //if (fi > datostrabajador.FechaTermino)
            //        //{
            //            return Json(new { Valid = false, Message = $"La fecha de término de este contrato o comisión es {datostrabajador.FechaTermino}, no se puede aplicar una falta en un día posterior {fi}" }, JsonRequestBehavior.AllowGet);

            //        //}
            //    }
            //    else
            //    {
                    var rs = IncidenciaPermiso_stIncidenciaTrabajador.ValidaContratosComision((int)datostrabajador.IdTrabajador, idcltc, fi);
                    if (!rs.IsValid)

                        return Json(new { Valid = false, Message = rs.Messsage }, JsonRequestBehavior.AllowGet);

               // }
            

                string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
                IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
                ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
                ipt.FechaInicio = fi;
                ipt.FechaTermino = fi;
                ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                ipt.FechaCreacion = fi;
                ipt.EsAplicada = false;
                ipt.EsSubsecuente = false;
                ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                ipt.Autorizo = false;
                ipt.EsCancelada = false;
                ipt.EsCerrada = false;
                ipt.Horas = 8;
                ipt.TiempoFuera = TimeSpan.FromHours(8);
                ipt.IdIncidenciaJustificacion = 0;
                ipt.EsFaltaDirecta = true;

                if (rela == "DOCENTE")
                {
                    if (falta.Horas == 0)
                    {
                        ModelState.AddModelError("E1", "Debe ingresar las horas de la falta");
                    }
                    else
                    {
                        if (falta.Horas > 12)
                        {
                            ModelState.AddModelError("E2", "el número de horas no debe ser mayor a 12");

                        }
                        ipt.IdTipoIncidencia = 8;
                        ipt.Horas = falta.Horas;
                        ipt.TiempoFuera = TimeSpan.FromHours(8);
                    }
                }
                else
                {
                    ipt.IdTipoIncidencia = 2;
                    ipt.Horas = 8;
                    ipt.TiempoFuera = TimeSpan.FromHours(8);
                }


                if (ModelState.IsValid)
                {
                    try
                    {
                        msjfaltas = msjfaltas + $",{elemento}";

                        db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {


                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                    }
                    //    return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

                }
                messages = string.Join("; ", ModelState.Values
                          .SelectMany(x => x.Errors)
                          .Select(x => x.ErrorMessage));
            }
            if (messages == "")
                return Json(new { Valid = true, Message = $"Las faltas se agregaron exitosamente para las fechas,  {msjfaltas}" }, JsonRequestBehavior.AllowGet);
            else
                return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult Prima(string id,int idcltc, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);

            vwDatosAspirantesTrabajadoresHistorial trabajador = new vwDatosAspirantesTrabajadoresHistorial();
            trabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(z => z.IdTrabajador == Id && z.IdConvenioLaboralTrabajadorCategoria==idcltc).FirstOrDefault();
            

            //int idcltc = (int)trabajador.IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = trabajador.RelacionLaboral;


            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;
            ViewBag.NombreTrabajador = $"{trabajador.Nombre} {trabajador.ApellidoPaterno} {trabajador.ApellidoMaterno} - {trabajador.ConvenioLaboral}- {trabajador.RelacionLaboral} {trabajador.Categoria}";


            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }


        public ActionResult PrimaResponsable(string id, int idcltc, string fi, string ff, string di, string df, string nuquin, string nommes)
        {

            
            int Id = Convert.ToInt32(id);

            vwDatosAspirantesTrabajadoresHistorial trabajador = new vwDatosAspirantesTrabajadoresHistorial();
            trabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(z => z.IdTrabajador == Id && z.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();


            //int idcltc = (int)trabajador.IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = trabajador.RelacionLaboral;


            DateTime fechainicial = Convert.ToDateTime(fi);

           

            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;
            ViewBag.NombreTrabajador = $"{trabajador.Nombre} {trabajador.ApellidoPaterno} {trabajador.ApellidoMaterno} - {trabajador.ConvenioLaboral}- {trabajador.RelacionLaboral} {trabajador.Categoria}";


            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult PrimaResponsable(Prima prima)
        {

           

            DateTime fi = prima.Dia;
            if (fi.DayOfWeek != DayOfWeek.Saturday)
            {
                if (fi.DayOfWeek != DayOfWeek.Sunday)
                {
                    return Json(new { Valid = false, Message = "Error: La prima dominical aplica únicamente para sábado o domingo" }, JsonRequestBehavior.AllowGet);

                }
            }
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);

            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();

            if (EsQuincenaCerrada(prima.Dia, datostrabajador.IdEstructuraOrganicaFisica))
            {
                return JsonView(false, "Ya la quincena esta cerrada, ya no es posible agregar mas incidencias");

            }

            if (!datostrabajador.ConvenioLaboral.Contains("BASE"))
            {
                return Json(new { Valid = false, Message = $"Esta prestacion solo es para personal de Base " }, JsonRequestBehavior.AllowGet);

            }

            if (datostrabajador.ConvenioLaboral.Contains("BASE") && datostrabajador.EsCuotaSindical == false)
            {
                return Json(new { Valid = false, Message = $"Esta prestacion solo es para personal de Base Sindicalizado" }, JsonRequestBehavior.AllowGet);

            }

            if (datostrabajador.FechaTermino != null)
            {
                if (fi > datostrabajador.FechaTermino)
                {
                    return Json(new { Valid = false, Message = $"La fecha de término de este contrato o comisión es {datostrabajador.FechaTermino}, no se puede aplicar una prima en un día posterior {fi}" }, JsonRequestBehavior.AllowGet);

                }
            }
            else
            {
                var rs = IncidenciaPermiso_stIncidenciaTrabajador.ValidaContratosComision((int)datostrabajador.IdTrabajador, idcltc, fi);
                if (!rs.IsValid)

                    return Json(new { Valid = false, Message = rs.Messsage }, JsonRequestBehavior.AllowGet);

            }

            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = false;
             
            ipt.EsFaltaDirecta = true;

            ipt.IdTipoIncidencia = 37;
            string msj = "La prima dominical se grabó exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Prima(Prima prima)
        {
            DateTime fi = prima.Dia;
            if (fi.DayOfWeek != DayOfWeek.Saturday)
            {
                if (fi.DayOfWeek != DayOfWeek.Sunday)
                {
                    return Json(new { Valid = false, Message = "Error: La prima dominical aplica únicamente para sábado o domingo" }, JsonRequestBehavior.AllowGet);

                }
            }
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);

            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();

            if (!datostrabajador.ConvenioLaboral.Contains("BASE") )
            {
                return Json(new { Valid = false, Message = $"Esta prestacion solo es para personal de Base " }, JsonRequestBehavior.AllowGet);

            }

            if (datostrabajador.ConvenioLaboral.Contains("BASE") && datostrabajador.EsCuotaSindical==false)
            {
                return Json(new { Valid = false, Message = $"Esta prestacion solo es para personal de Base Sindicalizado" }, JsonRequestBehavior.AllowGet);

            }


            if (datostrabajador.FechaTermino != null)
            { 
                if (fi > datostrabajador.FechaTermino)
                {
                    return Json(new { Valid = false, Message = $"La fecha de término de este contrato o comisión es {datostrabajador.FechaTermino}, no se puede aplicar una prima en un día posterior {fi}" }, JsonRequestBehavior.AllowGet);

                }
        }
            else
            {
                var rs = IncidenciaPermiso_stIncidenciaTrabajador.ValidaContratosComision((int)datostrabajador.IdTrabajador, idcltc, fi);
                if (!rs.IsValid)

                    return Json(new { Valid = false, Message = rs.Messsage }, JsonRequestBehavior.AllowGet);

            }

            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = true;
            ipt.FechaAutorizacion = DateTime.Now;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

            ipt.IdTipoIncidencia = 37;
            string msj = "La prima dominical se grabó exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult DiasDescanso(string id,int idcltc, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
           // int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu == null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(z => z.IdTrabajador == Id && z.IdConvenioLaboralTrabajadorCategoria==idcltc).FirstOrDefault().RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }


        public ActionResult DiasDescansoResponsable(string id, int idcltc, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            // int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu == null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(z => z.IdTrabajador == Id && z.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault().RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);

            

            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult DiasDescanso(Prima falta)
        {
            DateTime fi = falta.Dia;
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();
            if (datostrabajador.FechaTermino != null)
            { 
                if (fi > datostrabajador.FechaTermino)
                {
                    return Json(new { Valid = false, Message = $"La fecha de término de este contrato o comisión es {datostrabajador.FechaTermino}, no se puede aplicar un día de descanso en un día posterior {fi}" }, JsonRequestBehavior.AllowGet);

                }
        }
            else
            {
                var rs = IncidenciaPermiso_stIncidenciaTrabajador.ValidaContratosComision((int)datostrabajador.IdTrabajador, idcltc, fi);
                if (!rs.IsValid)

                    return Json(new { Valid = false, Message = rs.Messsage }, JsonRequestBehavior.AllowGet);

            }


            if (!datostrabajador.ConvenioLaboral.Contains("BASE"))
            {
                return Json(new { Valid = false, Message = $"Esta prestacion solo es para personal de Base " }, JsonRequestBehavior.AllowGet);

            }

            if (datostrabajador.ConvenioLaboral.Contains("BASE") && datostrabajador.EsCuotaSindical == false)
            {
                return Json(new { Valid = false, Message = $"Esta prestacion solo es para personal de Base Sindicalizado" }, JsonRequestBehavior.AllowGet);

            }

            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = true;
            ipt.FechaAutorizacion = DateTime.Now;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

            ipt.IdTipoIncidencia = 38;
            string msj = "El día de descanso se grabó exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult DiasDescansoResponsable(Prima falta)
        {
            DateTime fi = falta.Dia;


            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();


            if (EsQuincenaCerrada(falta.Dia, datostrabajador.IdEstructuraOrganicaFisica))
            {
                return JsonView(false, "Ya la quincena esta cerrada, ya no es posible agregar mas incidencias");

            }

            if (datostrabajador.FechaTermino != null)
            {
                if (fi > datostrabajador.FechaTermino)
                {
                    return Json(new { Valid = false, Message = $"La fecha de término de este contrato o comisión es {datostrabajador.FechaTermino}, no se puede aplicar un día de descanso en un día posterior {fi}" }, JsonRequestBehavior.AllowGet);

                }
            }
            else
            {
                var rs = IncidenciaPermiso_stIncidenciaTrabajador.ValidaContratosComision((int)datostrabajador.IdTrabajador, idcltc, fi);
                if (!rs.IsValid)

                    return Json(new { Valid = false, Message = rs.Messsage }, JsonRequestBehavior.AllowGet);

            }

            if (!datostrabajador.ConvenioLaboral.Contains("BASE"))
            {
                return Json(new { Valid = false, Message = $"Esta prestacion solo es para personal de Base " }, JsonRequestBehavior.AllowGet);

            }

            if (datostrabajador.ConvenioLaboral.Contains("BASE") && datostrabajador.EsCuotaSindical == false)
            {
                return Json(new { Valid = false, Message = $"Esta prestacion solo es para personal de Base Sindicalizado" }, JsonRequestBehavior.AllowGet);

            }

            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = false;
           
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

            ipt.IdTipoIncidencia = 38;
            string msj = "El día de descanso se grabó exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        public ActionResult PaseResponsable(string id,int idcltc, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);

            vwDatosAspirantesTrabajadoresHistorial trabajador = new vwDatosAspirantesTrabajadoresHistorial();
            trabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(z => z.IdConvenioLaboralTrabajadorCategoria == idcltc ).FirstOrDefault();
            //if (trabajador == null)
            //{
            //    trabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id).FirstOrDefault();
            //}

            DateTime fechainicial = Convert.ToDateTime(fi);

         
             


            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = trabajador.IdConvenioLaboralTrabajadorCategoria;
            
            ViewBag.NombreTrabajador = $"{trabajador.Nombre} {trabajador.ApellidoPaterno} {trabajador.ApellidoMaterno} - {trabajador.ConvenioLaboral}- {trabajador.RelacionLaboral} {trabajador.Categoria}";



            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }

        public ActionResult Pase(string id,int? idcltc, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);

            vwDatosAspirantesTrabajadoresHistorial trabajador = new vwDatosAspirantesTrabajadoresHistorial();
            //trabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu == null).FirstOrDefault();
              trabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(z => z.IdConvenioLaboralTrabajadorCategoria == idcltc ).FirstOrDefault();
            //if (trabajador == null)
            //{
            //    trabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id).FirstOrDefault();
            //}
            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = trabajador.IdConvenioLaboralTrabajadorCategoria;
        
            ViewBag.NombreTrabajador = $"{trabajador.Nombre} {trabajador.ApellidoPaterno} {trabajador.ApellidoMaterno} - {trabajador.ConvenioLaboral}- {trabajador.RelacionLaboral} {trabajador.Categoria}";



            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult PaseResponsable(Pase pase)
        {
            

            if (pase.TiempoFuera == null)
            {
                return JsonView(false, "El tiempo del pase de salida no debe de estar vacio");
            }

            if (pase.TiempoFuera==TimeSpan.Zero)
            {
                return JsonView(false, "El tiempo del pase de salida debe de ser mayor a 0");
            }

            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            DateTime fi = pase.Dia;
            string msj = "El pase de salida se grabó exitosamente";
            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();

            if (EsQuincenaCerrada(pase.Dia, datostrabajador.IdEstructuraOrganicaFisica))
            {
                return JsonView(false, "Ya la quincena esta cerrada, ya no es posible agregar mas incidencias");

            }
            if (datostrabajador.ConvenioLaboralTipo != "BASE")
            {
                return Json(new { Valid = false, Message = $"Los pases de salida solo se aplican a los trabajadores de base" }, JsonRequestBehavior.AllowGet);
            }

            var rs = IncidenciaPermiso_stIncidenciaTrabajador.ValidaContratosComision((int)datostrabajador.IdTrabajador, idcltc, fi);
                if (!rs.IsValid)

                    return Json(new { Valid = false, Message = rs.Messsage }, JsonRequestBehavior.AllowGet);
 

            if (ModelState.IsValid)
            {
                IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
                ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
                ipt.IdTipoIncidencia = 43;
                ipt.FechaInicio = fi;
                ipt.FechaTermino = fi;
                ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                ipt.FechaCreacion = fi;
                ipt.EsAplicada = false;
                ipt.EsSubsecuente = false;
                ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                ipt.IdConvenioLaboralTrabajadorCategoriaJustifico = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                ipt.Autorizo = false;
                ipt.FechaJustificacion = DateTime.Now;
                ipt.IdIncidenciaJustificacion = 36;
                //ipt.FechaJustificacion = fi;
                ipt.EsFaltaDirecta = true;
                ipt.Horas = 0;
                ipt.EsCancelada = false;
                ipt.EsCerrada = false;
                ipt.TiempoFuera = pase.TiempoFuera;
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();

                    Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();

                    rc.CreaFaltasPorRetardosYPases(ipt.FechaInicio, (int)datostrabajador.IdTrabajador);


                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

    
        private short RedondearATiempoCompleto(TimeSpan tiempo)
        {
            // Redondear a la hora más cercana y convertir a entero
            return Convert.ToInt16(Math.Round(tiempo.TotalHours));
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Pase(Pase pase)
        {
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            DateTime fi = pase.Dia;
            string msj = "El pase de salida se grabó exitosamente";

            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(q => q.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();

            if (datostrabajador.ConvenioLaboralTipo != "BASE")
            {
                return Json(new { Valid = false, Message = $"Los pases de salida solo se aplican a los trabajadores de base" }, JsonRequestBehavior.AllowGet);
            }


            if (pase.TiempoFuera == null)
            {
                return JsonView(false, "El tiempo del pase de salida no debe de estar vacio");
            }

            if (pase.TiempoFuera == TimeSpan.Zero)
            {
                return JsonView(false, "El tiempo del pase de salida debe de ser mayor a 0");
            }

            if (datostrabajador.FechaTermino != null)
            { 
                if (fi > datostrabajador.FechaTermino)
                {
                    return Json(new { Valid = false, Message = $"La fecha de término de este contrato o comisión es {datostrabajador.FechaTermino}, no se puede aplicar un pase en un día posterior {fi}" }, JsonRequestBehavior.AllowGet);

                }
        }
            else
            {
                var rs = IncidenciaPermiso_stIncidenciaTrabajador.ValidaContratosComision((int)datostrabajador.IdTrabajador, idcltc, fi);
                if (!rs.IsValid)

                    return Json(new { Valid = false, Message = rs.Messsage }, JsonRequestBehavior.AllowGet);

            }
            if (ModelState.IsValid)
            {
                IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
                ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
                ipt.IdTipoIncidencia = 43;
                ipt.FechaInicio = fi;
                ipt.FechaTermino = fi;
                ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                ipt.FechaCreacion = fi;
                ipt.EsAplicada = false;
                ipt.EsSubsecuente = false;
                ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                ipt.Autorizo = true;
                ipt.FechaJustificacion = DateTime.Now;
                ipt.IdIncidenciaJustificacion = 36;
                ipt.FechaJustificacion = fi;
                ipt.EsFaltaDirecta = true;
                ipt.Horas =0;
                ipt.EsCancelada = false;
                ipt.EsCerrada = false;
                ipt.TiempoFuera = pase.TiempoFuera;
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();

                    Nova.Models.RelojChecador rc = new Nova.Models.RelojChecador();

                    rc.CreaFaltasPorRetardosYPases(ipt.FechaInicio, (int)datostrabajador.IdTrabajador);


                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: IncidenciaPermiso_stIncidenciaTrabajador/Create
        public ActionResult Create(int id)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia.AsNoTracking(), "IdTipoIncidencia", "Incidencia");
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria.AsNoTracking(), "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria.AsNoTracking(), "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria.AsNoTracking(), "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion.AsNoTracking(), "IdIncidenciaJustificacion", "IncidenciaJustificacion");
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador.AsNoTracking(), "IdNominaTrabajador", "IdNominaTrabajador");
            return View();
        }

      
        public List<vwDatosAspirantesTrabajadoresAsistencias> FiltrarRegistrosPorTrabajador(List<vwDatosAspirantesTrabajadoresAsistencias> registros, DateTime fechaInicioQuincena, DateTime fechaFinQuincena)
        {
            var resultado = new List<vwDatosAspirantesTrabajadoresAsistencias>();

            // Agrupar registros por IdTrabajador
            var gruposPorTrabajador = registros.GroupBy(r => r.IdTrabajador);

            foreach (var grupo in gruposPorTrabajador)
            {
                var registrosTrabajador = grupo.ToList();
                var plazaBase = registrosTrabajador.FirstOrDefault(r => r.EsPlazaBase==true);
                var comision = registrosTrabajador.FirstOrDefault(r => r.EsPlazaBase==false);

                // Si solo hay un tipo de registro, lo incluimos si está activo durante la quincena
                if (plazaBase == null || comision == null)
                {
                    resultado.AddRange(registrosTrabajador.Where(r =>
                        r.FechaInicio <= fechaFinQuincena && (r.FechaTermino == null || r.FechaTermino >= fechaInicioQuincena)));
                    continue;
                }

                // Verificar si la comisión está activa durante la quincena
                bool comisionActiva = comision.FechaInicio <= fechaFinQuincena &&
                                      (comision.FechaTermino == null || comision.FechaTermino >= fechaInicioQuincena);

                if (comisionActiva)
                {
                    if (comision.FechaInicio <= fechaInicioQuincena)
                    {
                        // La comisión inicia antes o en la fecha de inicio de la quincena, incluimos ambos

                        resultado.Add(comision);
                        if ((comision.FechaInicio.Value.Year == fechaInicioQuincena.Year &&
                            comision.FechaInicio.Value.Month == fechaInicioQuincena.Month)
                            ||
                                (comision.FechaTermino.Value.Year == fechaInicioQuincena.Year &&
                            comision.FechaTermino.Value.Month == fechaInicioQuincena.Month))
                        {
                            resultado.Add(plazaBase);
                        }

                    }
                    else
                    if (comision.FechaInicio >= fechaInicioQuincena && comision.FechaInicio <= fechaFinQuincena)
                    {
                        // LA COMISION INICIA ENTRE AL QUINCENA , SE AGREGA LA PLAZA BASE
                        resultado.Add(plazaBase);
                        resultado.Add(comision);
                    }
                    else
                        {
                        // La comisión inicia después de la fecha de inicio de la quincena, solo incluimos la comisión
                        resultado.Add(comision);
                    }
                }
                else
                {
                    // La comisión no está activa, incluimos la plaza base si está activa
                    if (plazaBase.FechaInicio <= fechaFinQuincena &&
                        (plazaBase.FechaTermino == null || plazaBase.FechaTermino >= fechaInicioQuincena))
                    {
                        resultado.Add(plazaBase);
                    }
                }
            }

            return resultado;
        }

        // POST: IncidenciaPermiso_stIncidenciaTrabajador/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdIncidenciaTrabajador,IdConvenioLaboralTrabajadorCategoria,IdTipoIncidencia,FechaInicio,FechaTermino,Observaciones,UserId,FechaCreacion,IdNominaTrabajador,EsAplicada,EsSubsecuente,DiasPagados100,DiasPagados40,DiasAcumulados,IdIncidenciaTrabajadorPadre,IdConvenioLaboralTrabajadorCategoriaRegistro,Autorizo,IdConvenioLaboralTrabajadorCategoriaAutorizo,IdIncidenciaJustificacion,IdConvenioLaboralTrabajadorCategoriaJustifico,DescripcionJustificacion,FechaJustificacion,QuincenasCalculadas,PercepcionDiaria,Horas,FechaAutorizacion,EsJustificacionExtemporanea")] IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador)
        {
            if (ModelState.IsValid)
            {
                db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia.AsNoTracking(), "IdTipoIncidencia", "Incidencia", incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria.AsNoTracking(), "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria.AsNoTracking(), "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria.AsNoTracking(), "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo);
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion.AsNoTracking(), "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador.AsNoTracking(), "IdNominaTrabajador", "IdNominaTrabajador", incidenciaPermiso_stIncidenciaTrabajador.IdNominaTrabajador);
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }
        public ActionResult VerRegistrosReloj(int id, string fi = null, string ff = null)
        {
            string fii = null;
            string fff = null;
            if (fi != null)
            {
                fii = fi.Substring(0, 10);
                fff = ff.Substring(0, 10);
            }
            //ViewBag.NombreMes = nm;
            //ViewBag.NoQuincena = nq;
            ViewBag.Trabajador = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(z => z.IdTrabajador == id && z.RestringirMenu == null).FirstOrDefault();
            //var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == id && DbFunctions.TruncateTime(x.FechaAsistencia) >= DbFunctions.TruncateTime(fii) &&  DbFunctions.TruncateTime(x.FechaAsistencia) <= DbFunctions.TruncateTime(fff)).OrderBy(z => z.FechaAsistencia).ToList(); 
            return PartialView(IncidenciaPermiso_stIncidenciaTrabajador.getAsistencias(id, fii, fff));
        }

        public ActionResult AsistenciasReloj(int id)
        {

            //ViewBag.NombreMes = nm;
            //ViewBag.NoQuincena = nq;
            ViewBag.Trabajador = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(z => z.IdTrabajador == id && z.RestringirMenu == null).FirstOrDefault();
            //var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == id && DbFunctions.TruncateTime(x.FechaAsistencia) >= DbFunctions.TruncateTime(fii) &&  DbFunctions.TruncateTime(x.FechaAsistencia) <= DbFunctions.TruncateTime(fff)).OrderBy(z => z.FechaAsistencia).ToList(); 
            return View("VerRegistrosReloj", IncidenciaPermiso_stIncidenciaTrabajador.getAsistencias(id, null, null));
        }

        public ActionResult JustificarIncidenciaResponsable(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            int IdTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.IdIncidenciaTrabajador == id).FirstOrDefault().Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            var dtrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(x => x.IdConvenioLaboralTrabajadorCategoria== incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            ViewBag.IdTrabajador = IdTrabajador;
            
            ViewBag.Trabajador = $"{dtrabajador.Nombre} {dtrabajador.ApellidoPaterno} {dtrabajador.ApellidoMaterno} - {dtrabajador.ConvenioLaboral}- {dtrabajador.RelacionLaboral} {dtrabajador.Categoria}";
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion.AsNoTracking().OrderBy(z => z.IncidenciaJustificacion), "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.AsNoTracking().Where(x => x.IdTrabajador == IdTrabajador && DbFunctions.TruncateTime(x.FechaAsistencia) == DbFunctions.TruncateTime(incidenciaPermiso_stIncidenciaTrabajador.FechaInicio)).OrderBy(z => z.FechaAsistencia).ToList(); ;
            ViewBag.incidenciasreloj = incidenciasreloj;
            return PartialView("JustificarIncidenciaResponsable", incidenciaPermiso_stIncidenciaTrabajador);
        }

        // GET: IncidenciaPermiso_stIncidenciaTrabajador/Edit/5
        public ActionResult JustificarIncidencia(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            int IdTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.IdIncidenciaTrabajador == id).FirstOrDefault().Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

            vwDatosAspirantesTrabajadores dtrabajador = new vwDatosAspirantesTrabajadores();
            dtrabajador = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(z => z.IdTrabajador == IdTrabajador && z.RestringirMenu == null).FirstOrDefault();
            if (dtrabajador == null)
            {
                dtrabajador = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(z => z.IdTrabajador == IdTrabajador).FirstOrDefault();
            }
           // var dtrabajador = db.vwDatosAspirantesTrabajadores.Where(x => x.IdTrabajador == IdTrabajador && x.RestringirMenu == null).FirstOrDefault();
            ViewBag.IdTrabajador = IdTrabajador;
            
            ViewBag.Trabajador = $"{dtrabajador.Nombre} {dtrabajador.ApellidoPaterno} {dtrabajador.ApellidoMaterno} - {dtrabajador.ConvenioLaboral}- {dtrabajador.RelacionLaboral} {dtrabajador.Categoria}";

            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion.AsNoTracking().OrderBy(z => z.IncidenciaJustificacion), "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.AsNoTracking().Where(x => x.IdTrabajador == IdTrabajador && DbFunctions.TruncateTime(x.FechaAsistencia) == DbFunctions.TruncateTime(incidenciaPermiso_stIncidenciaTrabajador.FechaInicio)).OrderBy(z => z.FechaAsistencia).ToList(); ;
            ViewBag.incidenciasreloj = incidenciasreloj;
            return PartialView(incidenciaPermiso_stIncidenciaTrabajador);
        }


        // POST: IncidenciaPermiso_stIncidenciaTrabajador/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult JustificarIncidenciaResponsable()
        {
            long id = System.Convert.ToInt64(Request.Form["IdIncidenciaTrabajador"]);
            int idij = System.Convert.ToInt32(Request.Form["hfIdincidenciajustificacion"]);
            string observacion = System.Convert.ToString(Request.Form["hfIdObservacion"]);

            var usuario = Seguridad.Identidad.Usuario();
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = idij;
            var incidenciajustificacion = db.Incidencia_ctJustificacion.AsNoTracking().Where(z => z.IdIncidenciaJustificacion == idij).FirstOrDefault();
            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(x => x.IdConvenioLaboralTrabajadorCategoria == incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            if (incidenciajustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO")
            {
                var diaseconomicosmes = db.Catalogos_ctParametrosRelacionLaboral.AsNoTracking().Where(x => x.IdRelacionConvenioLaboral == datostrabajador.IdRelacionConvenioLaboral && x.FechaInicio.Year == DateTime.Now.Year).OrderByDescending(f => f.FechaFinal).FirstOrDefault();
                if (diaseconomicosmes != null)
                {
                    int diaseconomicosdisfrutadosaño = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                    && z.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year
                    && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                    
                    ).Count();

                    if (diaseconomicosdisfrutadosaño >= diaseconomicosmes.DiasEconomicosPorAño)
                    {
                        ModelState.AddModelError("error2", "Ya ha disfrutado sus " + diaseconomicosmes.DiasEconomicosPorAño + " días económicos permitidos por año");
                    }
                    else
                    {
                        int diaseconomicosdisfrutadosmes = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                        && z.FechaInicio.Month == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Month
                         && z.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year
                        && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                        && ((z.FechaAutorizacion != null && z.Autorizo == true) || (z.FechaJustificacion != null && z.FechaAutorizacion == null))
                        ).Count();
                        if (diaseconomicosdisfrutadosmes >= diaseconomicosmes.MaximoDiasEconomicosMensuales)
                        {
                            ModelState.AddModelError("error1", "Ya ha disfrutado sus " + diaseconomicosmes.MaximoDiasEconomicosMensuales + " días económicos permitidos por mes");
                        }
                    }
                }

            }
            incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = DateTime.Now;
            incidenciaPermiso_stIncidenciaTrabajador.Observaciones = observacion;
            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaJustifico = usuario.IdConvenioLaboralTrabajadorCategoria;

            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = "La justificación de la incidencia se realizó exitosamente" }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // POST: IncidenciaPermiso_stIncidenciaTrabajador/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult JustificarIncidencia()
        {
            long id = System.Convert.ToInt64(Request.Form["IdIncidenciaTrabajador"]);
            int idij = System.Convert.ToInt32(Request.Form["hfIdincidenciajustificacion"]);
            string observacion = System.Convert.ToString(Request.Form["hfIdObservacion"]);

            var usuario = Seguridad.Identidad.Usuario();
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = idij;
            var incidenciajustificacion = db.Incidencia_ctJustificacion.AsNoTracking().Where(z => z.IdIncidenciaJustificacion == idij).FirstOrDefault();
            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(x => x.IdConvenioLaboralTrabajadorCategoria == incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            if (incidenciajustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO")
            {
                var diaseconomicosmes = db.Catalogos_ctParametrosRelacionLaboral.AsNoTracking().Where(x => x.IdRelacionConvenioLaboral == datostrabajador.IdRelacionConvenioLaboral && x.FechaInicio.Year == DateTime.Now.Year).OrderByDescending(f => f.FechaFinal).FirstOrDefault();
                if (diaseconomicosmes != null)
                {
                    int diaseconomicosdisfrutadosaño = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                    && z.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year
                    && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                   
                    ).Count();

                    Nomina_stNominaTrabajador NominaTrabajador = new Nomina_stNominaTrabajador();
                    NominaTrabajador.setLicenciasPrimaVacaional(incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year);
                    var regresadeLicencia = NominaTrabajador.LicenciasTrabajadoresPrimavacacional.Where(s => s.IdTrabajador == datostrabajador.IdTrabajador).FirstOrDefault();

                    int SindiaseconomicosPorLicencias = 0;
                    if (regresadeLicencia != null)
                        if (regresadeLicencia.FechaTerminoIncidencia != null)
                        { 
                             
                                // diasAPagar = diasAPagar -NominaTrabajador.DiasdePrima(ConvenioLaboralTrabajadorCategoria, regresadeLicencia);
                                SindiaseconomicosPorLicencias =  NominaTrabajador.DiasEconomicosADescontarPorLicencias((DateTime)regresadeLicencia.FechaTerminoIncidencia.Value.AddDays(1), regresadeLicencia.FechaInicioIncidencia, incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year);
                            diaseconomicosmes.DiasEconomicosPorAño = (short?)(diaseconomicosmes.DiasEconomicosPorAño.Value - (short)SindiaseconomicosPorLicencias);
                        }

                    

                    if (diaseconomicosdisfrutadosaño >= diaseconomicosmes.DiasEconomicosPorAño)
                    {
                        if (SindiaseconomicosPorLicencias > 0)
                            ModelState.AddModelError("error2", "Ya ha disfrutado sus " + diaseconomicosmes.DiasEconomicosPorAño + " días económicos permitidos por año, recuerde qeu tuvo licencia si goce de sueldo y no tiene derecho a :"+ SindiaseconomicosPorLicencias + " dias económicos" );
                        else
                            ModelState.AddModelError("error2", "Ya ha disfrutado sus " + diaseconomicosmes.DiasEconomicosPorAño + " días económicos permitidos por año");
                    }
                    else
                    {
                        int diaseconomicosdisfrutadosmes = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                        && z.FechaInicio.Month == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Month
                        && z.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year
                        && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                        && ((z.FechaAutorizacion != null && z.Autorizo == true) || (z.FechaJustificacion != null && z.FechaAutorizacion == null))
                        ).Count();
                        if (diaseconomicosdisfrutadosmes >= diaseconomicosmes.MaximoDiasEconomicosMensuales)
                        {
                            ModelState.AddModelError("error1", "Ya ha disfrutado sus " + diaseconomicosmes.MaximoDiasEconomicosMensuales + " días económicos permitidos por mes");
                        }
                    }
                }

            }
            incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = DateTime.Now;
            incidenciaPermiso_stIncidenciaTrabajador.Observaciones = observacion;
            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaJustifico = usuario.IdConvenioLaboralTrabajadorCategoria;

            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                     }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = "La justificación de la incidencia se realizó exitosamente" }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        [HttpPost]
        public ActionResult EliminarPase(long id)
        {

            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = "Se eliminó exitosamente la incidencia" }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        public ActionResult EliminarDictamen(long id)
        {

            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador.EsCerrada == true)
            {
                ModelState.AddModelError("E1", "No es posible eliminar una incidencia cerrada");
            }

            if (ModelState.IsValid)
            {
                try
                {
                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaJustifico = null;
                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = 0;
                    incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = null;
                    incidenciaPermiso_stIncidenciaTrabajador.DescripcionJustificacion = null;
                    incidenciaPermiso_stIncidenciaTrabajador.Observaciones = null;
                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                    incidenciaPermiso_stIncidenciaTrabajador.FechaAutorizacion = null;

                    db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = "Se eliminó exitosamente el dictamen" }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult EliminarJustificacion(long id)
        {

            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador.EsCerrada == true)
            {
                ModelState.AddModelError("E1", "No es posible eliminar una incidencia cerrada");
            }

            if (ModelState.IsValid)
            {
                try
                {
                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaJustifico = null;
                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = 0;
                    incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = null;
                    incidenciaPermiso_stIncidenciaTrabajador.DescripcionJustificacion = null;
                    incidenciaPermiso_stIncidenciaTrabajador.Observaciones = null;
                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                    incidenciaPermiso_stIncidenciaTrabajador.FechaAutorizacion = null;

                    db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = "Se eliminó exitosamente la justificación" }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

       
        public ActionResult EliminarFalta(long id)
        {

            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            if (incidenciaPermiso_stIncidenciaTrabajador.EsFaltaDirecta != true)
            {
                return Json(new { Valid = false, Message = "Esta incidencia fue generada automáticamente por el sistema por lo que no puede ser eliminada, " }, JsonRequestBehavior.AllowGet);
            }

            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = "Se eliminó exitosamente la incidencia" }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: IncidenciaPermisoTrabajador/Edit/5
        public ActionResult AutorizarIncidencia(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }

            

            int IdTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.IdIncidenciaTrabajador == id).FirstOrDefault().Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            var dtrabajador = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(x => x.IdTrabajador == IdTrabajador).FirstOrDefault();

            var idu = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            //var hay = db.Nomina_RelojChecadorControlUsuarios.AsNoTracking().Where(d =>
            //dtrabajador.UbicacionFisica==uf 
            //&& d.IdConvenioLaboralTrabajadorCategoria == id).FirstOrDefault();
            //if (hay == null)
            //{
            //    return HttpNotFound();
            //}

            ViewBag.IdTrabajador = IdTrabajador;
            ViewBag.Trabajador = dtrabajador.Nombre + " " + dtrabajador.ApellidoPaterno + " " + dtrabajador.ApellidoMaterno;
            ViewBag.IdIncidenciaJustificacionA = new SelectList(db.Incidencia_ctJustificacion.AsNoTracking(), "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.AsNoTracking().Where(x => x.IdTrabajador == IdTrabajador && DbFunctions.TruncateTime(x.FechaAsistencia) == DbFunctions.TruncateTime(incidenciaPermiso_stIncidenciaTrabajador.FechaInicio)).OrderBy(z => z.FechaAsistencia).ToList(); ;
            ViewBag.incidenciasreloj = incidenciasreloj;
            ViewBag.idij = incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion;
            return PartialView(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: IncidenciaPermiso_stIncidenciaTrabajador/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult AutorizarIncidencia()
        {
            long id = System.Convert.ToInt64(Request.Form["IdIncidenciaTrabajador"]);

            int autorizo = System.Convert.ToInt32(Request.Form["hfautorizo"]);
            string observacion = System.Convert.ToString(Request.Form["Observaciones"]);
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            string msj = "";
              int idij = System.Convert.ToInt32(Request.Form["Idincidenciajustificacion"]);
             
             if (idij == 0 &&
                incidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia != "PRIMA DOMINICAL"
                 &&
                            incidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia != "DIAS DE DESCANSO OBLIGATORIO")
            {
                ModelState.AddModelError("Error", "Debe seleccionar una justificación");
            }

            //int idij = System.Convert.ToInt32(Request.Form["hfIdincidenciajustificacion"]);
            var usuario = Seguridad.Identidad.Usuario();
             incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = idij;
            incidenciaPermiso_stIncidenciaTrabajador.FechaAutorizacion = DateTime.Now;
            incidenciaPermiso_stIncidenciaTrabajador.Observaciones = observacion;

            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = usuario.IdConvenioLaboralTrabajadorCategoria;
            //incidenciaPermiso_stIncidenciaTrabajador.Observaciones = observacion;
            if (autorizo==1)
            {
                incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                msj = "La NO autorización de la incidencia se realizó exitosamente";

            }
            else
            {
                msj = "La autorización de la incidencia se realizó exitosamente";
                incidenciaPermiso_stIncidenciaTrabajador.Autorizo = true;
                //if (idijNuevo > 0)
                //{
                //    if (idijAnterior != idijNuevo)
                //    {
                //        incidenciaPermiso_stIncidenciaTrabajador.Observaciones = incidenciaPermiso_stIncidenciaTrabajador.Observaciones
                //        + " se sustituyo la justificación: " + db.Incidencia_ctJustificacion.Where(z => z.IdIncidenciaJustificacion == idijAnterior).FirstOrDefault().IncidenciaJustificacion
                //        + " por " + db.Incidencia_ctJustificacion.Where(z => z.IdIncidenciaJustificacion == idijNuevo).FirstOrDefault().IncidenciaJustificacion;
                //        incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = idijNuevo;
                //    }
                //}

            }
            var incidenciajustificacion = db.Incidencia_ctJustificacion.AsNoTracking().Where(z => z.IdIncidenciaJustificacion == idij).FirstOrDefault();

            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(x => x.IdConvenioLaboralTrabajadorCategoria == incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            if (incidenciajustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO")
            {
                var diaseconomicosmes = db.Catalogos_ctParametrosRelacionLaboral.AsNoTracking().Where(x => x.IdRelacionConvenioLaboral == datostrabajador.IdRelacionConvenioLaboral && x.FechaInicio.Year == DateTime.Now.Year).OrderByDescending(f => f.FechaFinal).FirstOrDefault();
                if (diaseconomicosmes != null)
                {
                    int diaseconomicosdisfrutadosaño = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                    && z.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year
                    && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                    && ((z.FechaAutorizacion != null && z.Autorizo == true) || (z.FechaJustificacion != null && z.FechaAutorizacion == null))
                    ).Count();

                    if (diaseconomicosdisfrutadosaño > diaseconomicosmes.DiasEconomicosPorAño)
                    {
                        ModelState.AddModelError("error2", "Ya ha disfrutado sus " + diaseconomicosmes.DiasEconomicosPorAño + " días económicos permitidos por año");
                    }
                    else
                    {
                        int diaseconomicosdisfrutadosmes = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                        && z.FechaInicio.Month == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Month
                           && z.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year
                        && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                        && ((z.FechaAutorizacion != null && z.Autorizo == true) || (z.FechaJustificacion != null && z.FechaAutorizacion == null))
                        ).Count();
                        if (diaseconomicosdisfrutadosmes > diaseconomicosmes.MaximoDiasEconomicosMensuales)
                        {
                            ModelState.AddModelError("error1", "Ya ha disfrutado sus " + diaseconomicosmes.MaximoDiasEconomicosMensuales + " días económicos permitidos por mes");
                        }
                    }
                }

            }
             if (datostrabajador.IdModalidadEstudio==0)
            {
                if (!incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion.HasValue)
                {
                    incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = DateTime.Now;
                }
            }
            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                    IncidenciaPermisoTrabajadorProcesoEstatus proceso = new IncidenciaPermisoTrabajadorProcesoEstatus();
                    proceso.GuardaEstatus(datostrabajador.IdEstructuraOrganicaFisica, Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria, IncidenciaPermisoTrabajadorProcesoEstatus.ObtenerQuincena(incidenciaPermiso_stIncidenciaTrabajador.FechaInicio), incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year, IncidenciasProcesosEstatus.AUTORIZADO);

                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult CancelarIncidencia(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            int IdTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => z.IdIncidenciaTrabajador == id).FirstOrDefault().Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            var dtrabajador = db.vwDatosAspirantesTrabajadores.AsNoTracking().Where(x => x.IdTrabajador == IdTrabajador).FirstOrDefault();
            ViewBag.IdTrabajador = IdTrabajador;
            ViewBag.Trabajador = dtrabajador.Nombre + " " + dtrabajador.ApellidoPaterno + " " + dtrabajador.ApellidoMaterno;
            ViewBag.Justificacion = db.Incidencia_ctJustificacion.AsNoTracking().Where(s=>s.IdIncidenciaJustificacion== incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion).FirstOrDefault().IncidenciaJustificacion;
            var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.AsNoTracking().Where(x => x.IdTrabajador == IdTrabajador && DbFunctions.TruncateTime(x.FechaAsistencia) == DbFunctions.TruncateTime(incidenciaPermiso_stIncidenciaTrabajador.FechaInicio)).OrderBy(z => z.FechaAsistencia).ToList(); ;
            ViewBag.incidenciasreloj = incidenciasreloj;
            return PartialView(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: IncidenciaPermiso_stIncidenciaTrabajador/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult CancelarIncidencia()
        {

            string msj = "La Cancelación de la Incidencia se realizó exitosamente !!";
            long id = System.Convert.ToInt64(Request.Form["IdIncidenciaTrabajador"]);

            var usuario = Seguridad.Identidad.Usuario();
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = usuario.IdConvenioLaboralTrabajadorCategoria;
            incidenciaPermiso_stIncidenciaTrabajador.EsCancelada = true;
            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message }, JsonRequestBehavior.AllowGet);
                }
                return Json(new { Valid = true, Message = msj }, JsonRequestBehavior.AllowGet);

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: IncidenciaPermisoTrabajador/Delete/5
        public ActionResult Delete(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: IncidenciaPermisoTrabajador/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(long id)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
