﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using System.Web.Mail;
using System.Net.Mail;
using System.Net;
using Dapper;
using Seguridad;
using System.Threading;

namespace Nova.Controllers
{
      [Authorize]
    public class HomeController : Controller
    {


        public ActionResult ReenviarEmailsAceptados()
        {
            try
            {
                bdNovaEntities bd = new bdNovaEntities();
                Libraries.DapperQuery dp = new Libraries.DapperQuery("bdNovaEntities");

                string query = @"SELECT  a.IdKardexSolicitudEvaluacion
FROM [bdNova].[dbo].[Kardex_SolicitudEvaluacionesEstatus] a
inner join  Catalogos_ctEstatusContratos b on a.IdEstatusContratacion=b.IdEstatusContratos
inner join Kardex_SolicitudEvaluaciones c on c.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
where b.EstatusContratos='ACEPTABLE' and CicloEscolar='2025-1'";
                List<long> lista = (List<long>)dp.connection.Query<long>(query.ToString());

                // Obtener todas las solicitudes con estatus 2 (aceptados)
                var solicitudesAceptadas = bd.Kardex_SolicitudEvaluaciones
                    .Where(s => lista.Contains(s.IdKardexSolicitudEvaluacion))
                    .ToList();

                int totalEnviados = 0;
                int errores = 0;
                const int LOTE_ENVIO = 100;
                const int PAUSA_SEGUNDOS = 30;

                foreach (var solicitud in solicitudesAceptadas)
                {
                    try
                    {
                        UrlEncryptor crip = new UrlEncryptor(new { Id = solicitud.IdKardexSolicitudEvaluacion });
                        string baseUrl = "https://www.cecyteo.edu.mx/nova/Seleccion/Index?token=" + crip.EncryptedQueryString;
                        Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailIngresoPersonal(baseUrl, solicitud.IdKardexSolicitudEvaluacion);
                        totalEnviados++;

                        // Hacer una pausa cada 100 correos
                        if (totalEnviados % LOTE_ENVIO == 0 && totalEnviados < solicitudesAceptadas.Count)
                        {
                            System.Threading.Thread.Sleep(PAUSA_SEGUNDOS * 1000); // Pausa de 30 segundos
                            System.Diagnostics.Debug.WriteLine($"Pausa de {PAUSA_SEGUNDOS} segundos después de enviar {totalEnviados} correos...");
                        }
                    }
                    catch (Exception ex)
                    {
                        errores++;
                        System.Diagnostics.Debug.WriteLine($"Error al enviar correo para solicitud {solicitud.IdKardexSolicitudEvaluacion}: {ex.Message}");
                        continue;
                    }
                }

                return Json(new
                {
                    success = true,
                    message = $"Proceso completado: {totalEnviados} correos enviados, {errores} errores",
                    detalles = new
                    {
                        totalProcesados = solicitudesAceptadas.Count,
                        exitosos = totalEnviados,
                        errores = errores,
                        pausasRealizadas = totalEnviados / LOTE_ENVIO
                    }
                }, JsonRequestBehavior.AllowGet);
            }
            catch (Exception ex)
            {
                return Json(new { success = false, message = "Error al procesar las solicitudes: " + ex.Message }, JsonRequestBehavior.AllowGet);
            }
        }
        public ActionResult Reenviaemail(long idks)
        {
            bdNovaEntities bd = new bdNovaEntities();
            var item = bd.Kardex_SolicitudEvaluaciones.Find(idks);
            UrlEncryptor crip = new UrlEncryptor(new { Id = item.IdKardexSolicitudEvaluacion });
            string baseUrl = Request.Url.GetLeftPart(UriPartial.Authority) + Url.Action("Index", "Seleccion", new { token = crip.EncryptedQueryString });

            Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailIngresoPersonal(baseUrl, item.IdKardexSolicitudEvaluacion);



            return View();
        }
        public ActionResult enviaemailscitas()
        {
            bdNovaEntities bd = new bdNovaEntities();
            //var lista = bd.Kardex_SolicitudEvaluaciones.Where(a => a.Catalogos_ctEstatusContratos.EstatusContratos == "ACEPTABLE").ToList();

            var cicloEscolarMaximo = bd.Kardex_SolicitudEvaluaciones
                        .Where(a => a.Catalogos_ctEstatusContratos.EstatusContratos != "RECHAZADA")
                        .Max(a => a.CicloEscolar);

            var lista = bd.Kardex_SolicitudEvaluaciones
                .Where(a => a.Catalogos_ctEstatusContratos.EstatusContratos != "RECHAZADA"
                            && a.CicloEscolar == cicloEscolarMaximo).ToList();

            foreach (var item in lista)
            {
                UrlEncryptor crip = new UrlEncryptor(new { Id = item.IdKardexSolicitudEvaluacion });
                string baseUrl = Request.Url.GetLeftPart(UriPartial.Authority) + Url.Action("Index", "Seleccion", new { token = crip.EncryptedQueryString });
                Thread.Sleep(3000);
                Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailIngresoPersonal(baseUrl, item.IdKardexSolicitudEvaluacion);

            }

            return View(lista);
        }

        public ActionResult TimeoutRedirect()
        {
            return View();
        }
        public ActionResult CheckTimeout()
        {
            return View();
        }

        //
        // GET: /Home/

        public ActionResult Index()
        {
            Libraries.DapperQuery dp = new Libraries.DapperQuery("bdAriesEntities");
            List<stHorario> r = (List<stHorario>)dp.connection.Query<stHorario>("SELECT IdHorario,IdCicloEscolar,IdPlanEstudioAsignatura,IdGrupoCampus,IdEmpleado,IdCurso,Autorizado,IdReglamento FROM stHorario where idcicloescolar=22");


            bdNovaEntities db = new bdNovaEntities();
            if (HttpContext.User.Identity.IsAuthenticated)
            {
                ViewData["HtmlAlertas"] = "";
                HttpContext.Session["Nombre"] = HttpContext.User.Identity.Name;
                string nombre = HttpContext.Session["Nombre"].ToString();
                if (HttpContext.Session["IdKardex"] == null)
                {
                    var usuario = from a in db.AspNetUsers
                                  join b in db.UsuarioKardex on a.Id equals b.Id
                                  join c in db.Kardex_ctDatosPersonales on b.IdKardex equals c.IdKardex
                                  where a.UserName == nombre
                                  select new { IdKardex = c.IdKardex, NombreUsuario = c.Nombre + " " + c.ApellidoPaterno + " " + c.ApellidoMaterno };
                    HttpContext.Session["IdKardex"] = usuario.First().IdKardex;
                    HttpContext.Session["NombreUsuario"] = usuario.First().NombreUsuario;
                    int idk = (int)HttpContext.Session["IdKardex"];
                    var ideo = from a in db.Convenios_stConvenioLaboralTrabajadorCategoria
                               join b in db.Convenios_stConvenioLaboralTrabajador on a.IdConvenioLaboralTrabajador equals b.IdConvenioLaboralTrabajador
                               join c in db.Kardex_ctTrabajador on b.IdTrabajador equals c.IdTrabajador
                               join d in db.Catalogos_ctEstructuraOrganica on a.IdEstructuraOrganica equals d.IdEstructuraOrganica
                               where c.IdKardex == idk
                               orderby a.FechaInicio descending
                               select new { IdTrabajador = b.IdTrabajador, IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria, FechaInicio = a.FechaInicio, IdEstructuraOrganica = a.IdEstructuraOrganica, EstructuraOrganica = d.EstructuraOrganica };
                    if (ideo.Count() == 0)
                    {
                        throw new Exception("El usuario no es un trabajador activo, no es posible acceder a la funcionalidad");
                    }
                    HttpContext.Session["IdEstructuraOrganicaFisica"] = ideo.First().IdEstructuraOrganica;



                    //if (usuario.First().NombreUsuario.IndexOf("JUAN CARLOS MANUEL", 0, StringComparison.InvariantCultureIgnoreCase) > -1 || usuario.First().NombreUsuario.IndexOf("ANA ITA", 0, StringComparison.InvariantCultureIgnoreCase) > -1 || usuario.First().NombreUsuario.IndexOf("CLAUDIO ELIEZER", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
                    //    HttpContext.Session["AreaUsuario"] = "EMSAD";
                    //else
                    //    if (usuario.First().NombreUsuario.IndexOf("ALMA ROSA", 0, StringComparison.InvariantCultureIgnoreCase) > -1 )
                    //        HttpContext.Session["AreaUsuario"] = "PLANTEL";


                    //else
                    HttpContext.Session["AreaUsuario"] = ideo.First().EstructuraOrganica;

                    //HttpContext.Session["AreaUsuario"] = ideo.First().EstructuraOrganica;


                    HttpContext.Session["IdTrabajador"] = ideo.First().IdTrabajador;
                    List<Seguridad.MenuItem> ap = new List<Seguridad.MenuItem>();
                    try
                    {
                        ap = Identidad.Roles();
                        var rr = ap.Where(z => z.RoleName == "Nomina").ToList();
                        if (rr.Count() > 0)
                        {
                            AlertasNomina mcnom = new AlertasNomina();
                            mcnom.GeneraAlertas();
                            mcnom.Show(ViewData, true);

                        }

                    }
                    catch (Exception e)
                    {
                        throw new Exception(e.Message);
                    }


                }
                //Para capacitación

                //AlertasEventos xx = new AlertasEventos();
                //xx.GeneraAlertas();
                //xx.Show(ViewData);

                AlertasCapacitacion ac = new AlertasCapacitacion();
                ac.GeneraAlertas();
                ac.Show(ViewData, true);

                AlertasMisCursos mc = new AlertasMisCursos();
                mc.GeneraAlertas();
                mc.Show(ViewData, true);

                //AlertasServicioProfesionalDocente mcspd = new AlertasServicioProfesionalDocente();
                //mcspd.GeneraAlertas();
                //mcspd.Show(ViewData, true);

                //

            }
            //throw new Exception("Excepción no controlada");
            return View();
            // return RedirectToAction("Registro", "Home");
            //  return View("_registro");
        }

        // GET: /Error/


        public ActionResult Registro()
        {
            //throw new Exception("Excepción no controlada");
            return View("_registro");
        }





        [HttpPost]
        public ActionResult ValidarID()
        {

            bdNovaEntities db = new bdNovaEntities();

            Int32 idemp = ConvertToInt.ConvertToInt32(Request["IdEmpleado"]);
            Models.Kardex_ctDatosPersonales idtrabajador = db.Kardex_ctDatosPersonales.Where(b => b.IdeEmpleadoAnt == idemp).FirstOrDefault();
            if (idtrabajador == null)
            {
                MessageBox.Show(ViewData, TipoMensaje.Error, "No existe ese Id en nuestra base de datos, verifique su informacion");
                return View("_registro");
            }
            else
            {
                idtrabajador = null;
                idtrabajador = db.Kardex_ctDatosPersonales.Where(b => b.IdeEmpleadoAnt == idemp && b.ProcesoCompletado == false).FirstOrDefault();
                if (idtrabajador == null)
                {
                    idtrabajador = db.Kardex_ctDatosPersonales.Where(b => b.IdeEmpleadoAnt == idemp).FirstOrDefault();
                    string check = Cifrado.Encrypt(idtrabajador.CorreoElectronico + idtrabajador.IdKardex.ToString());
                    return RedirectToAction("terminado", "DatosPersonales", new { id = idtrabajador.IdKardex, email = idtrabajador.CorreoElectronico, check = check });
                }
                else

                    //return View("registroPaso2", new { id = idtrabajador.IdKardex });
                    ViewBag.NombreTrabajador = idtrabajador.Nombre + ' ' + idtrabajador.ApellidoPaterno + ' ' + idtrabajador.ApellidoMaterno;
                ViewBag.id = idtrabajador.IdKardex;
                return View("_confirmarId");


            }

        }

        [HttpPost]
        public ActionResult RegistroPaso2(Int32 id)
        {
            //throw new Exception("Excepción no controlada");
            ViewBag.Id = id;
            return View("RegistroPaso2");
        }


        [HttpPost]
        public ActionResult EnviarEmail()
        {

            bdNovaEntities db = new bdNovaEntities();

            string email = (Request["email"]).Trim();
            string id = (Request["Id"]).Trim();


            Int16 ide = ConvertToInt.ConvertToInt16(id);

            var existe = db.Kardex_ctDatosPersonales.Where(g => g.CorreoElectronico == email && g.IdeEmpleadoAnt != ide).Select(e => e.CorreoElectronico).SingleOrDefault();
            if (existe == null)
            {


                ViewBag.email = email;

                System.Net.Mail.MailMessage msg = new System.Net.Mail.MailMessage();

                msg.From = new MailAddress("infonominas@cecyteo.edu.mx");
                msg.To.Add(email);
                msg.Subject = "Actualización de información laboral";
                msg.IsBodyHtml = true;
                string codificado = Cifrado.Encrypt(email + id.ToString());

                UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

                string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Edit", "DatosPersonales", new { id = id, email = email, check = HttpUtility.UrlEncode(codificado) });


                msg.Body = "<p>Estimado Trabajador</p><strong></strong><p>Para iniciar su proceso de actualización de información de datos personales y familiares de clic en la siguiente liga <a href='" + url + "'>clic aquí</a> ";

                msg.Body = msg.Body + " <p></p><p><strong>Cualquier duda o aclaración con este proceso favor de dirigirse con el Departamento de Recursos Humanos a los teléfonos : (951) 515-8036  ext. 234 de 08:00 a 16:00 horas de Lunes a Viernes.</strong></p> ";

                msg.Body = msg.Body + " <p></p><p>Este correo fue generado automáticamente, favor de no responder.</p>";


                //  msg.Priority = MailPriority.High;

                SmtpClient client = new SmtpClient();


                client.Credentials = new NetworkCredential("infonominas@cecyteo.edu.mx", "hola123@");
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                // client.UseDefaultCredentials = false;

                try
                {
                    client.Send(msg);
                    return View("mailenviado");
                }
                catch (Exception)
                {

                    throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
                }


            }

            else
            {
                MessageBox.Show(ViewData, TipoMensaje.Error, " El correo electronico : " + email + " ya ha sido registrado por otra persona en nuestra base de datos, si considera que hay un problema con esta situación por favor comuniquese al departamento de Recursos Humanos para cualquier aclaración o duda");
            }

            return View("registropaso2");



        }

    }
}
