﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class GrupoPercepcionDeduccionController : Controller
    {
        //
        // GET: /IsrGrupo/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvGridGrupoPercepcionDeduccion()
        {
            var model = db.Percepciones_ctGrupoPercepcionDeduccion;
            return PartialView("_pvGridGrupoPercepcionDeduccion", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvGridGrupoPercepcionDeduccionAddNew(Nova.Models.Percepciones_ctGrupoPercepcionDeduccion item)
        {
            var model = db.Percepciones_ctGrupoPercepcionDeduccion;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvGridGrupoPercepcionDeduccion", model.ToList());
        }
        //[HttpPost, ValidateInput(false)]
        //public ActionResult pvIsrGrupoUpdate(Nova.Models.Configuracion_stIsrGrupo item)
        //{
        //    var model = db.Configuracion_stIsrGrupo;
        //    if (ModelState.IsValid)
        //    {
        //        try
        //        {
        //            var modelItem = model.FirstOrDefault(it => it.IdIsrGrupo == item.IdIsrGrupo);
        //            if (modelItem != null)
        //            {
        //                this.UpdateModel(modelItem);
        //                db.SaveChanges();
        //            }
        //        }
        //        catch (Exception e)
        //        {
        //            ViewData["EditError"] = e.Message;
        //        }
        //    }
        //    else
        //        ViewData["EditError"] = "Please, correct all errors.";
        //    return PartialView("_pvIsrGrupo", model.ToList());
        //}
        [HttpPost, ValidateInput(false)]
        public ActionResult pvGridGrupoPercepcionDeduccionDelete(System.Int16 IdGrupoPercepcionDeduccion)
        {
            var model = db.Percepciones_ctGrupoPercepcionDeduccion;
            if (IdGrupoPercepcionDeduccion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdGrupoPercepcionDeduccion == IdGrupoPercepcionDeduccion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvGridGrupoPercepcionDeduccion", model.ToList());
        }
    }
}
