﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using System.Data.SqlClient;
using System.Configuration;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DevExpress.XtraLayout.Filtering.Templates;
using Nova.Models.Kardex;
using WebGrease.Activities;
using System.Web.UI.WebControls;
using Seguridad;
using System.Net.Sockets;
using System.Runtime.InteropServices.ComTypes;
using DevExpress.CodeParser;
using DevExpress.Utils.About;
using DevExpress.XtraEditors.Filtering.Templates;
using DevExpress.Utils.Extensions;
using Microsoft.Office.Interop.Excel;
using Nova.Models.Correo;

namespace Nova.Controllers.Kardex
{
    [AllowAnonymous]
    public class Foro_Estatal2024Controller : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

       
       

        //public ActionResult Details(int id)
        public ActionResult Detalles()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string query = string.Format(@"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from Kardex_DocumentosExpediente a
                         left join Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
                        where a.IdKardex = {0}
                        ", IdKardex);
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(query);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpediente.Where(z=> z.IdKardex == IdKardex));
        }





        // GET: KardexGradoAcademico/Create
        public ActionResult Registro()
        {
            int IdKardex = 920;
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            int IdConvenioLaboral = 24;

            string querytipodocumento;

            //querytipodocumento = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
            //INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
            //inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
            //where Tp.IdConvenioLaboral=@IdConvenioLaboral and Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
            //                        from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";
            querytipodocumento = @"SELECT *  
                                     FROM Kardex_stTipoDocumentoConvenio Tp
                                     INNER JOIN Kardex_TipoDocumento a ON a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
                                     INNER JOIN Catalogos_ctConvenioLaboral b ON b.IdConvenioLaboral = Tp.IdConvenioLaboral
                                     WHERE 
                                         Tp.IdConvenioLaboral = @IdConvenioLaboral
                                         AND (
                                             Tp.IdKardexTipoDocumento = 18 
                                             OR Tp.IdKardexTipoDocumento NOT IN (
                                                 SELECT IdKardexTipoDocumento 
                                                 FROM Kardex_DocumentosExpediente 
                                                 WHERE IdKardex = @IdKardex
                                             )
                                         )";
            var todastipodocumento = (List<Kardex_TipoDocumento>)dpcg.connection.Query<Kardex_TipoDocumento>(querytipodocumento, new { IdConvenioLaboral, IdKardex });

            dpcg.Close();

            ViewBag.IdKardex = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == IdKardex).FirstOrDefault().IdKardex;
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumento, "IdKardexTipoDocumento", "DocumentoExpediente");
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar");
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            return PartialView();
        }

        // POST: KardexGradoAcademico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [AllowAnonymous]
        [HttpPost]
        [ValidateAntiForgeryToken] // Recomiendo mantener esto para seguridad
        public ActionResult Registro([Bind(Include = "IdFolio, Nombre, ApellidoPaterno, ApellidoMaterno, InstitucionProcedencia, CorreoElectronico, Telefono, EsInvitado")] Foro_Estatal2024 foro_Estatal2024)
        {
            
            // Suponiendo que 'Records' es la propiedad de colección en tu modelo
            ViewBag.Registros = db.Foro_Estatal2024.Count();

            if (ModelState.IsValid)
            {

                var exists =db.Foro_Estatal2024.Any(f =>
                f.Nombre == foro_Estatal2024.Nombre &&
                    f.ApellidoPaterno == foro_Estatal2024.ApellidoPaterno &&
                    f.ApellidoMaterno == foro_Estatal2024.ApellidoMaterno);
                if (exists)
                {
                    return Json(new
                    {
                        Valid = false,
                        Message = "Ya existe un registro con estos datos.",
                        Errors = new[] { "Registro duplicado." }
                    });
                }
                else { 
                try
                {
                    // Crear una nueva instancia y asignar valores
                    var foro = new Foro_Estatal2024
                    {
                        Nombre = foro_Estatal2024.Nombre.ToUpper(),
                        ApellidoPaterno = foro_Estatal2024.ApellidoPaterno.ToUpper(),
                        ApellidoMaterno = foro_Estatal2024.ApellidoMaterno.ToUpper(),
                        InstitucionProcedencia = foro_Estatal2024.InstitucionProcedencia.ToUpper(),
                        CorreoElectronico = foro_Estatal2024.CorreoElectronico,
                        Telefono = foro_Estatal2024.Telefono,
                        EsInvitado = false
                    };

                    db.Foro_Estatal2024.Add(foro);
                    db.SaveChanges();
                        // Enviar email
                        enviaMailRegistro(foro_Estatal2024.CorreoElectronico);
                        return Json(new { Valid = true, Message = "El participante se ha registrado correctamente." });
                }
                catch (Exception e)
                {
                    // Log the exception here if needed
                    //return Json(new { Valid = false, Message = "Error al registrar: " + ExceptionExtensions.GetOriginalException(e).Message });
                      return Json(new { Valid = false, Message = "Todos los datos son requeridos" });
                    }
                }
            }

            // Si el ModelState no es válido, devuelve los errores
            var errors = ModelState.Values.SelectMany(v => v.Errors).Select(e => e.ErrorMessage);
            return Json(new { Valid = false, Message = "Datos inválidos", Errors = errors });
        }

        public static void enviaMailRegistro(string mail)
        {
            bdNovaEntities bd = new bdNovaEntities();
            Foro_Estatal2024 solicitud = new Foro_Estatal2024();

            solicitud = bd.Foro_Estatal2024.Where(a => a.CorreoElectronico == mail).FirstOrDefault();
            CorreoPersonalizado correo = new CorreoPersonalizado();

            correo.TituloCorreo = "Registro Foro Estatal 2024";
            correo.Nombre = $"{solicitud.Nombre} {solicitud.ApellidoPaterno} {solicitud.ApellidoMaterno} ";
            correo.IdFolio = solicitud.IdFolio;


            correo.DestinatarioEmail = mail.Trim().ToLower();
            //correo.DirigidoA = "JULIO MARTIN DIAZ SANCHEZ";
           


            CorreoService.EnviarCorreoPersonalizado(correo, "~/Views/Foro_Estatal2024/PlantillaBienvenidaContrato.html");


        }



        public ActionResult Preguntas()
        {
            int IdKardex = 920;
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            int IdConvenioLaboral = 24;

            string querytipodocumento;

            //querytipodocumento = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
            //INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
            //inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
            //where Tp.IdConvenioLaboral=@IdConvenioLaboral and Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
            //                        from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";
            querytipodocumento = @"SELECT *  
                                     FROM Kardex_stTipoDocumentoConvenio Tp
                                     INNER JOIN Kardex_TipoDocumento a ON a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
                                     INNER JOIN Catalogos_ctConvenioLaboral b ON b.IdConvenioLaboral = Tp.IdConvenioLaboral
                                     WHERE 
                                         Tp.IdConvenioLaboral = @IdConvenioLaboral
                                         AND (
                                             Tp.IdKardexTipoDocumento = 18 
                                             OR Tp.IdKardexTipoDocumento NOT IN (
                                                 SELECT IdKardexTipoDocumento 
                                                 FROM Kardex_DocumentosExpediente 
                                                 WHERE IdKardex = @IdKardex
                                             )
                                         )";
            var todastipodocumento = (List<Kardex_TipoDocumento>)dpcg.connection.Query<Kardex_TipoDocumento>(querytipodocumento, new { IdConvenioLaboral, IdKardex });

            dpcg.Close();

            ViewBag.IdKardex = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == IdKardex).FirstOrDefault().IdKardex;
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumento, "IdKardexTipoDocumento", "DocumentoExpediente");
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar");
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            return PartialView();
        }

        // POST: KardexGradoAcademico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [AllowAnonymous]
        [HttpPost]
        [ValidateAntiForgeryToken] // Recomiendo mantener esto para seguridad
        public ActionResult Preguntas([Bind(Include = "IdPregunta, Nombre, ApellidoPaterno, ApellidoMaterno, InstitucionProcedencia, CorreoElectronico, Pregunta ")] Foro_EstatalPreguntas2024 foro_EstatalPreguntas2024)
        {
            if (ModelState.IsValid)
            {

                var exists = db.Foro_EstatalPreguntas2024.Any(f =>
                f.Pregunta == foro_EstatalPreguntas2024.Pregunta);
                if (exists)
                {
                    return Json(new
                    {
                        Valid = false,
                        Message = "Ya existe una pregunta igual.",
                        Errors = new[] { "Registro duplicado." }
                    });
                }
                else
                {
                    try
                    {
                        // Crear una nueva instancia y asignar valores
                        var foro = new Foro_EstatalPreguntas2024
                        {
                            Nombre = foro_EstatalPreguntas2024.Nombre.ToUpper(),
                            ApellidoPaterno = foro_EstatalPreguntas2024.ApellidoPaterno.ToUpper(),
                            ApellidoMaterno = foro_EstatalPreguntas2024.ApellidoMaterno.ToUpper(),
                            InstitucionProcedencia = foro_EstatalPreguntas2024.InstitucionProcedencia.ToUpper(),
                            CorreoElectronico = foro_EstatalPreguntas2024.CorreoElectronico,
                            Pregunta = foro_EstatalPreguntas2024.Pregunta.ToUpper()

                        };

                        db.Foro_EstatalPreguntas2024.Add(foro);
                        db.SaveChanges();
                        // Enviar email
                        //enviaMailRegistro(foro_Estatal2024.CorreoElectronico);
                        return Json(new { Valid = true, Message = "El participante ha enviado su pregunta correctamente." });
                    }
                    catch (Exception e)
                    {
                        // Log the exception here if needed
                        //return Json(new { Valid = false, Message = "Error al registrar: " + ExceptionExtensions.GetOriginalException(e).Message });
                        return Json(new { Valid = false, Message = "Todos los datos son requeridos" });
                    }
                }
            }

            // Si el ModelState no es válido, devuelve los errores
            var errors = ModelState.Values.SelectMany(v => v.Errors).Select(e => e.ErrorMessage);
            return Json(new { Valid = false, Message = "Datos inválidos", Errors = errors });
        }

        public FileResult VerInfo(int idgradoacademico)
        {
            var archivosanexo = db.Kardex_stGradoAcademicoFotografia.Where(x => x.IdKardexGradoAcademico == idgradoacademico).FirstOrDefault();

            if (archivosanexo.TipoDocumento == "application/pdf")
            {
                return File(archivosanexo.Archivo, "application/pdf");

            }
            else if (archivosanexo.TipoDocumento == "application/msword")
            {
                return File(archivosanexo.Archivo, "application/msword");
            }

            else if (archivosanexo.TipoDocumento == "image/jpeg")
            {
                return File(archivosanexo.Archivo, "image/jpeg");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.ms-excel")
            {
                return File(archivosanexo.Archivo, "application/vnd.ms-excel");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            }

            return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }


        public FileResult DescargarInfo(int idkardexdocumentosexpedientetrabajador)
        {
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string queryexpedientetrabajador;

            queryexpedientetrabajador = @"select* from bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador a
                                            inner join vwDatosaspirantesTrabajadores b on a.IdKardex = b.IdKardex
                                            where a.IdKardexDocumentosExpedienteTrabajador = @idkardexdocumentosexpedientetrabajador";
            var todosexpedientes = (List<KardexDocumentosExpedientesTrabajadores300>)dpcg.connection.Query<KardexDocumentosExpedientesTrabajadores300>(queryexpedientetrabajador, new { idkardexdocumentosexpedientetrabajador });
            dpcg.Close();

            if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/pdf")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/pdf", "Descarga_" + todosexpedientes.FirstOrDefault().IdTrabajador + "_" + todosexpedientes.FirstOrDefault().Nombre + " " + todosexpedientes.FirstOrDefault().ApellidoPaterno + " " + todosexpedientes.FirstOrDefault().ApellidoMaterno + "_" + todosexpedientes.FirstOrDefault().RFC + ".pdf");

            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/msword")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/msword", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".doc");
            }

            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "image/jpeg")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "image/jpeg", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".jpg");
            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/vnd.ms-excel")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.ms-excel", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".xls");
            }


            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/octet-stream")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/octet-stream", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".zip");
            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".docx");
            }

            return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".xlsx");

            //string modalidad = "Poa_Mir" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


        }

        // GET: KardexGradoAcademico/Edit/5
        public ActionResult Edit(int id)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string query = string.Format(@"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar,a.Folio,a.Clave, a.FechaDocumento, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from Kardex_DocumentosExpediente a
                         left join Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
                        where a.IdKardex = {0}
                        ", IdKardex);
          
            ViewBag.IdKardex = IdKardex;
            ViewBag.IdKardexDocumentosExpediente = id;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(query);
    
            string querytipodocumento;

            querytipodocumento = @"Select * from (Select * from Kardex_TipoDocumento Tp
                                     where Tp.IdKardexTipoDocumento in (select  Kardex_DocumentosExpediente.IdKardexTipoDocumento 
                                           from Kardex_DocumentosExpediente )) a
                                    inner join Kardex_DocumentosExpediente b on a.IdKardexTipoDocumento = b.IdKardexTipoDocumento
                                    where b.IdKardex=@IdKardex";

            var todastipodocumento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(querytipodocumento, new { IdKardex });
           
            int TipoDocumento = todastipodocumento.Where(z=> z.IdKardexDocumentosExpediente== id).FirstOrDefault().IdKardexTipoDocumento;


            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string querytipodocumentos;

            //querytipodocumento = @"Select * from bdNova.dbo.Kardex_TipoDocumento Tp where 
            //                     Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
            //                     from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";


            querytipodocumentos = @"SELECT *  FROM Kardex_stTipoDocumentoConvenio Tp
								 INNER JOIN  Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
								 inner join  Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
								 where Tp.IdConvenioLaboral=@IdConvenioLaboral ";


            var todastipodocumentos = (List<Kardex_TipoDocumento>)dp.connection.Query<Kardex_TipoDocumento>(querytipodocumentos, new { IdConvenioLaboral });




            string queryciclo;

            queryciclo = @"select a.IdCicloEscolar, b.CicloEscolar from bdCtlEscSeg.dbo.ctCicloescolar a
                            inner join Kardex_DocumentosExpediente b on a.Nombre=b.CicloEscolar
                            where b.IdKardexDocumentosExpediente=@id";

            var todasciclo = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryciclo, new { id });

            int idciclo = todasciclo.FirstOrDefault().IdCicloEscolar;



            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            var valorkardex_DocumentosExpediente = kardex_DocumentosExpediente.Where(z=> z.IdKardex==id).FirstOrDefault();
            if (kardex_DocumentosExpediente == null)
            {
                return HttpNotFound();
            }
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_GradoAcademico.IdKardex);
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumentos.ToList(), "IdKardexTipoDocumento", "DocumentoExpediente", todastipodocumentos.Where(x=> x.IdKardexTipoDocumento == TipoDocumento).FirstOrDefault().IdKardexTipoDocumento);
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar", Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(a=> a.IdCicloEscolar == idciclo).FirstOrDefault().IdCicloEscolar);
            ViewBag.IdKardexTipoDocumentos = TipoDocumento;
            dp.Close();
            return PartialView(kardex_DocumentosExpediente.Where(a=> a.IdKardexDocumentosExpediente==id).FirstOrDefault());
        
            //return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdKardexDocumentosExpediente,IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,Folio,Clave,FechaDocumento,NombreArchivo,FechaRegistro")] Kardex_DocumentosExpediente kardex_DocumentosExpediente, int IdCicloEscolar, HttpPostedFileBase upload)
        {
                string msj = "El Grado académico ha sido editado existosamente!";
          
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            //kardex_GradoAcademico.AbreviaturaProfesion=kardex_GradoAcademico.AbreviaturaProfesion.ToUpper();
            //kardex_GradoAcademico.NivelEstudioDescripcion=kardex_GradoAcademico.NivelEstudioDescripcion.ToUpper();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            string CicloEscolar = Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(z => z.IdCicloEscolar == IdCicloEscolar).FirstOrDefault().CicloEscolar;
            DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));

            if (ModelState.IsValid)
            {
             
                try
                {

                    if (upload != null && upload.ContentLength > 0)
                    {
                        byte[] imagenData = null;
                        string tipoarchivo = "";
                        using (var binaryArchivo = new BinaryReader(upload.InputStream))
                        {
                            imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                            tipoarchivo = upload.ContentType;

                        }
                        //kardex_stGradoAcademicoFotografia.Archivo = imagenData;
                        //kardex_stGradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                        //kardex_stGradoAcademicoFotografia.NombreArchivo = upload.FileName;


                           using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos
                                    

                            string sqlupdateQuery = @"UPDATE Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = "+ IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar+ "','" + kardex_DocumentosExpediente.Folio + "','" + kardex_DocumentosExpediente.Clave + "','" + kardex_DocumentosExpediente.FechaDocumento + " WHERE IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";
                            
                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);
                         


                            string sql = @"SELECT IdKardexDocumentosExpediente
                                           FROM bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador
										   where IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";
                            int idKardexDocumentosExpediente = dp.connection.ExecuteScalar<int>(sql);

                            ////Escribir archivo 
                            
                            if (idKardexDocumentosExpediente != 0)
                            {
                                var rowsAffectedDocFile = dp.connection.Execute("UPDATE bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador SET IdKardex=@IdKardex, Archivo= @Archivo, TipoDocumento = @TipoDocumento, NombreArchivo=@NombreArchivo, FechaRegistro=@FechaRegistro, IdKardexDocumentosExpediente=@IdKardexDocumentosExpediente WHERE IdKardexDocumentosExpediente = @IdKardexDocumentosExpediente01", new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente, IdKardexDocumentosExpediente01 = kardex_DocumentosExpediente.IdKardexDocumentosExpediente });
                            }
                            else
                            {
                                string sqlinsert = "Insert Into bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador (IdKardex ,Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexDocumentosExpediente) " +
                                   "Values(@IdKardex,@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexDocumentosExpediente)  ";                                

                                var parameters = new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente };
                                var rowsAffectedImg01 = dp.connection.ExecuteScalar(sqlinsert, parameters);

                            }
                            
                            


                            dp.Close();
                                trans.Complete();
                                return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                            }

                        }

                    else 
                    {
                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos

                            string sqlupdateQuery = @"UPDATE Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = " + IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar + "','" + kardex_DocumentosExpediente.Folio + "','" + kardex_DocumentosExpediente.Clave + "','" + kardex_DocumentosExpediente.FechaDocumento + "' WHERE IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";

                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);


                            dp.Close();
                            trans.Complete();
                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });
                        }

                            


                    }
                       
                   
                       
                        
                    }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: KardexGradoAcademico/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            if (kardex_GradoAcademico == null)
            {
                return HttpNotFound();
            }
            return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            //db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {

                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                        var sqlDeleteExp= "DELETE Kardex_DocumentosExpediente WHERE IdKardexDocumentosExpediente ="+ id +"";

                        var rowsAffectedExp = dp.connection.Execute(sqlDeleteExp);

                        var sqlDeleteArchivo = "DELETE bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador WHERE IdKardexDocumentosExpediente = "+ id +"";


                        var rowsAffectedArch = dp.connection.Execute(sqlDeleteArchivo);

                        dp.Close();
                        trans.Complete();
                    }
                    //db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
