﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models.EliminarPlantillas;
using Nova.Models;

namespace Nova.Controllers.EliminarPlantilla
{
    public class EliminarPlantillaController : Controller
    {
        //
        // GET: /EliminarPlantilla/

        public ActionResult Index()
        {
            return View();
        }

       


        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvEliminarPlantillas()
        {
            var model = db.Nomina_stNomina;
            return PartialView("_pvEliminarPlantillas", EliminarPlantillas.GetPlantillasPrueba());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvEliminarPlantillasAddNew(Nova.Models.Nomina_stNomina item)
        {
            var model = db.Nomina_stNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvEliminarPlantillas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvEliminarPlantillasUpdate(Nova.Models.Nomina_stNomina item)
        {
            var model = db.Nomina_stNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdNomina == item.IdNomina);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvEliminarPlantillas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvEliminarPlantillasDelete(System.Int32 IdNomina)
        {
            var model = db.Nomina_stNomina;
            if (IdNomina != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdNomina == IdNomina);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvEliminarPlantillas", model.ToList());
        }

        //  Eliminar


        public ActionResult EliminarNomina2(int idnomina)
        {

            Session["idnomina"] = idnomina;
            
             return null;
        }

        


        //[HttpPost, ValidateInput(false)]
        public ActionResult EliminarNomina()
        {
            int id = (int)Session["idnomina"];
            var model = db.Nomina_stNomina;

            var model4 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetEliminaNominaTrabajador(db.Nomina_stNominaTrabajador, id);
            var IdNominaTrabajador = model4.FirstOrDefault(z => z.IdNomina == id).IdNominaTrabajador;            
            var model2= Nova.Models.EliminarPlantillas.EliminarPlantillas.GetEliminaNomina(db.Nomina_stNomina, id);
            var IdPlantillaNomina = model2.First(a => a.IdNomina == id).IdPlantillaNomina;
            var model3 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetEliminaPlantilla(db.Nomina_ctPlantillaNomina, IdPlantillaNomina);
            var IdPlantilla = model3.FirstOrDefault(b => b.IdPlantillaNomina == IdPlantillaNomina);

            var modelodos = db.Creditos_stNominaCreditoTrabajador;
            var modelotres= db.Deducciones_stNominaTrabajadorDeduccion;
            var modelocuatro= db.Incidencias_stNominaTrabajadorIncidenciaDeduccion;
            var modelocinco= db.Pensiones_stNominaPensionTrabajador;
            var modeloseis= db.Percepciones_stNominaTrabajadorPercepciones;
            var modelosiete = db.Percepciones_stNominaTrabajadorPercepcionesPersonalizadas;
            var modeloocho= db.Suplencia_stNominaTrabajadorSuplente;
            
            var modelodoce = db.Percepciones_stPercepcionesCalendarizadas;
            var modelodiez = db.Deducciones_stPlantillaNominaDeducciones;
            var modeloonce = db.Percepciones_stPlantillaNominaPercepciones;
            
            var modelouno = db.Nomina_stNominaTrabajador;
            var modelonueve = db.Nomina_stNomina;
            var modelotrece = db.Nomina_ctPlantillaNomina;






            if (id != null)
            {

                if (IdNominaTrabajador != null)
                {
                    //1
                    try
                    {

                        var item11 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetCreditos(id);
                        if (item11 != null)
                            foreach (var credito1 in item11)
                            {
                                var modelo1 = db.Creditos_stNominaCreditoTrabajador.Find(credito1);
                                db.Creditos_stNominaCreditoTrabajador.Remove(modelo1);

                            }

                        db.SaveChanges();




                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }


                    //2
                    try
                    {
                        var item12 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetDeducciones(id);
                        if (item12 != null)
                            foreach (var deducciones in item12)
                            {
                                var modelo2 = db.Deducciones_stNominaTrabajadorDeduccion.Find(deducciones);
                                db.Deducciones_stNominaTrabajadorDeduccion.Remove(modelo2);

                            }

                        db.SaveChanges();


                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }

                    //3
                    try
                    {
                        var item13 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetIncidencias(id);
                        if (item13 != null)
                            foreach (var incidencias in item13)
                            {
                                var modelo3 = db.Incidencias_stNominaTrabajadorIncidenciaDeduccion.Find(incidencias);
                                db.Incidencias_stNominaTrabajadorIncidenciaDeduccion.Remove(modelo3);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }

                    //4
                    try
                    {
                        var item14 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetPensiones(id);
                        if (item14 != null)
                            foreach (var pensiones in item14)
                            {
                                var modelo4 = db.Pensiones_stNominaPensionTrabajador.Find(pensiones);
                                db.Pensiones_stNominaPensionTrabajador.Remove(modelo4);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                       // ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }

                    //5
                    try
                    {
                        var item15 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetPercepciones(id);
                        if (item15 != null)
                            foreach (var percepciones in item15)
                            {
                                var modelo5 = db.Percepciones_stNominaTrabajadorPercepciones.Find(percepciones);
                                db.Percepciones_stNominaTrabajadorPercepciones.Remove(modelo5);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }

                    //6
                    try
                    {
                        var item16 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetPercepcionesPerso(id);
                        if (item16 != null)
                            foreach (var percepcionesperso in item16)
                            {
                                var modelo6 = db.Percepciones_stNominaTrabajadorPercepcionesPersonalizadas.Find(percepcionesperso);
                                db.Percepciones_stNominaTrabajadorPercepcionesPersonalizadas.Remove(modelo6);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }

                    //7
                    try
                    {

                        var item17 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetSuplencias(id);
                        if (item17 != null)
                            foreach (var suplencias in item17)
                            {
                                var modelo7 = db.Suplencia_stNominaTrabajadorSuplente.Find(suplencias);
                                db.Suplencia_stNominaTrabajadorSuplente.Remove(modelo7);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }


                }

                if (IdPlantilla != null)
                {

                    //8
                    try
                    {
                        int valor = db.Percepciones_stPercepcionesCalendarizadas.Where(a => a.IdPlantillaNomina == IdPlantillaNomina).Count();
                        var item18 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetPercepcionesCalen(id);
                        if (item18 != null)
                            foreach (var percepcalen in item18)
                            {
                                var modelo8 = db.Percepciones_stPercepcionesCalendarizadas.Find(percepcalen);
                                db.Percepciones_stPercepcionesCalendarizadas.Remove(modelo8);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }


                    //9

                    try
                    {
                        var item19 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetPlantillaDeducciones(id);
                        if (item19 != null)
                            foreach (var plantilladeduc in item19)
                            {
                                var modelo9 = db.Deducciones_stPlantillaNominaDeducciones.Find(plantilladeduc);
                                db.Deducciones_stPlantillaNominaDeducciones.Remove(modelo9);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }

                    //10
                    try
                    {
                        var item110 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetPlantillaPercepciones(id);
                        if (item110 != null)
                            foreach (var plantillapercep in item110)
                            {
                                var modelo10 = db.Percepciones_stPlantillaNominaPercepciones.Find(plantillapercep);
                                db.Percepciones_stPlantillaNominaPercepciones.Remove(modelo10);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                       // ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                    //11
                    try
                    {

                        var item111 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetNominaTrabajador(id);
                        if (item111 != null)
                            foreach (var nominatrab in item111)
                            {
                                var modelo11 = db.Nomina_stNominaTrabajador.Find(nominatrab);
                                db.Nomina_stNominaTrabajador.Remove(modelo11);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                    //12
                    try
                    {
                        int valor = db.Nomina_ctPlantillaNomina.Where(a => a.IdPlantillaNomina == IdPlantillaNomina).Count();
                        var item113 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetPlantillaNomina(id);
                        if (item113 != null)
                            foreach (var plantillanomina in item113)
                            {
                                var modelo13 = db.Nomina_ctPlantillaNomina.Find(plantillanomina);
                                db.Nomina_ctPlantillaNomina.Remove(modelo13);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                   
                    //13
                    try
                    {
                        int valor2 = db.Nomina_stNomina.Where(a => a.IdPlantillaNomina == IdPlantillaNomina).Count();
                        var item112 = Nova.Models.EliminarPlantillas.EliminarPlantillas.GetNomina(id);
                        if (item112 != null)
                            foreach (var nomina in item112)
                            {
                                var modelo12 = db.Nomina_stNomina.Find(nomina);
                                db.Nomina_stNomina.Remove(modelo12);

                            }

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        //ViewData["EditError"] = e.Message;
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                }
                else
                {
                    return RedirectToAction("Index", "EliminarPlantilla");
                }

            }
            return RedirectToAction("Index", "EliminarPlantilla");
            //return PartialView("_pvEliminarPlantillas", model.ToList());
        }



       

    }
}
