﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;
using System.Data.Entity;
using Nova.Libraries;

namespace Nova.Controllers
{
    public class DeduccionPersonalizadaController : Controller
    {
        //
        // GET: /DeduccionPersonalizada/

        public ActionResult Index(int idtrabajador)
        {
            Session["idtrabajador"] = idtrabajador;
            string convenio = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == idtrabajador).FirstOrDefault().ConvenioLaboral;
            if (convenio != "BASE")
            {
                throw new Exception("ESTA OPCIÓN SOLO APLICA PARA TRABAJADORES DE BASE");
            }

            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        public ActionResult MostrarGridConveniolaboralTrabajadorCategoria()
        {
            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);
            Convenios_stConvenioLaboralTrabajadorCategoria Valida = new Convenios_stConvenioLaboralTrabajadorCategoria();
            var model = from a in db.Convenios_stConvenioLaboralTrabajadorCategoria
                        join b in db.Convenios_stConvenioLaboralTrabajador on a.IdConvenioLaboralTrabajador equals b.IdConvenioLaboralTrabajador
                        join c in db.Plazas_stDistribucionPlazaCategoria on a.IdDistribucionPlazaCategoria equals c.IdDistribucionPlazaCategoria
                        join j in db.Catalogos_ctEstructuraOrganica on c.IdEstructuraOrganica equals j.IdEstructuraOrganica
                        join d in db.Plazas_ctCategoria on c.IdCategoria equals d.IdCategoria
                        join e in db.Convenios_stRelacionConvenioLaboral on d.IdRelacionConvenioLaboral equals e.IdRelacionConvenioLaboral
                        join f in db.Catalogos_ctConvenioLaboral on e.IdConvenioLaboral equals f.IdConvenioLaboral
                        join g in db.Catalogos_ctRelacionLaboral on e.IdRelacionLaboral equals g.IdRelacionLaboral
                        join h in db.Kardex_ctTrabajador on b.IdTrabajador equals h.IdTrabajador
                        join i in db.Kardex_ctDatosPersonales on h.IdKardex equals i.IdKardex
                        join k in db.Catalogos_ctEstructuraOrganica on a.IdEstructuraOrganica equals k.IdEstructuraOrganica
                        where b.IdTrabajador == idtrabajador && a.EsCancelado == false
                        orderby a.IdConvenioLaboralTrabajadorCategoria descending
                        select new
                        {
                            IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria,
                            Nombre = i.Nombre,
                            ApellidoPaterno = i.ApellidoPaterno,
                            ApellidoMaterno = i.ApellidoMaterno,
                            IdTrabajador = b.IdTrabajador,
                            ConvenioLaboral = f.ConvenioLaboral,
                            RelacionLaboral = g.RelacionLaboral,
                            Categoria = d.Categoria,
                            EstructuraOrganica = j.EstructuraOrganica,
                            FechaInicioConvenioTrabajadorCategoria = a.FechaInicio,
                            FechaTerminoConvenioTrabajadorCategoria = a.FechaTermino,
                            IdConvenioLaboral = f.IdConvenioLaboral,
                            IdDistribucionPlazaCategoria = a.IdDistribucionPlazaCategoria,
                            IdRelacionConvenioLaboral = d.IdRelacionConvenioLaboral,
                            IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador,
                            Observacion = a.Observacion,
                            LaboraFisicamente = k.EstructuraOrganica
                        };
            //var model = db.vwIdConvenioLaboralTrabajadorCategoria.Where(s => s.IdTrabajador == idtrabajador && s.EsCancelado==false ).OrderByDescending(s => s.FechaInicioConvenioTrabajadorCategoria);
            //Nova.Models.ValidacionModelos.ResultadoValidacion resultado = new ValidacionModelos.ResultadoValidacion();
            //resultado = Valida.ValidaModelo(idtrabajador);
            return PartialView("MostrarGridConveniolaboralTrabajadorCategoria", model.ToList());
        }

        [ValidateInput(false)]
        public ActionResult pvDeduccionPersonalizada()
        {
            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);

            //var model = from a in db.Percepciones_stPercepcionesPersonalizadas
            //            join b in db.Convenios_stConvenioLaboralTrabajadorCategoria on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria
            //            join c in db.Convenios_stConvenioLaboralTrabajador on b.IdConvenioLaboralTrabajador equals c.IdConvenioLaboralTrabajador
            //            join d in db.Kardex_ctTrabajador on c.IdTrabajador equals d.IdTrabajador
            //            where c.IdTrabajador == idtrabajador
            //            select  new 
            //            {
            //                a.IdPercepcionesPersonalizadas,
            //                a.IdConvenioLaboralTrabajadorCategoria,
            //                a.IdPercepcion,
            //                a.IdPeriodoNomina,
            //                a.FechaInicioPercepcion,
            //                a.EsVigente,
            //                a.Importe
            //            };
            var model = db.Deducciones_stDeduccionesPersonalizadas.Where(s =>  s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador ==idtrabajador);
            return PartialView("_pvDeduccionPersonalizada", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionPersonalizadaAddNew(Nova.Models.Deducciones_stDeduccionesPersonalizadas item)
        {
            
            int UltimoIdCLTC = Convert.ToInt32(Session["UltimoIdConvenioLaboralTrabajadorCategoria"]);

            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);
            bdNovaEntities bd = new bdNovaEntities();

            int idtrabajadorcategoria =(int) bd.vwDatosAspirantesTrabajadores.Where(w => w.IdTrabajador == idtrabajador).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;

            item.IdConvenioLaboralTrabajadorCategoria = idtrabajadorcategoria;
            var model = db.Deducciones_stDeduccionesPersonalizadas;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            var modelt = db.Deducciones_stDeduccionesPersonalizadas.Where(w => w.IdConvenioLaboralTrabajadorCategoria == idtrabajadorcategoria);

            return PartialView("_pvDeduccionPersonalizada", modelt.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionPersonalizadaUpdate(Nova.Models.Deducciones_stDeduccionesPersonalizadas item)
        {
            
            //var model = db.Deducciones_stDeduccionesPersonalizadas.Where(w => w.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria);
            if (ModelState.IsValid)
            {
                try
                {
                    //var modelItem = model.FirstOrDefault(it => it.IdDeduccionesPersonalizadas == item.IdDeduccionesPersonalizadas);
                    //if (modelItem != null)
                    //{
                        //this.UpdateModel(modelItem);
                        //db.SaveChanges();
                    db.Deducciones_stDeduccionesPersonalizadas.Attach(item);
                    db.Entry(item).State = EntityState.Modified;
                    db.SaveChanges();

                    //}
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            var model = db.Deducciones_stDeduccionesPersonalizadas.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList();

            return PartialView("_pvDeduccionPersonalizada", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionPersonalizadaDelete(System.Int32 IdDeduccionesPersonalizadas)
        {

            Deducciones_stDeduccionesPersonalizadas ele = db.Deducciones_stDeduccionesPersonalizadas.Where(x => x.IdDeduccionesPersonalizadas == IdDeduccionesPersonalizadas).FirstOrDefault();

            if (IdDeduccionesPersonalizadas != 0)
                if (ModelState.IsValid)
                {
                    try
                    {
                        //var item = db.FirstOrDefault(it => it.IdPensionTrabajador == IdPensionTrabajador);
                        // if (item != null)
                        db.Deducciones_stDeduccionesPersonalizadas.Attach(ele);
                        db.Deducciones_stDeduccionesPersonalizadas.Remove(ele);

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                }
                else
                    ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                 .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            var model = db.Deducciones_stDeduccionesPersonalizadas.Where(x => x.IdConvenioLaboralTrabajadorCategoria == ele.IdConvenioLaboralTrabajadorCategoria).ToList();
            return PartialView("_pvDeduccionPersonalizada", model.ToList());
        }


    }
}
