﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models.PlantillaNominaDeducciones;
using Nova.Models.PlantillaNominaPercepciones;

namespace Nova.Controllers.DeduccionesFijas
{
    public class DeduccionesFijasController : Controller
    {
        //
        // GET: /DeduccionesFijas/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        public ActionResult pvDeduccionesFijasDetalle(int? IdPlantillaNomina)
        {
            if (IdPlantillaNomina.HasValue)
            {
                Session["IdPlantillaNomina"] = IdPlantillaNomina;
                return PartialView("_pvDeduccionesFijasDetalle", PlantillaNominaDeducciones.GetPlantillaNominaDeducciones((int)IdPlantillaNomina));
            }
            else
                return RedirectToAction("Index", "DeduccionesFijas");
        }

        [ValidateInput(false)]
        public ActionResult pvDeduccionesFijas()
        {
            return PartialView("_pvDeduccionesFijas", PlantillaNominaDeducciones.GetPlantillas());
            //var model = db.Nomina_ctPlantillaNomina;
            //return PartialView("_MasterDetailMasterPartial", model.ToList());
            // return PartialView("_MasterDetailMasterPartial", NorthwindDataProvider.GetCustomers());
        }

        

        //[ValidateInput(false)]
        //public ActionResult pvDeduccionesFijas()
        //{
        //    var model = db.Nomina_ctPlantillaNomina;
        //    return PartialView("_pvDeduccionesFijas", model.ToList());
        //}

        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionesFijasAddNew(Nova.Models.Nomina_ctPlantillaNomina item)
        {
            var model = db.Nomina_ctPlantillaNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvDeduccionesFijas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionesFijasUpdate(Nova.Models.Nomina_ctPlantillaNomina item)
        {
            var model = db.Nomina_ctPlantillaNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPlantillaNomina == item.IdPlantillaNomina);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvDeduccionesFijas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionesFijasDelete(System.Int16 IdPlantillaNomina)
        {
            var model = db.Nomina_ctPlantillaNomina;
            if (IdPlantillaNomina != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPlantillaNomina == IdPlantillaNomina);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvDeduccionesFijas", model.ToList());
        }

        //Botones Deducciones Detalle



        //[ValidateInput(false)]
        //public ActionResult pvDeduccionesFijasDetalle()
        //{
        //    var model = db.Deducciones_stPlantillaNominaDeducciones;
        //    return PartialView("_pvDeduccionesFijasDetalle", model.ToList());
        //}

        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionesFijasDetalleAddNew(Nova.Models.Deducciones_stPlantillaNominaDeducciones item)
        {
            var model = db.Deducciones_stPlantillaNominaDeducciones;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
                return RedirectToAction("Index", "DeduccionesFijas");
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvDeduccionesFijasDetalle", model.ToList());
            //var model2 = db.Nomina_ctPlantillaNomina;
            //return PartialView("_pvDeduccionesFijas", model2.ToList());
            ////var model2 = db.Nomina_ctPlantillaNomina;
            ////return View("_pvDeduccionesFijas", model2.ToList());
            ////return Html.Action("pvDeduccionesFijas", "DeduccionesFijas")
            

            
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionesFijasDetalleUpdate(Nova.Models.Deducciones_stPlantillaNominaDeducciones item)
        {
            var model = db.Deducciones_stPlantillaNominaDeducciones;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPlantillaNominaDeduccion == item.IdPlantillaNominaDeduccion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
                return RedirectToAction("Index", "DeduccionesFijas");
            }

            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvDeduccionesFijasDetalle", model.ToList());
            //return PartialView("_pvDeduccionesFijasDetalle", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionesFijasDetalleDelete(System.Int16 IdPlantillaNominaDeduccion)
        {
            var model = db.Deducciones_stPlantillaNominaDeducciones;
            if (IdPlantillaNominaDeduccion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPlantillaNominaDeduccion == IdPlantillaNominaDeduccion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            //return PartialView("_pvDeduccionesFijasDetalle", model.ToList());
            return RedirectToAction("Index", "DeduccionesFijas");
        }

    }
}
