﻿using Nova.Models.DashBoards;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.DashBoards
{

    public class ContratacionEstadisticasController : Controller
    {
        [AllowAnonymous]
        public ActionResult Dashboard()
        {
            return View();
        }
        [AllowAnonymous]
        public ActionResult GraficaPorEstatus()
        {
            GraficasContratacion graficasService = new GraficasContratacion();
            var datos = graficasService.ObtenDatosPorEstatus();
            return Json(datos, JsonRequestBehavior.AllowGet);
        }
        [AllowAnonymous]
        public ActionResult GraficaPorAreaConocimiento()
        {
            GraficasContratacion graficasService = new GraficasContratacion();
            var datos = graficasService.ObtenDatosPorAreaConocimientoCategoria();
            return Json(datos, JsonRequestBehavior.AllowGet);
        }
        [AllowAnonymous]
        public ActionResult GraficaAvance()
        {
            GraficasContratacion graficasService = new GraficasContratacion();
            var datos = graficasService.ObtenDatosAvance();
            return Json(datos, JsonRequestBehavior.AllowGet);
        }
        [AllowAnonymous]
        public ActionResult GraficaAvanceDocente()
        {
            GraficasContratacion graficasService = new GraficasContratacion();
            var datos = graficasService.ObtenDatosAvanceDocente();
            return Json(datos, JsonRequestBehavior.AllowGet);
        }
        [AllowAnonymous]
        public ActionResult GraficaAvanceAdministrativo()
        {
            GraficasContratacion graficasService = new GraficasContratacion();
            var datos = graficasService.ObtenDatosAvanceAdministrativo();
            return Json(datos, JsonRequestBehavior.AllowGet);
        }
        [AllowAnonymous]
        public ActionResult GraficaPorTipoRelacion()
        {
            GraficasContratacion graficasService = new GraficasContratacion();
            var datos = graficasService.ObtenDatosPorTipoRelacion();
            return Json(datos, JsonRequestBehavior.AllowGet);
        }
        [AllowAnonymous]
        public ActionResult GraficaPorTiempoAtencion()
        {
            GraficasContratacion graficasService = new GraficasContratacion();
            var datos = graficasService.ObtenDatosPorTiempoAtencion();
            return Json(datos, JsonRequestBehavior.AllowGet);
        }
        [AllowAnonymous]
        public ActionResult GraficaPorEncuesta()
        {
            GraficasContratacion graficasService = new GraficasContratacion();
            var datos = graficasService.ObtenDatosPorEncuesta();
            return Json(datos, JsonRequestBehavior.AllowGet);
        }
        [AllowAnonymous]
        public ActionResult GraficaPorGenero()
        {
            GraficasContratacion graficasService = new GraficasContratacion();
            var datos = graficasService.ObtenDatosPorGenero();
            return Json(datos, JsonRequestBehavior.AllowGet);
        }
    }

}