﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Transactions;

namespace Nova.Controllers
{
    public class CuotaSindicalController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: CuotaSindical
        public ActionResult Index(int IdConvenioLaboralTrabajadorCategoria)
        {
            var model = db.vwDatosAspirantesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
            //var2 convenios_stConvenioLaboralTrabajadorCategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Include(c => c.Catalogos_ctEstructuraOrganica).Include(c => c.Convenios_stConvenioLaboralTrabajador).Include(c => c.Plazas_stDistribucionPlazaCategoria);
            //return View(convenios_stConvenioLaboralTrabajadorCategoria.ToList());
            Session["IdConvenioLaboralTrabajadorCategoria"] = IdConvenioLaboralTrabajadorCategoria;

            if (model.Count() == 0)
            {

                ModelState.AddModelError("", "Verifique el trabajador");
                ViewData["EditError"] = "Verifique el trabajador";
                //MessageBox.Show(ViewData, TipoMensaje.Error, "El trabajador ya tiene asignada una plaza, Verifique el Ide");
                throw new System.ArgumentException("El trabajador termino su relacion de trabajo");

            }

            return View(model);

        }

        // GET: CuotaSindical/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Convenios_stConvenioLaboralTrabajadorCategoria convenios_stConvenioLaboralTrabajadorCategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id);
            if (convenios_stConvenioLaboralTrabajadorCategoria == null)
            {
                return HttpNotFound();
            }
            return View(convenios_stConvenioLaboralTrabajadorCategoria);
        }

        // GET: CuotaSindical/Create
        public ActionResult Create()
        {
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador");
            ViewBag.IdDistribucionPlazaCategoria = new SelectList(db.Plazas_stDistribucionPlazaCategoria, "IdDistribucionPlazaCategoria", "Codigo");
            return View();
        }

        // POST: CuotaSindical/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdConvenioLaboralTrabajadorCategoria,IdConvenioLaboralTrabajador,IdDistribucionPlazaCategoria,IdEstructuraOrganica,EsComisionado,FechaInicio,FechaTermino,EsCancelado,UserId,FechaCreacion,Observacion,EsCuotaSindical,FechaCuotaSindical")] Convenios_stConvenioLaboralTrabajadorCategoria convenios_stConvenioLaboralTrabajadorCategoria)
        {
            if (ModelState.IsValid)
            {
                db.Convenios_stConvenioLaboralTrabajadorCategoria.Add(convenios_stConvenioLaboralTrabajadorCategoria);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica);
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador", convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajador);
            ViewBag.IdDistribucionPlazaCategoria = new SelectList(db.Plazas_stDistribucionPlazaCategoria, "IdDistribucionPlazaCategoria", "Codigo", convenios_stConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria);
            return View(convenios_stConvenioLaboralTrabajadorCategoria);
        }

        // GET: CuotaSindical/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Convenios_stConvenioLaboralTrabajadorCategoria convenios_stConvenioLaboralTrabajadorCategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id);
            if (convenios_stConvenioLaboralTrabajadorCategoria == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica);
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador", convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajador);
            ViewBag.IdDistribucionPlazaCategoria = new SelectList(db.Plazas_stDistribucionPlazaCategoria, "IdDistribucionPlazaCategoria", "Codigo", convenios_stConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria);
            return View(convenios_stConvenioLaboralTrabajadorCategoria);
        }

        // POST: CuotaSindical/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdConvenioLaboralTrabajadorCategoria,IdConvenioLaboralTrabajador,IdDistribucionPlazaCategoria,IdEstructuraOrganica,EsComisionado,FechaInicio,FechaTermino,EsCancelado,UserId,FechaCreacion,Observacion,EsCuotaSindical,FechaCuotaSindical")] Convenios_stConvenioLaboralTrabajadorCategoria convenios_stConvenioLaboralTrabajadorCategoria)
        {
            if (ModelState.IsValid)
            {
                db.Entry(convenios_stConvenioLaboralTrabajadorCategoria).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica);
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador", convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajador);
            ViewBag.IdDistribucionPlazaCategoria = new SelectList(db.Plazas_stDistribucionPlazaCategoria, "IdDistribucionPlazaCategoria", "Codigo", convenios_stConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria);
            return View(convenios_stConvenioLaboralTrabajadorCategoria);
        }

        // GET: CuotaSindical/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Convenios_stConvenioLaboralTrabajadorCategoria convenios_stConvenioLaboralTrabajadorCategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id);
            if (convenios_stConvenioLaboralTrabajadorCategoria == null)
            {
                return HttpNotFound();
            }
            return View(convenios_stConvenioLaboralTrabajadorCategoria);
        }

        // POST: CuotaSindical/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Convenios_stConvenioLaboralTrabajadorCategoria convenios_stConvenioLaboralTrabajadorCategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id);
            db.Convenios_stConvenioLaboralTrabajadorCategoria.Remove(convenios_stConvenioLaboralTrabajadorCategoria);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }


        [HttpPost, ValidateInput(false)]
        public ActionResult ActualizarCuotaSindical(Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria item, string FechaCuotaSindical, bool EsCuotaSindical)
        {
            int idcltc = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
          


            var model = db.Convenios_stConvenioLaboralTrabajadorCategoria.ToList();




            if (FechaCuotaSindical == "")
            {
                ModelState.AddModelError("", "Los Datos son requeridos");
            }


            if (ModelState.IsValid)
            {

                TransactionOptions GrabarRenuncia = new TransactionOptions();
                GrabarRenuncia.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;

                try
                {
                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, GrabarRenuncia))
                    {
                        var modelItem = model.First(it => it.IdConvenioLaboralTrabajadorCategoria == idcltc);

                        if (modelItem != null)
                        {
                            modelItem.FechaCuotaSindical = Convert.ToDateTime(FechaCuotaSindical);
                            modelItem.EsCuotaSindical = EsCuotaSindical;
                            this.UpdateModel(modelItem);
                            db.SaveChanges();
                            scope.Complete();
                        }
                                  
                    }

                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }


            }

            else
            {
                ViewData["EditError"] = "Please, correct all errors.";
                throw new System.ArgumentException("La Fecha es un dato requerido", "FechaTermino");
            }

            return RedirectToAction("Index", new { IdConvenioLaboralTrabajadorCategoria = idcltc });
            //return RedirectToAction("Home/Index");
        }
    }
}
