﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;
using Nova.App_Start;
using System.Transactions;
using Rotativa;

namespace Nova.Controllers.Credenciales
{
    public class CredencialesReimpresionesController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        bdAriesEntities bdaries = new bdAriesEntities();

        bdNovaEntities bdnova = new bdNovaEntities();

        // GET: /CredencialesReimpresiones/
        public ActionResult Index()
        {
            var credenciales_impresiones = db.Credenciales_Impresiones.Include(c => c.Convenios_stConvenioLaboralTrabajadorCategoria).Include(c => c.Credenciales_MotivoReimpresion).Include(c => c.Credenciales_Proceso);
            return View(credenciales_impresiones.ToList());
        }

        public ActionResult HistorialPlantel()
        {
            return View(new ImpresionHistorial().GetHistorialImpresion(1));
        }
        public ActionResult HistorialEmsad()
        {
            return View(new ImpresionHistorial().GetHistorialImpresion(2));
        }

        // GET: /CredencialesReimpresiones/Details/5

        public ActionResult Details(long id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Credenciales_Impresiones credenciales_impresiones = db.Credenciales_Impresiones.Find(id);
            if (credenciales_impresiones == null)
            {
                return HttpNotFound();
            }
            return View(credenciales_impresiones);
        }

        // GET: /CredencialesReimpresiones/Create
        [NoCache]
        public ActionResult Create(int id)
        {
            Nova.Models.Credenciales credes = new Nova.Models.Credenciales();
         
            List<Credenciales_Proceso> credencial = db.Credenciales_Proceso.Where(q => q.IdCredencialesProceso == id).ToList();

            List<Credenciales_Impresiones> impresiones = db.Credenciales_Impresiones.Where(q => q.IdCredencialesProceso == id).ToList();

           OrdenesCredenciales datoscredencial= credes.getCredencial(credencial.FirstOrDefault().IdOrden, credencial.FirstOrDefault().IdCampus);
           ViewBag.datoscredencial = datoscredencial;
           //ViewBag.CredencialesProceso = credencial;
           ViewBag.impresiones = impresiones;
            ViewBag.IdCredencialesMotivoReimpresion = new SelectList(db.Credenciales_MotivoReimpresion.Where(t=> t.IdCredencialesMotivoReimpresion>0), "IdCredencialesMotivoReimpresion", "MotivoReimpresion");
            //ViewBag.IdCredencialesProceso = new SelectList(db.Credenciales_Proceso, "IdCredencialesProceso", "Documento");

            Credenciales_Impresiones model = new Nova.Models.Credenciales_Impresiones();
            model.FechaReimpresion = DateTime.Now;
            model.IdConvenioLaboralTrabajadorCategoriaImprimio = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            model.IdCredencialesProceso = id;
            
             return View(model);
        }

        // POST: /CredencialesReimpresiones/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [NoCache]
        public ActionResult Imprimir(int idorden,short idcampus )
        {
            Nova.Models.Credenciales credes = new Nova.Models.Credenciales();
            List<OrdenesCredenciales> listaimpresion = new List<OrdenesCredenciales>();
            List<vwCampus> Campus = bdnova.vwCampus.ToList();
            List<ctPlanEstudio> planes = bdaries.ctPlanEstudio.ToList();

            ViewBag.ListaPlanes = planes;
            ViewBag.ListaCampus = Campus;

         
                  

                    listaimpresion.Add( credes.getCredencial(idorden, idcampus));

            string modalidad = "Credenciales" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 0;
            // Establecer el tamaño de la página como Tabloid (11x17 pulgadas)
            Rotativa.Options.Size pageSize = Rotativa.Options.Size.Tabloid;

            return new ViewAsPdf(listaimpresion)
            {
                PageSize = pageSize,
                PageOrientation = Rotativa.Options.Orientation.Landscape,
                PageMargins = m,
                FileName = modalidad
            };
            // return View(listaimpresion);
        }

      

        [HttpPost]
        [ValidateAntiForgeryToken]
        [NoCache]
        public ActionResult Create([Bind(Include="IdCredencialesImpresiones,IdCredencialesProceso,IdConvenioLaboralTrabajadorCategoriaImprimio,FechaReimpresion,IdCredencialesMotivoReimpresion,Estante")] Credenciales_Impresiones credenciales_impresiones)
        {
            long id = (long)credenciales_impresiones.IdCredencialesProceso;
            Credenciales_Proceso crede = bdnova.Credenciales_Proceso.Find(credenciales_impresiones.IdCredencialesProceso);
            Credenciales_Inventario inventario = bdnova.Credenciales_Inventario.Where(q => q.IdModalidadEstudio == crede.IdModalidadEstudio && q.Existencias > 0).OrderByDescending(q => q.IdCredencialesInventario).FirstOrDefault();

            inventario.Existencias = (short)(inventario.Existencias - 1);
            credenciales_impresiones.IdCredencialesInventario = inventario.IdCredencialesInventario;

            bdnova.Entry(inventario).State = System.Data.Entity.EntityState.Modified;
            bdnova.Entry(inventario).Property("Existencias").IsModified = true;
             


            if (ModelState.IsValid)
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                  using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {
                db.Credenciales_Impresiones.Add(credenciales_impresiones);

                Credenciales_Proceso proceso = bdnova.Credenciales_Proceso.Where(w => w.IdCredencialesProceso == credenciales_impresiones.IdCredencialesProceso).FirstOrDefault();
                db.SaveChanges();
                bdnova.SaveChanges();
                scope.Complete();
               
                return RedirectToAction("Imprimir", new { proceso.IdOrden, proceso.IdCampus });
                 }
            }

            Nova.Models.Credenciales credes = new Nova.Models.Credenciales();

            List<Credenciales_Proceso> credencial = db.Credenciales_Proceso.Where(q => q.IdCredencialesProceso == id).ToList();

            List<Credenciales_Impresiones> impresiones = db.Credenciales_Impresiones.Where(q => q.IdCredencialesProceso == id).ToList();

            OrdenesCredenciales datoscredencial = credes.getCredencial(credencial.FirstOrDefault().IdOrden, credencial.FirstOrDefault().IdCampus);
            ViewBag.datoscredencial = datoscredencial;
            //ViewBag.CredencialesProceso = credencial;
            ViewBag.impresiones = impresiones;
            ViewBag.IdCredencialesMotivoReimpresion = new SelectList(db.Credenciales_MotivoReimpresion.Where(t => t.IdCredencialesMotivoReimpresion > 0), "IdCredencialesMotivoReimpresion", "MotivoReimpresion");
            //ViewBag.IdCredencialesProceso = new SelectList(db.Credenciales_Proceso, "IdCredencialesProceso", "Documento");

            Credenciales_Impresiones model = new Nova.Models.Credenciales_Impresiones();
            model.FechaReimpresion = DateTime.Now;
            model.IdConvenioLaboralTrabajadorCategoriaImprimio = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            model.IdCredencialesProceso = id;

            return View(credenciales_impresiones);
        }

        // GET: /CredencialesReimpresiones/Edit/5
        public ActionResult Edit(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Credenciales_Impresiones credenciales_impresiones = db.Credenciales_Impresiones.Find(id);
            if (credenciales_impresiones == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoriaImprimio = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", credenciales_impresiones.IdConvenioLaboralTrabajadorCategoriaImprimio);
            ViewBag.IdCredencialesMotivoReimpresion = new SelectList(db.Credenciales_MotivoReimpresion, "IdCredencialesMotivoReimpresion", "MotivoReimpresion", credenciales_impresiones.IdCredencialesMotivoReimpresion);
            ViewBag.IdCredencialesProceso = new SelectList(db.Credenciales_Proceso, "IdCredencialesProceso", "Documento", credenciales_impresiones.IdCredencialesProceso);
            return View(credenciales_impresiones);
        }

        // POST: /CredencialesReimpresiones/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include="IdCredencialesImpresiones,IdCredencialesProceso,IdConvenioLaboralTrabajadorCategoriaImprimio,FechaReimpresion,IdCredencialesMotivoReimpresion,Estante")] Credenciales_Impresiones credenciales_impresiones)
        {
            if (ModelState.IsValid)
            {
                db.Entry(credenciales_impresiones).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoriaImprimio = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", credenciales_impresiones.IdConvenioLaboralTrabajadorCategoriaImprimio);
            ViewBag.IdCredencialesMotivoReimpresion = new SelectList(db.Credenciales_MotivoReimpresion, "IdCredencialesMotivoReimpresion", "MotivoReimpresion", credenciales_impresiones.IdCredencialesMotivoReimpresion);
            ViewBag.IdCredencialesProceso = new SelectList(db.Credenciales_Proceso, "IdCredencialesProceso", "Documento", credenciales_impresiones.IdCredencialesProceso);
            return View(credenciales_impresiones);
        }

        // GET: /CredencialesReimpresiones/Delete/5
        public ActionResult Delete(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Credenciales_Impresiones credenciales_impresiones = db.Credenciales_Impresiones.Find(id);
            if (credenciales_impresiones == null)
            {
                return HttpNotFound();
            }
            return View(credenciales_impresiones);
        }

        // POST: /CredencialesReimpresiones/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(long id)
        {
            Credenciales_Impresiones credenciales_impresiones = db.Credenciales_Impresiones.Find(id);
            db.Credenciales_Impresiones.Remove(credenciales_impresiones);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
