﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class CredencialesIncidentesController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /CredencialesIncidentes/
        public ActionResult Index()
        {
            var credenciales_incidentes = db.Credenciales_Incidentes.Include(c => c.Catalogos_ctModalidadEstudio).Include(c => c.Credenciales_Incidencia);
            return View(credenciales_incidentes.ToList());
        }

        // GET: /CredencialesIncidentes/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Credenciales_Incidentes credenciales_incidentes = db.Credenciales_Incidentes.Find(id);
            if (credenciales_incidentes == null)
            {
                return HttpNotFound();
            }
            return View(credenciales_incidentes);
        }

        // GET: /CredencialesIncidentes/Create
        public ActionResult Create()
        {
            ViewBag.IdModalidadEstudio = new SelectList(db.Catalogos_ctModalidadEstudio, "IdModalidadEstudio", "ModalidadEstudio");
            ViewBag.IdCredencialesIncidencia = new SelectList(db.Credenciales_Incidencia, "IdCredencialesIncidencia", "Incidencia");
            return View();
        }

        // POST: /CredencialesIncidentes/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include="IdCredencialesIncidentes,FechaIncidente,IdCredencialesIncidencia,IdModalidadEstudio,FechaCorrecion")] Credenciales_Incidentes credenciales_incidentes)
        {
            if (ModelState.IsValid)
            {
                db.Credenciales_Incidentes.Add(credenciales_incidentes);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdModalidadEstudio = new SelectList(db.Catalogos_ctModalidadEstudio, "IdModalidadEstudio", "ModalidadEstudio", credenciales_incidentes.IdModalidadEstudio);
            ViewBag.IdCredencialesIncidencia = new SelectList(db.Credenciales_Incidencia, "IdCredencialesIncidencia", "Incidencia", credenciales_incidentes.IdCredencialesIncidencia);
            return View(credenciales_incidentes);
        }

        // GET: /CredencialesIncidentes/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Credenciales_Incidentes credenciales_incidentes = db.Credenciales_Incidentes.Find(id);
            if (credenciales_incidentes == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdModalidadEstudio = new SelectList(db.Catalogos_ctModalidadEstudio, "IdModalidadEstudio", "ModalidadEstudio", credenciales_incidentes.IdModalidadEstudio);
            ViewBag.IdCredencialesIncidencia = new SelectList(db.Credenciales_Incidencia, "IdCredencialesIncidencia", "Incidencia", credenciales_incidentes.IdCredencialesIncidencia);
            return View(credenciales_incidentes);
        }

        // POST: /CredencialesIncidentes/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include="IdCredencialesIncidentes,FechaIncidente,IdCredencialesIncidencia,IdModalidadEstudio,FechaCorrecion")] Credenciales_Incidentes credenciales_incidentes)
        {
            if (ModelState.IsValid)
            {
                db.Entry(credenciales_incidentes).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdModalidadEstudio = new SelectList(db.Catalogos_ctModalidadEstudio, "IdModalidadEstudio", "ModalidadEstudio", credenciales_incidentes.IdModalidadEstudio);
            ViewBag.IdCredencialesIncidencia = new SelectList(db.Credenciales_Incidencia, "IdCredencialesIncidencia", "Incidencia", credenciales_incidentes.IdCredencialesIncidencia);
            return View(credenciales_incidentes);
        }

        // GET: /CredencialesIncidentes/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Credenciales_Incidentes credenciales_incidentes = db.Credenciales_Incidentes.Find(id);
            if (credenciales_incidentes == null)
            {
                return HttpNotFound();
            }
            return View(credenciales_incidentes);
        }

        // POST: /CredencialesIncidentes/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Credenciales_Incidentes credenciales_incidentes = db.Credenciales_Incidentes.Find(id);
            db.Credenciales_Incidentes.Remove(credenciales_incidentes);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
