﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using System.Transactions;
using Microsoft.AspNet.Identity.Owin;
using Microsoft.AspNet.Identity;
using System.Web.Security;
using System.Threading.Tasks;
using Seguridad;
using System.Net.Mail;
using System.Net;
using Nova.App_Start;
using Rotativa;
using static Nova.Models.Credenciales;
using Dapper;
using System.Data.SqlClient;
using System.Data;

namespace Nova.Controllers.Credenciales
{

    public class CredencialesController : Controller
    {
        private Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdAriesEntities");
        private ApplicationUserManager _userManager;

        //
        // GET: /Credenciales/
        bdAriesEntities bdaries = new bdAriesEntities();

        bdNovaEntities bdnova = new bdNovaEntities();

        public ActionResult ReporteCredencialesMarcadas()
        {
            string añosConsulta = (DateTime.Now.Year - 1).ToString() + "," + DateTime.Now.Year.ToString();
            string query = String.Format(@"select   convert(varchar, bb.FechaReimpresion, 105)FechaImpresion,
                                convert(varchar, bb.FechaReimpresion, 8)HoraImpresion
                                ,c.NumeroNombre,c.NombreLargo
                                ,b.Curp,d.ApPaterno,d.ApMaterno,d.Nombre,CicloEscolarOrden=e.Nombre
                                ,ResponsableImpresion=z.ApellidoPaterno+SPACE(1)+z.ApellidoMaterno+SPACE(1)+z.Nombre
                                from bdNova.dbo.Credenciales_Proceso a
                                left join bdNova.dbo.Credenciales_Impresiones bb on bb.IdCredencialesProceso=a.IdCredencialesProceso
                                inner join bdCtlEscSeg.dbo.ptOrdenes b on a.IdOrden=b.IdOrden and a.IdCampus=b.IdCampus
                                inner join bdCtlEscSeg.dbo.ctCampus c on c.IdCampus=b.IdCampus
                                inner join bdCtlEscSeg.dbo.ctAlumnos d on d.Curp=b.Curp
                                inner join bdCtlEscSeg.dbo.ctCicloescolar e on e.IdCicloEscolar=b.IdCicloEscolar
                                inner join bdNova.dbo.vwDatosAspirantesTrabajadores z on z.IdConvenioLaboralTrabajadorCategoria=bb.IdConvenioLaboralTrabajadorCategoriaImprimio
                                where year(a.FechaRegistro) in ({0}) 
                                order by a.FechaRegistro desc ", añosConsulta);

            var model = (List<CredencialesMarcadas>)dp.connection.Query<CredencialesMarcadas>(query);
            dp.Close();
            return View(model);
        }


        public ActionResult Index()
        {
            ViewBag.ErrorMessage = string.Empty;
            ViewBag.ListaNoProcesados = string.Empty;
            return View();
        }

        [HttpPost]
        public ActionResult Index(string busqueda)
        {
            ViewBag.Searchtext = busqueda;

            string query = string.Empty;
            List<AlumnoInformacionFotografia> estudiantes = new List<AlumnoInformacionFotografia>();
            if (string.IsNullOrEmpty(busqueda))
            {
                query = @" select a.Curp,a.Nombre,a.ApPaterno,a.ApMaterno
                                ,CentroEducativo=c.NumeroNombre,Semestre=d.Nombre
                                ,TipoImagen=isnull(b.TipoImagen,'SinDato')
                                ,TamañoBytes=case when b.foto is null then 0 else datalength(b.foto) end
                                into #Vigentes                                
                                from ctAlumnos a 
                                inner join ctCampus c on c.IdCampus=a.IdCampus
                                inner join ctValorCiclo d on d.IdValorCiclo=a.IdValorCiclo
                                inner join ctStatusAlumno e on e.IdStatusAlumno=a.IdStatusAlumno
                                inner join ctStatusAlumnoGrupal f on f.IdStatusAlumnoGrupal=e.IdStatusAlumnoGrupal
                                inner join stAlumnosFotos b on a.Curp=b.Curp 
                                where f.Nombre='ALTAS'

                                select top 100 * from #Vigentes
                                where TamañoBytes > 10000 
                                order by TamañoBytes desc";

                estudiantes = (List<AlumnoInformacionFotografia>)dp.connection.Query<AlumnoInformacionFotografia>(query);
                dp.Close();
            }

            else
            {
                query = @"select a.Curp,Nombre=a.ApPaterno+' '+a.ApMaterno+' '+a.Nombre
                                ,CentroEducativo=c.NumeroNombre,Semestre=d.Nombre,Semestre=d.Nombre,b.TipoImagen,b.Foto
                                ,TamañoBytes=case when b.foto is null then 0 else datalength(b.foto) end
                                from ctAlumnos a 
                                left join stAlumnosFotos b on a.Curp=b.Curp
                                inner join ctCampus c on c.IdCampus=a.IdCampus
                                inner join ctValorCiclo d on d.IdValorCiclo=a.IdValorCiclo
                                where a.curp='{0}'";
                query = string.Format(query, busqueda);

                estudiantes = (List<AlumnoInformacionFotografia>)dp.connection.Query<AlumnoInformacionFotografia>(query);
                dp.Close();

            }
            ViewBag.Procesados = 0;
            ViewBag.TiempoProcesamiento = 0;
            ViewBag.ResultadosEncontrados = estudiantes.Count;
            ViewBag.ErrorMessage = estudiantes.Count == 0 ? "CURP no válida o estudiante inexistente" : string.Empty;
            //ViewBag.Percentage = 100;
            return View(estudiantes);

        }
        [HttpPost]
        public ActionResult ReduceFotografia(string busqueda)
        {
            bool HayError;
            ViewBag.HayError = HayError = false;
            ViewBag.Searchtext = busqueda;
            string query = string.Empty;
            List<AlumnoInformacionFotografia> estudiantes = new List<AlumnoInformacionFotografia>();
            List<AlumnoInformacionFotografia> ListaNoProcesados = new List<AlumnoInformacionFotografia>();
            int procesados = 0;
            DateTime TiemposInicial = DateTime.Now;
            if (string.IsNullOrEmpty(busqueda))
            {
                query = @" select  a.Curp
                                ,a.Nombre,a.ApPaterno,a.ApMaterno
                                ,CentroEducativo=c.NumeroNombre,Semestre=d.Nombre
                                ,TipoImagen=isnull(b.TipoImagen,'SinDato')
                                ,TamañoBytes=case when b.foto is null then 0 else datalength(b.foto) end
                                into #Vigentes                                
                                from ctAlumnos a 
                                inner join ctCampus c on c.IdCampus=a.IdCampus
                                inner join ctValorCiclo d on d.IdValorCiclo=a.IdValorCiclo
                                inner join ctStatusAlumno e on e.IdStatusAlumno=a.IdStatusAlumno
                                inner join ctStatusAlumnoGrupal f on f.IdStatusAlumnoGrupal=e.IdStatusAlumnoGrupal
                                inner join stAlumnosFotos b on a.Curp=b.Curp 
                                where f.Nombre='ALTAS'

                                select top 100 * from #Vigentes
                                where TamañoBytes > 10000 
                                order by TamañoBytes desc";

                estudiantes = (List<AlumnoInformacionFotografia>)dp.connection.Query<AlumnoInformacionFotografia>(query);
                dp.Close();


                foreach (var item in estudiantes)
                {
                    AlumnoInformacionFotografia EstudianteEnProceso = new AlumnoInformacionFotografia();
                    try
                    {

                        stAlumnosFotos alumnofoto = new stAlumnosFotos();
                        query = string.Format("select * from stAlumnosFotos where curp = '{0}'", item.Curp);
                        alumnofoto = (stAlumnosFotos)dp.connection.QuerySingle<stAlumnosFotos>(query);
                        dp.connection.Close();
                        EstudianteEnProceso = item;
                        alumnofoto.Foto = Repositorio.RedimensionarImagen(alumnofoto.Foto);
                        dp.connection.Open();
                        string sql = "update stAlumnosFotos set Foto=@Foto where Curp=@CURP";
                        SqlCommand cmd = new SqlCommand(sql, dp.connection);
                        cmd.Parameters.Add("@Foto", SqlDbType.VarBinary, alumnofoto.Foto.Length).Value = alumnofoto.Foto;
                        cmd.Parameters.Add("@CURP", SqlDbType.NVarChar).Value = alumnofoto.Curp;
                        cmd.ExecuteNonQuery();
                        dp.connection.Close();
                        procesados += 1;
                    }
                    catch (Exception e)
                    {
                        ViewBag.HayError = HayError = true;
                        ViewBag.ErrorMessage = "Error al procesar al estudiante [" + item.Curp + "]  generó el error: [" + e.Message + "]";
                        ViewBag.Procesados = procesados;
                        ListaNoProcesados.Add(EstudianteEnProceso);
                        ViewBag.TiempoProcesamiento = DateTime.Now.Subtract(TiemposInicial);
                    }


                }
                ViewBag.Procesados = procesados;
                ViewBag.TiempoProcesamiento = DateTime.Now.Subtract(TiemposInicial);
            }
            else
            {
                try
                {
                    stAlumnosFotos alumnofoto = new stAlumnosFotos();
                    query = string.Format("select * from stAlumnosFotos where curp = '{0}'", busqueda);
                    alumnofoto = (stAlumnosFotos)dp.connection.QuerySingle<stAlumnosFotos>(query);
                    dp.connection.Close();
                    alumnofoto.Foto = Repositorio.RedimensionarImagen(alumnofoto.Foto);
                    dp.connection.Open();
                    string sql = "update stAlumnosFotos set Foto=@Foto where Curp=@CURP";
                    SqlCommand cmd = new SqlCommand(sql, dp.connection);
                    cmd.Parameters.Add("@Foto", SqlDbType.VarBinary, alumnofoto.Foto.Length).Value = alumnofoto.Foto;
                    cmd.Parameters.Add("@CURP", SqlDbType.NVarChar).Value = alumnofoto.Curp;
                    cmd.ExecuteNonQuery();
                    dp.connection.Close();
                    ViewBag.Procesados = procesados += 1;
                }
                catch (Exception e)
                {
                    ViewBag.HayError = HayError = true;
                    ViewBag.ErrorMessage = "CURP no válida o estudiante inexistente" + " Error: [" + e.Message + "]";
                    ViewBag.Procesados = procesados;

                }
            }
            query = @" select  a.Curp
                                ,a.Nombre,a.ApPaterno,a.ApMaterno
                                ,CentroEducativo=c.NumeroNombre,Semestre=d.Nombre
                                ,TipoImagen=isnull(b.TipoImagen,'SinDato')
                                ,TamañoBytes=case when b.foto is null then 0 else datalength(b.foto) end
                                into #Vigentes                                
                                from ctAlumnos a 
                                inner join ctCampus c on c.IdCampus=a.IdCampus
                                inner join ctValorCiclo d on d.IdValorCiclo=a.IdValorCiclo
                                inner join ctStatusAlumno e on e.IdStatusAlumno=a.IdStatusAlumno
                                inner join ctStatusAlumnoGrupal f on f.IdStatusAlumnoGrupal=e.IdStatusAlumnoGrupal
                                inner join stAlumnosFotos b on a.Curp=b.Curp 
                                where f.Nombre='ALTAS'

                                select top 100 * from #Vigentes
                                where TamañoBytes > 10000 
                                order by TamañoBytes desc";

            estudiantes = (List<AlumnoInformacionFotografia>)dp.connection.Query<AlumnoInformacionFotografia>(query);
            dp.Close();
            if (!HayError)
                ViewBag.ErrorMessage = "Proceso realizado con éxito.";
            ViewBag.Procesados = procesados;
            ViewBag.TiempoProcesamiento = DateTime.Now.Subtract(TiemposInicial);
            ViewBag.ListaNoProcesados = ListaNoProcesados;
            return View("Index", estudiantes);
        }

        public ActionResult Fotografia(string curp, bool EsOriginal = true)
        {
            var alumno = bdaries.stAlumnosFotos.Where(a => a.Curp == curp).Single();

            if (alumno.Foto == null)
                return File(Repositorio.FromFile("~/Content/imagenes/estudiante.jpg"), "image/jpg");
            else
            {
                if (!EsOriginal)
                    alumno.Foto = Repositorio.RedimensionarImagen(alumno.Foto);

                return File(alumno.Foto, alumno.TipoImagen);
            }

        }

        public ActionResult DetalleFotografia(string id, string campus)
        {
            var model = bdaries.stAlumnosFotos.Where(d => d.Curp == id).FirstOrDefault();
            ViewBag.Size = String.Format("NUEVO TAMAÑO:  {0:0.00} MB", ((Repositorio.RedimensionarImagen(model.Foto)).Length * 0.000001));
            ViewBag.Campus = campus;
            return View(model);
        }

        public ActionResult UsuarioEmsadFirmar(int id)
        {
            Nova.Models.Credenciales model = new Nova.Models.Credenciales();




            List<Credenciales_Proceso> Impresiones = bdnova.Credenciales_Proceso.ToList();


            ViewBag.Modalidad = " Visor de credenciales Emsad";
            ViewBag.Tipo = "cliente";


            ViewBag.ListaImpresiones = Impresiones;

            var idtrabajador = bdnova.vwDatosAspirantesTrabajadores.Where(h => h.IdTrabajador == id).FirstOrDefault();
            var empleado = bdnova.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idtrabajador.IdConvenioLaboralTrabajadorCategoria);

            ViewBag.IdConvenioLaboralTrabajadorCategoria = idtrabajador.IdConvenioLaboralTrabajadorCategoria;

            int idstructuraorganica = empleado.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;
            List<Credenciales_Reporte> reportes = bdnova.Credenciales_Reporte.Where(o => o.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == idstructuraorganica && o.IdTipoReporte == 1).OrderByDescending(w => w.FechaReporte).ToList();

            ViewBag.ReportesDelUsuario = reportes;

            ViewBag.IdEstructuraOrganica = idstructuraorganica;

            List<Credenciales_Incidentes> incidentes = bdnova.Credenciales_Incidentes.Where(q => q.FechaCorrecion == null && q.IdModalidadEstudio == 2).ToList();
            ViewBag.incidentes = incidentes;

            List<Credenciales_Inventario> inventario = bdnova.Credenciales_Inventario.Where(q => q.IdModalidadEstudio == 2).OrderByDescending(w => w.IdCredencialesInventario).Take(1).ToList();
            ViewBag.inventario = inventario;



            // return View("_solicitudes", model.getCredencialesParaImpresion(1));
            var m = model.getCredencialesParaImpresion((short)empleado.Catalogos_ctEstructuraOrganica.IdCampusEquivalencia);
            ViewBag._Campus = new SelectList(m.GroupBy(g => g.Campus).OrderBy(o => o.Key).Select(s => s.Key));
            return View("_solicitudes", model.getCredencialesParaImpresion((short)empleado.Catalogos_ctEstructuraOrganica.IdCampusEquivalencia));
        }
        public ActionResult UsuarioPlantelFirmar(int id)
        {
            Nova.Models.Credenciales model = new Nova.Models.Credenciales();




            List<Credenciales_Proceso> Impresiones = bdnova.Credenciales_Proceso.ToList();


            ViewBag.Modalidad = " Visor de credenciales PLANTEL";
            ViewBag.Tipo = "cliente";


            ViewBag.ListaImpresiones = Impresiones;

            var idtrabajador = bdnova.vwDatosAspirantesTrabajadores.Where(h => h.IdTrabajador == id).FirstOrDefault();
            var empleado = bdnova.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idtrabajador.IdConvenioLaboralTrabajadorCategoria);

            ViewBag.IdConvenioLaboralTrabajadorCategoria = idtrabajador.IdConvenioLaboralTrabajadorCategoria;

            int idstructuraorganica = empleado.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;
            List<Credenciales_Reporte> reportes = bdnova.Credenciales_Reporte.Where(o => o.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == idstructuraorganica && o.IdTipoReporte == 1).OrderByDescending(w => w.FechaReporte).ToList();

            ViewBag.ReportesDelUsuario = reportes;

            ViewBag.IdEstructuraOrganica = idstructuraorganica;

            List<Credenciales_Incidentes> incidentes = bdnova.Credenciales_Incidentes.Where(q => q.FechaCorrecion == null && q.IdModalidadEstudio == 1).ToList();
            ViewBag.incidentes = incidentes;

            List<Credenciales_Inventario> inventario = bdnova.Credenciales_Inventario.Where(q => q.IdModalidadEstudio == 1).OrderByDescending(w => w.IdCredencialesInventario).Take(1).ToList();
            ViewBag.inventario = inventario;

            // return View("_solicitudes", model.getCredencialesParaImpresion(1));
            var m = model.getCredencialesParaImpresion((short)empleado.Catalogos_ctEstructuraOrganica.IdCampusEquivalencia);
            ViewBag._Campus = new SelectList(m.GroupBy(g => g.Campus).OrderBy(o => o.Key).Select(s => s.Key));
            return View("_solicitudes", model.getCredencialesParaImpresion((short)empleado.Catalogos_ctEstructuraOrganica.IdCampusEquivalencia));
        }

        public ActionResult UsuarioPlantel()
        {
            Nova.Models.Credenciales universo = new Nova.Models.Credenciales();




            List<Credenciales_Proceso> Impresiones = bdnova.Credenciales_Proceso.ToList();


            ViewBag.Modalidad = " Visor de credenciales PLANTEL";
            ViewBag.Tipo = "cliente";


            ViewBag.ListaImpresiones = Impresiones;


            //string txtreporte="";
            //int idstructuraorganica = Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;
            //Credenciales_Reporte reporte= bdnova.Credenciales_Reporte.Where(o => o.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == idstructuraorganica).OrderByDescending(w => w.FechaReporte).Take(1).FirstOrDefault();

            //if (reporte!=null)
            //    txtreporte=reporte.FechaReporte.ToShortDateString() + " por "+ reporte.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre+" "+reporte.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno+" "+reporte.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            //ViewBag.UltimoReporte = txtreporte;


            int idstructuraorganica = Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;

            ViewBag.IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            List<Credenciales_Reporte> reportes = bdnova.Credenciales_Reporte.Where(o => o.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == idstructuraorganica && o.IdTipoReporte == 1).OrderByDescending(w => w.FechaReporte).ToList();

            ViewBag.ReportesDelUsuario = reportes;

            ViewBag.IdEstructuraOrganica = idstructuraorganica;

            List<Credenciales_Incidentes> incidentes = bdnova.Credenciales_Incidentes.Where(q => q.FechaCorrecion == null && q.IdModalidadEstudio == 1).ToList();
            ViewBag.incidentes = incidentes;

            List<Credenciales_Inventario> inventario = bdnova.Credenciales_Inventario.Where(q => q.IdModalidadEstudio == 1).OrderByDescending(w => w.IdCredencialesInventario).Take(1).ToList();
            ViewBag.inventario = inventario;

            var model = universo.getCredencialesParaImpresion((short)Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdCampusEquivalencia);

            ViewBag._Campus = new SelectList(model.GroupBy(g => g.Campus).OrderBy(o => o.Key).Select(s => s.Key));
            return View("_solicitudes", model);
        }

        public ActionResult UsuarioEmsad()
        {
            Nova.Models.Credenciales universo = new Nova.Models.Credenciales();

            ViewBag.Tipo = "cliente";


            List<Credenciales_Proceso> Impresiones = bdnova.Credenciales_Proceso.ToList();


            ViewBag.Modalidad = " Visor de credenciales EMSAD";


            ViewBag.ListaImpresiones = Impresiones;


            int idstructuraorganica = Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;
            List<Credenciales_Reporte> reportes = bdnova.Credenciales_Reporte.Where(o => o.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == idstructuraorganica && o.IdTipoReporte == 1).OrderByDescending(w => w.FechaReporte).ToList();

            ViewBag.IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            ViewBag.ReportesDelUsuario = reportes;
            ViewBag.IdEstructuraOrganica = idstructuraorganica;

            List<Credenciales_Incidentes> incidentes = bdnova.Credenciales_Incidentes.Where(q => q.FechaCorrecion == null && q.IdModalidadEstudio == 2).ToList();
            ViewBag.incidentes = incidentes;

            List<Credenciales_Inventario> inventario = bdnova.Credenciales_Inventario.Where(q => q.IdModalidadEstudio == 2).OrderByDescending(w => w.IdCredencialesInventario).Take(1).ToList();
            ViewBag.inventario = inventario;

            var model = universo.getCredencialesParaImpresion((short)Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdCampusEquivalencia);

            ViewBag._Campus = new SelectList(model.GroupBy(g => g.Campus).OrderBy(o => o.Key).Select(s => s.Key));
            return View("_solicitudes", model);

        }

        public ActionResult AdministradorEmsad()
        {
            Nova.Models.Credenciales universo = new Nova.Models.Credenciales();

            ViewBag.Tipo = "administrador";


            List<Credenciales_Proceso> Impresiones = bdnova.Credenciales_Proceso.ToList();

            ViewBag.Modalidad = " Administrador de impresión de credenciales EMSAD";


            ViewBag.ListaImpresiones = Impresiones;

            List<Credenciales_Reporte> reportes = bdnova.Credenciales_Reporte.Where(r => r.IdModalidadEstudio == 2 && r.IdTipoReporte == 1).OrderByDescending(w => w.FechaReporte).ToList();
            ViewBag.ReportesDelUsuario = reportes;

            List<Credenciales_Reporte> reportesrecoleccion = bdnova.Credenciales_Reporte.Where(r => r.IdModalidadEstudio == 2 && r.IdTipoReporte == 2).OrderByDescending(w => w.FechaReporte).ToList();
            ViewBag.ReportesRecoleccion = reportesrecoleccion;


            bool reportar = false;
            if (reportesrecoleccion.Count == 0)
                reportar = true;
            else
            {
                DateTime hoy = DateTime.Now;
                TimeSpan t = hoy - (DateTime)reportesrecoleccion[0].FechaReporte;
                if (t.Days > Nova.Models.Credenciales.DiasMinimosParaReportar)
                    reportar = true;
            }

            ViewBag.PuedeReportarRecoleccion = reportar;

            long idmodalidad = 2;
            ViewBag.IdModalidadEstudio = 2;

            List<Credenciales_Incidentes> incidentes = bdnova.Credenciales_Incidentes.Where(q => q.FechaCorrecion == null && q.IdModalidadEstudio == 2).ToList();
            ViewBag.incidentes = incidentes;

            List<Credenciales_Inventario> inventario = bdnova.Credenciales_Inventario.Where(q => q.IdModalidadEstudio == 2).OrderByDescending(w => w.IdCredencialesInventario).Take(1).ToList();
            ViewBag.inventario = inventario;
            var model = universo.getCredencialesParaImpresion(idmodalidad);

            ViewBag._Campus = new SelectList(model.GroupBy(g => g.Campus).OrderBy(o => o.Key).Select(s => s.Key));
            return View("_solicitudes", model);
        }

        [HttpPost]
        public ActionResult VerReportarRecoleccion()
        {

            Nova.Models.Credenciales model = new Nova.Models.Credenciales();
            long idmodalidad = Nova.Libraries.ConvertToInt.ConvertToInt64(Request["hfprevidreportar"]);

            List<vwCampus> Campus = bdnova.vwCampus.ToList();
            List<vwCampus> CampusExistentes = new List<vwCampus>();
            List<OrdenesCredenciales> credes = model.getCredencialesParaImpresion(idmodalidad).Where(q => q.ParaEntrega == true && q.DiasSinRecorgerCredencial > Nova.Models.Credenciales.DiasMinimosParaReportar).ToList();

            foreach (var item in credes.GroupBy(o => o.IdCampus).Select(p => p.Key).ToList())
            {
                vwCampus centro = new vwCampus();

                CampusExistentes.Add(Campus.Where(q => q.IdCampus == item).FirstOrDefault());


            }



            ViewBag.campus = CampusExistentes;
            ViewBag.credes = credes;
            return View("VerReportarRecoleccion");
        }


        [HttpPost]
        public ActionResult ReportarRecoleccion()
        {

            Nova.Models.Credenciales model = new Nova.Models.Credenciales();
            long idmodalidad = Nova.Libraries.ConvertToInt.ConvertToInt64(Request["hfidreportar"]);

            List<vwCampus> Campus = bdnova.vwCampus.ToList();
            List<vwCampus> CampusExistentes = new List<vwCampus>();
            List<OrdenesCredenciales> credes = model.getCredencialesParaImpresion(idmodalidad).Where(q => q.ParaEntrega == true && q.DiasSinRecorgerCredencial > Nova.Models.Credenciales.DiasMinimosParaReportar).ToList();

            foreach (var item in credes.GroupBy(o => o.IdCampus).Select(p => p.Key).ToList())
            {
                vwCampus centro = new vwCampus();

                CampusExistentes.Add(Campus.Where(q => q.IdCampus == item).FirstOrDefault());
                Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria director = bdnova.Convenios_stConvenioLaboralTrabajadorCategoria
                   .Where(q => (q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("DIRECTOR")
                       || q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("SUBDIRECTOR DE CENTRO EMSAD")
                 || q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("AUXILIAR DE RESPONSABLE DE CENTRO")
                 || q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("RESPONSABLE DE CENTRO")) && q.Catalogos_ctEstructuraOrganica.IdCampusEquivalencia == item).FirstOrDefault();

                //Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria director = bdnova.Convenios_stConvenioLaboralTrabajadorCategoria
                //  .Where(q => q.IdConvenioLaboralTrabajador==1889).FirstOrDefault();

                Nova.Models.Credenciales modelo = new Nova.Models.Credenciales();
                MailMessage msg = new MailMessage();

                msg.From = new MailAddress("sistemas@cecyteo.edu.mx");

                //msg.To.Add(director.Catalogos_ctEstructuraOrganica.CorreoElectronico);
                modelo.getEmailAdministradores(ref msg);


                msg.Subject = "Reporte de Credenciales sin recolectar " + director.Catalogos_ctEstructuraOrganica.EstructuraOrganica;
                msg.IsBodyHtml = true;

                CredencialesEmailReporte email = new CredencialesEmailReporte();

                email = modelo.EmailReporteSinRecoleccion(credes.Where(w => w.IdCampus == item).ToList(), Identidad.Usuario(), director, 1);

                msg.Body = email.Email;
                ViewBag.Correo = email.Email;

                SmtpClient client = new SmtpClient();


                client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                // client.UseDefaultCredentials = false;

                try
                {
                    client.Send(msg);
                    Credenciales_Reporte reporte = new Credenciales_Reporte();

                    reporte.IdConvenioLaboralTrabajadorCategoriaReporto = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                    reporte.IdConvenioLaboralTrabajadorCategoria = director.IdConvenioLaboralTrabajadorCategoria;
                    reporte.FechaReporte = DateTime.Now;
                    reporte.IdTipoReporte = 2;
                    reporte.TotalReportadas = email.TotalReporte;

                    int idstructuraorganica = Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;

                    reporte.IdModalidadEstudio = (short)idmodalidad;


                    bdnova.Entry(reporte).State = System.Data.Entity.EntityState.Added;
                    bdnova.SaveChanges();

                }
                catch (Exception)
                {
                    // regresa = false;
                    throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
                }

            }




            //CredencialesEmailReporte email = new CredencialesEmailReporte();
            //email = model.EmailReporteSinImpresion(Identidad.Usuario(), 1);
            //ViewBag.Email = email.Email;
            ViewBag.campus = CampusExistentes;
            ViewBag.credes = credes;
            return View("ReportarRecoleccion");
        }

        [HttpPost]
        public ActionResult VerReportarImpresion()
        {



            Nova.Models.Credenciales model = new Nova.Models.Credenciales();

            CredencialesEmailReporte email = new CredencialesEmailReporte();
            email = model.EmailReporteSinImpresion(Identidad.Usuario(), (short)Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdCampusEquivalencia);
            ViewBag.Email = email.Email;
            return View("_VerReportarImpresion");
        }

        [HttpPost]
        public ActionResult ReportarImpresion()
        {
            Nova.Models.Credenciales model = new Nova.Models.Credenciales();
            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            model.getEmailAdministradores(ref msg);

            msg.Subject = "Reporte de Credenciales sin imprimir";
            msg.IsBodyHtml = true;

            CredencialesEmailReporte email = new CredencialesEmailReporte();
            if (Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdCampusEquivalencia == 0)
                throw new Exception(" Para poder enviar un reporte de recordatorio de impresión se debe de estar asignado a un centro educativo");
            else
                email = model.EmailReporteSinImpresion(Identidad.Usuario(), (short)Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdCampusEquivalencia);

            msg.Body = email.Email;
            ViewBag.Correo = email.Email;

            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false;

            try
            {
                client.Send(msg);
                Credenciales_Reporte reporte = new Credenciales_Reporte();

                reporte.IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                reporte.IdConvenioLaboralTrabajadorCategoriaReporto = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                reporte.FechaReporte = DateTime.Now;
                reporte.IdTipoReporte = 1;
                reporte.TotalReportadas = email.TotalReporte;

                int idstructuraorganica = Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;

                reporte.IdModalidadEstudio = bdnova.Catalogos_ctEstructuraOrganica.Where(q => q.IdEstructuraOrganica == idstructuraorganica).FirstOrDefault().IdModalidadEstudio;


                bdnova.Entry(reporte).State = System.Data.Entity.EntityState.Added;
                bdnova.SaveChanges();

            }
            catch (Exception)
            {
                // regresa = false;
                throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }

            return View();
        }

        public ActionResult AdministradorPlantel()
        {
            Nova.Models.Credenciales universo = new Nova.Models.Credenciales();


            List<Credenciales_Proceso> Impresiones = bdnova.Credenciales_Proceso.ToList();

            ViewBag.Tipo = "administrador";
            ViewBag.Modalidad = " Administrador de impresión de credenciales PLANTEL";


            ViewBag.ListaImpresiones = Impresiones;

            List<Credenciales_Reporte> reportes = bdnova.Credenciales_Reporte.Where(r => r.IdModalidadEstudio == 1 && r.IdTipoReporte == 2).OrderByDescending(w => w.FechaReporte).ToList();
            ViewBag.ReportesDelUsuario = reportes;

            List<Credenciales_Reporte> reportesrecoleccion = bdnova.Credenciales_Reporte.Where(r => r.IdModalidadEstudio == 1 && r.IdTipoReporte == 2).OrderByDescending(w => w.FechaReporte).ToList();
            ViewBag.ReportesRecoleccion = reportesrecoleccion;

            long idmodalidad = 1;


            ViewBag.IdModalidadEstudio = 1;

            List<Credenciales_Incidentes> incidentes = bdnova.Credenciales_Incidentes.Where(q => q.FechaCorrecion == null && q.IdModalidadEstudio == 1).ToList();
            ViewBag.incidentes = incidentes;

            List<Credenciales_Inventario> inventario = bdnova.Credenciales_Inventario.Where(q => q.IdModalidadEstudio == 1).OrderByDescending(w => w.IdCredencialesInventario).Take(1).ToList();
            ViewBag.inventario = inventario;
            var model = universo.getCredencialesParaImpresion(idmodalidad);

            ViewBag._Campus = new SelectList(model.GroupBy(g => g.Campus).OrderBy(o => o.Key).Select(s => s.Key));
            return View("_solicitudes", model);
        }


        //public ActionResult ReporteGralCredenciales()
        //{

        //    var model = Nova.Models.Credenciales.getCredencialesReporteGral();

        //    return View(model);
        //}
        [HttpPost]
        public JsonResult CargarCredencialesData()
        {
            try
            {
                var datos = Nova.Models.Credenciales.getEstatusCredencialCicloVigente();

                // Configurar JsonResult con un límite mayor
                return new JsonResult
                {
                    Data = datos,
                    MaxJsonLength = int.MaxValue, // o un valor muy grande como 50000000
                    JsonRequestBehavior = JsonRequestBehavior.AllowGet
                };
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine("Error en CargarCredencialesData: " + ex.Message);
                System.Diagnostics.Debug.WriteLine("StackTrace: " + ex.StackTrace);

                return new JsonResult
                {
                    Data = new { error = true, message = "Error interno del servidor: " + ex.Message },
                    MaxJsonLength = int.MaxValue,
                    JsonRequestBehavior = JsonRequestBehavior.AllowGet
                };
            }
        }
        public ActionResult ReporteGralCredenciales()
        {

            var model = Nova.Models.Credenciales.getEstatusCredencialCicloVigente();

            return View(model);
        }
        public ActionResult ReporteGeneralXls()
        {


            var result = Nova.Models.Credenciales.getCredencialesReporteGral();

            string modalidad = "Credenciales_ReporteGeneral" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }


        [HttpPost]
        [NoCache]
        public ActionResult Atender()
        {
            Nova.Models.Credenciales credes = new Nova.Models.Credenciales();
            List<OrdenesCredenciales> listaimpresion = new List<OrdenesCredenciales>();


            //List<vwCampus> Campus = bdnova.vwCampus.ToList();
            //List<CtPlanEstudio> planes = bdaries.CtPlanEstudio.ToList();

            //ViewBag.ListaPlanes = planes;
            //ViewBag.ListaCampus = Campus;

            string[] datos = Request["hfatenderids"].Split('|');
            ViewBag.total = datos.Length;
            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            int total = 0;
            int contador = 0;
            foreach (var item in datos)
            {
                if (item.Trim() != "")
                {
                    total++;
                }
            }


            foreach (var item in datos)
            {
                if (item.Trim() != "")
                {

                    string[] registro = item.Split('*');
                    stPagosServicios servicio = new stPagosServicios();
                    int idorden = Nova.Libraries.ConvertToInt.ConvertToInt32(registro[0]);
                    short idcampus = Nova.Libraries.ConvertToInt.ConvertToInt16(registro[1]);
                    short idpagoservicio = Nova.Libraries.ConvertToInt.ConvertToInt16(registro[2]);

                    bdAriesEntities bdaries = new bdAriesEntities();
                    bdaries.Configuration.AutoDetectChangesEnabled = false;
                    bdaries.Configuration.ValidateOnSaveEnabled = false;

                    servicio = bdaries.stPagosServicios.Where(e => e.IdOrden == idorden && e.IdCampus == idcampus && e.IdPagoServicio == idpagoservicio).FirstOrDefault();
                    servicio.Atendido = true;
                    servicio.FechaAtendido = DateTime.Now;

                    bdaries.Entry(servicio).State = System.Data.Entity.EntityState.Modified;
                    bdaries.Entry(servicio).Property("Atendido").IsModified = true;
                    bdaries.Entry(servicio).Property("FechaAtendido").IsModified = true;


                    OrdenesCredenciales orden = new OrdenesCredenciales();
                    orden = credes.getCredencial(Nova.Libraries.ConvertToInt.ConvertToInt32(registro[0]), Nova.Libraries.ConvertToInt.ConvertToInt16(registro[1]));

                    Credenciales_Inventario inventario = bdnova.Credenciales_Inventario.Where(q => q.IdModalidadEstudio == orden.IdModalidadEstudio && q.Existencias > 0).OrderByDescending(q => q.IdCredencialesInventario).FirstOrDefault();

                    contador++;
                    if (contador == 1)
                    {
                        if (total > inventario.Existencias)
                        {
                            throw new ApplicationException("Las existencias de material es de " + inventario.Existencias.ToString() + " , el cual excede al total de impresiones requeridas (" + total.ToString() + ")");
                        }
                    }

                    Credenciales_Proceso procesocredes = new Credenciales_Proceso();
                    procesocredes.IdOrden = orden.IdOrden;
                    procesocredes.IdCampus = orden.IdCampus;
                    procesocredes.DiasSinFoto = orden.DiasSinFoto;
                    procesocredes.DiasSinCompletarDatos = orden.DiasSinCompletarDatos;
                    procesocredes.DiasSinImprimir = orden.DiasSinImprimir;
                    procesocredes.FechaRegistro = DateTime.Now;
                    procesocredes.Documento = orden.Documento;
                    procesocredes.Servicio = orden.Servicio;
                    procesocredes.IdModalidadEstudio = orden.IdModalidadEstudio;
                    procesocredes.CicloEscolarAlumno = orden.CicloEscolarAlumno;
                    procesocredes.CicloEscolarOrden = orden.CicloEscolarOrden;
                    procesocredes.PlanEstudio = orden.PlanEstudio;


                    bdnova.Entry(procesocredes).State = System.Data.Entity.EntityState.Added;


                    inventario.Existencias = (short)(inventario.Existencias - 1);
                    bdnova.Entry(inventario).State = System.Data.Entity.EntityState.Modified;
                    bdnova.Entry(inventario).Property("Existencias").IsModified = true;



                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.Required, transactionoptions1))
                    {

                        try
                        {
                            bdaries.SaveChanges();
                            bdnova.SaveChanges();
                        }
                        catch (Exception e)
                        {

                            throw new System.Exception(ExceptionExtensions.GetOriginalException(e).Message + " IdOrden:"+ orden.IdOrden + " IdCampus:"+ orden.IdCampus + " IdPagoServicio:" + idpagoservicio);
                        }
                       


                        Credenciales_Impresiones imprimir = new Credenciales_Impresiones();
                        imprimir.IdCredencialesProceso = procesocredes.IdCredencialesProceso;
                        imprimir.FechaReimpresion = DateTime.Now;
                        imprimir.IdConvenioLaboralTrabajadorCategoriaImprimio = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                        imprimir.IdCredencialesMotivoReimpresion = 1;
                        imprimir.IdCredencialesInventario = inventario.IdCredencialesInventario;

                        bdnova.Entry(imprimir).State = System.Data.Entity.EntityState.Added;
                        bdnova.SaveChanges();

                        scope.Complete();
                    }

                    bdaries = null;
                }
            }
            return View(listaimpresion);
        }
        //    [HttpPost]
        //    [NoCache]
        //    public ActionResult Atender()
        //    {
        //        Nova.Models.Credenciales credes = new Nova.Models.Credenciales();
        //        List<OrdenesCredenciales> listaimpresion = new List<OrdenesCredenciales>();


        //        //List<vwCampus> Campus = bdnova.vwCampus.ToList();
        //        //List<CtPlanEstudio> planes = bdaries.CtPlanEstudio.ToList();

        //        //ViewBag.ListaPlanes = planes;
        //        //ViewBag.ListaCampus = Campus;

        //        string[] datos = Request["hfatenderids"].Split('|');
        //        ViewBag.total = datos.Length;
        //        TransactionOptions transactionoptions1 = new TransactionOptions();
        //            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


        //            int total = 0;
        //        int contador=0;
        //            foreach (var item in datos)
        //            {
        //                if (item.Trim() != "")
        //                {
        //                    total++;
        //                }
        //            }

        //     bdaries.Configuration.AutoDetectChangesEnabled = false;
        //                bdaries.Configuration.ValidateOnSaveEnabled = false;

        //                bdnova.Configuration.AutoDetectChangesEnabled = false;
        //                bdnova.Configuration.ValidateOnSaveEnabled = false;
        //      //bdaries.Entry(servicio).Property("Atendido").IsModified = true;
        //      //          bdaries.Entry(servicio).Property("FechaAtendido").IsModified = true;

        //        foreach (var item in datos)
        //        {
        //            if (item.Trim() != "")
        //            {

        //                string[] registro = item.Split('*');
        //                stPagosServicios servicio= new stPagosServicios();
        //                int idorden=Nova.Libraries.ConvertToInt.ConvertToInt32(registro[0]);
        //                short idcampus=Nova.Libraries.ConvertToInt.ConvertToInt16(registro[1]);
        //                short idpagoservicio=Nova.Libraries.ConvertToInt.ConvertToInt16(registro[2]);

        //               // bdAriesEntities aries = new bdAriesEntities();

        //                servicio = bdaries.stPagosServicios.Where(e => e.IdOrden == idorden && e.IdCampus == idcampus && e.IdPagoServicio == idpagoservicio).FirstOrDefault();
        //                if (servicio == null)
        //                    throw new Exception("Algo salio mal, al momento de buscar las ordenes, intente nuevamente" + idorden +" : "+idcampus +" :"+idpagoservicio);

        //                servicio.Atendido=true;
        //                    servicio.FechaAtendido=DateTime.Now;

        //                bdaries.Entry(servicio).State = System.Data.Entity.EntityState.Modified;


        //                OrdenesCredenciales orden = new OrdenesCredenciales();
        //                orden = credes.getCredencial(Nova.Libraries.ConvertToInt.ConvertToInt32(registro[0]), Nova.Libraries.ConvertToInt.ConvertToInt16(registro[1]));

        //                Credenciales_Inventario inventario = bdnova.Credenciales_Inventario.Where(q => q.IdModalidadEstudio == orden.IdModalidadEstudio && q.Existencias > 0).OrderByDescending(q => q.IdCredencialesInventario).FirstOrDefault();

        //                contador++;
        //                if (contador == 1)
        //                {
        //                    if (total > inventario.Existencias)
        //                    {
        //                        throw new ApplicationException("Las existencias de material es de " + inventario.Existencias.ToString() + " , el cual excede al total de impresiones requeridas (" + total.ToString() + ")");
        //                    }
        //                }

        //                Credenciales_Proceso procesocredes = new Credenciales_Proceso();
        //                procesocredes.IdOrden = orden.IdOrden;
        //                procesocredes.IdCampus = orden.IdCampus;
        //                procesocredes.DiasSinFoto = orden.DiasSinFoto;
        //                procesocredes.DiasSinCompletarDatos = orden.DiasSinCompletarDatos;
        //                procesocredes.DiasSinImprimir = orden.DiasSinImprimir;
        //                procesocredes.FechaRegistro = DateTime.Now;
        //                procesocredes.Documento = orden.Documento;
        //                procesocredes.Servicio = orden.Servicio;
        //                procesocredes.IdModalidadEstudio = orden.IdModalidadEstudio;
        //                procesocredes.CicloEscolarAlumno = orden.CicloEscolarAlumno;
        //                procesocredes.CicloEscolarOrden = orden.CicloEscolarOrden;
        //                procesocredes.PlanEstudio = orden.PlanEstudio;


        //                bdnova.Entry(procesocredes).State = System.Data.Entity.EntityState.Added;


        //                inventario.Existencias = (short)(inventario.Existencias - 1);



        //             using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
        //            { 
        //                   bdnova.SaveChanges();

        //                 bdnova.Entry(inventario).State = System.Data.Entity.EntityState.Modified;
        //                bdnova.Entry(inventario).Property("Existencias").IsModified = true;

        //                bdnova.SaveChanges();

        //                  bdaries.SaveChanges();


        //                  bdNovaEntities nova = new bdNovaEntities();
        //                Credenciales_Impresiones imprimir = new Credenciales_Impresiones();
        //                imprimir.IdCredencialesProceso = procesocredes.IdCredencialesProceso;
        //                imprimir.FechaReimpresion = DateTime.Now;
        //                imprimir.IdConvenioLaboralTrabajadorCategoriaImprimio = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
        //                imprimir.IdCredencialesMotivoReimpresion = 1;
        //                imprimir.IdCredencialesInventario = inventario.IdCredencialesInventario;

        //                nova.Entry(imprimir).State = System.Data.Entity.EntityState.Added;
        //                nova.SaveChanges();

        //                    scope.Complete();
        //            }

        //            // bdaries = null;
        //}
        //        }
        //        return View(listaimpresion);
        //    }


        public ActionResult HistorialUsuario(short Id)
        {
            ViewData["Id"] = Id;
            ViewData["EsUsuario"] = "Si";
            return PartialView("_HistorialUsuario");
        }

        public ActionResult ImpresionesAdministrador(short Id)
        {
            ViewData["Id"] = Id;
            ViewBag.tipo = "administrador";
            return View("HistorialImpresiones");
        }

        public ActionResult ImpresionesUsuario(short Id)
        {
            ViewData["Id"] = Id;
            ViewBag.tipo = "";
            return View("HistorialImpresiones");
        }

        public ActionResult HistorialAdministrador(short Id)
        {
            ViewData["Id"] = Id;
            ViewData["EsUsuario"] = "No";
            return PartialView("_HistorialAdministrador");
        }


        [HttpPost]
        [NoCache]
        public ActionResult Marcar()
        {
            Nova.Models.Credenciales credes = new Nova.Models.Credenciales();
            List<OrdenesCredenciales> listaimpresion = new List<OrdenesCredenciales>();
            List<vwCampus> Campus = bdnova.vwCampus.ToList();
            List<ctPlanEstudio> planes = bdaries.ctPlanEstudio.ToList();

            ViewBag.ListaPlanes = planes;
            ViewBag.ListaCampus = Campus;

            string[] datos = Request["hfids"].Split('|');
            foreach (var item in datos)
            {
                if (item.Trim() != "")
                {
                    string[] registro = item.Split('*');
                    OrdenesCredenciales orden = new OrdenesCredenciales();
                    orden = credes.getCredencial(Nova.Libraries.ConvertToInt.ConvertToInt32(registro[0]), Nova.Libraries.ConvertToInt.ConvertToInt16(registro[1]));

                    listaimpresion.Add(orden);
                }
            }


            return View(listaimpresion);
        }

        [HttpPost]
        [NoCache]
        public ActionResult Entregar()
        {
            Nova.Models.Credenciales credes = new Nova.Models.Credenciales();
            List<OrdenesCredenciales> listaimpresion = new List<OrdenesCredenciales>();
            List<vwCampus> Campus = bdnova.vwCampus.ToList();
            //List<CtPlanEstudio> planes = bdaries.CtPlanEstudio.ToList();

            //ViewBag.ListaPlanes = planes;
            ViewBag.ListaCampus = Campus;

            string[] datos = Request["hfentregarids"].Split('|');

            ViewBag.IdConvenioLaboralTrabajadorCategoria = Request["IdConvenioLaboralTrabajadorCategoria"];



            foreach (var item in datos)
            {
                if (item.Trim() != "")
                {
                    string[] registro = item.Split('*');
                    OrdenesCredenciales orden = new OrdenesCredenciales();
                    orden = credes.getCredencial(Nova.Libraries.ConvertToInt.ConvertToInt32(registro[0]), Nova.Libraries.ConvertToInt.ConvertToInt16(registro[1]));

                    listaimpresion.Add(orden);
                }
            }


            return View(listaimpresion);
        }

        public ApplicationUserManager UserManager
        {
            get
            {
                return _userManager ?? HttpContext.GetOwinContext().GetUserManager<ApplicationUserManager>();
            }
            private set
            {
                _userManager = value;
            }
        }


        [HttpPost]
        [NoCache]
        public ActionResult CompletarEntrega()
        {


            //                 if (ModelState.IsValid)
            //            {
            //                PasswordVerificationResult result = PasswordVerificationResult.Failed;
            //                var user  =   UserManager.FindByEmailAsync(details.Name);
            //                if (user == null)
            //                {
            //                    ModelState.AddModelError("", "Invalid name or password.");
            //                }
            //                else
            //                {
            //                   IdentityResult resultPassword =  UserManager.PasswordValidator.ValidateAsync(Request["password"]));
            //if (resultPassword.Succeeded)
            //{
            //    IdentityResult result = await UserManager.ChangePasswordAsync(User.Identity.GetUserId(), model.OldPassword, model.NewPassword);
            //}
            //                    var resultado = UserManager.PasswordValidator.ValidateAsync( Request["password"]);

            //                    if (!(resultado == PasswordVerificationResult.Success))
            //                     {
            //                         ModelState.AddModelError("", "Invalid name or password.");
            //                     }

            //                }



            //        //    ApplicationUserManager UserManager=new ApplicationUserManager();
            //            var user =  UserManager.FindAsync(Request["usuario"], Request["password"]);

            // var result = await SignInManager.PasswordSignInAsync(model.UserName, model.Password, model.RememberMe, shouldLockout: true);


            Nova.Models.Credenciales credes = new Nova.Models.Credenciales();
            List<OrdenesCredenciales> listaimpresion = new List<OrdenesCredenciales>();
            List<vwCampus> Campus = bdnova.vwCampus.ToList();
            //List<CtPlanEstudio> planes = bdaries.CtPlanEstudio.ToList();

            //ViewBag.ListaPlanes = planes;
            ViewBag.ListaCampus = Campus;

            string[] datos = Request["hfentregarids"].Split('|');
            int IdConvenioLaboralTrabajadorCategoria = Libraries.ConvertToInt.ConvertToInt32(Request["IdConvenioLaboralTrabajadorCategoria"]);

            if (IdConvenioLaboralTrabajadorCategoria == 0)
                throw new ApplicationException("Ha ocurrido un error , notifique al administradoir del sistema");


            ViewBag.total = datos.Length;

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {

                foreach (var item in datos)
                {
                    if (item.Trim() != "")
                    {
                        string[] registro = item.Split('*');
                        OrdenesCredenciales orden = new OrdenesCredenciales();
                        orden = credes.getCredencial(Nova.Libraries.ConvertToInt.ConvertToInt32(registro[0]), Nova.Libraries.ConvertToInt.ConvertToInt16(registro[1]));
                        Credenciales_Proceso proceso = bdnova.Credenciales_Proceso.Where(q => q.IdCredencialesProceso == orden.IdCredencialesProceso).FirstOrDefault();
                        proceso.FechaRecoleccion = DateTime.Now;
                        proceso.DiasSinRecorgerCredencial = orden.DiasSinRecorgerCredencial;
                        //proceso.IdConvenioLaboralTrabajadorCategoriaRecibio = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                        proceso.IdConvenioLaboralTrabajadorCategoriaRecibio = IdConvenioLaboralTrabajadorCategoria;

                        bdnova.Entry(proceso).State = System.Data.Entity.EntityState.Modified;
                        bdnova.Entry(proceso).Property("FechaRecoleccion").IsModified = true;
                        bdnova.Entry(proceso).Property("DiasSinRecorgerCredencial").IsModified = true;
                        bdnova.SaveChanges();

                        listaimpresion.Add(orden);
                    }
                }

                scope.Complete();
            }

            return View(listaimpresion);

        }

        [HttpPost]
        [NoCache]
        public ActionResult Imprimir()
        {
            Nova.Models.Credenciales credes = new Nova.Models.Credenciales();
            List<OrdenesCredenciales> listaimpresion = new List<OrdenesCredenciales>();
            List<vwCampus> Campus = bdnova.vwCampus.ToList();
            List<ctPlanEstudio> planes = bdaries.ctPlanEstudio.ToList();

            ViewBag.ListaPlanes = planes;
            ViewBag.ListaCampus = Campus;

            string[] datos = Request["hfids"].Split('|');
            foreach (var item in datos)
            {
                if (item.Trim() != "")
                {
                    string[] registro = item.Split('*');
                    OrdenesCredenciales orden = new OrdenesCredenciales();
                    orden = credes.getCredencial(Nova.Libraries.ConvertToInt.ConvertToInt32(registro[0]), Nova.Libraries.ConvertToInt.ConvertToInt16(registro[1]));

                    listaimpresion.Add(orden);
                }
            }


            // return View(listaimpresion);


            string modalidad = "Credenciales" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 0;
            // Establecer el tamaño de la página como Tabloid (11x17 pulgadas)
            Rotativa.Options.Size pageSize = Rotativa.Options.Size.Tabloid;

            return new ViewAsPdf(listaimpresion)
            {
                PageSize = pageSize,
                PageOrientation = Rotativa.Options.Orientation.Landscape,
                PageMargins = m,
                FileName = modalidad
            };


        }

        //[HttpPost]
        //[NoCache]
        //public ActionResult Imprimir()
        //{
        //    Nova.Models.Credenciales credes = new Nova.Models.Credenciales();
        //    List<OrdenesCredenciales> listaimpresion = new List<OrdenesCredenciales>();
        //    List<vwCampus> Campus = bdnova.vwCampus.ToList();
        //    List<ctPlanEstudio> planes = bdaries.ctPlanEstudio.ToList();

        //    ViewBag.ListaPlanes = planes;
        //    ViewBag.ListaCampus = Campus;

        //    string[] datos = Request["hfids"].Split('|');
        //    foreach (var item in datos)
        //    {
        //        if (item.Trim() != "")
        //        {
        //            string[] registro = item.Split('*');
        //            OrdenesCredenciales orden = new OrdenesCredenciales();
        //            orden = credes.getCredencial(Nova.Libraries.ConvertToInt.ConvertToInt32(registro[0]), Nova.Libraries.ConvertToInt.ConvertToInt16(registro[1]));

        //            listaimpresion.Add(orden);
        //        }
        //    }


        //    // return View(listaimpresion);


        //    string modalidad = "Credenciales" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

        //    // return View(model);
        //    Rotativa.Options.Margins m = new Rotativa.Options.Margins();
        //    m.Bottom = 0;
        //    m.Left = 0;
        //    m.Right = 0;
        //    m.Top = 20;
        //    return new ViewAsPdf(listaimpresion) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        //}


        [AllowAnonymous]
        public ActionResult getFotografia(string curp)
        {
            byte[] image = getFoto(curp);
            //var image = getFotoBase64(curp);
            if (image == null)
                //return String.Empty;
             return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.png"), "image/jpg");
            else
                //return image;
            return File(image, "image/jpg");
        }

        public byte[] getFoto(string curp)
        {
            bdAriesEntities d = new bdAriesEntities();
           

            byte[] w = d.stAlumnosFotos.Where(a => a.Curp == curp).Select(s => s.Foto).SingleOrDefault();

            return w;

        }
        public string getFotoBase64(string curp)
        {
            bdAriesEntities d = new bdAriesEntities();
            byte[] w = d.stAlumnosFotos.Where(a => a.Curp == curp).Select(s => s.Foto).SingleOrDefault();
            string base64String = Convert.ToBase64String(w);
            return base64String;

        }

        //// NERIS
    

        public ActionResult AdministradorPlantelCredencialesEntregadas()
        {

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string queryAreas = @"select NombreLargo  from vwCampus";

            var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            dp.Close();

            ViewBag.Tipo = "administrador";
            ViewBag.IdModalidadEstudio = 1;
            return View("_credenciales");
        }

        [HttpPost]
        public ActionResult AdministradorPlantelCredenciales(String[] areas, string fechainicial, string fechafinal)
        {
            Nova.Libraries.DapperQuery dpa = new Nova.Libraries.DapperQuery("bdNovaEntities");


            string query = "";

            //string ultimomes = DateTime.Now.Year.ToString() + System.DateTime.Today.Month.ToString("#00") + "01";
            //and   a.IdModalidadEstudio=" + idmodalidad + @"  and FechaRecoleccion>= '" + ultimomes + @"'
            query = @" select top 30 count(a.IdCredencialesProceso) as  Total, g.NombreLargo as Campus ,max(e.Nombre) +' '+max(e.ApellidoPaterno)+' ' +max(e.ApellidoMaterno) as Recibio,max(FechaRecoleccion) as  FechaRecoleccion
                from Credenciales_Proceso a
                inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoriaRecibio=b.IdConvenioLaboralTrabajadorCategoria
                inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
                inner join Kardex_ctTrabajador d on d.IdTrabajador=c.IdTrabajador
                inner join Kardex_ctDatosPersonales e on e.IdKardex=d.IdKardex
                inner join vwCampus g  on g.IdCampus=a.IdCampus
                 where DiasSinRecorgerCredencial is not null
and g.NombreLargo in @areas
and convert (nvarchar,FechaRecoleccion,103) between  @fechainicial and  @fechafinal
                group by IdModalidadEstudio,IdConvenioLaboralTrabajadorCategoriaRecibio,g.NombreLargo
                order by FechaRecoleccion desc,g.NombreLargo";

            var result = (List<UltimasCredencialesEntregadas>)dpa.connection.Query<UltimasCredencialesEntregadas>(query, new { areas, fechainicial, fechafinal });


            dpa.Close();

            ViewBag.Tipo = "administrador";
            ViewBag.IdModalidadEstudio = 1;




            return PartialView("_entregacredenciales", result.ToList());
        }

        [HttpPost]
        public ActionResult AdministradorPlantelCredencialesEntregadasPDF(String[] areas, string fechainicial, string fechafinal)
        {
            Nova.Libraries.DapperQuery dpa = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string query = "";
            //string ultimomes = DateTime.Now.Year.ToString() + System.DateTime.Today.Month.ToString("#00") + "01";
            //and   a.IdModalidadEstudio=" + idmodalidad + @"  and FechaRecoleccion>= '" + ultimomes + @"'
            query = @" select a.IdCredencialesProceso as  Total, g.NombreLargo as Campus ,(e.Nombre +' '+e.ApellidoPaterno+' ' +e.ApellidoMaterno) as Recibio,FechaRecoleccion as  FechaRecoleccion
                    ,(i.Nombre +' '+i.ApPaterno+' ' +i .ApMaterno) as Alumno , i.Matricula
                from Credenciales_Proceso a
                inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoriaRecibio=b.IdConvenioLaboralTrabajadorCategoria
                inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
                inner join Kardex_ctTrabajador d on d.IdTrabajador=c.IdTrabajador
                inner join Kardex_ctDatosPersonales e on e.IdKardex=d.IdKardex
                inner join vwCampus g  on g.IdCampus=a.IdCampus
inner join bdCtlEscSeg.dbo.ptOrdenes h on h.IdOrden = a.IdOrden and h.IdCampus= a.IdCampus
inner join bdCtlEscSeg.dbo.ctAlumnos i on i.Curp = h.Curp
                 where DiasSinRecorgerCredencial is not null
and g.NombreLargo in @areas
and convert (nvarchar,FechaRecoleccion,103) between  @fechainicial and  @fechafinal
                order by FechaRecoleccion desc,g.NombreLargo";
            var result = (List<UltimasCredencialesEntregadas>)dpa.connection.Query<UltimasCredencialesEntregadas>(query, new { areas, fechainicial, fechafinal });
            dpa.Close();
            string modalidad = "CredencialesEntregadas" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";
            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            //return PartialView("_entregacredenciales", result.ToList());
        }


        public ActionResult AdministradorPlantelCredencialesEntregadasXls(String[] areas, string fechainicial, string fechafinal)
        //String[] proyectos,
        {

            Nova.Libraries.DapperQuery dpa = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string query = "";
            query = @" select a.IdCredencialesProceso as  Total, g.NombreLargo as Campus ,(e.Nombre +' '+e.ApellidoPaterno+' ' +e.ApellidoMaterno) as Recibio,FechaRecoleccion as  FechaRecoleccion
,(i.Nombre +' '+i.ApPaterno+' ' +i .ApMaterno) as Alumno , i.Matricula
                from Credenciales_Proceso a
                inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoriaRecibio=b.IdConvenioLaboralTrabajadorCategoria
                inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
                inner join Kardex_ctTrabajador d on d.IdTrabajador=c.IdTrabajador
                inner join Kardex_ctDatosPersonales e on e.IdKardex=d.IdKardex
                inner join vwCampus g  on g.IdCampus=a.IdCampus
inner join bdCtlEscSeg.dbo.ptOrdenes h on h.IdOrden = a.IdOrden and h.IdCampus= a.IdCampus
inner join bdCtlEscSeg.dbo.ctAlumnos i on i.Curp = h.Curp
                 where DiasSinRecorgerCredencial is not null
and g.NombreLargo in @areas
and convert (nvarchar,FechaRecoleccion,103) between  @fechainicial and  @fechafinal
                order by FechaRecoleccion desc,g.NombreLargo";
            var result = (List<UltimasCredencialesEntregadas>)dpa.connection.Query<UltimasCredencialesEntregadas>(query, new { areas, fechainicial, fechafinal });
            dpa.Close();

            string modalidad = "CredencialesEntregadas" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }



        ////



    }
}