﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Net.Mail;
using System.IO;
using System.Net;
using Nova.Models;
using Dapper;
using Nova.Libraries;
namespace Nova.Controllers
{
    public class ComunicacionEstudiantilController : Controller
    {
        // GET: ComunicacionEstudiantil
        public ActionResult Index()
        {
            return View();
        }

        [HttpPost]
        public ActionResult Index(FormCollection collection, HttpPostedFileBase[] Attachedfiles)
        {
            try
            {
                Email mail = new Email();
                mail.To = collection["To"];
                mail.Subject = collection["Subject"];
                mail.Body = collection["Body"];
                string result= EnviarCorreo(mail, Attachedfiles);
                ViewBag.Mesaje = "¡Correo(s) enviado(s) exitosamente! \n \n " + result + " ,0";
                return View();
            }
            catch (Exception e)
            {
                ViewBag.Mesaje = "¡Error al procesar los correos! \n \n Información del error: " + ExceptionExtensions.GetOriginalException(e).Message + ",1";
                return View();
            }
        }

        private string FormateaCuerpoCorreo(string to, string body)
        {
            string cuerpo = @"<!doctype html>
                                                        <html xmlns='http://www.w3.org/1999/xhtml'>
                                                        <head>

                                                        <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />

                                                        <title>Portal de Estudiantes | Comunicación Estudiantil</title>

                                                        <style type='text/css'>
	                                                        .ReadMsgBody {width: 100%; background-color: #ffffff;}
	                                                        .ExternalClass {width: 100%; background-color: #ffffff;}
	                                                        body	 {width: 100%; background-color: #ffffff; margin:0; padding:0; -webkit-font-smoothing: antialiased;font-family: Helvetica, Georgia, Times, serif}
                                                           
                                                            table {border-collapse: collapse;}

	                                                        @media only screen and (max-width: 640px)  {
					                                                        body[yahoo] .deviceWidth {width:440px!important; padding:0;}
					                                                        body[yahoo] .center {text-align: center!important;}
			                                                        }

	                                                        @media only screen and (max-width: 479px) {
					                                                        body[yahoo] .deviceWidth {width:280px!important; padding:0;}
					                                                        body[yahoo] .center {text-align: center!important;}
			                                                        }

                                                        </style>
                                                        </head>

                                                        <body leftmargin='0' topmargin='0' marginwidth='0' marginheight='0' yahoo='fix' style='font-family: Helvetica, Georgia, Times, serif'>

                                                        <!-- Wrapper -->
                                                        <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
	                                                        <tr>
		                                                        <td width='100%' valign='top' bgcolor='#ffffff' style='padding-top:20px'>

			                                                        <!-- Start Header-->
			                                                        <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
				                                                        <tr>
					                                                        <td width='100%' bgcolor='#ffffff'>

                                                                                    <!-- Logo -->
                                                                                    <table border='0' cellpadding='0' cellspacing='0' align='left' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td style='padding:10px 20px' class='center'>
                                                                                                <a href='https://www.cecyteo.edu.mx/Estudiantes'><img src='http://cecyteo.edu.mx/Estudiantes/images/logo-adminInicio.png' alt='' border='0' /></a>
                                                                                            </td>
                                                                                              <td style='padding:10px 20px' class='center'>
                                                                                                <div class='social-links'>
                                                                                                     <p><a href='https://twitter.com/cecyteoaxaca' target='_blank' ><img src='http://cecyteo.edu.mx/Nova/Content/Site/images/twitter.jpg' alt='' border='0' /></a></p>
                                                                                                        <p><a href='https://www.facebook.com/CECyTEO' target='_blank' ><img src='http://cecyteo.edu.mx/Nova/Content/Site/images/facebook.jpg' alt='' border='0' /></a></p>
                                                                                                </div>
                                                                                              </td>
                                                                                            
                                                                                        </tr>
                                                                                    </table><!-- End Logo -->

                                                                                    <!-- Nav -->
                                                                                    <table border='0' cellpadding='0' cellspacing='0' align='right' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td class='center' style='font-size: 13px; color: #272727; font-weight: light; text-align: right; font-family: Helvetica, Georgia, Times, serif; line-height: 20px; vertical-align: middle; padding:10px 20px; font-style:italic'>
                                         
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table><!-- End Nav -->

					                                                        </td>
				                                                        </tr>
			                                                        </table><!-- End Header -->

		


                                                        <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


                                                                    <!-- 2 Column Images & Text Side by SIde -->
                                                                    <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' bgcolor='#FFC300' style='margin:0 auto;'>
                                                                        <tr>
                                                                            <td style='padding:10px 0'>
                                                                                    <table align='left' width='29%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td valign='top' align='center' class='center' style='padding-left:10px; padding-top:20px;color:#fff;' >
                                                                                                 <h1 style='text-align:center;' >Comunicación Estudiantil</h1>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table>
                                                                                    <table align='right' width='69%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td style='font-size: 12px; color: #959595; font-weight: normal; text-align: left; font-family: Helvetica, Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:10px 8px 10px 8px'>

                                                                                                <table>
                                                                                                    <tr>
                                                                                                        <td valign='top' style='padding:0 10px 10px 5px;color:#fff;'>
                                                    
                                                                                                        </td>
                                                                                                        <td valign='middle' style='padding:0 10px 10px 0'>
                                                                                                        <p style='text-decoration: none; font-size: 16px; color: #1B2631; font-weight: normal; font-family:Arial, sans-serif '><strong>Hola, " + to + @"</strong>, es un gusto saludarte y compartirte un dato de interés.</p>
                                                                                                          <p> </p>                                                                                              
                                                                                                        <p style='text-decoration: none; font-size: 16px; color: #1B2631; font-weight: normal; font-family:Arial, sans-serif '> <style>a {color:white;}</style>" + body + @"</p>
                                                                                                        
                                                                                                        <p>&nbsp;</p>  
                                                                                                        <p style='text-decoration: none; font-size: 16px; color: #1B2631; font-weight: normal; font-family:Arial, sans-serif '>" + "¡Gracias por ser parte de la Comunidad CECyTEO!" + @"</p>
                                                                                                      <p style='text-decoration: none; font-size: 14px; color: #1B2631; font-weight: normal; font-family:Arial, sans-serif '>" + "Este mensaje fue generado automáticamente con una cuenta de correo no supervisada, por favor no respondas el mensaje." + @"</p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>

                                                                                                <p style='mso-table-lspace:0;mso-table-rspace:0; margin:0'>
                                                                                                    <br/><br/>
                                                                                                </p>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table>

                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td bgcolor='#fe7f00'><div style='height:6px'>&nbsp;</div></td>
                                                                        </tr>
                                                                    </table><!-- End 2 Column Images & Text Side by SIde -->


                                                        <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->
			                                                        <!-- Two Column (Images Stacked over Text) -->
                                                        <div style='height:35px;margin:0 auto;'>&nbsp;</div><!-- spacer -->
			                                                        <!-- 4 Columns -->
			                                                        <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
				                                                        <tr>
					                                                        <td bgcolor='#ffffff' style='padding:30px 0'>
                                                                                <table width='580' border='0' cellpadding='10' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
                                                                                    <tr>
                                                                                        <td>
                                                                                                <table width='45%' cellpadding='0' cellspacing='0'  border='0' align='left' class='deviceWidth'>
                                                                                                    <tr>
                                                                                                    <td valign='top' s style=' text-align: justify; font-size: 12px; color:#1B2631; font-family: Arial, sans-serif; padding-bottom:20px' class='center'>

                                                                                                        El Colegio de Estudios Científicos y Tecnológicos del Estado de Oaxaca (CECyTEO), es responsable del tratamiento de sus datos personales, hace de su conocimiento que la protección de sus datos personales y sus datos personales sensibles es sumamente importante para nosotros como institución.
                                                                                                        <br/><br/> 
                                                                                                        <a href='https://www.cecyteo.edu.mx/nova/content/site/docs/AvisoPrivacidad/AvisoPrivacidadSimplificado.pdf' target='_blank' style='color:#3a80c7;text-decoration:none;'>Aviso de privacidad</a><br/><br/>
                                                

                                                                                                     </td>
                                                                                                   </tr>
                              
                                                                                                        <tr>
                                                                                                        <td valign='top' style='font-size: 12px; color:#1B2631; font-family: Arial, sans-serif; padding-bottom:20px' class='center'>

                                                                                                           Departamento de Sistemas, Redes y Soporte Técnico | 
                                                                                                            <a href='https://www.cecyteo.edu.mx/Estudiantes' target='_blank' style='color:#4D5B69;text-decoration:none;'>Portal de Estudiantes | " + DateTime.Now.Year + @"</a><br/>

                                                                                                            <br/><br/>
                                                   

                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>

                                                                                                <table width='40%' cellpadding='0' cellspacing='0'  border='0' align='right' class='deviceWidth'>
                                                                                                    <tr>
                                                                                                        <td valign='top' style='font-size: 12px; color: #1B2631; font-weight: normal; font-family: Helvetica, Georgia, Times, serif; line-height: 26px; vertical-align: top; text-align:right' class='center'>
                                                                                                            
                                                                                                            <a href='http://cecyteo.edu.mx/' target='_blank'><img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/icons/logo7.png' alt='' border='0' /></a>

                                                                                                                   Todos los Derechos Reservados - Cecyteo  " + DateTime.Now.Year + @"

                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>

                        		                                                        </td>
                        	                                                        </tr>
                                                                                </table>
                                                                            </td>
                                                                        </tr>
                                                                    </table><!-- End 4 Columns -->

		                                                        </td>
	                                                        </tr>
                                                        </table> <!-- End Wrapper -->
                                                        <div style='display:none; white-space:nowrap; font:15px courier; color:#ffffff;'>
                                                        - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
                                                        </div>
                                                        </body>
                                                        </html>";
            return cuerpo;
        }
        private string EnviarCorreo(Email objModelMail, HttpPostedFileBase[] Attachedfiles)
        {
            Libraries.DapperQuery dp = new Libraries.DapperQuery("bdAriesEntities");
            List<DatosAlumnosCorreoElectrónico> CorreosNovalidos = new List<DatosAlumnosCorreoElectrónico>();
            List<DatosAlumnosCorreoElectrónico> CorreosValidos = new List<DatosAlumnosCorreoElectrónico>();
             
            string from = "comunicacion.estudiantil@cecyteo.edu.mx"; //Email like- anil.singh581@gmail.com
            List<DatosAlumnosCorreoElectrónico> correos = new List<DatosAlumnosCorreoElectrónico>();
            string query;
            query = @"	use bdCtlEscSeg
	                    declare @IdCicloEscolar  as int = (select dbo.fnObtencicloescolarvigente(1))
	                    select b.IdTipoCentro,a.Nombre,a.CorreoElectronico
	                    from ctAlumnos a
	                    inner join ctCampus b on a.IdCampus= b.IdCampus
	                    inner join ctStatusAlumno d on a.IdStatusAlumno=d.IdStatusAlumno
	                    where a.IdCicloEscolar=@IdCicloEscolar 
	                    and a.Curp in 
	                    (
	                    select a.Curp from ptOrdenes a
	                    inner join stPagosServicios b on a.IdCampus=b.IdCampus and a.IdOrden=b.IdOrden
	                    and b.IdPagoServicio in (select IdPagoServicio from ctPagoServicio where EsInscripcion=1 or EsReinscripcion=1)
	                    where a.IdCicloEscolar=@IdCicloEscolar and FechaPago is not null
	                    group by a.Curp
	                    )
	                    and d.IdstatusAlumnoGrupal in (1,4) 
	                    and (a.CorreoElectronico is not null or a.CorreoElectronico<>'' )
	                    and SUBSTRING(correoelectronico,CHARINDEX('@',correoelectronico),len(correoelectronico)) in 
	                    ('@gmail.com', '@hotmail.com','@outlook.es','@outlook.com','@yahoo.com','@yahoo.com.mx')";

            correos = (List<DatosAlumnosCorreoElectrónico>)dp.connection.Query<DatosAlumnosCorreoElectrónico>(query);
            dp.Close();

            try
            {
                DatosAlumnosCorreoElectrónico sistemas = new DatosAlumnosCorreoElectrónico();
                switch (objModelMail.To)
                {
                    case "-1":
                        
                        sistemas.Nombre = "Sistemas";
                        sistemas.CorreoElectronico = "soporte.sistemas@cecyteo.edu.mx";
                        sistemas.IdTipoCentro = 0;
                        correos.Clear();
                        correos.Add(sistemas);

                        break;
                    case "0":
                        sistemas.Nombre = "Comunicación Social";
                        sistemas.CorreoElectronico = "comunicacion.social@cecyteo.edu.mx";
                        sistemas.IdTipoCentro = 0;
                        correos.Clear();
                        correos.Add(sistemas);

                        break;
                    case "2":
                        correos = correos.Where(w => w.IdTipoCentro == 2).ToList();
                        break;
                    case "3":
                        correos = correos.Where(w => w.IdTipoCentro == 1).ToList();
                        break;
                }
                foreach (var item in correos)
                {
                    using (MailMessage mail = new MailMessage(from, item.CorreoElectronico))
                    {
                        mail.Subject = objModelMail.Subject;
                        mail.IsBodyHtml = true;
                        mail.Body = FormateaCuerpoCorreo(item.Nombre, objModelMail.Body);


                        if (Attachedfiles[0] != null)
                        {
                            foreach (HttpPostedFileBase file in Attachedfiles)
                            {
                                string fileName = Path.GetFileName(file.FileName);
                                mail.Attachments.Add(new Attachment(file.InputStream, fileName));
                            }
                        }
                        SmtpClient smtp = new SmtpClient();
                        smtp.Host = "smtp.gmail.com";
                        smtp.DeliveryMethod = SmtpDeliveryMethod.Network;
                        smtp.EnableSsl = true;
                        NetworkCredential networkCredential = new NetworkCredential(from, "comunicacion@");

                        smtp.Credentials = networkCredential;
                        smtp.Port = 587;
                        try
                        {

                            smtp.Send(mail);
                            CorreosValidos.Add(item);
                        }
                        catch (Exception)
                        {
                            CorreosNovalidos.Add(item);
                        }


                    }
                }
                return " Total de correos: "+ correos.Count().ToString() + " Enviados: " + CorreosValidos.Count().ToString() + " Correos no válidos: "+ CorreosNovalidos.Count().ToString();
            }
            catch (Exception e)
            {

                throw new ArgumentException(ExceptionExtensions.GetOriginalException(e).Message);
            }

        }


    }
    public class Email
    {
        public string To { get; set; }
        public string Subject { get; set; }
        public string Body { get; set; }
    }

    public class DatosAlumnosCorreoElectrónico
    {
        public int IdTipoCentro { get; set; }
        public string Nombre { get; set; }

        public string CorreoElectronico { get; set; }


    }
}