﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;

namespace Nova.Controllers.Comisiones
{
    public class ComisionesSATController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: ComisionesSAT
        public ActionResult Index()



        {
            int Ide= Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            string Estructura = Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;
            
            if (Ide ==2636)
            {
                var lista_comisiones2 = db.Comisiones_ComisionesSAT.Where(z => z.Adscripcion == "DIRECCIÓN ACADÉMICA").ToList();
                return View(lista_comisiones2.ToList());
            }
            else if (Ide== 1877 || Ide==1607)
            {
                var lista_comisiones2 = db.Comisiones_ComisionesSAT.Where(z => z.Adscripcion == "DIRECCIÓN DE EDUCACIÓN A DISTANCIA").ToList();
                return View(lista_comisiones2.ToList());

            }
            else if (Ide== 2180 || Ide==2980 )
            {
                var lista_comisiones2 = db.Comisiones_ComisionesSAT.Where(z => z.Adscripcion == "DIRECCION DE ADMINISTRACION").ToList();
                return View(lista_comisiones2.ToList());

            }
            else if (Ide == 2955 || Ide==2128)
            {
                var lista_comisiones2 = db.Comisiones_ComisionesSAT.Where(z => z.Adscripcion == "DIRECCIÓN DE VINCULACIÓN CON EL SECTOR PRODUCTIVO").ToList();
                return View(lista_comisiones2.ToList());

            }
            else if (Ide == 367 || Ide == 3437)
            {
                var lista_comisiones2 = db.Comisiones_ComisionesSAT.Where(z => z.Adscripcion == "DIRECCIÓN DE PLANEACIÓN").ToList();
                return View(lista_comisiones2.ToList());

            }
             else if (Ide == 561)
            {
                var lista_comisiones2 = db.Comisiones_ComisionesSAT.Where(z => z.Adscripcion == "SUBDIRECCIÓN DE REGISTRO ESCOLAR Y ESTADISTICA").ToList();
                return View(lista_comisiones2.ToList());

            }
            else if (Ide == 1593)
            {
                var lista_comisiones2 = db.Comisiones_ComisionesSAT.Where(z => z.Adscripcion == "DEPARTAMENTO JURIDICO").ToList();
                return View(lista_comisiones2.ToList());

            }
            else if (Ide == 1621)
            {
                var lista_comisiones2 = db.Comisiones_ComisionesSAT.Where(z => z.Adscripcion == "DIRECCIÓN GENERAL").ToList();
                return View(lista_comisiones2.ToList());

            }
            else { 
            
            var lista_comisiones = db.Comisiones_ComisionesSAT.Where(z => z.Adscripcion == Estructura).ToList();
            return View(lista_comisiones.ToList());
            }
        }

        // GET: ComisionesSAT/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Comisiones_ComisionesSAT comisiones_ComisionesSAT = db.Comisiones_ComisionesSAT.Find(id);
            if (comisiones_ComisionesSAT == null)
            {
                return HttpNotFound();
            }
            return View(comisiones_ComisionesSAT);
        }

        // GET: ComisionesSAT/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: ComisionesSAT/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdeComision,IdeTrabajador,NombreComisionado,Categoria,Adscripcion,LugarComision,RegionComision,DistritoComision,MunicipioComision,ObjetoComision,SituacionComision,FechaTramiteComision,FechaInicioComision,FechaTerminoComision,MontoComision,DiasComision,TotalComision,Cuenta,Programa,Subprograma,Proyecto,Actividad,Clave,Tramite,Comprobado,Deducible,FechaEntregaComision,Compromiso,MetaCumplida,ObservacionesMeta")] Comisiones_ComisionesSAT comisiones_ComisionesSAT)
        {
            if (ModelState.IsValid)
            {
                db.Comisiones_ComisionesSAT.Add(comisiones_ComisionesSAT);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(comisiones_ComisionesSAT);
        }

        // GET: ComisionesSAT/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Comisiones_ComisionesSAT comisiones_ComisionesSAT = db.Comisiones_ComisionesSAT.Find(id);
            var fechas = (from a in db.Comisiones_ComisionesSAT
                      where a.IdeComision == id
                      select new
                      {
                          FechaInicioComision = a.FechaInicioComision,
                          FechaTerminoComision = a.FechaTerminoComision
                      });
             
            foreach (var item in fechas)
            {


                Session["FechaInicioComision"] = item.FechaInicioComision.ToString();
                Session["FechaTerminoComision"] = item.FechaTerminoComision.ToString();

                //    TimeSpan diferencia = FechaTerminoCurso.Date - FechaInicioCurso.Date; 
                //diascurso =diferencia.TotalDays;
            }
                
            

            if (comisiones_ComisionesSAT == null)
            {
                return HttpNotFound();
            }
            return View(comisiones_ComisionesSAT);
        }

        // POST: ComisionesSAT/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdeComision,IdeTrabajador,NombreComisionado,Categoria,Adscripcion,LugarComision,RegionComision,DistritoComision,MunicipioComision,ObjetoComision,SituacionComision,FechaTramiteComision,FechaInicioComision,FechaTerminoComision,MontoComision,DiasComision,TotalComision,Cuenta,Programa,Subprograma,Proyecto,Actividad,Clave,Tramite,Comprobado,Deducible,FechaEntregaComision,Compromiso,MetaCumplida,ObservacionesMeta")] Comisiones_ComisionesSAT comisiones_ComisionesSAT)
        {
            
            if (ModelState.IsValid)
            {
                comisiones_ComisionesSAT.FechaInicioComision = System.Convert.ToDateTime (Session["FechaInicioComision"]);
                comisiones_ComisionesSAT.FechaTerminoComision = System.Convert.ToDateTime (Session["FechaTerminoComision"]);
                db.Entry(comisiones_ComisionesSAT).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(comisiones_ComisionesSAT);
        }

        // GET: ComisionesSAT/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Comisiones_ComisionesSAT comisiones_ComisionesSAT = db.Comisiones_ComisionesSAT.Find(id);
            if (comisiones_ComisionesSAT == null)
            {
                return HttpNotFound();
            }
            return View(comisiones_ComisionesSAT);
        }

        // POST: ComisionesSAT/Delete/5
        [HttpPost, ActionName("DeleteConfirmed")]
        //[ValidateAntiForgeryToken]
        public JsonResult DeleteConfirmed(int id)
        {
            Comisiones_ComisionesSAT comisiones_ComisionesSAT = db.Comisiones_ComisionesSAT.Find(id);
            db.Comisiones_ComisionesSAT.Remove(comisiones_ComisionesSAT);
            db.SaveChanges();
            return new JsonResult() { Data = "Registro eliminado exitosamente" };
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
