﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Catalogos
{
    public class SubsidioEmpleoController : Controller
    {
        //
        // GET: /SubsidioEmpleo/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvSubsidioEmpleo()
        {
            var model = db.Configuracion_ctSubsidioEmpleo;
            return PartialView("_pvSubsidioEmpleo", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvSubsidioEmpleoAddNew(Nova.Models.Configuracion_ctSubsidioEmpleo item)
        {
            var model = db.Configuracion_ctSubsidioEmpleo;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvSubsidioEmpleo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSubsidioEmpleoUpdate(Nova.Models.Configuracion_ctSubsidioEmpleo item)
        {
            var model = db.Configuracion_ctSubsidioEmpleo;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdSubsidioEmpleo == item.IdSubsidioEmpleo);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvSubsidioEmpleo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSubsidioEmpleoDelete(System.Int16 IdSubsidioEmpleo)
        {
            var model = db.Configuracion_ctSubsidioEmpleo;
            if (IdSubsidioEmpleo != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdSubsidioEmpleo == IdSubsidioEmpleo);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvSubsidioEmpleo", model.ToList());
        }
    }
}
