﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class RelacionLaboralController : Controller
    {
        //
        // GET: /RelacionLaboral/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvGridViewRelacionLaboral()
        {
            var model = db.Catalogos_ctRelacionLaboral;
            return PartialView("__pvGridViewRelacionLaboral", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridViewRelacionLaboralAddNew(Nova.Models.Catalogos_ctRelacionLaboral item)
        {
            var model = db.Catalogos_ctRelacionLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("__pvGridViewRelacionLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridViewRelacionLaboralUpdate(Nova.Models.Catalogos_ctRelacionLaboral item)
        {
            var model = db.Catalogos_ctRelacionLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdRelacionLaboral == item.IdRelacionLaboral);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvGridViewRelacionLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridViewRelacionLaboralDelete(System.Int16 IdRelacionLaboral)
        {
            var model = db.Catalogos_ctRelacionLaboral;
            if (IdRelacionLaboral != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdRelacionLaboral == IdRelacionLaboral);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("__pvGridViewRelacionLaboral", model.ToList());
        }
    }
}
