﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
namespace Nova.Controllers.Catalogos
{
    public class PlantillaNominaController : Controller
    {
        //
        // GET: /PlantillaNomina/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvPlantillaNomina()
        {
            List<Nomina_ctPlantillaNomina> model = db.Nomina_ctPlantillaNomina.Where (x=> x.EsVigente.Equals (true)).ToList();
            return PartialView("_pvPlantillaNomina", model);
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPlantillaNominaAddNew(Nova.Models.Nomina_ctPlantillaNomina item)
        {
            var model = db.Nomina_ctPlantillaNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                              .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvPlantillaNomina", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPlantillaNominaUpdate(Nova.Models.Nomina_ctPlantillaNomina item)
        {
            var model = db.Nomina_ctPlantillaNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPlantillaNomina == item.IdPlantillaNomina);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvPlantillaNomina", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPlantillaNominaDelete(System.Int16 IdPlantillaNomina)
        {
            var model = db.Nomina_ctPlantillaNomina;
            if (IdPlantillaNomina != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPlantillaNomina == IdPlantillaNomina);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvPlantillaNomina", model.ToList());
        }

    }
}
