﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class PeriodoSalarioDiarioIntegradoController : Controller
    {
        //
        // GET: /PeriodoSalarioDiarioIntegrado/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvgvPeriodoSalarioDiarioIntegrado()
        {
            var model = db.Catalogos_ctPeriodoSalarioDiarioIntegrado;
            return PartialView("__pvgvPeriodoSalarioDiarioIntegrado", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvPeriodoSalarioDiarioIntegradoAddNew(Nova.Models.Catalogos_ctPeriodoSalarioDiarioIntegrado item)
        {
            var model = db.Catalogos_ctPeriodoSalarioDiarioIntegrado;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("__pvgvPeriodoSalarioDiarioIntegrado", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvPeriodoSalarioDiarioIntegradoUpdate(Nova.Models.Catalogos_ctPeriodoSalarioDiarioIntegrado item)
        {
            var model = db.Catalogos_ctPeriodoSalarioDiarioIntegrado;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPeriodoSalarioDiarioIntegrado == item.IdPeriodoSalarioDiarioIntegrado);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgvPeriodoSalarioDiarioIntegrado", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvPeriodoSalarioDiarioIntegradoDelete(System.Int16 IdPeriodoSalarioDiarioIntegrado)
        {
            var model = db.Catalogos_ctPeriodoSalarioDiarioIntegrado;
            if (IdPeriodoSalarioDiarioIntegrado != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPeriodoSalarioDiarioIntegrado == IdPeriodoSalarioDiarioIntegrado);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            return PartialView("__pvgvPeriodoSalarioDiarioIntegrado", model.ToList());
        }
    }
}
