﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class PeriodoNominaController : Controller
    {
        //
        // GET: /PeriodoNomina/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvgvPeriodoNomina()
        {
            var model = db.Catalogos_ctPeriodoNomina;
            return PartialView("__pvgvPeriodoNomina", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvPeriodoNominaAddNew(Nova.Models.Catalogos_ctPeriodoNomina item)
        {
            var model = db.Catalogos_ctPeriodoNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("__pvgvPeriodoNomina", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvPeriodoNominaUpdate(Nova.Models.Catalogos_ctPeriodoNomina item)
        {
            var model = db.Catalogos_ctPeriodoNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPeriodoNomina == item.IdPeriodoNomina);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgvPeriodoNomina", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvPeriodoNominaDelete(System.Int16 IdPeriodoNomina)
        {
            var model = db.Catalogos_ctPeriodoNomina;
            if (IdPeriodoNomina != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPeriodoNomina == IdPeriodoNomina);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message; 
                }
            }
            return PartialView("__pvgvPeriodoNomina", model.ToList());
        }
    }
}
