﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.Web.Mvc;

namespace Nova.Controllers.Catalogos
{
    public class PercepcionesController : Controller
    {
        //
        // GET: /Percepciones/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvPercepciones()
        {
            //ViewBag.IsNewRowEditing = false;
            var model = db.Percepciones_ctPercepcion;
            return PartialView("_pvPercepciones", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesAddNew(Nova.Models.Percepciones_ctPercepcion item)
        {
            var model = db.Percepciones_ctPercepcion;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                            .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvPercepciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesUpdate(Nova.Models.Percepciones_ctPercepcion item)
        {
            
            var model = db.Percepciones_ctPercepcion;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPercepcion == item.IdPercepcion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                            .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvPercepciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesDelete(System.Int16 IdPercepcion)
        {
            var model = db.Percepciones_ctPercepcion;
            if (IdPercepcion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPercepcion == IdPercepcion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            return PartialView("_pvPercepciones", model.ToList());
        }

    }
}
