﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.Web.Mvc;


namespace Nova.Controllers.Catalogos
{
    public class PartidasPresupuestalesController : Controller
    {
        //
        // GET: /PartidasPresupuestales/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvPartidasPresupuestales()
        {
            var model = db.Catalogos_ctPartidaPresupuestal;
            return PartialView("_pvPartidasPresupuestales", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPartidasPresupuestalesAddNew(Nova.Models.Catalogos_ctPartidaPresupuestal item)
        {
            var model = db.Catalogos_ctPartidaPresupuestal;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvPartidasPresupuestales", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPartidasPresupuestalesUpdate(Nova.Models.Catalogos_ctPartidaPresupuestal item)
        {
            var model = db.Catalogos_ctPartidaPresupuestal;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPartidaPresupuestal == item.IdPartidaPresupuestal);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvPartidasPresupuestales", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPartidasPresupuestalesDelete(System.Int16 IdPartidaPresupuestal)
        {
            var model = db.Catalogos_ctPartidaPresupuestal;
            if (IdPartidaPresupuestal != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPartidaPresupuestal == IdPartidaPresupuestal);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvPartidasPresupuestales", model.ToList());
        }
    }
}
