﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;
namespace Nova.Controllers.Catalogos
{
    public class ParametrosRelacionLaboralController : Controller
    {
        //
        // GET: /ParametrosRelacionLaboral/

        public ActionResult Index()
        {
            return View();
        }
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvParametrosRelacionLaboral()
        {
            var model = db.Catalogos_ctParametrosRelacionLaboral;
            return PartialView("_pvParametrosRelacionLaboral", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvParametrosRelacionLaboralAddNew(Nova.Models.Catalogos_ctParametrosRelacionLaboral item)
        {
            var model = db.Catalogos_ctParametrosRelacionLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvParametrosRelacionLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvParametrosRelacionLaboralUpdate(Nova.Models.Catalogos_ctParametrosRelacionLaboral item)
        {
            var model = db.Catalogos_ctParametrosRelacionLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdParametroRelacionLaboral == item.IdParametroRelacionLaboral);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvParametrosRelacionLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvParametrosRelacionLaboralDelete(System.Int16 IdParametroRelacionLaboral)
        {
            var model = db.Catalogos_ctParametrosRelacionLaboral;
            if (IdParametroRelacionLaboral != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdParametroRelacionLaboral == IdParametroRelacionLaboral);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvParametrosRelacionLaboral", model.ToList());
        }

    }
}
