﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.Web.Mvc;


namespace Nova.Controllers.Catalogos
{
    public class EstatusTrabajadorController : Controller
    {
        //
        // GET: /EstatusTrabajador/

        public ActionResult Index()
        {
            return View();
        }


        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvEstatusTrabajador()
        {
            var model = db.Catalogos_ctEstatusTrabajador;
            return PartialView("_pvEstatusTrabajador", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvEstatusTrabajadorAddNew(Nova.Models.Catalogos_ctEstatusTrabajador item)
        {
            var model = db.Catalogos_ctEstatusTrabajador;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvEstatusTrabajador", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvEstatusTrabajadorUpdate(Nova.Models.Catalogos_ctEstatusTrabajador item)
        {
            var model = db.Catalogos_ctEstatusTrabajador;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdEstatusTrabajador == item.IdEstatusTrabajador);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvEstatusTrabajador", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvEstatusTrabajadorDelete(System.Int16 IdEstatusTrabajador)
        {
            var model = db.Catalogos_ctEstatusTrabajador;
            if (IdEstatusTrabajador != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdEstatusTrabajador == IdEstatusTrabajador);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvEstatusTrabajador", model.ToList());
        }

    }
}
