﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Catalogos
{
    public class CreditoController : Controller
    {
        //
        // GET: /Credito/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCredito()
        {
            var model = db.Catalogos_ctTipoCredito;
            return PartialView("_pvCredito", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCreditoAddNew(Nova.Models.Catalogos_ctTipoCredito item)
        {
            
            var model = db.Catalogos_ctTipoCredito;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvCredito", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCreditoUpdate(Nova.Models.Catalogos_ctTipoCredito item)
        {
            var model = db.Catalogos_ctTipoCredito;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdTipoCredito == item.IdTipoCredito);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvCredito", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCreditoDelete(System.Int16 IdTipoCredito)
        {
            var model = db.Catalogos_ctTipoCredito;
            if (IdTipoCredito != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdTipoCredito == IdTipoCredito);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvCredito", model.ToList());
        }
    }
}
