﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class ConvenioLaboralController : Controller
    {
        //
        // GET: /ConvenioLaboral/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvgvConvenioLaboral()
        {
            var model = db.Catalogos_ctConvenioLaboral;
            return PartialView("__pvgvConvenioLaboral", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvConvenioLaboralAddNew(Nova.Models.Catalogos_ctConvenioLaboral item)
        {
            var model = db.Catalogos_ctConvenioLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);


            return PartialView("__pvgvConvenioLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvConvenioLaboralUpdate(Nova.Models.Catalogos_ctConvenioLaboral item)
        {
            var model = db.Catalogos_ctConvenioLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdConvenioLaboral == item.IdConvenioLaboral);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);


            return PartialView("__pvgvConvenioLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvConvenioLaboralDelete(System.Int16 IdConvenioLaboral)
        {
            var model = db.Catalogos_ctConvenioLaboral;
            if (IdConvenioLaboral != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdConvenioLaboral == IdConvenioLaboral);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] =  ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            return PartialView("__pvgvConvenioLaboral", model.ToList());
        }
    }
}
