﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Catalogos
{
    public class ConfigurarISRController : Controller
    {
        //
        // GET: /ConfigurarISR/

        public ActionResult Index()
        {
            return View();
        }


        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvConfigurarISR()
        {
            var model = db.Configuracion_ctISR;
            return PartialView("_pvConfigurarISR", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvConfigurarISRAddNew(Nova.Models.Configuracion_ctISR item)
        {
            var model = db.Configuracion_ctISR;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvConfigurarISR", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvConfigurarISRUpdate(Nova.Models.Configuracion_ctISR item)
        {
            var model = db.Configuracion_ctISR;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdISR == item.IdISR);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvConfigurarISR", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvConfigurarISRDelete(System.Int16 IdISR)
        {
            var model = db.Configuracion_ctISR;
            if (IdISR != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdISR == IdISR);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvConfigurarISR", model.ToList());
        }

    }
}
