﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Catalogos
{
    public class CatalogoSalarioMinimoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: CatalogoSalarioMinimo
        public ActionResult Index()
        {
            var catalogos_ctSalarioMinimo = db.Catalogos_ctSalarioMinimo.Include(c => c.Catalogos_ctZonaSalarioMinimo);
            return View(catalogos_ctSalarioMinimo.ToList());
        }

        // GET: CatalogoSalarioMinimo/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Catalogos_ctSalarioMinimo catalogos_ctSalarioMinimo = db.Catalogos_ctSalarioMinimo.Find(id);
            if (catalogos_ctSalarioMinimo == null)
            {
                return HttpNotFound();
            }
            return View(catalogos_ctSalarioMinimo);
        }

        // GET: CatalogoSalarioMinimo/Create
        public ActionResult Create()
        {
            ViewBag.IdZonaSalarioMinimo = new SelectList(db.Catalogos_ctZonaSalarioMinimo, "IdZonaSalarioMinimo", "ZonaSalarioMinimo");
            return View();
        }

        // POST: CatalogoSalarioMinimo/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdSalarioMinimo,IdZonaSalarioMinimo,Monto,FechaInicio,FechaTermino")] Catalogos_ctSalarioMinimo catalogos_ctSalarioMinimo)
        {
            if (ModelState.IsValid)
            {
                db.Catalogos_ctSalarioMinimo.Add(catalogos_ctSalarioMinimo);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdZonaSalarioMinimo = new SelectList(db.Catalogos_ctZonaSalarioMinimo, "IdZonaSalarioMinimo", "ZonaSalarioMinimo", catalogos_ctSalarioMinimo.IdZonaSalarioMinimo);
            return View(catalogos_ctSalarioMinimo);
        }

        // GET: CatalogoSalarioMinimo/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Catalogos_ctSalarioMinimo catalogos_ctSalarioMinimo = db.Catalogos_ctSalarioMinimo.Find(id);
            if (catalogos_ctSalarioMinimo == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdZonaSalarioMinimo = new SelectList(db.Catalogos_ctZonaSalarioMinimo, "IdZonaSalarioMinimo", "ZonaSalarioMinimo", catalogos_ctSalarioMinimo.IdZonaSalarioMinimo);
            return View(catalogos_ctSalarioMinimo);
        }

        // POST: CatalogoSalarioMinimo/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdSalarioMinimo,IdZonaSalarioMinimo,Monto,FechaInicio,FechaTermino")] Catalogos_ctSalarioMinimo catalogos_ctSalarioMinimo)
        {
            if (ModelState.IsValid)
            {
                db.Entry(catalogos_ctSalarioMinimo).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdZonaSalarioMinimo = new SelectList(db.Catalogos_ctZonaSalarioMinimo, "IdZonaSalarioMinimo", "ZonaSalarioMinimo", catalogos_ctSalarioMinimo.IdZonaSalarioMinimo);
            return View(catalogos_ctSalarioMinimo);
        }

        // GET: CatalogoSalarioMinimo/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Catalogos_ctSalarioMinimo catalogos_ctSalarioMinimo = db.Catalogos_ctSalarioMinimo.Find(id);
            if (catalogos_ctSalarioMinimo == null)
            {
                return HttpNotFound();
            }
            return View(catalogos_ctSalarioMinimo);
        }

        // POST: CatalogoSalarioMinimo/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        [HttpPost]
        public ActionResult DeleteConfirmed()
        {
            Int16 id = System.Convert.ToInt16(Request["key-sm"]);
            if (id == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            
            Catalogos_ctSalarioMinimo catalogos_ctSalarioMinimo = db.Catalogos_ctSalarioMinimo.Find(id);
            db.Catalogos_ctSalarioMinimo.Remove(catalogos_ctSalarioMinimo);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
