﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Catalogos
{
    public class AccionesController : Controller
    {
        //
        // GET: /Acciones/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvAcciones()
        {
            var model = db.Catalogos_ctAccionPresupuestal;
            return PartialView("_pvAcciones", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvAccionesAddNew(Nova.Models.Catalogos_ctAccionPresupuestal item)
        {
            var model = db.Catalogos_ctAccionPresupuestal;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
              
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvAcciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvAccionesUpdate(Nova.Models.Catalogos_ctAccionPresupuestal item)
        {
            var model = db.Catalogos_ctAccionPresupuestal;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdAccionPresupuestal == item.IdAccionPresupuestal);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvAcciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvAccionesDelete(System.Int16 IdAccionPresupuestal)
        {
            var model = db.Catalogos_ctAccionPresupuestal;
            if (IdAccionPresupuestal != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdAccionPresupuestal == IdAccionPresupuestal);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                                       
                    
                }
            }
           
               
            return PartialView("_pvAcciones", model.ToList());
        }
    }
}
