﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Transactions;
using Rotativa;


namespace Nova.Controllers.Carreras
{
    public class CarreraCorredoresController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: CarreraCorredores
        public ActionResult Index()
        {
            var carreraCorredores = db.CarreraCorredores.Include(c => c.CarreraCategorias).Include(c => c.CarreraEstatus).Include(c => c.CarreraGenero);
            return View(carreraCorredores.ToList());
        }


        public ActionResult CorredoresXlsAdmin()
     
        {

            var result = db.CarreraCorredores.Include(c => c.CarreraCategorias).Include(c => c.CarreraEstatus).Include(c => c.CarreraGenero);
          
            string modalidad = "ListadoCorredores - " + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }

      




        // GET: CarreraCorredores/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            CarreraCorredores carreraCorredores = db.CarreraCorredores.Find(id);
            if (carreraCorredores == null)
            {
                return HttpNotFound();
            }
            return View(carreraCorredores);
        }

        
        // GET: CarreraCorredores/Create
        //[AllowAnonymous]
        public ActionResult Create()
        {
            int idCorredor = 0;
            if (TempData["idCorredor"] != null)
            {
                idCorredor = (int) TempData["idCorredor"];
                
            }

            ViewBag.IdCorredor = idCorredor;
            ViewBag.IdCategoria = new SelectList(db.CarreraCategorias, "IdCategoria", "Categoria");
            ViewBag.IdEstatus = new SelectList(db.CarreraEstatus, "IdEstatus", "Estatus");
            ViewBag.IdGenero = new SelectList(db.CarreraGenero, "IdGenero", "Genero");
            return View();
        }

        // POST: CarreraCorredores/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[AllowAnonymous]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdCorredor,Nombre,ApellidoPaterno,ApellidoMaterno,Edad,IdGenero,IdCategoria,IdEstatus,FechaInscripcion")] CarreraCorredores carreraCorredores)
        {
            //var array = db.CarreraCorredores.Select(f => new {Nombre= f.Nombre, ApPaterno= f.ApellidoPaterno, ApMaterno=f.ApellidoMaterno, Edad=f.Edad}).ToArray();

            Nova.Models.CarreraCorredores corredorExiste = db.CarreraCorredores.Where(e => e.Nombre == carreraCorredores.Nombre && e.ApellidoPaterno == carreraCorredores.ApellidoPaterno && e.ApellidoMaterno == carreraCorredores.ApellidoMaterno && e.Edad == carreraCorredores.Edad).FirstOrDefault();
            if (corredorExiste != null)
            {
                
                ModelState.AddModelError(String.Empty, "YA EXISTE UN CORREDOR  CON EL MISMO NOMBRE, FAVOR DE VERIFICAR SUS DATOS");
            }
                    
            if (ModelState.IsValid)
            {
                carreraCorredores.Nombre = carreraCorredores.Nombre.ToUpper();
                carreraCorredores.ApellidoPaterno = carreraCorredores.ApellidoPaterno.ToUpper();
                carreraCorredores.ApellidoMaterno = carreraCorredores.ApellidoMaterno.ToUpper();
                carreraCorredores.FechaInscripcion = DateTime.Now;
                db.CarreraCorredores.Add(carreraCorredores);
                db.SaveChanges();

                TempData["idCorredor"] = carreraCorredores.IdCorredor;
                //descargar pdf
                return RedirectToAction("Create");
                
                
            }
            
            ViewBag.IdCategoria = new SelectList(db.CarreraCategorias, "IdCategoria", "Categoria", carreraCorredores.IdCategoria);
            ViewBag.IdEstatus = new SelectList(db.CarreraEstatus, "IdEstatus", "Estatus", carreraCorredores.IdEstatus);
            ViewBag.IdGenero = new SelectList(db.CarreraGenero, "IdGenero", "Genero", carreraCorredores.IdGenero);
            return View(carreraCorredores);
        }

         [AllowAnonymous]
        public ActionResult DescargarPdfCorredor(int id)
        //String[] proyectos,
        {

            //DescargarPdfCorredor(carreraCorredores.IdCorredor);
            var result = db.CarreraCorredores.Where(a => a.IdCorredor == id).FirstOrDefault();


            string modalidad = "CartaResponsiva" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            //return View("ReporteMir", result.ToList());
            return new ViewAsPdf("DescargarPdfCorredor", result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = modalidad };
        
        }

        // GET: CarreraCorredores/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            CarreraCorredores carreraCorredores = db.CarreraCorredores.Find(id);
            if (carreraCorredores == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdCategoria = new SelectList(db.CarreraCategorias, "IdCategoria", "Categoria", carreraCorredores.IdCategoria);
            ViewBag.IdEstatus = new SelectList(db.CarreraEstatus, "IdEstatus", "Estatus", carreraCorredores.IdEstatus);
            ViewBag.IdGenero = new SelectList(db.CarreraGenero, "IdGenero", "Genero", carreraCorredores.IdGenero);
            return View(carreraCorredores);
        }

        // POST: CarreraCorredores/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdCorredor,Nombre,ApellidoPaterno,ApellidoMaterno,Edad,IdGenero,IdCategoria,IdEstatus,FechaInscripcion")] CarreraCorredores carreraCorredores)
        {
            if (ModelState.IsValid)
            {
                db.Entry(carreraCorredores).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdCategoria = new SelectList(db.CarreraCategorias, "IdCategoria", "Categoria", carreraCorredores.IdCategoria);
            ViewBag.IdEstatus = new SelectList(db.CarreraEstatus, "IdEstatus", "Estatus", carreraCorredores.IdEstatus);
            ViewBag.IdGenero = new SelectList(db.CarreraGenero, "IdGenero", "Genero", carreraCorredores.IdGenero);
            return View(carreraCorredores);
        }

        // GET: CarreraCorredores/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            CarreraCorredores carreraCorredores = db.CarreraCorredores.Find(id);
            if (carreraCorredores == null)
            {
                return HttpNotFound();
            }
            return View(carreraCorredores);
        }

        // POST: CarreraCorredores/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            CarreraCorredores carreraCorredores = db.CarreraCorredores.Find(id);
            db.CarreraCorredores.Remove(carreraCorredores);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

       

    }
}
