﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

using Nova.Libraries;

using System.Net.Mail;
using System.Net;


namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionRelacionLaboralController : Controller
    {
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        
     
        // GET: CapacitacionCategoria
        public ActionResult Index()
        {
            return View();
        }

        // GET: CapacitacionCategoria
        public ActionResult Notificar(int id)
        {
            Capacitacion_PersonalPermitidoRelacionLaboral item = db.Capacitacion_PersonalPermitidoRelacionLaboral.Find(id);

            List<Convenios_stConvenioLaboralTrabajadorCategoria> trabajadores = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.IdRelacionLaboral == item.IdRelacionLaboral && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
            ViewBag.trabajadores = trabajadores;
            return View(item);
        }

        [HttpPost]
        public ActionResult EnviarNotificacion(int id)
        {
            Capacitacion_PersonalPermitidoRelacionLaboral item = db.Capacitacion_PersonalPermitidoRelacionLaboral.Find(id);

            List<Convenios_stConvenioLaboralTrabajadorCategoria> correos = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.IdRelacionLaboral == item.IdRelacionLaboral && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
            // ViewBag.trabajadores = trabajadores;
            UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

              string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Index", "Home");

            Nova.Models.Capacitacion_PersonalPermitidoCategoria.EnviarEmailInvitacion("jcmc2@hotmail.com", item.Capacitacion_stConvocatoriasCursos ,url);

            MessageBox.Show(ViewData, TipoMensaje.Success, "Se han enviado los correos electrónicos exitosamente ");

            Capacitacion_PersonalPermitidoRelacionLaboral variable = db.Capacitacion_PersonalPermitidoRelacionLaboral.Find(id);

            List<Convenios_stConvenioLaboralTrabajadorCategoria> trabajadores = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.IdRelacionLaboral == item.IdRelacionLaboral && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
            ViewBag.trabajadores = trabajadores;


            return View("Notificar", variable);
        }

        [ValidateInput(false)]
        public ActionResult RelacionLaboral()
        {
            var model = db.Capacitacion_PersonalPermitidoRelacionLaboral;
            return PartialView("_RelacionLaboral", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult RelacionLaboralAddNew(Nova.Models.Capacitacion_PersonalPermitidoRelacionLaboral item)
        {
            ViewData["Item"] = item;
            var model = db.Capacitacion_PersonalPermitidoRelacionLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_RelacionLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult RelacionLaboralUpdate(Nova.Models.Capacitacion_PersonalPermitidoRelacionLaboral item)
        {

            var model = db.Capacitacion_PersonalPermitidoRelacionLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPersonalPermitidoRelacionLaboral == item.IdPersonalPermitidoRelacionLaboral);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_RelacionLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult RelacionLaboralDelete(System.Byte IdPersonalPermitidoRelacionLaboral)
        {
            var model = db.Capacitacion_PersonalPermitidoRelacionLaboral;
            if (IdPersonalPermitidoRelacionLaboral != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPersonalPermitidoRelacionLaboral == IdPersonalPermitidoRelacionLaboral);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_RelacionLaboral", model.ToList());
        }
    }
}