﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionRegistroEvaluacionAspirantesController : BaseController
    {
        // GET: CapacitacionRegistroEvaluacionAspirantes
        private Nova.Models.bdNovaEntities db = new Models.bdNovaEntities();
        public ActionResult Index()
        {
            List<int> IdKardexAspirantes = new List<int>();
            List<int> IdKardexTrabajadores = new List<int>();
            IdKardexTrabajadores = db.Kardex_ctTrabajador.Select(y=>y.IdKardex).ToList();
            IdKardexAspirantes = db.Kardex_ctDatosPersonales.Select(i=>i.IdKardex).ToList().Except(IdKardexTrabajadores).ToList();
            var model = db.Kardex_ctDatosPersonales.Where(i => i.EsDocente == true && IdKardexAspirantes.Contains(i.IdKardex)).ToList();
            return View(model);
        }

        // GET: CapacitacionRegistroEvaluacionAspirantes/Details/5
        public ActionResult Details(int id)
        {
            return View();
        }

        // GET: CapacitacionRegistroEvaluacionAspirantes/Create
        public ActionResult Create(int Id)
        {
            ViewBag.IdKardex = Id;
            return View();
        }

        // POST: CapacitacionRegistroEvaluacionAspirantes/Create
        [HttpPost]
        public ActionResult Create([Bind(Include = "IdKardex,FechaEvaluacion,EsApto,EstaEvaluado,Observaciones,IdConvenioLaboralTrabajadorCategoriaAutorizo")] Capacitacion_AspiranteResultadoEvaluacion capacitacion_AspiranteResultadoEvaluacion)
        {
            ViewBag.IdKardex = capacitacion_AspiranteResultadoEvaluacion.IdKardex;
            capacitacion_AspiranteResultadoEvaluacion.IdConvenioLaboralTrabajadorCategoriaAutorizo = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            if (ModelState.IsValid)
            {
                try
                {
                    db.Capacitacion_AspiranteResultadoEvaluacion.Add(capacitacion_AspiranteResultadoEvaluacion);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }



                return JsonView(ModelState.IsValid, "Se ha agregado el registro con éxito", null, null, Url.Action("Index", "CapacitacionRegistroEvaluacionAspirantes", null));

            }


            string messages = string.Join("; ", ModelState.Values
                                       .SelectMany(x => x.Errors)
                                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, "Create", capacitacion_AspiranteResultadoEvaluacion);

        }

        // GET: CapacitacionRegistroEvaluacionAspirantes/Edit/5
        public ActionResult VerEvaluaciones(int id)
        {
            ViewBag.IdKardex = id;
            var model = db.Capacitacion_AspiranteResultadoEvaluacion.Where(e => e.IdKardex == id).OrderByDescending(x=>x.FechaEvaluacion).ToList();
            return View(model);
        }

        // POST: CapacitacionRegistroEvaluacionAspirantes/Edit/5
        
        [HttpPost]
        public ActionResult Delete(int id)
        {
            try
            {

                Capacitacion_AspiranteResultadoEvaluacion Evaluacion = db.Capacitacion_AspiranteResultadoEvaluacion.Find(id);
                db.Capacitacion_AspiranteResultadoEvaluacion.Remove(Evaluacion);
                db.SaveChanges();
                
            }
            catch (Exception e)
            {


                return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
            }




            return JsonView(true, "Se ha eliminado el registro exitosamente", null, null, Url.Action("Index", "CapacitacionRegistroEvaluacionAspirantes"));

        }
    }
}
