﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class CapacitacionInstructoresController : Controller
    {
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        // GET: CapacitacionInstructores
        public ActionResult Index()
        {
            return View();
        }

        [ValidateInput(false)]
        public ActionResult Instructores()
        {
            var model = db.Capacitacion_ctInstructores;
            return PartialView("_Instructores", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult InstructoresDelete(System.Int32 IdInstructor)
        {
            var model = db.Capacitacion_ctInstructores;
            if (IdInstructor != 0)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdInstructor == IdInstructor);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_Instructores", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult InstructoresAddNew(Nova.Models.Capacitacion_ctInstructores item)
        {
           
            var model = db.Capacitacion_ctInstructores;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_Instructores", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult InstructoresUpdate(Nova.Models.Capacitacion_ctInstructores item)
        {
          
            var model = db.Capacitacion_ctInstructores;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdInstructor == item.IdInstructor);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_Instructores", model.ToList());
        }
    
    }
}